// ui/base/dragdrop/mojom/drag_drop_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-params-data.h"
namespace ui {
namespace mojom {

std::string DragEventSourceToString(DragEventSource value) {
  switch(value) {
    case DragEventSource::kMouse:
      return "DragEventSource::kMouse";
    case DragEventSource::kTouch:
      return "DragEventSource::kTouch";
    default:
      return base::StringPrintf("Unknown DragEventSource value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DragEventSource value) {
  return os << DragEventSourceToString(value);
}

std::string DragOperationToString(DragOperation value) {
  switch(value) {
    case DragOperation::kNone:
      return "DragOperation::kNone";
    case DragOperation::kCopy:
      return "DragOperation::kCopy";
    case DragOperation::kLink:
      return "DragOperation::kLink";
    case DragOperation::kMove:
      return "DragOperation::kMove";
    default:
      return base::StringPrintf("Unknown DragOperation value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DragOperation value) {
  return os << DragOperationToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::DragEventSource>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::DragEventSource value) {
  return std::move(context).WriteString(::ui::mojom::DragEventSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::DragOperation>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::DragOperation value) {
  return std::move(context).WriteString(::ui::mojom::DragOperationToString(value));
}

} // namespace perfetto
