// ui/base/ime/mojom/ime_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/ime/mojom/ime_types.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/ime/mojom/ime_types.mojom-params-data.h"
namespace ui {
namespace mojom {

std::string TextInputModeToString(TextInputMode value) {
  switch(value) {
    case TextInputMode::kDefault:
      return "TextInputMode::kDefault";
    case TextInputMode::kNone:
      return "TextInputMode::kNone";
    case TextInputMode::kText:
      return "TextInputMode::kText";
    case TextInputMode::kTel:
      return "TextInputMode::kTel";
    case TextInputMode::kUrl:
      return "TextInputMode::kUrl";
    case TextInputMode::kEmail:
      return "TextInputMode::kEmail";
    case TextInputMode::kNumeric:
      return "TextInputMode::kNumeric";
    case TextInputMode::kDecimal:
      return "TextInputMode::kDecimal";
    case TextInputMode::kSearch:
      return "TextInputMode::kSearch";
    default:
      return base::StringPrintf("Unknown TextInputMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TextInputMode value) {
  return os << TextInputModeToString(value);
}

std::string TextInputActionToString(TextInputAction value) {
  switch(value) {
    case TextInputAction::kDefault:
      return "TextInputAction::kDefault";
    case TextInputAction::kEnter:
      return "TextInputAction::kEnter";
    case TextInputAction::kDone:
      return "TextInputAction::kDone";
    case TextInputAction::kGo:
      return "TextInputAction::kGo";
    case TextInputAction::kNext:
      return "TextInputAction::kNext";
    case TextInputAction::kPrevious:
      return "TextInputAction::kPrevious";
    case TextInputAction::kSearch:
      return "TextInputAction::kSearch";
    case TextInputAction::kSend:
      return "TextInputAction::kSend";
    default:
      return base::StringPrintf("Unknown TextInputAction value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TextInputAction value) {
  return os << TextInputActionToString(value);
}

std::string TextInputTypeToString(TextInputType value) {
  switch(value) {
    case TextInputType::NONE:
      return "TextInputType::NONE";
    case TextInputType::TEXT:
      return "TextInputType::TEXT";
    case TextInputType::PASSWORD:
      return "TextInputType::PASSWORD";
    case TextInputType::SEARCH:
      return "TextInputType::SEARCH";
    case TextInputType::EMAIL:
      return "TextInputType::EMAIL";
    case TextInputType::NUMBER:
      return "TextInputType::NUMBER";
    case TextInputType::TELEPHONE:
      return "TextInputType::TELEPHONE";
    case TextInputType::URL:
      return "TextInputType::URL";
    case TextInputType::DATE:
      return "TextInputType::DATE";
    case TextInputType::DATE_TIME:
      return "TextInputType::DATE_TIME";
    case TextInputType::DATE_TIME_LOCAL:
      return "TextInputType::DATE_TIME_LOCAL";
    case TextInputType::MONTH:
      return "TextInputType::MONTH";
    case TextInputType::TIME:
      return "TextInputType::TIME";
    case TextInputType::WEEK:
      return "TextInputType::WEEK";
    case TextInputType::TEXT_AREA:
      return "TextInputType::TEXT_AREA";
    case TextInputType::CONTENT_EDITABLE:
      return "TextInputType::CONTENT_EDITABLE";
    case TextInputType::DATE_TIME_FIELD:
      return "TextInputType::DATE_TIME_FIELD";
    case TextInputType::TYPE_NULL:
      return "TextInputType::{TYPE_NULL, MAX}";
    default:
      return base::StringPrintf("Unknown TextInputType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TextInputType value) {
  return os << TextInputTypeToString(value);
}

std::string ImeTextSpanTypeToString(ImeTextSpanType value) {
  switch(value) {
    case ImeTextSpanType::kComposition:
      return "ImeTextSpanType::kComposition";
    case ImeTextSpanType::kSuggestion:
      return "ImeTextSpanType::kSuggestion";
    case ImeTextSpanType::kMisspellingSuggestion:
      return "ImeTextSpanType::kMisspellingSuggestion";
    case ImeTextSpanType::kAutocorrect:
      return "ImeTextSpanType::kAutocorrect";
    default:
      return base::StringPrintf("Unknown ImeTextSpanType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ImeTextSpanType value) {
  return os << ImeTextSpanTypeToString(value);
}

std::string ImeTextSpanThicknessToString(ImeTextSpanThickness value) {
  switch(value) {
    case ImeTextSpanThickness::kNone:
      return "ImeTextSpanThickness::kNone";
    case ImeTextSpanThickness::kThin:
      return "ImeTextSpanThickness::kThin";
    case ImeTextSpanThickness::kThick:
      return "ImeTextSpanThickness::kThick";
    default:
      return base::StringPrintf("Unknown ImeTextSpanThickness value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ImeTextSpanThickness value) {
  return os << ImeTextSpanThicknessToString(value);
}

std::string ImeTextSpanUnderlineStyleToString(ImeTextSpanUnderlineStyle value) {
  switch(value) {
    case ImeTextSpanUnderlineStyle::kNone:
      return "ImeTextSpanUnderlineStyle::kNone";
    case ImeTextSpanUnderlineStyle::kSolid:
      return "ImeTextSpanUnderlineStyle::kSolid";
    case ImeTextSpanUnderlineStyle::kDot:
      return "ImeTextSpanUnderlineStyle::kDot";
    case ImeTextSpanUnderlineStyle::kDash:
      return "ImeTextSpanUnderlineStyle::kDash";
    case ImeTextSpanUnderlineStyle::kSquiggle:
      return "ImeTextSpanUnderlineStyle::kSquiggle";
    default:
      return base::StringPrintf("Unknown ImeTextSpanUnderlineStyle value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ImeTextSpanUnderlineStyle value) {
  return os << ImeTextSpanUnderlineStyleToString(value);
}

namespace internal {


// static
bool ImeTextSpan_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ImeTextSpan_Data* object = static_cast<const ImeTextSpan_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::ui::mojom::internal::ImeTextSpanType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::ui::mojom::internal::ImeTextSpanThickness_Data
        ::Validate(object->thickness, validation_context))
    return false;


  if (!::ui::mojom::internal::ImeTextSpanUnderlineStyle_Data
        ::Validate(object->underline_style, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestions, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams suggestions_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->suggestions, validation_context,
                                         &suggestions_validate_params)) {
    return false;
  }

  return true;
}

ImeTextSpan_Data::ImeTextSpan_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::TextInputMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::TextInputMode value) {
  return std::move(context).WriteString(::ui::mojom::TextInputModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::TextInputAction>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::TextInputAction value) {
  return std::move(context).WriteString(::ui::mojom::TextInputActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::TextInputType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::TextInputType value) {
  return std::move(context).WriteString(::ui::mojom::TextInputTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::ImeTextSpanType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::ImeTextSpanType value) {
  return std::move(context).WriteString(::ui::mojom::ImeTextSpanTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::ImeTextSpanThickness>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::ImeTextSpanThickness value) {
  return std::move(context).WriteString(::ui::mojom::ImeTextSpanThicknessToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::ImeTextSpanUnderlineStyle>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::ImeTextSpanUnderlineStyle value) {
  return std::move(context).WriteString(::ui::mojom::ImeTextSpanUnderlineStyleToString(value));
}

} // namespace perfetto
