// ui/base/mojom/ui_base_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/mojom/ui_base_types.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/mojom/ui_base_types.mojom-params-data.h"
namespace ui {
namespace mojom {

std::string DialogButtonToString(DialogButton value) {
  switch(value) {
    case DialogButton::NONE:
      return "DialogButton::NONE";
    case DialogButton::OK:
      return "DialogButton::OK";
    case DialogButton::CANCEL:
      return "DialogButton::CANCEL";
    default:
      return base::StringPrintf("Unknown DialogButton value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DialogButton value) {
  return os << DialogButtonToString(value);
}

std::string ModalTypeToString(ModalType value) {
  switch(value) {
    case ModalType::NONE:
      return "ModalType::NONE";
    case ModalType::WINDOW:
      return "ModalType::WINDOW";
    case ModalType::CHILD:
      return "ModalType::CHILD";
    case ModalType::SYSTEM:
      return "ModalType::SYSTEM";
    default:
      return base::StringPrintf("Unknown ModalType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ModalType value) {
  return os << ModalTypeToString(value);
}

std::string MenuSourceTypeToString(MenuSourceType value) {
  switch(value) {
    case MenuSourceType::NONE:
      return "MenuSourceType::NONE";
    case MenuSourceType::MOUSE:
      return "MenuSourceType::MOUSE";
    case MenuSourceType::KEYBOARD:
      return "MenuSourceType::KEYBOARD";
    case MenuSourceType::TOUCH:
      return "MenuSourceType::TOUCH";
    case MenuSourceType::TOUCH_EDIT_MENU:
      return "MenuSourceType::TOUCH_EDIT_MENU";
    case MenuSourceType::LONG_PRESS:
      return "MenuSourceType::LONG_PRESS";
    case MenuSourceType::LONG_TAP:
      return "MenuSourceType::LONG_TAP";
    case MenuSourceType::TOUCH_HANDLE:
      return "MenuSourceType::TOUCH_HANDLE";
    case MenuSourceType::STYLUS:
      return "MenuSourceType::STYLUS";
    case MenuSourceType::ADJUST_SELECTION:
      return "MenuSourceType::ADJUST_SELECTION";
    case MenuSourceType::ADJUST_SELECTION_RESET:
      return "MenuSourceType::ADJUST_SELECTION_RESET";
    default:
      return base::StringPrintf("Unknown MenuSourceType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MenuSourceType value) {
  return os << MenuSourceTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::DialogButton>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::DialogButton value) {
  return std::move(context).WriteString(::ui::mojom::DialogButtonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::ModalType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::ModalType value) {
  return std::move(context).WriteString(::ui::mojom::ModalTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::MenuSourceType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::MenuSourceType value) {
  return std::move(context).WriteString(::ui::mojom::MenuSourceTypeToString(value));
}

} // namespace perfetto
