// ui/display/mojom/display.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/display/mojom/display.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display.mojom-params-data.h"
namespace display {
namespace mojom {

std::string RotationToString(Rotation value) {
  switch(value) {
    case Rotation::VALUE_0:
      return "Rotation::VALUE_0";
    case Rotation::VALUE_90:
      return "Rotation::VALUE_90";
    case Rotation::VALUE_180:
      return "Rotation::VALUE_180";
    case Rotation::VALUE_270:
      return "Rotation::VALUE_270";
    default:
      return base::StringPrintf("Unknown Rotation value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Rotation value) {
  return os << RotationToString(value);
}

std::string TouchSupportToString(TouchSupport value) {
  switch(value) {
    case TouchSupport::UNKNOWN:
      return "TouchSupport::UNKNOWN";
    case TouchSupport::AVAILABLE:
      return "TouchSupport::AVAILABLE";
    case TouchSupport::UNAVAILABLE:
      return "TouchSupport::UNAVAILABLE";
    default:
      return base::StringPrintf("Unknown TouchSupport value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, TouchSupport value) {
  return os << TouchSupportToString(value);
}

std::string AccelerometerSupportToString(AccelerometerSupport value) {
  switch(value) {
    case AccelerometerSupport::UNKNOWN:
      return "AccelerometerSupport::UNKNOWN";
    case AccelerometerSupport::AVAILABLE:
      return "AccelerometerSupport::AVAILABLE";
    case AccelerometerSupport::UNAVAILABLE:
      return "AccelerometerSupport::UNAVAILABLE";
    default:
      return base::StringPrintf("Unknown AccelerometerSupport value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, AccelerometerSupport value) {
  return os << AccelerometerSupportToString(value);
}

namespace internal {


// static
bool Display_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Display_Data* object = static_cast<const Display_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size_in_pixels, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size_in_pixels, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->work_area, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->work_area, validation_context))
    return false;


  if (!::display::mojom::internal::Rotation_Data
        ::Validate(object->rotation, validation_context))
    return false;


  if (!::display::mojom::internal::TouchSupport_Data
        ::Validate(object->touch_support, validation_context))
    return false;


  if (!::display::mojom::internal::AccelerometerSupport_Data
        ::Validate(object->accelerometer_support, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->maximum_cursor_size, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->maximum_cursor_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_spaces, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_spaces, validation_context))
    return false;

  return true;
}

Display_Data::Display_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace display

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::Rotation>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::display::mojom::Rotation value) {
  return std::move(context).WriteString(::display::mojom::RotationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::TouchSupport>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::display::mojom::TouchSupport value) {
  return std::move(context).WriteString(::display::mojom::TouchSupportToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::AccelerometerSupport>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::display::mojom::AccelerometerSupport value) {
  return std::move(context).WriteString(::display::mojom::AccelerometerSupportToString(value));
}

} // namespace perfetto
