// ui/display/mojom/display_constants.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/display/mojom/display_constants.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display_constants.mojom-params-data.h"
namespace display {
namespace mojom {

std::string DisplayConnectionTypeToString(DisplayConnectionType value) {
  switch(value) {
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_NONE:
      return "DisplayConnectionType::DISPLAY_CONNECTION_TYPE_NONE";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_UNKNOWN:
      return "DisplayConnectionType::DISPLAY_CONNECTION_TYPE_UNKNOWN";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_INTERNAL:
      return "DisplayConnectionType::DISPLAY_CONNECTION_TYPE_INTERNAL";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_VGA:
      return "DisplayConnectionType::DISPLAY_CONNECTION_TYPE_VGA";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_HDMI:
      return "DisplayConnectionType::DISPLAY_CONNECTION_TYPE_HDMI";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_DVI:
      return "DisplayConnectionType::DISPLAY_CONNECTION_TYPE_DVI";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_DISPLAYPORT:
      return "DisplayConnectionType::DISPLAY_CONNECTION_TYPE_DISPLAYPORT";
    case DisplayConnectionType::DISPLAY_CONNECTION_TYPE_NETWORK:
      return "DisplayConnectionType::DISPLAY_CONNECTION_TYPE_NETWORK";
    default:
      return base::StringPrintf("Unknown DisplayConnectionType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DisplayConnectionType value) {
  return os << DisplayConnectionTypeToString(value);
}

std::string HDCPStateToString(HDCPState value) {
  switch(value) {
    case HDCPState::HDCP_STATE_UNDESIRED:
      return "HDCPState::HDCP_STATE_UNDESIRED";
    case HDCPState::HDCP_STATE_DESIRED:
      return "HDCPState::HDCP_STATE_DESIRED";
    case HDCPState::HDCP_STATE_ENABLED:
      return "HDCPState::HDCP_STATE_ENABLED";
    default:
      return base::StringPrintf("Unknown HDCPState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, HDCPState value) {
  return os << HDCPStateToString(value);
}

std::string ContentProtectionMethodToString(ContentProtectionMethod value) {
  switch(value) {
    case ContentProtectionMethod::CONTENT_PROTECTION_METHOD_NONE:
      return "ContentProtectionMethod::CONTENT_PROTECTION_METHOD_NONE";
    case ContentProtectionMethod::CONTENT_PROTECTION_METHOD_HDCP_TYPE_0:
      return "ContentProtectionMethod::CONTENT_PROTECTION_METHOD_HDCP_TYPE_0";
    case ContentProtectionMethod::CONTENT_PROTECTION_METHOD_HDCP_TYPE_1:
      return "ContentProtectionMethod::CONTENT_PROTECTION_METHOD_HDCP_TYPE_1";
    default:
      return base::StringPrintf("Unknown ContentProtectionMethod value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ContentProtectionMethod value) {
  return os << ContentProtectionMethodToString(value);
}

std::string PanelOrientationToString(PanelOrientation value) {
  switch(value) {
    case PanelOrientation::NORMAL:
      return "PanelOrientation::NORMAL";
    case PanelOrientation::BOTTOM_UP:
      return "PanelOrientation::BOTTOM_UP";
    case PanelOrientation::LEFT_UP:
      return "PanelOrientation::LEFT_UP";
    case PanelOrientation::RIGHT_UP:
      return "PanelOrientation::RIGHT_UP";
    default:
      return base::StringPrintf("Unknown PanelOrientation value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PanelOrientation value) {
  return os << PanelOrientationToString(value);
}

std::string PrivacyScreenStateToString(PrivacyScreenState value) {
  switch(value) {
    case PrivacyScreenState::DISABLED:
      return "PrivacyScreenState::DISABLED";
    case PrivacyScreenState::ENABLED:
      return "PrivacyScreenState::ENABLED";
    case PrivacyScreenState::NOT_SUPPORTED:
      return "PrivacyScreenState::NOT_SUPPORTED";
    default:
      return base::StringPrintf("Unknown PrivacyScreenState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, PrivacyScreenState value) {
  return os << PrivacyScreenStateToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace display

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::DisplayConnectionType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::display::mojom::DisplayConnectionType value) {
  return std::move(context).WriteString(::display::mojom::DisplayConnectionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::HDCPState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::display::mojom::HDCPState value) {
  return std::move(context).WriteString(::display::mojom::HDCPStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::ContentProtectionMethod>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::display::mojom::ContentProtectionMethod value) {
  return std::move(context).WriteString(::display::mojom::ContentProtectionMethodToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::PanelOrientation>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::display::mojom::PanelOrientation value) {
  return std::move(context).WriteString(::display::mojom::PanelOrientationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::PrivacyScreenState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::display::mojom::PrivacyScreenState value) {
  return std::move(context).WriteString(::display::mojom::PrivacyScreenStateToString(value));
}

} // namespace perfetto
