// ui/display/mojom/display_layout.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/display/mojom/display_layout.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/display/mojom/display_layout.mojom-params-data.h"
#include "ui/display/mojom/display_layout.mojom-shared-message-ids.h"

#include "ui/display/mojom/display_layout.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_BLINK_JUMBO_H_
#define UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_BLINK_JUMBO_H_
#endif
namespace display {
namespace mojom {
namespace blink {
DisplayPlacement::DisplayPlacement()
    : display_id(),
      parent_display_id(),
      position(),
      offset(),
      offset_reference() {}

DisplayPlacement::DisplayPlacement(
    int64_t display_id_in,
    int64_t parent_display_id_in,
    Position position_in,
    int32_t offset_in,
    OffsetReference offset_reference_in)
    : display_id(std::move(display_id_in)),
      parent_display_id(std::move(parent_display_id_in)),
      position(std::move(position_in)),
      offset(std::move(offset_in)),
      offset_reference(std::move(offset_reference_in)) {}

DisplayPlacement::~DisplayPlacement() = default;
size_t DisplayPlacement::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->display_id);
  seed = mojo::internal::WTFHash(seed, this->parent_display_id);
  seed = mojo::internal::WTFHash(seed, this->position);
  seed = mojo::internal::WTFHash(seed, this->offset);
  seed = mojo::internal::WTFHash(seed, this->offset_reference);
  return seed;
}

void DisplayPlacement::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_id"), this->display_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_display_id"), this->parent_display_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position, 
      "<value of type Position>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset_reference"), this->offset_reference, 
      "<value of type OffsetReference>");
}

bool DisplayPlacement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DisplayLayout::DisplayLayout()
    : default_unified(),
      primary_display_id(),
      placement_list() {}

DisplayLayout::DisplayLayout(
    bool default_unified_in,
    int64_t primary_display_id_in,
    WTF::Vector<DisplayPlacementPtr> placement_list_in)
    : default_unified(std::move(default_unified_in)),
      primary_display_id(std::move(primary_display_id_in)),
      placement_list(std::move(placement_list_in)) {}

DisplayLayout::~DisplayLayout() = default;

void DisplayLayout::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_unified"), this->default_unified, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_display_id"), this->primary_display_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "placement_list"), this->placement_list, 
      "<value of type WTF::Vector<DisplayPlacementPtr>>");
}

bool DisplayLayout::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace display

namespace mojo {


// static
bool StructTraits<::display::mojom::blink::DisplayPlacement::DataView, ::display::mojom::blink::DisplayPlacementPtr>::Read(
    ::display::mojom::blink::DisplayPlacement::DataView input,
    ::display::mojom::blink::DisplayPlacementPtr* output) {
  bool success = true;
  ::display::mojom::blink::DisplayPlacementPtr result(::display::mojom::blink::DisplayPlacement::New());
  
      if (success)
        result->display_id = input.display_id();
      if (success)
        result->parent_display_id = input.parent_display_id();
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success)
        result->offset = input.offset();
      if (success && !input.ReadOffsetReference(&result->offset_reference))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::display::mojom::blink::DisplayLayout::DataView, ::display::mojom::blink::DisplayLayoutPtr>::Read(
    ::display::mojom::blink::DisplayLayout::DataView input,
    ::display::mojom::blink::DisplayLayoutPtr* output) {
  bool success = true;
  ::display::mojom::blink::DisplayLayoutPtr result(::display::mojom::blink::DisplayLayout::New());
  
      if (success)
        result->default_unified = input.default_unified();
      if (success)
        result->primary_display_id = input.primary_display_id();
      if (success && !input.ReadPlacementList(&result->placement_list))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif