// ui/display/mojom/display_layout.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/display/mojom/display_layout.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display_layout.mojom-params-data.h"
namespace display {
namespace mojom {

std::string PositionToString(Position value) {
  switch(value) {
    case Position::TOP:
      return "Position::TOP";
    case Position::RIGHT:
      return "Position::RIGHT";
    case Position::BOTTOM:
      return "Position::BOTTOM";
    case Position::LEFT:
      return "Position::LEFT";
    default:
      return base::StringPrintf("Unknown Position value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, Position value) {
  return os << PositionToString(value);
}

std::string OffsetReferenceToString(OffsetReference value) {
  switch(value) {
    case OffsetReference::TOP_LEFT:
      return "OffsetReference::TOP_LEFT";
    case OffsetReference::BOTTOM_RIGHT:
      return "OffsetReference::BOTTOM_RIGHT";
    default:
      return base::StringPrintf("Unknown OffsetReference value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, OffsetReference value) {
  return os << OffsetReferenceToString(value);
}

namespace internal {


// static
bool DisplayPlacement_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DisplayPlacement_Data* object = static_cast<const DisplayPlacement_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::display::mojom::internal::Position_Data
        ::Validate(object->position, validation_context))
    return false;


  if (!::display::mojom::internal::OffsetReference_Data
        ::Validate(object->offset_reference, validation_context))
    return false;

  return true;
}

DisplayPlacement_Data::DisplayPlacement_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DisplayLayout_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DisplayLayout_Data* object = static_cast<const DisplayLayout_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->placement_list, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams placement_list_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->placement_list, validation_context,
                                         &placement_list_validate_params)) {
    return false;
  }

  return true;
}

DisplayLayout_Data::DisplayLayout_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace display

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::Position>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::display::mojom::Position value) {
  return std::move(context).WriteString(::display::mojom::PositionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::display::mojom::OffsetReference>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::display::mojom::OffsetReference value) {
  return std::move(context).WriteString(::display::mojom::OffsetReferenceToString(value));
}

} // namespace perfetto
