// ui/display/mojom/display_snapshot.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/display/mojom/display_snapshot.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/display/mojom/display_snapshot.mojom-params-data.h"
#include "ui/display/mojom/display_snapshot.mojom-shared-message-ids.h"

#include "ui/display/mojom/display_snapshot.mojom-import-headers.h"


#ifndef UI_DISPLAY_MOJOM_DISPLAY_SNAPSHOT_MOJOM_JUMBO_H_
#define UI_DISPLAY_MOJOM_DISPLAY_SNAPSHOT_MOJOM_JUMBO_H_
#endif
namespace display {
namespace mojom {
DisplaySnapshot::DisplaySnapshot()
    : display_id(),
      origin(),
      physical_size(),
      type(),
      base_connector_id(),
      path_topology(),
      is_aspect_preserving_scaling(),
      has_overscan(),
      privacy_screen_state(),
      has_color_correction_matrix(),
      color_correction_in_linear_space(),
      color_space(),
      bits_per_channel(),
      display_name(),
      sys_path(),
      modes(),
      panel_orientation(),
      edid(),
      current_mode_index(),
      has_current_mode(),
      native_mode_index(),
      has_native_mode(),
      product_code(),
      year_of_manufacture(),
      maximum_cursor_size() {}

DisplaySnapshot::DisplaySnapshot(
    int64_t display_id_in,
    const ::gfx::Point& origin_in,
    const ::gfx::Size& physical_size_in,
    ::display::DisplayConnectionType type_in,
    uint64_t base_connector_id_in,
    std::vector<uint64_t> path_topology_in,
    bool is_aspect_preserving_scaling_in,
    bool has_overscan_in,
    ::display::PrivacyScreenState privacy_screen_state_in,
    bool has_color_correction_matrix_in,
    bool color_correction_in_linear_space_in,
    const ::gfx::ColorSpace& color_space_in,
    uint32_t bits_per_channel_in,
    const std::string& display_name_in,
    const ::base::FilePath& sys_path_in,
    std::vector<::std::unique_ptr<::display::DisplayMode>> modes_in,
    ::display::mojom::PanelOrientation panel_orientation_in,
    std::vector<uint8_t> edid_in,
    uint64_t current_mode_index_in,
    bool has_current_mode_in,
    uint64_t native_mode_index_in,
    bool has_native_mode_in,
    int64_t product_code_in,
    int32_t year_of_manufacture_in,
    const ::gfx::Size& maximum_cursor_size_in)
    : display_id(std::move(display_id_in)),
      origin(std::move(origin_in)),
      physical_size(std::move(physical_size_in)),
      type(std::move(type_in)),
      base_connector_id(std::move(base_connector_id_in)),
      path_topology(std::move(path_topology_in)),
      is_aspect_preserving_scaling(std::move(is_aspect_preserving_scaling_in)),
      has_overscan(std::move(has_overscan_in)),
      privacy_screen_state(std::move(privacy_screen_state_in)),
      has_color_correction_matrix(std::move(has_color_correction_matrix_in)),
      color_correction_in_linear_space(std::move(color_correction_in_linear_space_in)),
      color_space(std::move(color_space_in)),
      bits_per_channel(std::move(bits_per_channel_in)),
      display_name(std::move(display_name_in)),
      sys_path(std::move(sys_path_in)),
      modes(std::move(modes_in)),
      panel_orientation(std::move(panel_orientation_in)),
      edid(std::move(edid_in)),
      current_mode_index(std::move(current_mode_index_in)),
      has_current_mode(std::move(has_current_mode_in)),
      native_mode_index(std::move(native_mode_index_in)),
      has_native_mode(std::move(has_native_mode_in)),
      product_code(std::move(product_code_in)),
      year_of_manufacture(std::move(year_of_manufacture_in)),
      maximum_cursor_size(std::move(maximum_cursor_size_in)) {}

DisplaySnapshot::~DisplaySnapshot() = default;

void DisplaySnapshot::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_id"), this->display_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin, 
      "<value of type const ::gfx::Point&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "physical_size"), this->physical_size, 
      "<value of type const ::gfx::Size&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type ::display::DisplayConnectionType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_connector_id"), this->base_connector_id, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path_topology"), this->path_topology, 
      "<value of type const std::vector<uint64_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_aspect_preserving_scaling"), this->is_aspect_preserving_scaling, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_overscan"), this->has_overscan, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "privacy_screen_state"), this->privacy_screen_state, 
      "<value of type ::display::PrivacyScreenState>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_color_correction_matrix"), this->has_color_correction_matrix, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_correction_in_linear_space"), this->color_correction_in_linear_space, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space, 
      "<value of type const ::gfx::ColorSpace&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bits_per_channel"), this->bits_per_channel, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sys_path"), this->sys_path, 
      "<value of type const ::base::FilePath&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modes"), this->modes, 
      "<value of type std::vector<::std::unique_ptr<::display::DisplayMode>>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "panel_orientation"), this->panel_orientation, 
      "<value of type ::display::mojom::PanelOrientation>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "edid"), this->edid, 
      "<value of type const std::vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_mode_index"), this->current_mode_index, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_current_mode"), this->has_current_mode, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "native_mode_index"), this->native_mode_index, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_native_mode"), this->has_native_mode, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_code"), this->product_code, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "year_of_manufacture"), this->year_of_manufacture, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maximum_cursor_size"), this->maximum_cursor_size, 
      "<value of type const ::gfx::Size&>");
}

bool DisplaySnapshot::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace display

namespace mojo {


// static
bool StructTraits<::display::mojom::DisplaySnapshot::DataView, ::display::mojom::DisplaySnapshotPtr>::Read(
    ::display::mojom::DisplaySnapshot::DataView input,
    ::display::mojom::DisplaySnapshotPtr* output) {
  bool success = true;
  ::display::mojom::DisplaySnapshotPtr result(::display::mojom::DisplaySnapshot::New());
  
      if (success)
        result->display_id = input.display_id();
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadPhysicalSize(&result->physical_size))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->base_connector_id = input.base_connector_id();
      if (success && !input.ReadPathTopology(&result->path_topology))
        success = false;
      if (success)
        result->is_aspect_preserving_scaling = input.is_aspect_preserving_scaling();
      if (success)
        result->has_overscan = input.has_overscan();
      if (success && !input.ReadPrivacyScreenState(&result->privacy_screen_state))
        success = false;
      if (success)
        result->has_color_correction_matrix = input.has_color_correction_matrix();
      if (success)
        result->color_correction_in_linear_space = input.color_correction_in_linear_space();
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success)
        result->bits_per_channel = input.bits_per_channel();
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadSysPath(&result->sys_path))
        success = false;
      if (success && !input.ReadModes(&result->modes))
        success = false;
      if (success && !input.ReadPanelOrientation(&result->panel_orientation))
        success = false;
      if (success && !input.ReadEdid(&result->edid))
        success = false;
      if (success)
        result->current_mode_index = input.current_mode_index();
      if (success)
        result->has_current_mode = input.has_current_mode();
      if (success)
        result->native_mode_index = input.native_mode_index();
      if (success)
        result->has_native_mode = input.has_native_mode();
      if (success)
        result->product_code = input.product_code();
      if (success)
        result->year_of_manufacture = input.year_of_manufacture();
      if (success && !input.ReadMaximumCursorSize(&result->maximum_cursor_size))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif