// ui/events/mojom/event_constants.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/events/mojom/event_constants.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/events/mojom/event_constants.mojom-params-data.h"
namespace ui {
namespace mojom {

std::string AcceleratorPhaseToString(AcceleratorPhase value) {
  switch(value) {
    case AcceleratorPhase::PRE_TARGET:
      return "AcceleratorPhase::PRE_TARGET";
    case AcceleratorPhase::POST_TARGET:
      return "AcceleratorPhase::POST_TARGET";
    default:
      return base::StringPrintf("Unknown AcceleratorPhase value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, AcceleratorPhase value) {
  return os << AcceleratorPhaseToString(value);
}

std::string EventTypeToString(EventType value) {
  switch(value) {
    case EventType::UNKNOWN:
      return "EventType::UNKNOWN";
    case EventType::KEY_PRESSED:
      return "EventType::KEY_PRESSED";
    case EventType::KEY_RELEASED:
      return "EventType::KEY_RELEASED";
    case EventType::GESTURE_TAP:
      return "EventType::GESTURE_TAP";
    case EventType::GESTURE_SWIPE:
      return "EventType::GESTURE_SWIPE";
    case EventType::GESTURE_PINCH_BEGIN:
      return "EventType::GESTURE_PINCH_BEGIN";
    case EventType::GESTURE_PINCH_END:
      return "EventType::GESTURE_PINCH_END";
    case EventType::GESTURE_PINCH_UPDATE:
      return "EventType::GESTURE_PINCH_UPDATE";
    case EventType::SCROLL:
      return "EventType::SCROLL";
    case EventType::SCROLL_FLING_START:
      return "EventType::SCROLL_FLING_START";
    case EventType::SCROLL_FLING_CANCEL:
      return "EventType::SCROLL_FLING_CANCEL";
    case EventType::CANCEL_MODE:
      return "EventType::CANCEL_MODE";
    case EventType::MOUSE_PRESSED_EVENT:
      return "EventType::MOUSE_PRESSED_EVENT";
    case EventType::MOUSE_DRAGGED_EVENT:
      return "EventType::MOUSE_DRAGGED_EVENT";
    case EventType::MOUSE_RELEASED_EVENT:
      return "EventType::MOUSE_RELEASED_EVENT";
    case EventType::MOUSE_MOVED_EVENT:
      return "EventType::MOUSE_MOVED_EVENT";
    case EventType::MOUSE_ENTERED_EVENT:
      return "EventType::MOUSE_ENTERED_EVENT";
    case EventType::MOUSE_EXITED_EVENT:
      return "EventType::MOUSE_EXITED_EVENT";
    case EventType::MOUSE_WHEEL_EVENT:
      return "EventType::MOUSE_WHEEL_EVENT";
    case EventType::MOUSE_CAPTURE_CHANGED_EVENT:
      return "EventType::MOUSE_CAPTURE_CHANGED_EVENT";
    case EventType::TOUCH_RELEASED:
      return "EventType::TOUCH_RELEASED";
    case EventType::TOUCH_PRESSED:
      return "EventType::TOUCH_PRESSED";
    case EventType::TOUCH_MOVED:
      return "EventType::TOUCH_MOVED";
    case EventType::TOUCH_CANCELLED:
      return "EventType::TOUCH_CANCELLED";
    default:
      return base::StringPrintf("Unknown EventType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, EventType value) {
  return os << EventTypeToString(value);
}

std::string ScrollEventPhaseToString(ScrollEventPhase value) {
  switch(value) {
    case ScrollEventPhase::kNone:
      return "ScrollEventPhase::kNone";
    case ScrollEventPhase::kBegan:
      return "ScrollEventPhase::kBegan";
    case ScrollEventPhase::kUpdate:
      return "ScrollEventPhase::kUpdate";
    case ScrollEventPhase::kEnd:
      return "ScrollEventPhase::kEnd";
    default:
      return base::StringPrintf("Unknown ScrollEventPhase value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ScrollEventPhase value) {
  return os << ScrollEventPhaseToString(value);
}

std::string EventMomentumPhaseToString(EventMomentumPhase value) {
  switch(value) {
    case EventMomentumPhase::NONE:
      return "EventMomentumPhase::NONE";
    case EventMomentumPhase::BEGAN:
      return "EventMomentumPhase::BEGAN";
    case EventMomentumPhase::MAY_BEGIN:
      return "EventMomentumPhase::MAY_BEGIN";
    case EventMomentumPhase::INERTIAL_UPDATE:
      return "EventMomentumPhase::INERTIAL_UPDATE";
    case EventMomentumPhase::END:
      return "EventMomentumPhase::END";
    case EventMomentumPhase::BLOCKED:
      return "EventMomentumPhase::BLOCKED";
    default:
      return base::StringPrintf("Unknown EventMomentumPhase value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, EventMomentumPhase value) {
  return os << EventMomentumPhaseToString(value);
}

std::string GestureDeviceTypeToString(GestureDeviceType value) {
  switch(value) {
    case GestureDeviceType::DEVICE_UNKNOWN:
      return "GestureDeviceType::DEVICE_UNKNOWN";
    case GestureDeviceType::DEVICE_TOUCHPAD:
      return "GestureDeviceType::DEVICE_TOUCHPAD";
    case GestureDeviceType::DEVICE_TOUCHSCREEN:
      return "GestureDeviceType::DEVICE_TOUCHSCREEN";
    default:
      return base::StringPrintf("Unknown GestureDeviceType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, GestureDeviceType value) {
  return os << GestureDeviceTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::AcceleratorPhase>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::AcceleratorPhase value) {
  return std::move(context).WriteString(::ui::mojom::AcceleratorPhaseToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::EventType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::EventType value) {
  return std::move(context).WriteString(::ui::mojom::EventTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::ScrollEventPhase>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::ScrollEventPhase value) {
  return std::move(context).WriteString(::ui::mojom::ScrollEventPhaseToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::EventMomentumPhase>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::EventMomentumPhase value) {
  return std::move(context).WriteString(::ui::mojom::EventMomentumPhaseToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::GestureDeviceType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::GestureDeviceType value) {
  return std::move(context).WriteString(::ui::mojom::GestureDeviceTypeToString(value));
}

} // namespace perfetto
