// ui/events/mojom/keyboard_codes.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/events/mojom/keyboard_codes.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/events/mojom/keyboard_codes.mojom-params-data.h"
namespace ui {
namespace mojom {

std::string KeyboardCodeToString(KeyboardCode value) {
  switch(value) {
    case KeyboardCode::UNKNOWN:
      return "KeyboardCode::UNKNOWN";
    case KeyboardCode::BACK:
      return "KeyboardCode::BACK";
    case KeyboardCode::TAB:
      return "KeyboardCode::TAB";
    case KeyboardCode::CLEAR:
      return "KeyboardCode::CLEAR";
    case KeyboardCode::RETURN:
      return "KeyboardCode::RETURN";
    case KeyboardCode::SHIFT:
      return "KeyboardCode::SHIFT";
    case KeyboardCode::CONTROL:
      return "KeyboardCode::CONTROL";
    case KeyboardCode::MENU:
      return "KeyboardCode::MENU";
    case KeyboardCode::PAUSE:
      return "KeyboardCode::PAUSE";
    case KeyboardCode::CAPITAL:
      return "KeyboardCode::CAPITAL";
    case KeyboardCode::KANA:
      return "KeyboardCode::{KANA, HANGUL}";
    case KeyboardCode::JUNJA:
      return "KeyboardCode::JUNJA";
    case KeyboardCode::FINAL:
      return "KeyboardCode::FINAL";
    case KeyboardCode::HANJA:
      return "KeyboardCode::{HANJA, KANJI}";
    case KeyboardCode::ESCAPE:
      return "KeyboardCode::ESCAPE";
    case KeyboardCode::CONVERT:
      return "KeyboardCode::CONVERT";
    case KeyboardCode::NONCONVERT:
      return "KeyboardCode::NONCONVERT";
    case KeyboardCode::ACCEPT:
      return "KeyboardCode::ACCEPT";
    case KeyboardCode::MODECHANGE:
      return "KeyboardCode::MODECHANGE";
    case KeyboardCode::SPACE:
      return "KeyboardCode::SPACE";
    case KeyboardCode::PRIOR:
      return "KeyboardCode::PRIOR";
    case KeyboardCode::NEXT:
      return "KeyboardCode::NEXT";
    case KeyboardCode::END:
      return "KeyboardCode::END";
    case KeyboardCode::HOME:
      return "KeyboardCode::HOME";
    case KeyboardCode::LEFT:
      return "KeyboardCode::LEFT";
    case KeyboardCode::UP:
      return "KeyboardCode::UP";
    case KeyboardCode::RIGHT:
      return "KeyboardCode::RIGHT";
    case KeyboardCode::DOWN:
      return "KeyboardCode::DOWN";
    case KeyboardCode::SELECT:
      return "KeyboardCode::SELECT";
    case KeyboardCode::PRINT:
      return "KeyboardCode::PRINT";
    case KeyboardCode::EXECUTE:
      return "KeyboardCode::EXECUTE";
    case KeyboardCode::SNAPSHOT:
      return "KeyboardCode::SNAPSHOT";
    case KeyboardCode::INSERT:
      return "KeyboardCode::INSERT";
    case KeyboardCode::KEY_DELETE:
      return "KeyboardCode::KEY_DELETE";
    case KeyboardCode::HELP:
      return "KeyboardCode::HELP";
    case KeyboardCode::NUM_0:
      return "KeyboardCode::NUM_0";
    case KeyboardCode::NUM_1:
      return "KeyboardCode::NUM_1";
    case KeyboardCode::NUM_2:
      return "KeyboardCode::NUM_2";
    case KeyboardCode::NUM_3:
      return "KeyboardCode::NUM_3";
    case KeyboardCode::NUM_4:
      return "KeyboardCode::NUM_4";
    case KeyboardCode::NUM_5:
      return "KeyboardCode::NUM_5";
    case KeyboardCode::NUM_6:
      return "KeyboardCode::NUM_6";
    case KeyboardCode::NUM_7:
      return "KeyboardCode::NUM_7";
    case KeyboardCode::NUM_8:
      return "KeyboardCode::NUM_8";
    case KeyboardCode::NUM_9:
      return "KeyboardCode::NUM_9";
    case KeyboardCode::A:
      return "KeyboardCode::A";
    case KeyboardCode::B:
      return "KeyboardCode::B";
    case KeyboardCode::C:
      return "KeyboardCode::C";
    case KeyboardCode::D:
      return "KeyboardCode::D";
    case KeyboardCode::E:
      return "KeyboardCode::E";
    case KeyboardCode::F:
      return "KeyboardCode::F";
    case KeyboardCode::G:
      return "KeyboardCode::G";
    case KeyboardCode::H:
      return "KeyboardCode::H";
    case KeyboardCode::I:
      return "KeyboardCode::I";
    case KeyboardCode::J:
      return "KeyboardCode::J";
    case KeyboardCode::K:
      return "KeyboardCode::K";
    case KeyboardCode::L:
      return "KeyboardCode::L";
    case KeyboardCode::M:
      return "KeyboardCode::M";
    case KeyboardCode::N:
      return "KeyboardCode::N";
    case KeyboardCode::O:
      return "KeyboardCode::O";
    case KeyboardCode::P:
      return "KeyboardCode::P";
    case KeyboardCode::Q:
      return "KeyboardCode::Q";
    case KeyboardCode::R:
      return "KeyboardCode::R";
    case KeyboardCode::S:
      return "KeyboardCode::S";
    case KeyboardCode::T:
      return "KeyboardCode::T";
    case KeyboardCode::U:
      return "KeyboardCode::U";
    case KeyboardCode::V:
      return "KeyboardCode::V";
    case KeyboardCode::W:
      return "KeyboardCode::W";
    case KeyboardCode::X:
      return "KeyboardCode::X";
    case KeyboardCode::Y:
      return "KeyboardCode::Y";
    case KeyboardCode::Z:
      return "KeyboardCode::Z";
    case KeyboardCode::LWIN:
      return "KeyboardCode::{LWIN, COMMAND}";
    case KeyboardCode::RWIN:
      return "KeyboardCode::RWIN";
    case KeyboardCode::APPS:
      return "KeyboardCode::APPS";
    case KeyboardCode::SLEEP:
      return "KeyboardCode::SLEEP";
    case KeyboardCode::NUMPAD0:
      return "KeyboardCode::NUMPAD0";
    case KeyboardCode::NUMPAD1:
      return "KeyboardCode::NUMPAD1";
    case KeyboardCode::NUMPAD2:
      return "KeyboardCode::NUMPAD2";
    case KeyboardCode::NUMPAD3:
      return "KeyboardCode::NUMPAD3";
    case KeyboardCode::NUMPAD4:
      return "KeyboardCode::NUMPAD4";
    case KeyboardCode::NUMPAD5:
      return "KeyboardCode::NUMPAD5";
    case KeyboardCode::NUMPAD6:
      return "KeyboardCode::NUMPAD6";
    case KeyboardCode::NUMPAD7:
      return "KeyboardCode::NUMPAD7";
    case KeyboardCode::NUMPAD8:
      return "KeyboardCode::NUMPAD8";
    case KeyboardCode::NUMPAD9:
      return "KeyboardCode::NUMPAD9";
    case KeyboardCode::MULTIPLY:
      return "KeyboardCode::MULTIPLY";
    case KeyboardCode::ADD:
      return "KeyboardCode::ADD";
    case KeyboardCode::SEPARATOR:
      return "KeyboardCode::SEPARATOR";
    case KeyboardCode::SUBTRACT:
      return "KeyboardCode::SUBTRACT";
    case KeyboardCode::DECIMAL:
      return "KeyboardCode::DECIMAL";
    case KeyboardCode::DIVIDE:
      return "KeyboardCode::DIVIDE";
    case KeyboardCode::F1:
      return "KeyboardCode::F1";
    case KeyboardCode::F2:
      return "KeyboardCode::F2";
    case KeyboardCode::F3:
      return "KeyboardCode::F3";
    case KeyboardCode::F4:
      return "KeyboardCode::F4";
    case KeyboardCode::F5:
      return "KeyboardCode::F5";
    case KeyboardCode::F6:
      return "KeyboardCode::F6";
    case KeyboardCode::F7:
      return "KeyboardCode::F7";
    case KeyboardCode::F8:
      return "KeyboardCode::F8";
    case KeyboardCode::F9:
      return "KeyboardCode::F9";
    case KeyboardCode::F10:
      return "KeyboardCode::F10";
    case KeyboardCode::F11:
      return "KeyboardCode::F11";
    case KeyboardCode::F12:
      return "KeyboardCode::F12";
    case KeyboardCode::F13:
      return "KeyboardCode::F13";
    case KeyboardCode::F14:
      return "KeyboardCode::F14";
    case KeyboardCode::F15:
      return "KeyboardCode::F15";
    case KeyboardCode::F16:
      return "KeyboardCode::F16";
    case KeyboardCode::F17:
      return "KeyboardCode::F17";
    case KeyboardCode::F18:
      return "KeyboardCode::F18";
    case KeyboardCode::F19:
      return "KeyboardCode::F19";
    case KeyboardCode::F20:
      return "KeyboardCode::F20";
    case KeyboardCode::F21:
      return "KeyboardCode::F21";
    case KeyboardCode::F22:
      return "KeyboardCode::F22";
    case KeyboardCode::F23:
      return "KeyboardCode::F23";
    case KeyboardCode::F24:
      return "KeyboardCode::F24";
    case KeyboardCode::NUMLOCK:
      return "KeyboardCode::NUMLOCK";
    case KeyboardCode::SCROLL:
      return "KeyboardCode::SCROLL";
    case KeyboardCode::WLAN:
      return "KeyboardCode::WLAN";
    case KeyboardCode::POWER:
      return "KeyboardCode::POWER";
    case KeyboardCode::ASSISTANT:
      return "KeyboardCode::ASSISTANT";
    case KeyboardCode::LSHIFT:
      return "KeyboardCode::LSHIFT";
    case KeyboardCode::RSHIFT:
      return "KeyboardCode::RSHIFT";
    case KeyboardCode::LCONTROL:
      return "KeyboardCode::LCONTROL";
    case KeyboardCode::RCONTROL:
      return "KeyboardCode::RCONTROL";
    case KeyboardCode::LMENU:
      return "KeyboardCode::LMENU";
    case KeyboardCode::RMENU:
      return "KeyboardCode::RMENU";
    case KeyboardCode::BROWSER_BACK:
      return "KeyboardCode::BROWSER_BACK";
    case KeyboardCode::BROWSER_FORWARD:
      return "KeyboardCode::BROWSER_FORWARD";
    case KeyboardCode::BROWSER_REFRESH:
      return "KeyboardCode::BROWSER_REFRESH";
    case KeyboardCode::BROWSER_STOP:
      return "KeyboardCode::BROWSER_STOP";
    case KeyboardCode::BROWSER_SEARCH:
      return "KeyboardCode::BROWSER_SEARCH";
    case KeyboardCode::BROWSER_FAVORITES:
      return "KeyboardCode::BROWSER_FAVORITES";
    case KeyboardCode::BROWSER_HOME:
      return "KeyboardCode::BROWSER_HOME";
    case KeyboardCode::VOLUME_MUTE:
      return "KeyboardCode::VOLUME_MUTE";
    case KeyboardCode::VOLUME_DOWN:
      return "KeyboardCode::VOLUME_DOWN";
    case KeyboardCode::VOLUME_UP:
      return "KeyboardCode::VOLUME_UP";
    case KeyboardCode::MEDIA_NEXT_TRACK:
      return "KeyboardCode::MEDIA_NEXT_TRACK";
    case KeyboardCode::MEDIA_PREV_TRACK:
      return "KeyboardCode::MEDIA_PREV_TRACK";
    case KeyboardCode::MEDIA_STOP:
      return "KeyboardCode::MEDIA_STOP";
    case KeyboardCode::MEDIA_PLAY_PAUSE:
      return "KeyboardCode::MEDIA_PLAY_PAUSE";
    case KeyboardCode::MEDIA_LAUNCH_MAIL:
      return "KeyboardCode::MEDIA_LAUNCH_MAIL";
    case KeyboardCode::MEDIA_LAUNCH_MEDIA_SELECT:
      return "KeyboardCode::MEDIA_LAUNCH_MEDIA_SELECT";
    case KeyboardCode::MEDIA_LAUNCH_APP1:
      return "KeyboardCode::MEDIA_LAUNCH_APP1";
    case KeyboardCode::MEDIA_LAUNCH_APP2:
      return "KeyboardCode::MEDIA_LAUNCH_APP2";
    case KeyboardCode::OEM_1:
      return "KeyboardCode::OEM_1";
    case KeyboardCode::OEM_PLUS:
      return "KeyboardCode::OEM_PLUS";
    case KeyboardCode::OEM_COMMA:
      return "KeyboardCode::OEM_COMMA";
    case KeyboardCode::OEM_MINUS:
      return "KeyboardCode::OEM_MINUS";
    case KeyboardCode::OEM_PERIOD:
      return "KeyboardCode::OEM_PERIOD";
    case KeyboardCode::OEM_2:
      return "KeyboardCode::OEM_2";
    case KeyboardCode::OEM_3:
      return "KeyboardCode::OEM_3";
    case KeyboardCode::BRIGHTNESS_DOWN:
      return "KeyboardCode::BRIGHTNESS_DOWN";
    case KeyboardCode::BRIGHTNESS_UP:
      return "KeyboardCode::BRIGHTNESS_UP";
    case KeyboardCode::KBD_BRIGHTNESS_DOWN:
      return "KeyboardCode::KBD_BRIGHTNESS_DOWN";
    case KeyboardCode::OEM_4:
      return "KeyboardCode::OEM_4";
    case KeyboardCode::OEM_5:
      return "KeyboardCode::OEM_5";
    case KeyboardCode::OEM_6:
      return "KeyboardCode::OEM_6";
    case KeyboardCode::OEM_7:
      return "KeyboardCode::OEM_7";
    case KeyboardCode::OEM_8:
      return "KeyboardCode::OEM_8";
    case KeyboardCode::ALTGR:
      return "KeyboardCode::ALTGR";
    case KeyboardCode::OEM_102:
      return "KeyboardCode::OEM_102";
    case KeyboardCode::PROCESSKEY:
      return "KeyboardCode::PROCESSKEY";
    case KeyboardCode::COMPOSE:
      return "KeyboardCode::COMPOSE";
    case KeyboardCode::PACKET:
      return "KeyboardCode::PACKET";
    case KeyboardCode::KBD_BRIGHTNESS_UP:
      return "KeyboardCode::KBD_BRIGHTNESS_UP";
    case KeyboardCode::DBE_SBCSCHAR:
      return "KeyboardCode::DBE_SBCSCHAR";
    case KeyboardCode::DBE_DBCSCHAR:
      return "KeyboardCode::DBE_DBCSCHAR";
    case KeyboardCode::ATTN:
      return "KeyboardCode::ATTN";
    case KeyboardCode::CRSEL:
      return "KeyboardCode::CRSEL";
    case KeyboardCode::EXSEL:
      return "KeyboardCode::EXSEL";
    case KeyboardCode::EREOF:
      return "KeyboardCode::EREOF";
    case KeyboardCode::PLAY:
      return "KeyboardCode::PLAY";
    case KeyboardCode::ZOOM:
      return "KeyboardCode::ZOOM";
    case KeyboardCode::NONAME:
      return "KeyboardCode::NONAME";
    case KeyboardCode::PA1:
      return "KeyboardCode::PA1";
    case KeyboardCode::OEM_CLEAR:
      return "KeyboardCode::OEM_CLEAR";
    default:
      return base::StringPrintf("Unknown KeyboardCode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, KeyboardCode value) {
  return os << KeyboardCodeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::KeyboardCode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::ui::mojom::KeyboardCode value) {
  return std::move(context).WriteString(::ui::mojom::KeyboardCodeToString(value));
}

} // namespace perfetto
