// ui/gfx/mojom/buffer_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/buffer_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/gfx/mojom/buffer_types.mojom-params-data.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/buffer_types.mojom-import-headers.h"


#ifndef UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_JUMBO_H_
#define UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_JUMBO_H_
#endif
namespace gfx {
namespace mojom {
BufferUsageAndFormat::BufferUsageAndFormat()
    : usage(),
      format() {}

BufferUsageAndFormat::BufferUsageAndFormat(
    ::gfx::BufferUsage usage_in,
    ::gfx::BufferFormat format_in)
    : usage(std::move(usage_in)),
      format(std::move(format_in)) {}

BufferUsageAndFormat::~BufferUsageAndFormat() = default;

void BufferUsageAndFormat::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage, 
      "<value of type ::gfx::BufferUsage>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format, 
      "<value of type ::gfx::BufferFormat>");
}

bool BufferUsageAndFormat::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuMemoryBufferId::GpuMemoryBufferId()
    : id() {}

GpuMemoryBufferId::GpuMemoryBufferId(
    int32_t id_in)
    : id(std::move(id_in)) {}

GpuMemoryBufferId::~GpuMemoryBufferId() = default;

void GpuMemoryBufferId::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type int32_t>");
}

bool GpuMemoryBufferId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuMemoryBufferHandle::GpuMemoryBufferHandle()
    : id(),
      offset(),
      stride(),
      platform_handle() {}

GpuMemoryBufferHandle::GpuMemoryBufferHandle(
    ::gfx::GpuMemoryBufferId id_in,
    uint32_t offset_in,
    uint32_t stride_in,
    ::gfx::mojom::GpuMemoryBufferPlatformHandlePtr platform_handle_in)
    : id(std::move(id_in)),
      offset(std::move(offset_in)),
      stride(std::move(stride_in)),
      platform_handle(std::move(platform_handle_in)) {}

GpuMemoryBufferHandle::~GpuMemoryBufferHandle() = default;

void GpuMemoryBufferHandle::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id, 
      "<value of type ::gfx::GpuMemoryBufferId>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stride"), this->stride, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "platform_handle"), this->platform_handle, 
      "<value of type ::gfx::mojom::GpuMemoryBufferPlatformHandlePtr>");
}

bool GpuMemoryBufferHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace gfx

namespace mojo {


// static
bool StructTraits<::gfx::mojom::BufferUsageAndFormat::DataView, ::gfx::mojom::BufferUsageAndFormatPtr>::Read(
    ::gfx::mojom::BufferUsageAndFormat::DataView input,
    ::gfx::mojom::BufferUsageAndFormatPtr* output) {
  bool success = true;
  ::gfx::mojom::BufferUsageAndFormatPtr result(::gfx::mojom::BufferUsageAndFormat::New());
  
      if (success && !input.ReadUsage(&result->usage))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gfx::mojom::GpuMemoryBufferId::DataView, ::gfx::mojom::GpuMemoryBufferIdPtr>::Read(
    ::gfx::mojom::GpuMemoryBufferId::DataView input,
    ::gfx::mojom::GpuMemoryBufferIdPtr* output) {
  bool success = true;
  ::gfx::mojom::GpuMemoryBufferIdPtr result(::gfx::mojom::GpuMemoryBufferId::New());
  
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gfx::mojom::GpuMemoryBufferHandle::DataView, ::gfx::mojom::GpuMemoryBufferHandlePtr>::Read(
    ::gfx::mojom::GpuMemoryBufferHandle::DataView input,
    ::gfx::mojom::GpuMemoryBufferHandlePtr* output) {
  bool success = true;
  ::gfx::mojom::GpuMemoryBufferHandlePtr result(::gfx::mojom::GpuMemoryBufferHandle::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success)
        result->offset = input.offset();
      if (success)
        result->stride = input.stride();
      if (success && !input.ReadPlatformHandle(&result->platform_handle))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif