// ui/gfx/mojom/color_space.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gfx/mojom/color_space.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/color_space.mojom-params-data.h"
namespace gfx {
namespace mojom {

std::string ColorSpacePrimaryIDToString(ColorSpacePrimaryID value) {
  switch(value) {
    case ColorSpacePrimaryID::INVALID:
      return "ColorSpacePrimaryID::INVALID";
    case ColorSpacePrimaryID::BT709:
      return "ColorSpacePrimaryID::BT709";
    case ColorSpacePrimaryID::BT470M:
      return "ColorSpacePrimaryID::BT470M";
    case ColorSpacePrimaryID::BT470BG:
      return "ColorSpacePrimaryID::BT470BG";
    case ColorSpacePrimaryID::SMPTE170M:
      return "ColorSpacePrimaryID::SMPTE170M";
    case ColorSpacePrimaryID::SMPTE240M:
      return "ColorSpacePrimaryID::SMPTE240M";
    case ColorSpacePrimaryID::FILM:
      return "ColorSpacePrimaryID::FILM";
    case ColorSpacePrimaryID::BT2020:
      return "ColorSpacePrimaryID::BT2020";
    case ColorSpacePrimaryID::SMPTEST428_1:
      return "ColorSpacePrimaryID::SMPTEST428_1";
    case ColorSpacePrimaryID::SMPTEST431_2:
      return "ColorSpacePrimaryID::SMPTEST431_2";
    case ColorSpacePrimaryID::SMPTEST432_1:
      return "ColorSpacePrimaryID::SMPTEST432_1";
    case ColorSpacePrimaryID::XYZ_D50:
      return "ColorSpacePrimaryID::XYZ_D50";
    case ColorSpacePrimaryID::ADOBE_RGB:
      return "ColorSpacePrimaryID::ADOBE_RGB";
    case ColorSpacePrimaryID::APPLE_GENERIC_RGB:
      return "ColorSpacePrimaryID::APPLE_GENERIC_RGB";
    case ColorSpacePrimaryID::WIDE_GAMUT_COLOR_SPIN:
      return "ColorSpacePrimaryID::WIDE_GAMUT_COLOR_SPIN";
    case ColorSpacePrimaryID::CUSTOM:
      return "ColorSpacePrimaryID::CUSTOM";
    default:
      return base::StringPrintf("Unknown ColorSpacePrimaryID value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ColorSpacePrimaryID value) {
  return os << ColorSpacePrimaryIDToString(value);
}

std::string ColorSpaceTransferIDToString(ColorSpaceTransferID value) {
  switch(value) {
    case ColorSpaceTransferID::INVALID:
      return "ColorSpaceTransferID::INVALID";
    case ColorSpaceTransferID::BT709:
      return "ColorSpaceTransferID::BT709";
    case ColorSpaceTransferID::BT709_APPLE:
      return "ColorSpaceTransferID::BT709_APPLE";
    case ColorSpaceTransferID::GAMMA18:
      return "ColorSpaceTransferID::GAMMA18";
    case ColorSpaceTransferID::GAMMA22:
      return "ColorSpaceTransferID::GAMMA22";
    case ColorSpaceTransferID::GAMMA24:
      return "ColorSpaceTransferID::GAMMA24";
    case ColorSpaceTransferID::GAMMA28:
      return "ColorSpaceTransferID::GAMMA28";
    case ColorSpaceTransferID::SMPTE170M:
      return "ColorSpaceTransferID::SMPTE170M";
    case ColorSpaceTransferID::SMPTE240M:
      return "ColorSpaceTransferID::SMPTE240M";
    case ColorSpaceTransferID::LINEAR:
      return "ColorSpaceTransferID::LINEAR";
    case ColorSpaceTransferID::LOG:
      return "ColorSpaceTransferID::LOG";
    case ColorSpaceTransferID::LOG_SQRT:
      return "ColorSpaceTransferID::LOG_SQRT";
    case ColorSpaceTransferID::IEC61966_2_4:
      return "ColorSpaceTransferID::IEC61966_2_4";
    case ColorSpaceTransferID::BT1361_ECG:
      return "ColorSpaceTransferID::BT1361_ECG";
    case ColorSpaceTransferID::IEC61966_2_1:
      return "ColorSpaceTransferID::IEC61966_2_1";
    case ColorSpaceTransferID::BT2020_10:
      return "ColorSpaceTransferID::BT2020_10";
    case ColorSpaceTransferID::BT2020_12:
      return "ColorSpaceTransferID::BT2020_12";
    case ColorSpaceTransferID::SMPTEST2084:
      return "ColorSpaceTransferID::SMPTEST2084";
    case ColorSpaceTransferID::SMPTEST428_1:
      return "ColorSpaceTransferID::SMPTEST428_1";
    case ColorSpaceTransferID::ARIB_STD_B67:
      return "ColorSpaceTransferID::ARIB_STD_B67";
    case ColorSpaceTransferID::IEC61966_2_1_HDR:
      return "ColorSpaceTransferID::IEC61966_2_1_HDR";
    case ColorSpaceTransferID::LINEAR_HDR:
      return "ColorSpaceTransferID::LINEAR_HDR";
    case ColorSpaceTransferID::CUSTOM:
      return "ColorSpaceTransferID::CUSTOM";
    case ColorSpaceTransferID::CUSTOM_HDR:
      return "ColorSpaceTransferID::CUSTOM_HDR";
    case ColorSpaceTransferID::PIECEWISE_HDR:
      return "ColorSpaceTransferID::PIECEWISE_HDR";
    default:
      return base::StringPrintf("Unknown ColorSpaceTransferID value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ColorSpaceTransferID value) {
  return os << ColorSpaceTransferIDToString(value);
}

std::string ColorSpaceMatrixIDToString(ColorSpaceMatrixID value) {
  switch(value) {
    case ColorSpaceMatrixID::INVALID:
      return "ColorSpaceMatrixID::INVALID";
    case ColorSpaceMatrixID::RGB:
      return "ColorSpaceMatrixID::RGB";
    case ColorSpaceMatrixID::BT709:
      return "ColorSpaceMatrixID::BT709";
    case ColorSpaceMatrixID::FCC:
      return "ColorSpaceMatrixID::FCC";
    case ColorSpaceMatrixID::BT470BG:
      return "ColorSpaceMatrixID::BT470BG";
    case ColorSpaceMatrixID::SMPTE170M:
      return "ColorSpaceMatrixID::SMPTE170M";
    case ColorSpaceMatrixID::SMPTE240M:
      return "ColorSpaceMatrixID::SMPTE240M";
    case ColorSpaceMatrixID::YCOCG:
      return "ColorSpaceMatrixID::YCOCG";
    case ColorSpaceMatrixID::BT2020_NCL:
      return "ColorSpaceMatrixID::BT2020_NCL";
    case ColorSpaceMatrixID::BT2020_CL:
      return "ColorSpaceMatrixID::BT2020_CL";
    case ColorSpaceMatrixID::YDZDX:
      return "ColorSpaceMatrixID::YDZDX";
    case ColorSpaceMatrixID::GBR:
      return "ColorSpaceMatrixID::GBR";
    default:
      return base::StringPrintf("Unknown ColorSpaceMatrixID value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ColorSpaceMatrixID value) {
  return os << ColorSpaceMatrixIDToString(value);
}

std::string ColorSpaceRangeIDToString(ColorSpaceRangeID value) {
  switch(value) {
    case ColorSpaceRangeID::INVALID:
      return "ColorSpaceRangeID::INVALID";
    case ColorSpaceRangeID::LIMITED:
      return "ColorSpaceRangeID::LIMITED";
    case ColorSpaceRangeID::FULL:
      return "ColorSpaceRangeID::FULL";
    case ColorSpaceRangeID::DERIVED:
      return "ColorSpaceRangeID::DERIVED";
    default:
      return base::StringPrintf("Unknown ColorSpaceRangeID value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ColorSpaceRangeID value) {
  return os << ColorSpaceRangeIDToString(value);
}

namespace internal {


// static
bool ColorSpace_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ColorSpace_Data* object = static_cast<const ColorSpace_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::gfx::mojom::internal::ColorSpacePrimaryID_Data
        ::Validate(object->primaries, validation_context))
    return false;


  if (!::gfx::mojom::internal::ColorSpaceTransferID_Data
        ::Validate(object->transfer, validation_context))
    return false;


  if (!::gfx::mojom::internal::ColorSpaceMatrixID_Data
        ::Validate(object->matrix, validation_context))
    return false;


  if (!::gfx::mojom::internal::ColorSpaceRangeID_Data
        ::Validate(object->range, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->custom_primary_matrix, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams custom_primary_matrix_validate_params(
      9, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->custom_primary_matrix, validation_context,
                                         &custom_primary_matrix_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transfer_params, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams transfer_params_validate_params(
      7, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->transfer_params, validation_context,
                                         &transfer_params_validate_params)) {
    return false;
  }

  return true;
}

ColorSpace_Data::ColorSpace_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gfx

namespace perfetto {

// static
void TraceFormatTraits<::gfx::mojom::ColorSpacePrimaryID>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::gfx::mojom::ColorSpacePrimaryID value) {
  return std::move(context).WriteString(::gfx::mojom::ColorSpacePrimaryIDToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gfx::mojom::ColorSpaceTransferID>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::gfx::mojom::ColorSpaceTransferID value) {
  return std::move(context).WriteString(::gfx::mojom::ColorSpaceTransferIDToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gfx::mojom::ColorSpaceMatrixID>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::gfx::mojom::ColorSpaceMatrixID value) {
  return std::move(context).WriteString(::gfx::mojom::ColorSpaceMatrixIDToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gfx::mojom::ColorSpaceRangeID>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::gfx::mojom::ColorSpaceRangeID value) {
  return std::move(context).WriteString(::gfx::mojom::ColorSpaceRangeIDToString(value));
}

} // namespace perfetto
