// ui/gfx/mojom/display_color_spaces.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/display_color_spaces.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/gfx/mojom/display_color_spaces.mojom-params-data.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/display_color_spaces.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_BLINK_JUMBO_H_
#define UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_BLINK_JUMBO_H_
#endif
namespace gfx {
namespace mojom {
namespace blink {
DisplayColorSpaces::DisplayColorSpaces()
    : color_spaces(),
      buffer_formats(),
      sdr_white_level() {}

DisplayColorSpaces::DisplayColorSpaces(
    WTF::Vector<::gfx::ColorSpace> color_spaces_in,
    WTF::Vector<::gfx::BufferFormat> buffer_formats_in,
    float sdr_white_level_in)
    : color_spaces(std::move(color_spaces_in)),
      buffer_formats(std::move(buffer_formats_in)),
      sdr_white_level(std::move(sdr_white_level_in)) {}

DisplayColorSpaces::~DisplayColorSpaces() = default;

void DisplayColorSpaces::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_spaces"), this->color_spaces, 
      "<value of type const WTF::Vector<::gfx::ColorSpace>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_formats"), this->buffer_formats, 
      "<value of type const WTF::Vector<::gfx::BufferFormat>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sdr_white_level"), this->sdr_white_level, 
      "<value of type float>");
}

bool DisplayColorSpaces::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace gfx

namespace mojo {


// static
bool StructTraits<::gfx::mojom::blink::DisplayColorSpaces::DataView, ::gfx::mojom::blink::DisplayColorSpacesPtr>::Read(
    ::gfx::mojom::blink::DisplayColorSpaces::DataView input,
    ::gfx::mojom::blink::DisplayColorSpacesPtr* output) {
  bool success = true;
  ::gfx::mojom::blink::DisplayColorSpacesPtr result(::gfx::mojom::blink::DisplayColorSpaces::New());
  
      if (success && !input.ReadColorSpaces(&result->color_spaces))
        success = false;
      if (success && !input.ReadBufferFormats(&result->buffer_formats))
        success = false;
      if (success)
        result->sdr_white_level = input.sdr_white_level();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif