// ui/gfx/mojom/display_color_spaces.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/display_color_spaces.mojom-params-data.h"
namespace gfx {
namespace mojom {

std::string ContentColorUsageToString(ContentColorUsage value) {
  switch(value) {
    case ContentColorUsage::kSRGB:
      return "ContentColorUsage::kSRGB";
    case ContentColorUsage::kWideColorGamut:
      return "ContentColorUsage::kWideColorGamut";
    case ContentColorUsage::kHDR:
      return "ContentColorUsage::kHDR";
    default:
      return base::StringPrintf("Unknown ContentColorUsage value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ContentColorUsage value) {
  return os << ContentColorUsageToString(value);
}

namespace internal {


// static
bool DisplayColorSpaces_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DisplayColorSpaces_Data* object = static_cast<const DisplayColorSpaces_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_spaces, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams color_spaces_validate_params(
      6, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->color_spaces, validation_context,
                                         &color_spaces_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer_formats, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams buffer_formats_validate_params(
      6, ::gfx::mojom::internal::BufferFormat_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->buffer_formats, validation_context,
                                         &buffer_formats_validate_params)) {
    return false;
  }

  return true;
}

DisplayColorSpaces_Data::DisplayColorSpaces_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gfx

namespace perfetto {

// static
void TraceFormatTraits<::gfx::mojom::ContentColorUsage>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::gfx::mojom::ContentColorUsage value) {
  return std::move(context).WriteString(::gfx::mojom::ContentColorUsageToString(value));
}

} // namespace perfetto
