// ui/gfx/mojom/hdr_metadata.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/hdr_metadata.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/gfx/mojom/hdr_metadata.mojom-params-data.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/hdr_metadata.mojom-import-headers.h"


#ifndef UI_GFX_MOJOM_HDR_METADATA_MOJOM_JUMBO_H_
#define UI_GFX_MOJOM_HDR_METADATA_MOJOM_JUMBO_H_
#endif
namespace gfx {
namespace mojom {
MasteringMetadata::MasteringMetadata()
    : primary_r(),
      primary_g(),
      primary_b(),
      white_point(),
      luminance_max(),
      luminance_min() {}

MasteringMetadata::MasteringMetadata(
    const ::gfx::PointF& primary_r_in,
    const ::gfx::PointF& primary_g_in,
    const ::gfx::PointF& primary_b_in,
    const ::gfx::PointF& white_point_in,
    float luminance_max_in,
    float luminance_min_in)
    : primary_r(std::move(primary_r_in)),
      primary_g(std::move(primary_g_in)),
      primary_b(std::move(primary_b_in)),
      white_point(std::move(white_point_in)),
      luminance_max(std::move(luminance_max_in)),
      luminance_min(std::move(luminance_min_in)) {}

MasteringMetadata::~MasteringMetadata() = default;

void MasteringMetadata::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_r"), this->primary_r, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_g"), this->primary_g, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_b"), this->primary_b, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "white_point"), this->white_point, 
      "<value of type const ::gfx::PointF&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "luminance_max"), this->luminance_max, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "luminance_min"), this->luminance_min, 
      "<value of type float>");
}

bool MasteringMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HDRMetadata::HDRMetadata()
    : mastering_metadata(),
      max_content_light_level(),
      max_frame_average_light_level() {}

HDRMetadata::HDRMetadata(
    const ::gfx::MasteringMetadata& mastering_metadata_in,
    uint32_t max_content_light_level_in,
    uint32_t max_frame_average_light_level_in)
    : mastering_metadata(std::move(mastering_metadata_in)),
      max_content_light_level(std::move(max_content_light_level_in)),
      max_frame_average_light_level(std::move(max_frame_average_light_level_in)) {}

HDRMetadata::~HDRMetadata() = default;

void HDRMetadata::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mastering_metadata"), this->mastering_metadata, 
      "<value of type const ::gfx::MasteringMetadata&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_content_light_level"), this->max_content_light_level, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_frame_average_light_level"), this->max_frame_average_light_level, 
      "<value of type uint32_t>");
}

bool HDRMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace gfx

namespace mojo {


// static
bool StructTraits<::gfx::mojom::MasteringMetadata::DataView, ::gfx::mojom::MasteringMetadataPtr>::Read(
    ::gfx::mojom::MasteringMetadata::DataView input,
    ::gfx::mojom::MasteringMetadataPtr* output) {
  bool success = true;
  ::gfx::mojom::MasteringMetadataPtr result(::gfx::mojom::MasteringMetadata::New());
  
      if (success && !input.ReadPrimaryR(&result->primary_r))
        success = false;
      if (success && !input.ReadPrimaryG(&result->primary_g))
        success = false;
      if (success && !input.ReadPrimaryB(&result->primary_b))
        success = false;
      if (success && !input.ReadWhitePoint(&result->white_point))
        success = false;
      if (success)
        result->luminance_max = input.luminance_max();
      if (success)
        result->luminance_min = input.luminance_min();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gfx::mojom::HDRMetadata::DataView, ::gfx::mojom::HDRMetadataPtr>::Read(
    ::gfx::mojom::HDRMetadata::DataView input,
    ::gfx::mojom::HDRMetadataPtr* output) {
  bool success = true;
  ::gfx::mojom::HDRMetadataPtr result(::gfx::mojom::HDRMetadata::New());
  
      if (success && !input.ReadMasteringMetadata(&result->mastering_metadata))
        success = false;
      if (success)
        result->max_content_light_level = input.max_content_light_level();
      if (success)
        result->max_frame_average_light_level = input.max_frame_average_light_level();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif