// ui/gfx/mojom/native_handle_types.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/native_handle_types.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/gfx/mojom/native_handle_types.mojom-params-data.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/native_handle_types.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_BLINK_JUMBO_H_
#define UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_BLINK_JUMBO_H_
#endif
namespace gfx {
namespace mojom {
namespace blink {
NativePixmapPlane::NativePixmapPlane()
    : stride(),
      offset(),
      size(),
      buffer_handle() {}

NativePixmapPlane::NativePixmapPlane(
    uint32_t stride_in,
    uint64_t offset_in,
    uint64_t size_in,
    ::mojo::PlatformHandle buffer_handle_in)
    : stride(std::move(stride_in)),
      offset(std::move(offset_in)),
      size(std::move(size_in)),
      buffer_handle(std::move(buffer_handle_in)) {}

NativePixmapPlane::~NativePixmapPlane() = default;

void NativePixmapPlane::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stride"), this->stride, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_handle"), this->buffer_handle, 
      "<value of type ::mojo::PlatformHandle>");
}

bool NativePixmapPlane::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NativePixmapHandle::NativePixmapHandle()
    : planes(),
      modifier() {}

NativePixmapHandle::NativePixmapHandle(
    WTF::Vector<::gfx::NativePixmapPlane> planes_in,
    uint64_t modifier_in)
    : planes(std::move(planes_in)),
      modifier(std::move(modifier_in)) {}

NativePixmapHandle::~NativePixmapHandle() = default;

void NativePixmapHandle::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "planes"), this->planes, 
      "<value of type WTF::Vector<::gfx::NativePixmapPlane>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifier"), this->modifier, 
      "<value of type uint64_t>");
}

bool NativePixmapHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuMemoryBufferPlatformHandle::GpuMemoryBufferPlatformHandle() : tag_(Tag::SHARED_MEMORY_HANDLE) {
  data_.shared_memory_handle = new ::base::UnsafeSharedMemoryRegion;
}

GpuMemoryBufferPlatformHandle::~GpuMemoryBufferPlatformHandle() {
  DestroyActive();
}


void GpuMemoryBufferPlatformHandle::set_shared_memory_handle(
    ::base::UnsafeSharedMemoryRegion shared_memory_handle) {
  if (tag_ == Tag::SHARED_MEMORY_HANDLE) {
    *(data_.shared_memory_handle) = std::move(shared_memory_handle);
  } else {
    DestroyActive();
    tag_ = Tag::SHARED_MEMORY_HANDLE;
    data_.shared_memory_handle = new ::base::UnsafeSharedMemoryRegion(
        std::move(shared_memory_handle));
  }
}
void GpuMemoryBufferPlatformHandle::set_native_pixmap_handle(
    ::gfx::NativePixmapHandle native_pixmap_handle) {
  if (tag_ == Tag::NATIVE_PIXMAP_HANDLE) {
    *(data_.native_pixmap_handle) = std::move(native_pixmap_handle);
  } else {
    DestroyActive();
    tag_ = Tag::NATIVE_PIXMAP_HANDLE;
    data_.native_pixmap_handle = new ::gfx::NativePixmapHandle(
        std::move(native_pixmap_handle));
  }
}

void GpuMemoryBufferPlatformHandle::DestroyActive() {
  switch (tag_) {

    case Tag::SHARED_MEMORY_HANDLE:

      delete data_.shared_memory_handle;
      break;
    case Tag::NATIVE_PIXMAP_HANDLE:

      delete data_.native_pixmap_handle;
      break;
  }
}

bool GpuMemoryBufferPlatformHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace blink
}  // namespace mojom
}  // namespace gfx

namespace mojo {


// static
bool StructTraits<::gfx::mojom::blink::NativePixmapPlane::DataView, ::gfx::mojom::blink::NativePixmapPlanePtr>::Read(
    ::gfx::mojom::blink::NativePixmapPlane::DataView input,
    ::gfx::mojom::blink::NativePixmapPlanePtr* output) {
  bool success = true;
  ::gfx::mojom::blink::NativePixmapPlanePtr result(::gfx::mojom::blink::NativePixmapPlane::New());
  
      if (success)
        result->stride = input.stride();
      if (success)
        result->offset = input.offset();
      if (success)
        result->size = input.size();
      if (success)
        result->buffer_handle = input.TakeBufferHandle();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gfx::mojom::blink::NativePixmapHandle::DataView, ::gfx::mojom::blink::NativePixmapHandlePtr>::Read(
    ::gfx::mojom::blink::NativePixmapHandle::DataView input,
    ::gfx::mojom::blink::NativePixmapHandlePtr* output) {
  bool success = true;
  ::gfx::mojom::blink::NativePixmapHandlePtr result(::gfx::mojom::blink::NativePixmapHandle::New());
  
      if (success && !input.ReadPlanes(&result->planes))
        success = false;
      if (success)
        result->modifier = input.modifier();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::gfx::mojom::blink::GpuMemoryBufferPlatformHandle::DataView, ::gfx::mojom::blink::GpuMemoryBufferPlatformHandlePtr>::Read(
    ::gfx::mojom::blink::GpuMemoryBufferPlatformHandle::DataView input,
    ::gfx::mojom::blink::GpuMemoryBufferPlatformHandlePtr* output) {
  using UnionType = ::gfx::mojom::blink::GpuMemoryBufferPlatformHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::SHARED_MEMORY_HANDLE: {
      ::base::UnsafeSharedMemoryRegion result_shared_memory_handle;
      if (!input.ReadSharedMemoryHandle(&result_shared_memory_handle))
        return false;

      *output = UnionType::NewSharedMemoryHandle(
          std::move(result_shared_memory_handle));
      break;
    }
    case Tag::NATIVE_PIXMAP_HANDLE: {
      ::gfx::NativePixmapHandle result_native_pixmap_handle;
      if (!input.ReadNativePixmapHandle(&result_native_pixmap_handle))
        return false;

      *output = UnionType::NewNativePixmapHandle(
          std::move(result_native_pixmap_handle));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif