// ui/gfx/mojom/swap_timings.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/swap_timings.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/gfx/mojom/swap_timings.mojom-params-data.h"
#include "ui/gfx/mojom/swap_timings.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/swap_timings.mojom-import-headers.h"


#ifndef UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_JUMBO_H_
#define UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_JUMBO_H_
#endif
namespace gfx {
namespace mojom {
SwapTimings::SwapTimings()
    : swap_start(),
      swap_end() {}

SwapTimings::SwapTimings(
    ::base::TimeTicks swap_start_in,
    ::base::TimeTicks swap_end_in)
    : swap_start(std::move(swap_start_in)),
      swap_end(std::move(swap_end_in)) {}

SwapTimings::~SwapTimings() = default;

void SwapTimings::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_start"), this->swap_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_end"), this->swap_end, 
      "<value of type ::base::TimeTicks>");
}

bool SwapTimings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace gfx

namespace mojo {


// static
bool StructTraits<::gfx::mojom::SwapTimings::DataView, ::gfx::mojom::SwapTimingsPtr>::Read(
    ::gfx::mojom::SwapTimings::DataView input,
    ::gfx::mojom::SwapTimingsPtr* output) {
  bool success = true;
  ::gfx::mojom::SwapTimingsPtr result(::gfx::mojom::SwapTimings::New());
  
      if (success && !input.ReadSwapStart(&result->swap_start))
        success = false;
      if (success && !input.ReadSwapEnd(&result->swap_end))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif