// ui/gl/mojom/gpu_preference.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gl/mojom/gpu_preference.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gl/mojom/gpu_preference.mojom-params-data.h"
namespace gl {
namespace mojom {

std::string GpuPreferenceToString(GpuPreference value) {
  switch(value) {
    case GpuPreference::kDefault:
      return "GpuPreference::kDefault";
    case GpuPreference::kLowPower:
      return "GpuPreference::kLowPower";
    case GpuPreference::kHighPerformance:
      return "GpuPreference::kHighPerformance";
    default:
      return base::StringPrintf("Unknown GpuPreference value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, GpuPreference value) {
  return os << GpuPreferenceToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace gl

namespace perfetto {

// static
void TraceFormatTraits<::gl::mojom::GpuPreference>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::gl::mojom::GpuPreference value) {
  return std::move(context).WriteString(::gl::mojom::GpuPreferenceToString(value));
}

} // namespace perfetto
