// ui/latency/mojom/latency_info.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/latency/mojom/latency_info.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/latency/mojom/latency_info.mojom-params-data.h"
#include "ui/latency/mojom/latency_info.mojom-shared-message-ids.h"

#include "ui/latency/mojom/latency_info.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_BLINK_JUMBO_H_
#define UI_LATENCY_MOJOM_LATENCY_INFO_MOJOM_BLINK_JUMBO_H_
#endif
namespace ui {
namespace mojom {
namespace blink {
LatencyInfo::LatencyInfo()
    : latency_components(),
      trace_id(),
      ukm_source_id(),
      coalesced(),
      began(),
      terminated(),
      source_event_type(),
      scroll_update_delta(),
      predicted_scroll_update_delta(),
      gesture_scroll_id() {}

LatencyInfo::LatencyInfo(
    const WTF::HashMap<::ui::LatencyComponentType, ::base::TimeTicks>& latency_components_in,
    int64_t trace_id_in,
    int64_t ukm_source_id_in,
    bool coalesced_in,
    bool began_in,
    bool terminated_in,
    SourceEventType source_event_type_in,
    float scroll_update_delta_in,
    float predicted_scroll_update_delta_in,
    int64_t gesture_scroll_id_in)
    : latency_components(std::move(latency_components_in)),
      trace_id(std::move(trace_id_in)),
      ukm_source_id(std::move(ukm_source_id_in)),
      coalesced(std::move(coalesced_in)),
      began(std::move(began_in)),
      terminated(std::move(terminated_in)),
      source_event_type(std::move(source_event_type_in)),
      scroll_update_delta(std::move(scroll_update_delta_in)),
      predicted_scroll_update_delta(std::move(predicted_scroll_update_delta_in)),
      gesture_scroll_id(std::move(gesture_scroll_id_in)) {}

LatencyInfo::~LatencyInfo() = default;

void LatencyInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latency_components"), this->latency_components, 
      "<value of type const WTF::HashMap<::ui::LatencyComponentType, ::base::TimeTicks>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_id"), this->trace_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ukm_source_id"), this->ukm_source_id, 
      "<value of type int64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coalesced"), this->coalesced, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "began"), this->began, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "terminated"), this->terminated, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_event_type"), this->source_event_type, 
      "<value of type SourceEventType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_update_delta"), this->scroll_update_delta, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "predicted_scroll_update_delta"), this->predicted_scroll_update_delta, 
      "<value of type float>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_scroll_id"), this->gesture_scroll_id, 
      "<value of type int64_t>");
}

bool LatencyInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace ui

namespace mojo {


// static
bool StructTraits<::ui::mojom::blink::LatencyInfo::DataView, ::ui::mojom::blink::LatencyInfoPtr>::Read(
    ::ui::mojom::blink::LatencyInfo::DataView input,
    ::ui::mojom::blink::LatencyInfoPtr* output) {
  bool success = true;
  ::ui::mojom::blink::LatencyInfoPtr result(::ui::mojom::blink::LatencyInfo::New());
  
      if (success && !input.ReadLatencyComponents(&result->latency_components))
        success = false;
      if (success)
        result->trace_id = input.trace_id();
      if (success)
        result->ukm_source_id = input.ukm_source_id();
      if (success)
        result->coalesced = input.coalesced();
      if (success)
        result->began = input.began();
      if (success)
        result->terminated = input.terminated();
      if (success && !input.ReadSourceEventType(&result->source_event_type))
        success = false;
      if (success)
        result->scroll_update_delta = input.scroll_update_delta();
      if (success)
        result->predicted_scroll_update_delta = input.predicted_scroll_update_delta();
      if (success)
        result->gesture_scroll_id = input.gesture_scroll_id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif