// ui/ozone/public/mojom/drm_device.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/ozone/public/mojom/drm_device.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/ozone/public/mojom/drm_device.mojom-params-data.h"
namespace ui {
namespace ozone {
namespace mojom {

namespace internal {


// static
bool DrmDevice_CreateWindow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_CreateWindow_Params_Data* object = static_cast<const DrmDevice_CreateWindow_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->widget, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->widget, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initial_bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initial_bounds, validation_context))
    return false;

  return true;
}

DrmDevice_CreateWindow_Params_Data::DrmDevice_CreateWindow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_DestroyWindow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_DestroyWindow_Params_Data* object = static_cast<const DrmDevice_DestroyWindow_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->widget, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->widget, validation_context))
    return false;

  return true;
}

DrmDevice_DestroyWindow_Params_Data::DrmDevice_DestroyWindow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_SetWindowBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_SetWindowBounds_Params_Data* object = static_cast<const DrmDevice_SetWindowBounds_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->widget, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->widget, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

DrmDevice_SetWindowBounds_Params_Data::DrmDevice_SetWindowBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_TakeDisplayControl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_TakeDisplayControl_Params_Data* object = static_cast<const DrmDevice_TakeDisplayControl_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DrmDevice_TakeDisplayControl_Params_Data::DrmDevice_TakeDisplayControl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_TakeDisplayControl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_TakeDisplayControl_ResponseParams_Data* object = static_cast<const DrmDevice_TakeDisplayControl_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DrmDevice_TakeDisplayControl_ResponseParams_Data::DrmDevice_TakeDisplayControl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_RelinquishDisplayControl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_RelinquishDisplayControl_Params_Data* object = static_cast<const DrmDevice_RelinquishDisplayControl_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DrmDevice_RelinquishDisplayControl_Params_Data::DrmDevice_RelinquishDisplayControl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_RelinquishDisplayControl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_RelinquishDisplayControl_ResponseParams_Data* object = static_cast<const DrmDevice_RelinquishDisplayControl_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DrmDevice_RelinquishDisplayControl_ResponseParams_Data::DrmDevice_RelinquishDisplayControl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_RefreshNativeDisplays_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_RefreshNativeDisplays_Params_Data* object = static_cast<const DrmDevice_RefreshNativeDisplays_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DrmDevice_RefreshNativeDisplays_Params_Data::DrmDevice_RefreshNativeDisplays_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_RefreshNativeDisplays_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_RefreshNativeDisplays_ResponseParams_Data* object = static_cast<const DrmDevice_RefreshNativeDisplays_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_snapshots, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams display_snapshots_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->display_snapshots, validation_context,
                                         &display_snapshots_validate_params)) {
    return false;
  }

  return true;
}

DrmDevice_RefreshNativeDisplays_ResponseParams_Data::DrmDevice_RefreshNativeDisplays_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_AddGraphicsDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_AddGraphicsDevice_Params_Data* object = static_cast<const DrmDevice_AddGraphicsDevice_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

DrmDevice_AddGraphicsDevice_Params_Data::DrmDevice_AddGraphicsDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_RemoveGraphicsDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_RemoveGraphicsDevice_Params_Data* object = static_cast<const DrmDevice_RemoveGraphicsDevice_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

DrmDevice_RemoveGraphicsDevice_Params_Data::DrmDevice_RemoveGraphicsDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_ConfigureNativeDisplays_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_ConfigureNativeDisplays_Params_Data* object = static_cast<const DrmDevice_ConfigureNativeDisplays_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config_requests, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams config_requests_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->config_requests, validation_context,
                                         &config_requests_validate_params)) {
    return false;
  }

  return true;
}

DrmDevice_ConfigureNativeDisplays_Params_Data::DrmDevice_ConfigureNativeDisplays_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_ConfigureNativeDisplays_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_ConfigureNativeDisplays_ResponseParams_Data* object = static_cast<const DrmDevice_ConfigureNativeDisplays_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DrmDevice_ConfigureNativeDisplays_ResponseParams_Data::DrmDevice_ConfigureNativeDisplays_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_GetHDCPState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_GetHDCPState_Params_Data* object = static_cast<const DrmDevice_GetHDCPState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DrmDevice_GetHDCPState_Params_Data::DrmDevice_GetHDCPState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_GetHDCPState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_GetHDCPState_ResponseParams_Data* object = static_cast<const DrmDevice_GetHDCPState_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::display::mojom::internal::HDCPState_Data
        ::Validate(object->state, validation_context))
    return false;


  if (!::display::mojom::internal::ContentProtectionMethod_Data
        ::Validate(object->protection_method, validation_context))
    return false;

  return true;
}

DrmDevice_GetHDCPState_ResponseParams_Data::DrmDevice_GetHDCPState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_SetHDCPState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_SetHDCPState_Params_Data* object = static_cast<const DrmDevice_SetHDCPState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::display::mojom::internal::HDCPState_Data
        ::Validate(object->state, validation_context))
    return false;


  if (!::display::mojom::internal::ContentProtectionMethod_Data
        ::Validate(object->protection_method, validation_context))
    return false;

  return true;
}

DrmDevice_SetHDCPState_Params_Data::DrmDevice_SetHDCPState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_SetHDCPState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_SetHDCPState_ResponseParams_Data* object = static_cast<const DrmDevice_SetHDCPState_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DrmDevice_SetHDCPState_ResponseParams_Data::DrmDevice_SetHDCPState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_SetColorMatrix_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_SetColorMatrix_Params_Data* object = static_cast<const DrmDevice_SetColorMatrix_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_matrix, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams color_matrix_validate_params(
      9, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->color_matrix, validation_context,
                                         &color_matrix_validate_params)) {
    return false;
  }

  return true;
}

DrmDevice_SetColorMatrix_Params_Data::DrmDevice_SetColorMatrix_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_SetGammaCorrection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_SetGammaCorrection_Params_Data* object = static_cast<const DrmDevice_SetGammaCorrection_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->degamma_lut, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams degamma_lut_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->degamma_lut, validation_context,
                                         &degamma_lut_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gamma_lut, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams gamma_lut_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->gamma_lut, validation_context,
                                         &gamma_lut_validate_params)) {
    return false;
  }

  return true;
}

DrmDevice_SetGammaCorrection_Params_Data::DrmDevice_SetGammaCorrection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_SetPrivacyScreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_SetPrivacyScreen_Params_Data* object = static_cast<const DrmDevice_SetPrivacyScreen_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DrmDevice_SetPrivacyScreen_Params_Data::DrmDevice_SetPrivacyScreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrmDevice_GetDeviceCursor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DrmDevice_GetDeviceCursor_Params_Data* object = static_cast<const DrmDevice_GetDeviceCursor_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->cursor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->cursor,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DrmDevice_GetDeviceCursor_Params_Data::DrmDevice_GetDeviceCursor_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ozone
}  // namespace ui
