// ui/ozone/public/mojom/drm_device.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "ui/ozone/public/mojom/drm_device.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "ui/display/mojom/display_configuration_params.mojom.h"
#include "ui/display/mojom/display_constants.mojom.h"
#include "ui/display/mojom/display_mode.mojom.h"
#include "ui/display/mojom/display_snapshot.mojom.h"
#include "ui/display/mojom/gamma_ramp_rgb_entry.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/accelerated_widget.mojom.h"
#include "ui/ozone/public/mojom/device_cursor.mojom.h"


#ifndef UI_OZONE_PUBLIC_MOJOM_DRM_DEVICE_MOJOM_JUMBO_H_
#define UI_OZONE_PUBLIC_MOJOM_DRM_DEVICE_MOJOM_JUMBO_H_
#endif


namespace ui {
namespace ozone {
namespace mojom {


void DrmDeviceInterceptorForTesting::CreateWindow(::gfx::AcceleratedWidget widget, const ::gfx::Rect& initial_bounds) {
  GetForwardingInterface()->CreateWindow(std::move(widget), std::move(initial_bounds));
}
void DrmDeviceInterceptorForTesting::DestroyWindow(::gfx::AcceleratedWidget widget) {
  GetForwardingInterface()->DestroyWindow(std::move(widget));
}
void DrmDeviceInterceptorForTesting::SetWindowBounds(::gfx::AcceleratedWidget widget, const ::gfx::Rect& bounds) {
  GetForwardingInterface()->SetWindowBounds(std::move(widget), std::move(bounds));
}
void DrmDeviceInterceptorForTesting::TakeDisplayControl(TakeDisplayControlCallback callback) {
  GetForwardingInterface()->TakeDisplayControl(std::move(callback));
}
void DrmDeviceInterceptorForTesting::RelinquishDisplayControl(RelinquishDisplayControlCallback callback) {
  GetForwardingInterface()->RelinquishDisplayControl(std::move(callback));
}
void DrmDeviceInterceptorForTesting::RefreshNativeDisplays(RefreshNativeDisplaysCallback callback) {
  GetForwardingInterface()->RefreshNativeDisplays(std::move(callback));
}
void DrmDeviceInterceptorForTesting::AddGraphicsDevice(const ::base::FilePath& path, ::base::File file) {
  GetForwardingInterface()->AddGraphicsDevice(std::move(path), std::move(file));
}
void DrmDeviceInterceptorForTesting::RemoveGraphicsDevice(const ::base::FilePath& path) {
  GetForwardingInterface()->RemoveGraphicsDevice(std::move(path));
}
void DrmDeviceInterceptorForTesting::ConfigureNativeDisplays(const std::vector<::display::DisplayConfigurationParams>& config_requests, ConfigureNativeDisplaysCallback callback) {
  GetForwardingInterface()->ConfigureNativeDisplays(std::move(config_requests), std::move(callback));
}
void DrmDeviceInterceptorForTesting::GetHDCPState(int64_t display_id, GetHDCPStateCallback callback) {
  GetForwardingInterface()->GetHDCPState(std::move(display_id), std::move(callback));
}
void DrmDeviceInterceptorForTesting::SetHDCPState(int64_t display_id, ::display::HDCPState state, ::display::ContentProtectionMethod protection_method, SetHDCPStateCallback callback) {
  GetForwardingInterface()->SetHDCPState(std::move(display_id), std::move(state), std::move(protection_method), std::move(callback));
}
void DrmDeviceInterceptorForTesting::SetColorMatrix(int64_t display_id, const std::vector<float>& color_matrix) {
  GetForwardingInterface()->SetColorMatrix(std::move(display_id), std::move(color_matrix));
}
void DrmDeviceInterceptorForTesting::SetGammaCorrection(int64_t display_id, const std::vector<::display::GammaRampRGBEntry>& degamma_lut, const std::vector<::display::GammaRampRGBEntry>& gamma_lut) {
  GetForwardingInterface()->SetGammaCorrection(std::move(display_id), std::move(degamma_lut), std::move(gamma_lut));
}
void DrmDeviceInterceptorForTesting::SetPrivacyScreen(int64_t display_id, bool enabled) {
  GetForwardingInterface()->SetPrivacyScreen(std::move(display_id), std::move(enabled));
}
void DrmDeviceInterceptorForTesting::GetDeviceCursor(::mojo::PendingAssociatedReceiver<::ui::ozone::mojom::DeviceCursor> cursor) {
  GetForwardingInterface()->GetDeviceCursor(std::move(cursor));
}
DrmDeviceAsyncWaiter::DrmDeviceAsyncWaiter(
    DrmDevice* proxy) : proxy_(proxy) {}

DrmDeviceAsyncWaiter::~DrmDeviceAsyncWaiter() = default;

void DrmDeviceAsyncWaiter::TakeDisplayControl(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->TakeDisplayControl(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void DrmDeviceAsyncWaiter::RelinquishDisplayControl(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->RelinquishDisplayControl(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void DrmDeviceAsyncWaiter::RefreshNativeDisplays(
    std::vector<::std::unique_ptr<::display::DisplaySnapshot>>* out_display_snapshots) {
  base::RunLoop loop;
  proxy_->RefreshNativeDisplays(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::std::unique_ptr<::display::DisplaySnapshot>>* out_display_snapshots
,
             std::vector<::std::unique_ptr<::display::DisplaySnapshot>> display_snapshots) {*out_display_snapshots = std::move(display_snapshots);
            loop->Quit();
          },
          &loop,
          out_display_snapshots));
  loop.Run();
}
void DrmDeviceAsyncWaiter::ConfigureNativeDisplays(
    const std::vector<::display::DisplayConfigurationParams>& config_requests, bool* out_config_success) {
  base::RunLoop loop;
  proxy_->ConfigureNativeDisplays(std::move(config_requests),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_config_success
,
             bool config_success) {*out_config_success = std::move(config_success);
            loop->Quit();
          },
          &loop,
          out_config_success));
  loop.Run();
}
void DrmDeviceAsyncWaiter::GetHDCPState(
    int64_t display_id, int64_t* out_display_id, bool* out_success, ::display::HDCPState* out_state, ::display::ContentProtectionMethod* out_protection_method) {
  base::RunLoop loop;
  proxy_->GetHDCPState(std::move(display_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_display_id
,
             bool* out_success
,
             ::display::HDCPState* out_state
,
             ::display::ContentProtectionMethod* out_protection_method
,
             int64_t display_id,
             bool success,
             ::display::HDCPState state,
             ::display::ContentProtectionMethod protection_method) {*out_display_id = std::move(display_id);*out_success = std::move(success);*out_state = std::move(state);*out_protection_method = std::move(protection_method);
            loop->Quit();
          },
          &loop,
          out_display_id,
          out_success,
          out_state,
          out_protection_method));
  loop.Run();
}
void DrmDeviceAsyncWaiter::SetHDCPState(
    int64_t display_id, ::display::HDCPState state, ::display::ContentProtectionMethod protection_method, int64_t* out_display_id, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetHDCPState(std::move(display_id),std::move(state),std::move(protection_method),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_display_id
,
             bool* out_success
,
             int64_t display_id,
             bool success) {*out_display_id = std::move(display_id);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_display_id,
          out_success));
  loop.Run();
}





}  // namespace mojom
}  // namespace ozone
}  // namespace ui

#if defined(__clang__)
#pragma clang diagnostic pop
#endif