// ui/ozone/public/mojom/drm_device.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/ozone/public/mojom/drm_device.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/ozone/public/mojom/drm_device.mojom-params-data.h"
#include "ui/ozone/public/mojom/drm_device.mojom-shared-message-ids.h"

#include "ui/ozone/public/mojom/drm_device.mojom-import-headers.h"


#ifndef UI_OZONE_PUBLIC_MOJOM_DRM_DEVICE_MOJOM_JUMBO_H_
#define UI_OZONE_PUBLIC_MOJOM_DRM_DEVICE_MOJOM_JUMBO_H_
#endif
namespace ui {
namespace ozone {
namespace mojom {
const char DrmDevice::Name_[] = "ui.ozone.mojom.DrmDevice";

class DrmDevice_TakeDisplayControl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DrmDevice_TakeDisplayControl_ForwardToCallback(
      DrmDevice::TakeDisplayControlCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DrmDevice::TakeDisplayControlCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DrmDevice_TakeDisplayControl_ForwardToCallback);
};

class DrmDevice_RelinquishDisplayControl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DrmDevice_RelinquishDisplayControl_ForwardToCallback(
      DrmDevice::RelinquishDisplayControlCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DrmDevice::RelinquishDisplayControlCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DrmDevice_RelinquishDisplayControl_ForwardToCallback);
};

class DrmDevice_RefreshNativeDisplays_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DrmDevice_RefreshNativeDisplays_ForwardToCallback(
      DrmDevice::RefreshNativeDisplaysCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DrmDevice::RefreshNativeDisplaysCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DrmDevice_RefreshNativeDisplays_ForwardToCallback);
};

class DrmDevice_ConfigureNativeDisplays_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DrmDevice_ConfigureNativeDisplays_ForwardToCallback(
      DrmDevice::ConfigureNativeDisplaysCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DrmDevice::ConfigureNativeDisplaysCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DrmDevice_ConfigureNativeDisplays_ForwardToCallback);
};

class DrmDevice_GetHDCPState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DrmDevice_GetHDCPState_ForwardToCallback(
      DrmDevice::GetHDCPStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DrmDevice::GetHDCPStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DrmDevice_GetHDCPState_ForwardToCallback);
};

class DrmDevice_SetHDCPState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DrmDevice_SetHDCPState_ForwardToCallback(
      DrmDevice::SetHDCPStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DrmDevice::SetHDCPStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DrmDevice_SetHDCPState_ForwardToCallback);
};

DrmDeviceProxy::DrmDeviceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DrmDeviceProxy::CreateWindow(
    ::gfx::AcceleratedWidget in_widget, const ::gfx::Rect& in_initial_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::CreateWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("widget"), in_widget, 
                        "<value of type ::gfx::AcceleratedWidget>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initial_bounds"), in_initial_bounds, 
                        "<value of type const ::gfx::Rect&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_CreateWindow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_CreateWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->widget)::BaseType> widget_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::AcceleratedWidgetDataView>(
      in_widget, widget_fragment);
  params->widget.Set(
      widget_fragment.is_null() ? nullptr : widget_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->widget.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null widget in DrmDevice.CreateWindow request");
  mojo::internal::MessageFragment<
      typename decltype(params->initial_bounds)::BaseType> initial_bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_initial_bounds, initial_bounds_fragment);
  params->initial_bounds.Set(
      initial_bounds_fragment.is_null() ? nullptr : initial_bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->initial_bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initial_bounds in DrmDevice.CreateWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("CreateWindow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DrmDeviceProxy::DestroyWindow(
    ::gfx::AcceleratedWidget in_widget) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::DestroyWindow", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("widget"), in_widget, 
                        "<value of type ::gfx::AcceleratedWidget>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_DestroyWindow_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_DestroyWindow_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->widget)::BaseType> widget_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::AcceleratedWidgetDataView>(
      in_widget, widget_fragment);
  params->widget.Set(
      widget_fragment.is_null() ? nullptr : widget_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->widget.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null widget in DrmDevice.DestroyWindow request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("DestroyWindow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DrmDeviceProxy::SetWindowBounds(
    ::gfx::AcceleratedWidget in_widget, const ::gfx::Rect& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::SetWindowBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("widget"), in_widget, 
                        "<value of type ::gfx::AcceleratedWidget>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds, 
                        "<value of type const ::gfx::Rect&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_SetWindowBounds_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_SetWindowBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->widget)::BaseType> widget_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::AcceleratedWidgetDataView>(
      in_widget, widget_fragment);
  params->widget.Set(
      widget_fragment.is_null() ? nullptr : widget_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->widget.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null widget in DrmDevice.SetWindowBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounds, bounds_fragment);
  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in DrmDevice.SetWindowBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("SetWindowBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DrmDeviceProxy::TakeDisplayControl(
    TakeDisplayControlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "ui::ozone::mojom::DrmDevice::TakeDisplayControl");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_TakeDisplayControl_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_TakeDisplayControl_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("TakeDisplayControl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DrmDevice_TakeDisplayControl_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DrmDeviceProxy::RelinquishDisplayControl(
    RelinquishDisplayControlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "ui::ozone::mojom::DrmDevice::RelinquishDisplayControl");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_RelinquishDisplayControl_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_RelinquishDisplayControl_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("RelinquishDisplayControl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DrmDevice_RelinquishDisplayControl_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DrmDeviceProxy::RefreshNativeDisplays(
    RefreshNativeDisplaysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "ui::ozone::mojom::DrmDevice::RefreshNativeDisplays");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_RefreshNativeDisplays_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_RefreshNativeDisplays_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("RefreshNativeDisplays");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DrmDevice_RefreshNativeDisplays_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DrmDeviceProxy::AddGraphicsDevice(
    const ::base::FilePath& in_path, ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::AddGraphicsDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path, 
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file, 
                        "<value of type ::base::File>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_AddGraphicsDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_AddGraphicsDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in DrmDevice.AddGraphicsDevice request");
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file in DrmDevice.AddGraphicsDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("AddGraphicsDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DrmDeviceProxy::RemoveGraphicsDevice(
    const ::base::FilePath& in_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::RemoveGraphicsDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path, 
                        "<value of type const ::base::FilePath&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_RemoveGraphicsDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_RemoveGraphicsDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in DrmDevice.RemoveGraphicsDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("RemoveGraphicsDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DrmDeviceProxy::ConfigureNativeDisplays(
    const std::vector<::display::DisplayConfigurationParams>& in_config_requests, ConfigureNativeDisplaysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::ConfigureNativeDisplays", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_requests"), in_config_requests, 
                        "<value of type const std::vector<::display::DisplayConfigurationParams>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_ConfigureNativeDisplays_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_ConfigureNativeDisplays_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config_requests)::BaseType>
      config_requests_fragment(params.message());
  const mojo::internal::ContainerValidateParams config_requests_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::DisplayConfigurationParamsDataView>>(
      in_config_requests, config_requests_fragment, &config_requests_validate_params);
  params->config_requests.Set(
      config_requests_fragment.is_null() ? nullptr : config_requests_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config_requests.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config_requests in DrmDevice.ConfigureNativeDisplays request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("ConfigureNativeDisplays");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DrmDevice_ConfigureNativeDisplays_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DrmDeviceProxy::GetHDCPState(
    int64_t in_display_id, GetHDCPStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::GetHDCPState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_GetHDCPState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_GetHDCPState_Params_Data> params(
          message);
  params.Allocate();
  params->display_id = in_display_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("GetHDCPState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DrmDevice_GetHDCPState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DrmDeviceProxy::SetHDCPState(
    int64_t in_display_id, ::display::HDCPState in_state, ::display::ContentProtectionMethod in_protection_method, SetHDCPStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::SetHDCPState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state, 
                        "<value of type ::display::HDCPState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("protection_method"), in_protection_method, 
                        "<value of type ::display::ContentProtectionMethod>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_SetHDCPState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_SetHDCPState_Params_Data> params(
          message);
  params.Allocate();
  params->display_id = in_display_id;
  mojo::internal::Serialize<::display::mojom::HDCPState>(
      in_state, &params->state);
  mojo::internal::Serialize<::display::mojom::ContentProtectionMethod>(
      in_protection_method, &params->protection_method);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("SetHDCPState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DrmDevice_SetHDCPState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void DrmDeviceProxy::SetColorMatrix(
    int64_t in_display_id, const std::vector<float>& in_color_matrix) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::SetColorMatrix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color_matrix"), in_color_matrix, 
                        "<value of type const std::vector<float>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_SetColorMatrix_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_SetColorMatrix_Params_Data> params(
          message);
  params.Allocate();
  params->display_id = in_display_id;
  mojo::internal::MessageFragment<
      typename decltype(params->color_matrix)::BaseType>
      color_matrix_fragment(params.message());
  const mojo::internal::ContainerValidateParams color_matrix_validate_params(
      9, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_color_matrix, color_matrix_fragment, &color_matrix_validate_params);
  params->color_matrix.Set(
      color_matrix_fragment.is_null() ? nullptr : color_matrix_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->color_matrix.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_matrix in DrmDevice.SetColorMatrix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("SetColorMatrix");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DrmDeviceProxy::SetGammaCorrection(
    int64_t in_display_id, const std::vector<::display::GammaRampRGBEntry>& in_degamma_lut, const std::vector<::display::GammaRampRGBEntry>& in_gamma_lut) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::SetGammaCorrection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("degamma_lut"), in_degamma_lut, 
                        "<value of type const std::vector<::display::GammaRampRGBEntry>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gamma_lut"), in_gamma_lut, 
                        "<value of type const std::vector<::display::GammaRampRGBEntry>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_SetGammaCorrection_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_SetGammaCorrection_Params_Data> params(
          message);
  params.Allocate();
  params->display_id = in_display_id;
  mojo::internal::MessageFragment<
      typename decltype(params->degamma_lut)::BaseType>
      degamma_lut_fragment(params.message());
  const mojo::internal::ContainerValidateParams degamma_lut_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::GammaRampRGBEntryDataView>>(
      in_degamma_lut, degamma_lut_fragment, &degamma_lut_validate_params);
  params->degamma_lut.Set(
      degamma_lut_fragment.is_null() ? nullptr : degamma_lut_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->degamma_lut.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null degamma_lut in DrmDevice.SetGammaCorrection request");
  mojo::internal::MessageFragment<
      typename decltype(params->gamma_lut)::BaseType>
      gamma_lut_fragment(params.message());
  const mojo::internal::ContainerValidateParams gamma_lut_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::GammaRampRGBEntryDataView>>(
      in_gamma_lut, gamma_lut_fragment, &gamma_lut_validate_params);
  params->gamma_lut.Set(
      gamma_lut_fragment.is_null() ? nullptr : gamma_lut_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gamma_lut.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gamma_lut in DrmDevice.SetGammaCorrection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("SetGammaCorrection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DrmDeviceProxy::SetPrivacyScreen(
    int64_t in_display_id, bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::SetPrivacyScreen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_SetPrivacyScreen_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_SetPrivacyScreen_Params_Data> params(
          message);
  params.Allocate();
  params->display_id = in_display_id;
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("SetPrivacyScreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DrmDeviceProxy::GetDeviceCursor(
    ::mojo::PendingAssociatedReceiver<::ui::ozone::mojom::DeviceCursor> in_cursor) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::ozone::mojom::DrmDevice::GetDeviceCursor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cursor"), in_cursor, 
                        "<value of type ::mojo::PendingAssociatedReceiver<::ui::ozone::mojom::DeviceCursor>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_GetDeviceCursor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_GetDeviceCursor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::ui::ozone::mojom::DeviceCursorAssociatedRequestDataView>(
      in_cursor, &params->cursor, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->cursor),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid cursor in DrmDevice.GetDeviceCursor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("GetDeviceCursor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class DrmDevice_TakeDisplayControl_ProxyToResponder {
 public:
  static DrmDevice::TakeDisplayControlCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DrmDevice_TakeDisplayControl_ProxyToResponder> proxy(
        new DrmDevice_TakeDisplayControl_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DrmDevice_TakeDisplayControl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DrmDevice_TakeDisplayControl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DrmDevice_TakeDisplayControl_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DrmDevice::TakeDisplayControlCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DrmDevice_TakeDisplayControl_ProxyToResponder);
};

bool DrmDevice_TakeDisplayControl_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "ui::ozone::mojom::DrmDevice::TakeDisplayControlCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DrmDevice_TakeDisplayControl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DrmDevice_TakeDisplayControl_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  DrmDevice_TakeDisplayControl_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DrmDevice::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void DrmDevice_TakeDisplayControl_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)ui::ozone::mojom::DrmDevice::TakeDisplayControlCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_TakeDisplayControl_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_TakeDisplayControl_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)ui::ozone::mojom::DrmDevice::TakeDisplayControlCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("TakeDisplayControl");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DrmDevice_RelinquishDisplayControl_ProxyToResponder {
 public:
  static DrmDevice::RelinquishDisplayControlCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DrmDevice_RelinquishDisplayControl_ProxyToResponder> proxy(
        new DrmDevice_RelinquishDisplayControl_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DrmDevice_RelinquishDisplayControl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DrmDevice_RelinquishDisplayControl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DrmDevice_RelinquishDisplayControl_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DrmDevice::RelinquishDisplayControlCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DrmDevice_RelinquishDisplayControl_ProxyToResponder);
};

bool DrmDevice_RelinquishDisplayControl_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "ui::ozone::mojom::DrmDevice::RelinquishDisplayControlCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DrmDevice_RelinquishDisplayControl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DrmDevice_RelinquishDisplayControl_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  DrmDevice_RelinquishDisplayControl_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DrmDevice::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void DrmDevice_RelinquishDisplayControl_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)ui::ozone::mojom::DrmDevice::RelinquishDisplayControlCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_RelinquishDisplayControl_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_RelinquishDisplayControl_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)ui::ozone::mojom::DrmDevice::RelinquishDisplayControlCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("RelinquishDisplayControl");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DrmDevice_RefreshNativeDisplays_ProxyToResponder {
 public:
  static DrmDevice::RefreshNativeDisplaysCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DrmDevice_RefreshNativeDisplays_ProxyToResponder> proxy(
        new DrmDevice_RefreshNativeDisplays_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DrmDevice_RefreshNativeDisplays_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DrmDevice_RefreshNativeDisplays_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DrmDevice_RefreshNativeDisplays_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DrmDevice::RefreshNativeDisplaysCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::std::unique_ptr<::display::DisplaySnapshot>> in_display_snapshots);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DrmDevice_RefreshNativeDisplays_ProxyToResponder);
};

bool DrmDevice_RefreshNativeDisplays_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "ui::ozone::mojom::DrmDevice::RefreshNativeDisplaysCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DrmDevice_RefreshNativeDisplays_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DrmDevice_RefreshNativeDisplays_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<::std::unique_ptr<::display::DisplaySnapshot>> p_display_snapshots{};
  DrmDevice_RefreshNativeDisplays_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDisplaySnapshots(&p_display_snapshots))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DrmDevice::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_display_snapshots));
  return true;
}

void DrmDevice_RefreshNativeDisplays_ProxyToResponder::Run(
    std::vector<::std::unique_ptr<::display::DisplaySnapshot>> in_display_snapshots) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)ui::ozone::mojom::DrmDevice::RefreshNativeDisplaysCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_snapshots"), in_display_snapshots, 
                        "<value of type std::vector<::std::unique_ptr<::display::DisplaySnapshot>>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_RefreshNativeDisplays_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_RefreshNativeDisplays_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->display_snapshots)::BaseType>
      display_snapshots_fragment(params.message());
  const mojo::internal::ContainerValidateParams display_snapshots_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::DisplaySnapshotDataView>>(
      in_display_snapshots, display_snapshots_fragment, &display_snapshots_validate_params);
  params->display_snapshots.Set(
      display_snapshots_fragment.is_null() ? nullptr : display_snapshots_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->display_snapshots.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_snapshots in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)ui::ozone::mojom::DrmDevice::RefreshNativeDisplaysCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("RefreshNativeDisplays");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DrmDevice_ConfigureNativeDisplays_ProxyToResponder {
 public:
  static DrmDevice::ConfigureNativeDisplaysCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DrmDevice_ConfigureNativeDisplays_ProxyToResponder> proxy(
        new DrmDevice_ConfigureNativeDisplays_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DrmDevice_ConfigureNativeDisplays_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DrmDevice_ConfigureNativeDisplays_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DrmDevice_ConfigureNativeDisplays_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DrmDevice::ConfigureNativeDisplaysCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_config_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DrmDevice_ConfigureNativeDisplays_ProxyToResponder);
};

bool DrmDevice_ConfigureNativeDisplays_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "ui::ozone::mojom::DrmDevice::ConfigureNativeDisplaysCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DrmDevice_ConfigureNativeDisplays_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DrmDevice_ConfigureNativeDisplays_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_config_success{};
  DrmDevice_ConfigureNativeDisplays_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_config_success = input_data_view.config_success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DrmDevice::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_config_success));
  return true;
}

void DrmDevice_ConfigureNativeDisplays_ProxyToResponder::Run(
    bool in_config_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)ui::ozone::mojom::DrmDevice::ConfigureNativeDisplaysCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_success"), in_config_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_ConfigureNativeDisplays_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_ConfigureNativeDisplays_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->config_success = in_config_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)ui::ozone::mojom::DrmDevice::ConfigureNativeDisplaysCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("ConfigureNativeDisplays");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DrmDevice_GetHDCPState_ProxyToResponder {
 public:
  static DrmDevice::GetHDCPStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DrmDevice_GetHDCPState_ProxyToResponder> proxy(
        new DrmDevice_GetHDCPState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DrmDevice_GetHDCPState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DrmDevice_GetHDCPState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DrmDevice_GetHDCPState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DrmDevice::GetHDCPStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_display_id, bool in_success, ::display::HDCPState in_state, ::display::ContentProtectionMethod in_protection_method);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DrmDevice_GetHDCPState_ProxyToResponder);
};

bool DrmDevice_GetHDCPState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "ui::ozone::mojom::DrmDevice::GetHDCPStateCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DrmDevice_GetHDCPState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DrmDevice_GetHDCPState_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_display_id{};
  bool p_success{};
  ::display::HDCPState p_state{};
  ::display::ContentProtectionMethod p_protection_method{};
  DrmDevice_GetHDCPState_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_display_id = input_data_view.display_id();
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (success && !input_data_view.ReadProtectionMethod(&p_protection_method))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DrmDevice::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_display_id), 
std::move(p_success), 
std::move(p_state), 
std::move(p_protection_method));
  return true;
}

void DrmDevice_GetHDCPState_ProxyToResponder::Run(
    int64_t in_display_id, bool in_success, ::display::HDCPState in_state, ::display::ContentProtectionMethod in_protection_method) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)ui::ozone::mojom::DrmDevice::GetHDCPStateCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state, 
                        "<value of type ::display::HDCPState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("protection_method"), in_protection_method, 
                        "<value of type ::display::ContentProtectionMethod>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_GetHDCPState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_GetHDCPState_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->display_id = in_display_id;
  params->success = in_success;
  mojo::internal::Serialize<::display::mojom::HDCPState>(
      in_state, &params->state);
  mojo::internal::Serialize<::display::mojom::ContentProtectionMethod>(
      in_protection_method, &params->protection_method);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)ui::ozone::mojom::DrmDevice::GetHDCPStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("GetHDCPState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DrmDevice_SetHDCPState_ProxyToResponder {
 public:
  static DrmDevice::SetHDCPStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DrmDevice_SetHDCPState_ProxyToResponder> proxy(
        new DrmDevice_SetHDCPState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DrmDevice_SetHDCPState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DrmDevice_SetHDCPState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DrmDevice_SetHDCPState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DrmDevice::SetHDCPStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_display_id, bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DrmDevice_SetHDCPState_ProxyToResponder);
};

bool DrmDevice_SetHDCPState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "ui::ozone::mojom::DrmDevice::SetHDCPStateCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DrmDevice_SetHDCPState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DrmDevice_SetHDCPState_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int64_t p_display_id{};
  bool p_success{};
  DrmDevice_SetHDCPState_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_display_id = input_data_view.display_id();
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DrmDevice::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_display_id), 
std::move(p_success));
  return true;
}

void DrmDevice_SetHDCPState_ProxyToResponder::Run(
    int64_t in_display_id, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)ui::ozone::mojom::DrmDevice::SetHDCPStateCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDrmDevice_SetHDCPState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::DrmDevice_SetHDCPState_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->display_id = in_display_id;
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)ui::ozone::mojom::DrmDevice::SetHDCPStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DrmDevice::Name_);
  message.set_method_name("SetHDCPState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DrmDeviceStubDispatch::Accept(
    DrmDevice* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDrmDevice_CreateWindow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::CreateWindow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::CreateWindow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DrmDevice_CreateWindow_Params_Data* params =
          reinterpret_cast<internal::DrmDevice_CreateWindow_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::AcceleratedWidget p_widget{};
      ::gfx::Rect p_initial_bounds{};
      DrmDevice_CreateWindow_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWidget(&p_widget))
        success = false;
      if (success && !input_data_view.ReadInitialBounds(&p_initial_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWindow(
std::move(p_widget), 
std::move(p_initial_bounds));
      return true;
    }
    case internal::kDrmDevice_DestroyWindow_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::DestroyWindow",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::DestroyWindow");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DrmDevice_DestroyWindow_Params_Data* params =
          reinterpret_cast<internal::DrmDevice_DestroyWindow_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::AcceleratedWidget p_widget{};
      DrmDevice_DestroyWindow_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWidget(&p_widget))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyWindow(
std::move(p_widget));
      return true;
    }
    case internal::kDrmDevice_SetWindowBounds_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::SetWindowBounds",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::SetWindowBounds");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DrmDevice_SetWindowBounds_Params_Data* params =
          reinterpret_cast<internal::DrmDevice_SetWindowBounds_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::AcceleratedWidget p_widget{};
      ::gfx::Rect p_bounds{};
      DrmDevice_SetWindowBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWidget(&p_widget))
        success = false;
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWindowBounds(
std::move(p_widget), 
std::move(p_bounds));
      return true;
    }
    case internal::kDrmDevice_TakeDisplayControl_Name: {
      break;
    }
    case internal::kDrmDevice_RelinquishDisplayControl_Name: {
      break;
    }
    case internal::kDrmDevice_RefreshNativeDisplays_Name: {
      break;
    }
    case internal::kDrmDevice_AddGraphicsDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::AddGraphicsDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::AddGraphicsDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DrmDevice_AddGraphicsDevice_Params_Data* params =
          reinterpret_cast<internal::DrmDevice_AddGraphicsDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      ::base::File p_file{};
      DrmDevice_AddGraphicsDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddGraphicsDevice(
std::move(p_path), 
std::move(p_file));
      return true;
    }
    case internal::kDrmDevice_RemoveGraphicsDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::RemoveGraphicsDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::RemoveGraphicsDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DrmDevice_RemoveGraphicsDevice_Params_Data* params =
          reinterpret_cast<internal::DrmDevice_RemoveGraphicsDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      DrmDevice_RemoveGraphicsDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveGraphicsDevice(
std::move(p_path));
      return true;
    }
    case internal::kDrmDevice_ConfigureNativeDisplays_Name: {
      break;
    }
    case internal::kDrmDevice_GetHDCPState_Name: {
      break;
    }
    case internal::kDrmDevice_SetHDCPState_Name: {
      break;
    }
    case internal::kDrmDevice_SetColorMatrix_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::SetColorMatrix",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::SetColorMatrix");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DrmDevice_SetColorMatrix_Params_Data* params =
          reinterpret_cast<internal::DrmDevice_SetColorMatrix_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_display_id{};
      std::vector<float> p_color_matrix{};
      DrmDevice_SetColorMatrix_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_display_id = input_data_view.display_id();
      if (success && !input_data_view.ReadColorMatrix(&p_color_matrix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetColorMatrix(
std::move(p_display_id), 
std::move(p_color_matrix));
      return true;
    }
    case internal::kDrmDevice_SetGammaCorrection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::SetGammaCorrection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::SetGammaCorrection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DrmDevice_SetGammaCorrection_Params_Data* params =
          reinterpret_cast<internal::DrmDevice_SetGammaCorrection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_display_id{};
      std::vector<::display::GammaRampRGBEntry> p_degamma_lut{};
      std::vector<::display::GammaRampRGBEntry> p_gamma_lut{};
      DrmDevice_SetGammaCorrection_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_display_id = input_data_view.display_id();
      if (success && !input_data_view.ReadDegammaLut(&p_degamma_lut))
        success = false;
      if (success && !input_data_view.ReadGammaLut(&p_gamma_lut))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetGammaCorrection(
std::move(p_display_id), 
std::move(p_degamma_lut), 
std::move(p_gamma_lut));
      return true;
    }
    case internal::kDrmDevice_SetPrivacyScreen_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::SetPrivacyScreen",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::SetPrivacyScreen");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DrmDevice_SetPrivacyScreen_Params_Data* params =
          reinterpret_cast<internal::DrmDevice_SetPrivacyScreen_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_display_id{};
      bool p_enabled{};
      DrmDevice_SetPrivacyScreen_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_display_id = input_data_view.display_id();
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPrivacyScreen(
std::move(p_display_id), 
std::move(p_enabled));
      return true;
    }
    case internal::kDrmDevice_GetDeviceCursor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::GetDeviceCursor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::GetDeviceCursor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DrmDevice_GetDeviceCursor_Params_Data* params =
          reinterpret_cast<internal::DrmDevice_GetDeviceCursor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::ui::ozone::mojom::DeviceCursor> p_cursor{};
      DrmDevice_GetDeviceCursor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_cursor =
            input_data_view.TakeCursor<decltype(p_cursor)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceCursor(
std::move(p_cursor));
      return true;
    }
  }
  return false;
}

// static
bool DrmDeviceStubDispatch::AcceptWithResponder(
    DrmDevice* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDrmDevice_CreateWindow_Name: {
      break;
    }
    case internal::kDrmDevice_DestroyWindow_Name: {
      break;
    }
    case internal::kDrmDevice_SetWindowBounds_Name: {
      break;
    }
    case internal::kDrmDevice_TakeDisplayControl_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::TakeDisplayControl",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::TakeDisplayControl");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DrmDevice_TakeDisplayControl_Params_Data* params =
          reinterpret_cast<
              internal::DrmDevice_TakeDisplayControl_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DrmDevice_TakeDisplayControl_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 3, false);
        return false;
      }
      DrmDevice::TakeDisplayControlCallback callback =
          DrmDevice_TakeDisplayControl_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakeDisplayControl(std::move(callback));
      return true;
    }
    case internal::kDrmDevice_RelinquishDisplayControl_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::RelinquishDisplayControl",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::RelinquishDisplayControl");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DrmDevice_RelinquishDisplayControl_Params_Data* params =
          reinterpret_cast<
              internal::DrmDevice_RelinquishDisplayControl_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DrmDevice_RelinquishDisplayControl_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 4, false);
        return false;
      }
      DrmDevice::RelinquishDisplayControlCallback callback =
          DrmDevice_RelinquishDisplayControl_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RelinquishDisplayControl(std::move(callback));
      return true;
    }
    case internal::kDrmDevice_RefreshNativeDisplays_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::RefreshNativeDisplays",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::RefreshNativeDisplays");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DrmDevice_RefreshNativeDisplays_Params_Data* params =
          reinterpret_cast<
              internal::DrmDevice_RefreshNativeDisplays_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      DrmDevice_RefreshNativeDisplays_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 5, false);
        return false;
      }
      DrmDevice::RefreshNativeDisplaysCallback callback =
          DrmDevice_RefreshNativeDisplays_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RefreshNativeDisplays(std::move(callback));
      return true;
    }
    case internal::kDrmDevice_AddGraphicsDevice_Name: {
      break;
    }
    case internal::kDrmDevice_RemoveGraphicsDevice_Name: {
      break;
    }
    case internal::kDrmDevice_ConfigureNativeDisplays_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::ConfigureNativeDisplays",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::ConfigureNativeDisplays");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DrmDevice_ConfigureNativeDisplays_Params_Data* params =
          reinterpret_cast<
              internal::DrmDevice_ConfigureNativeDisplays_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<::display::DisplayConfigurationParams> p_config_requests{};
      DrmDevice_ConfigureNativeDisplays_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfigRequests(&p_config_requests))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 8, false);
        return false;
      }
      DrmDevice::ConfigureNativeDisplaysCallback callback =
          DrmDevice_ConfigureNativeDisplays_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigureNativeDisplays(
std::move(p_config_requests), std::move(callback));
      return true;
    }
    case internal::kDrmDevice_GetHDCPState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::GetHDCPState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::GetHDCPState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DrmDevice_GetHDCPState_Params_Data* params =
          reinterpret_cast<
              internal::DrmDevice_GetHDCPState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_display_id{};
      DrmDevice_GetHDCPState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_display_id = input_data_view.display_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 9, false);
        return false;
      }
      DrmDevice::GetHDCPStateCallback callback =
          DrmDevice_GetHDCPState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHDCPState(
std::move(p_display_id), std::move(callback));
      return true;
    }
    case internal::kDrmDevice_SetHDCPState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::ozone::mojom::DrmDevice::SetHDCPState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::ozone::mojom::DrmDevice::SetHDCPState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DrmDevice_SetHDCPState_Params_Data* params =
          reinterpret_cast<
              internal::DrmDevice_SetHDCPState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_display_id{};
      ::display::HDCPState p_state{};
      ::display::ContentProtectionMethod p_protection_method{};
      DrmDevice_SetHDCPState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_display_id = input_data_view.display_id();
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (success && !input_data_view.ReadProtectionMethod(&p_protection_method))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DrmDevice::Name_, 10, false);
        return false;
      }
      DrmDevice::SetHDCPStateCallback callback =
          DrmDevice_SetHDCPState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHDCPState(
std::move(p_display_id), 
std::move(p_state), 
std::move(p_protection_method), std::move(callback));
      return true;
    }
    case internal::kDrmDevice_SetColorMatrix_Name: {
      break;
    }
    case internal::kDrmDevice_SetGammaCorrection_Name: {
      break;
    }
    case internal::kDrmDevice_SetPrivacyScreen_Name: {
      break;
    }
    case internal::kDrmDevice_GetDeviceCursor_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDrmDeviceValidationInfo[] = {
    {internal::kDrmDevice_CreateWindow_Name,
     {&internal::DrmDevice_CreateWindow_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDrmDevice_DestroyWindow_Name,
     {&internal::DrmDevice_DestroyWindow_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDrmDevice_SetWindowBounds_Name,
     {&internal::DrmDevice_SetWindowBounds_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDrmDevice_TakeDisplayControl_Name,
     {&internal::DrmDevice_TakeDisplayControl_Params_Data::Validate,
      &internal::DrmDevice_TakeDisplayControl_ResponseParams_Data::Validate}},
    {internal::kDrmDevice_RelinquishDisplayControl_Name,
     {&internal::DrmDevice_RelinquishDisplayControl_Params_Data::Validate,
      &internal::DrmDevice_RelinquishDisplayControl_ResponseParams_Data::Validate}},
    {internal::kDrmDevice_RefreshNativeDisplays_Name,
     {&internal::DrmDevice_RefreshNativeDisplays_Params_Data::Validate,
      &internal::DrmDevice_RefreshNativeDisplays_ResponseParams_Data::Validate}},
    {internal::kDrmDevice_AddGraphicsDevice_Name,
     {&internal::DrmDevice_AddGraphicsDevice_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDrmDevice_RemoveGraphicsDevice_Name,
     {&internal::DrmDevice_RemoveGraphicsDevice_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDrmDevice_ConfigureNativeDisplays_Name,
     {&internal::DrmDevice_ConfigureNativeDisplays_Params_Data::Validate,
      &internal::DrmDevice_ConfigureNativeDisplays_ResponseParams_Data::Validate}},
    {internal::kDrmDevice_GetHDCPState_Name,
     {&internal::DrmDevice_GetHDCPState_Params_Data::Validate,
      &internal::DrmDevice_GetHDCPState_ResponseParams_Data::Validate}},
    {internal::kDrmDevice_SetHDCPState_Name,
     {&internal::DrmDevice_SetHDCPState_Params_Data::Validate,
      &internal::DrmDevice_SetHDCPState_ResponseParams_Data::Validate}},
    {internal::kDrmDevice_SetColorMatrix_Name,
     {&internal::DrmDevice_SetColorMatrix_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDrmDevice_SetGammaCorrection_Name,
     {&internal::DrmDevice_SetGammaCorrection_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDrmDevice_SetPrivacyScreen_Name,
     {&internal::DrmDevice_SetPrivacyScreen_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDrmDevice_GetDeviceCursor_Name,
     {&internal::DrmDevice_GetDeviceCursor_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DrmDeviceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ui::ozone::mojom::DrmDevice::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDrmDeviceValidationInfo);
}

bool DrmDeviceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::ui::ozone::mojom::DrmDevice::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDrmDeviceValidationInfo);

}
}  // namespace mojom
}  // namespace ozone
}  // namespace ui

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif