// ui/ozone/public/mojom/scenic_gpu_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/ozone/public/mojom/scenic_gpu_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/ozone/public/mojom/scenic_gpu_service.mojom-params-data.h"
#include "ui/ozone/public/mojom/scenic_gpu_service.mojom-shared-message-ids.h"

#include "ui/ozone/public/mojom/scenic_gpu_service.mojom-import-headers.h"


#ifndef UI_OZONE_PUBLIC_MOJOM_SCENIC_GPU_SERVICE_MOJOM_JUMBO_H_
#define UI_OZONE_PUBLIC_MOJOM_SCENIC_GPU_SERVICE_MOJOM_JUMBO_H_
#endif
namespace ui {
namespace mojom {
const char ScenicGpuService::Name_[] = "ui.mojom.ScenicGpuService";

ScenicGpuServiceProxy::ScenicGpuServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScenicGpuServiceProxy::Initialize(
    ::mojo::PendingRemote<::ui::mojom::ScenicGpuHost> in_scenic_gpu_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ui::mojom::ScenicGpuService::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scenic_gpu_host"), in_scenic_gpu_host, 
                        "<value of type ::mojo::PendingRemote<::ui::mojom::ScenicGpuHost>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kScenicGpuService_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ui::mojom::internal::ScenicGpuService_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::ui::mojom::ScenicGpuHostInterfaceBase>>(
      in_scenic_gpu_host, &params->scenic_gpu_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->scenic_gpu_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid scenic_gpu_host in ScenicGpuService.Initialize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScenicGpuService::Name_);
  message.set_method_name("Initialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ScenicGpuServiceStubDispatch::Accept(
    ScenicGpuService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kScenicGpuService_Initialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ui::mojom::ScenicGpuService::Initialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ui::mojom::ScenicGpuService::Initialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ScenicGpuService_Initialize_Params_Data* params =
          reinterpret_cast<internal::ScenicGpuService_Initialize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::ui::mojom::ScenicGpuHost> p_scenic_gpu_host{};
      ScenicGpuService_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_scenic_gpu_host =
            input_data_view.TakeScenicGpuHost<decltype(p_scenic_gpu_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScenicGpuService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(
std::move(p_scenic_gpu_host));
      return true;
    }
  }
  return false;
}

// static
bool ScenicGpuServiceStubDispatch::AcceptWithResponder(
    ScenicGpuService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kScenicGpuService_Initialize_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kScenicGpuServiceValidationInfo[] = {
    {internal::kScenicGpuService_Initialize_Name,
     {&internal::ScenicGpuService_Initialize_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ScenicGpuServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ui::mojom::ScenicGpuService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kScenicGpuServiceValidationInfo);
}

}  // namespace mojom
}  // namespace ui

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif