
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>

QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "passwordbackend_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void PasswordBackendWrapper::pysideInitQtMetaTypes()
{
}

void PasswordBackendWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

PasswordBackendWrapper::PasswordBackendWrapper() : PasswordBackend()
{
    resetPyMethodCache();
    // ... middle
}

void PasswordBackendWrapper::addEntry(const PasswordEntry & entry)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.addEntry()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "addEntry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.addEntry()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), &entry)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QVector<PasswordEntry > PasswordBackendWrapper::getAllEntries()
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.getAllEntries()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "getAllEntries";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.getAllEntries()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_PASSWORDENTRY_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "PasswordBackend.getAllEntries", "vector", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QVector<PasswordEntry > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QVector<PasswordEntry > PasswordBackendWrapper::getEntries(const QUrl & url)
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.getEntries()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "getEntries";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.getEntries()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &url)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_PASSWORDENTRY_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "PasswordBackend.getEntries", "vector", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QVector<PasswordEntry > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QStringList PasswordBackendWrapper::getUsernames(const QUrl & url)
{
    if (m_PyMethodCache[3])
        return this->::PasswordBackend::getUsernames(url);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QStringList();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "getUsernames";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::PasswordBackend::getUsernames(url);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &url)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QStringList();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "PasswordBackend.getUsernames", "QStringList", Py_TYPE(pyResult)->tp_name);
        return ::QStringList();
    }
    ::QStringList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool PasswordBackendWrapper::hasSettings() const
{
    if (m_PyMethodCache[4])
        return this->::PasswordBackend::hasSettings();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasSettings";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::PasswordBackend::hasSettings();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "PasswordBackend.hasSettings", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QString PasswordBackendWrapper::name() const
{
    if (m_PyMethodCache[5]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.name()' not implemented.");
        return ::QString();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "name";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.name()' not implemented.");
        return ::QString();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "PasswordBackend.name", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void PasswordBackendWrapper::removeAll()
{
    if (m_PyMethodCache[6]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.removeAll()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "removeAll";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.removeAll()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void PasswordBackendWrapper::removeEntry(const PasswordEntry & entry)
{
    if (m_PyMethodCache[7]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.removeEntry()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "removeEntry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.removeEntry()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), &entry)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void PasswordBackendWrapper::setActive(bool active)
{
    if (m_PyMethodCache[8]) {
        return this->::PasswordBackend::setActive(active);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setActive";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::PasswordBackend::setActive(active);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &active)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void PasswordBackendWrapper::showSettings(QWidget * parent)
{
    if (m_PyMethodCache[9]) {
        return this->::PasswordBackend::showSettings(parent);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "showSettings";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::PasswordBackend::showSettings(parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool PasswordBackendWrapper::updateEntry(const PasswordEntry & entry)
{
    if (m_PyMethodCache[10]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.updateEntry()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateEntry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.updateEntry()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), &entry)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "PasswordBackend.updateEntry", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void PasswordBackendWrapper::updateLastUsed(PasswordEntry & entry)
{
    if (m_PyMethodCache[11]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.updateLastUsed()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateLastUsed";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.updateLastUsed()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), &entry)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

PasswordBackendWrapper::~PasswordBackendWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PasswordBackend_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'PasswordBackend' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PasswordBackend >()))
        return -1;

    ::PasswordBackendWrapper *cptr{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // PasswordBackend()
            cptr = new ::PasswordBackendWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::PasswordBackend >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_PasswordBackendFunc_addEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::addEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArg)))) {
        overloadId = 0; // addEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordBackendFunc_addEntry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // addEntry(PasswordEntry)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.addEntry()' not implemented.");
                return {};
            }
            cppSelf->addEntry(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PasswordBackendFunc_addEntry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.PasswordBackend.addEntry");
        return {};
}

static PyObject *Sbk_PasswordBackendFunc_getAllEntries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getAllEntries()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.getAllEntries()' not implemented.");
                return {};
            }
            QVector<PasswordEntry > cppResult = cppSelf->getAllEntries();
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_PASSWORDENTRY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_PasswordBackendFunc_getEntries(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::getEntries(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // getEntries(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordBackendFunc_getEntries_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // getEntries(QUrl)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.getEntries()' not implemented.");
                return {};
            }
            QVector<PasswordEntry > cppResult = cppSelf->getEntries(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QVECTOR_PASSWORDENTRY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PasswordBackendFunc_getEntries_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.PasswordBackend.getEntries");
        return {};
}

static PyObject *Sbk_PasswordBackendFunc_getUsernames(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::getUsernames(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // getUsernames(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordBackendFunc_getUsernames_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // getUsernames(QUrl)
            QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PasswordBackend::getUsernames(*cppArg0)
                : cppSelf->getUsernames(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PasswordBackendFunc_getUsernames_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.PasswordBackend.getUsernames");
        return {};
}

static PyObject *Sbk_PasswordBackendFunc_hasSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasSettings()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::PasswordBackend *>(cppSelf)->::PasswordBackend::hasSettings()
                : const_cast<const ::PasswordBackend *>(cppSelf)->hasSettings();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_PasswordBackendFunc_isActive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isActive()const
            bool cppResult = const_cast<const ::PasswordBackend *>(cppSelf)->isActive();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_PasswordBackendFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.name()' not implemented.");
                return {};
            }
            QString cppResult = const_cast<const ::PasswordBackend *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_PasswordBackendFunc_removeAll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeAll()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.removeAll()' not implemented.");
                return {};
            }
            cppSelf->removeAll();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_PasswordBackendFunc_removeEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::removeEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArg)))) {
        overloadId = 0; // removeEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordBackendFunc_removeEntry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeEntry(PasswordEntry)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.removeEntry()' not implemented.");
                return {};
            }
            cppSelf->removeEntry(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PasswordBackendFunc_removeEntry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.PasswordBackend.removeEntry");
        return {};
}

static PyObject *Sbk_PasswordBackendFunc_setActive(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::setActive(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setActive(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordBackendFunc_setActive_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActive(bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PasswordBackend::setActive(cppArg0)
                : cppSelf->setActive(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PasswordBackendFunc_setActive_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.PasswordBackend.setActive");
        return {};
}

static PyObject *Sbk_PasswordBackendFunc_showSettings(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::showSettings(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // showSettings(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordBackendFunc_showSettings_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // showSettings(QWidget*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PasswordBackend::showSettings(cppArg0)
                : cppSelf->showSettings(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PasswordBackendFunc_showSettings_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.PasswordBackend.showSettings");
        return {};
}

static PyObject *Sbk_PasswordBackendFunc_updateEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::updateEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArg)))) {
        overloadId = 0; // updateEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordBackendFunc_updateEntry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // updateEntry(PasswordEntry)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.updateEntry()' not implemented.");
                return {};
            }
            bool cppResult = cppSelf->updateEntry(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_PasswordBackendFunc_updateEntry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.PasswordBackend.updateEntry");
        return {};
}

static PyObject *Sbk_PasswordBackendFunc_updateLastUsed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::updateLastUsed(PasswordEntry&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArg)))) {
        overloadId = 0; // updateLastUsed(PasswordEntry&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordBackendFunc_updateLastUsed_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // updateLastUsed(PasswordEntry&)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'PasswordBackend.updateLastUsed()' not implemented.");
                return {};
            }
            cppSelf->updateLastUsed(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_PasswordBackendFunc_updateLastUsed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.PasswordBackend.updateLastUsed");
        return {};
}


static const char *Sbk_PasswordBackend_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PasswordBackend_methods[] = {
    {"addEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_addEntry), METH_O},
    {"getAllEntries", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_getAllEntries), METH_NOARGS},
    {"getEntries", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_getEntries), METH_O},
    {"getUsernames", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_getUsernames), METH_O},
    {"hasSettings", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_hasSettings), METH_NOARGS},
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_isActive), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_name), METH_NOARGS},
    {"removeAll", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_removeAll), METH_NOARGS},
    {"removeEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_removeEntry), METH_O},
    {"setActive", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_setActive), METH_O},
    {"showSettings", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_showSettings), METH_O},
    {"updateEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_updateEntry), METH_O},
    {"updateLastUsed", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_updateLastUsed), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_PasswordBackend_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<PasswordBackendWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_PasswordBackend_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_PasswordBackend_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_PasswordBackend_Type = nullptr;
static SbkObjectType *Sbk_PasswordBackend_TypeF(void)
{
    return _Sbk_PasswordBackend_Type;
}

static PyType_Slot Sbk_PasswordBackend_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_PasswordBackend_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PasswordBackend_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PasswordBackend_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PasswordBackend_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PasswordBackend_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_PasswordBackend_spec = {
    "1:PyFalkon.PasswordBackend",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_PasswordBackend_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PasswordBackend_PythonToCpp_PasswordBackend_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_PasswordBackend_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PasswordBackend_PythonToCpp_PasswordBackend_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_PasswordBackend_TypeF())))
        return PasswordBackend_PythonToCpp_PasswordBackend_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PasswordBackend_PTR_CppToPython_PasswordBackend(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::PasswordBackend *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_PasswordBackend_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *PasswordBackend_SignatureStrings[] = {
    "PyFalkon.PasswordBackend(self)",
    "PyFalkon.PasswordBackend.addEntry(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordBackend.getAllEntries(self)->QVector[PyFalkon.PasswordEntry]",
    "PyFalkon.PasswordBackend.getEntries(self,url:PySide2.QtCore.QUrl)->QVector[PyFalkon.PasswordEntry]",
    "PyFalkon.PasswordBackend.getUsernames(self,url:PySide2.QtCore.QUrl)->QStringList",
    "PyFalkon.PasswordBackend.hasSettings(self)->bool",
    "PyFalkon.PasswordBackend.isActive(self)->bool",
    "PyFalkon.PasswordBackend.name(self)->QString",
    "PyFalkon.PasswordBackend.removeAll(self)",
    "PyFalkon.PasswordBackend.removeEntry(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordBackend.setActive(self,active:bool)",
    "PyFalkon.PasswordBackend.showSettings(self,parent:PySide2.QtWidgets.QWidget)",
    "PyFalkon.PasswordBackend.updateEntry(self,entry:PyFalkon.PasswordEntry)->bool",
    "PyFalkon.PasswordBackend.updateLastUsed(self,entry:PyFalkon.PasswordEntry)",
    nullptr}; // Sentinel

void init_PasswordBackend(PyObject *module)
{
    _Sbk_PasswordBackend_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PasswordBackend",
        "PasswordBackend*",
        &Sbk_PasswordBackend_spec,
        &Shiboken::callCppDestructor< ::PasswordBackend >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_PasswordBackend_Type);
    InitSignatureStrings(pyType, PasswordBackend_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_PasswordBackend_Type), Sbk_PasswordBackend_PropertyStrings);
    SbkPyFalkonTypes[SBK_PASSWORDBACKEND_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_PasswordBackend_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_PasswordBackend_TypeF(),
        PasswordBackend_PythonToCpp_PasswordBackend_PTR,
        is_PasswordBackend_PythonToCpp_PasswordBackend_PTR_Convertible,
        PasswordBackend_PTR_CppToPython_PasswordBackend);

    Shiboken::Conversions::registerConverterName(converter, "PasswordBackend");
    Shiboken::Conversions::registerConverterName(converter, "PasswordBackend*");
    Shiboken::Conversions::registerConverterName(converter, "PasswordBackend&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PasswordBackend).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::PasswordBackendWrapper).name());



    PasswordBackendWrapper::pysideInitQtMetaTypes();
}
