
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>

QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "wheelhelper_wrapper.h"

// inner classes

// Extra includes
#include <qevent.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_WheelHelper_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::WheelHelper >()))
        return -1;

    ::WheelHelper *cptr{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "WheelHelper", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: WheelHelper::WheelHelper()
    // 1: WheelHelper::WheelHelper(WheelHelper)
    if (numArgs == 0) {
        overloadId = 0; // WheelHelper()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WHEELHELPER_IDX]), (pyArgs[0])))) {
        overloadId = 1; // WheelHelper(WheelHelper)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WheelHelper_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // WheelHelper()
        {

            if (!PyErr_Occurred()) {
                // WheelHelper()
                cptr = new ::WheelHelper();
            }
            break;
        }
        case 1: // WheelHelper(const WheelHelper & WheelHelper)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::WheelHelper cppArg0_local;
            ::WheelHelper *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WHEELHELPER_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // WheelHelper(WheelHelper)
                cptr = new ::WheelHelper(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::WheelHelper >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto Sbk_WheelHelper_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_WheelHelper_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WheelHelper");
        return -1;
}

static PyObject *Sbk_WheelHelperFunc_processEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WheelHelper *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WHEELHELPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WheelHelper::processEvent(QWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // processEvent(QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WheelHelperFunc_processEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // processEvent(QWheelEvent*)
            cppSelf->processEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WheelHelperFunc_processEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WheelHelper.processEvent");
        return {};
}

static PyObject *Sbk_WheelHelperFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WheelHelper *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WHEELHELPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()
            cppSelf->reset();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_WheelHelperFunc_takeDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::WheelHelper *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WHEELHELPER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // takeDirection()
            WheelHelper::Direction cppResult = WheelHelper::Direction(cppSelf->takeDirection());
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WheelHelper___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::WheelHelper *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WHEELHELPER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WHEELHELPER_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_WheelHelper_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_WheelHelper_methods[] = {
    {"processEvent", reinterpret_cast<PyCFunction>(Sbk_WheelHelperFunc_processEvent), METH_O},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_WheelHelperFunc_reset), METH_NOARGS},
    {"takeDirection", reinterpret_cast<PyCFunction>(Sbk_WheelHelperFunc_takeDirection), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_WheelHelper___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_WheelHelper_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_WheelHelper_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_WheelHelper_Type = nullptr;
static SbkObjectType *Sbk_WheelHelper_TypeF(void)
{
    return _Sbk_WheelHelper_Type;
}

static PyType_Slot Sbk_WheelHelper_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_WheelHelper_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_WheelHelper_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_WheelHelper_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_WheelHelper_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_WheelHelper_spec = {
    "1:PyFalkon.WheelHelper",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_WheelHelper_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void WheelHelper_Direction_PythonToCpp_WheelHelper_Direction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::WheelHelper::Direction *>(cppOut) =
        static_cast<::WheelHelper::Direction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_WheelHelper_Direction_PythonToCpp_WheelHelper_Direction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX]))
        return WheelHelper_Direction_PythonToCpp_WheelHelper_Direction;
    return {};
}
static PyObject *WheelHelper_Direction_CppToPython_WheelHelper_Direction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::WheelHelper::Direction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void WheelHelper_PythonToCpp_WheelHelper_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_WheelHelper_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_WheelHelper_PythonToCpp_WheelHelper_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_WheelHelper_TypeF())))
        return WheelHelper_PythonToCpp_WheelHelper_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *WheelHelper_PTR_CppToPython_WheelHelper(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::WheelHelper *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_WheelHelper_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *WheelHelper_COPY_CppToPython_WheelHelper(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_WheelHelper_TypeF(), new ::WheelHelper(*reinterpret_cast<const ::WheelHelper *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void WheelHelper_PythonToCpp_WheelHelper_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::WheelHelper *>(cppOut) = *reinterpret_cast< ::WheelHelper *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WHEELHELPER_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_WheelHelper_PythonToCpp_WheelHelper_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_WheelHelper_TypeF())))
        return WheelHelper_PythonToCpp_WheelHelper_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *WheelHelper_SignatureStrings[] = {
    "1:PyFalkon.WheelHelper(self)",
    "0:PyFalkon.WheelHelper(self,WheelHelper:PyFalkon.WheelHelper)",
    "PyFalkon.WheelHelper.processEvent(self,event:PySide2.QtGui.QWheelEvent)",
    "PyFalkon.WheelHelper.reset(self)",
    "PyFalkon.WheelHelper.takeDirection(self)->PyFalkon.WheelHelper.Direction",
    "PyFalkon.WheelHelper.__copy__()",
    nullptr}; // Sentinel

void init_WheelHelper(PyObject *module)
{
    _Sbk_WheelHelper_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "WheelHelper",
        "WheelHelper",
        &Sbk_WheelHelper_spec,
        &Shiboken::callCppDestructor< ::WheelHelper >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_WheelHelper_Type);
    InitSignatureStrings(pyType, WheelHelper_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_WheelHelper_Type), Sbk_WheelHelper_PropertyStrings);
    SbkPyFalkonTypes[SBK_WHEELHELPER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_WheelHelper_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_WheelHelper_TypeF(),
        WheelHelper_PythonToCpp_WheelHelper_PTR,
        is_WheelHelper_PythonToCpp_WheelHelper_PTR_Convertible,
        WheelHelper_PTR_CppToPython_WheelHelper,
        WheelHelper_COPY_CppToPython_WheelHelper);

    Shiboken::Conversions::registerConverterName(converter, "WheelHelper");
    Shiboken::Conversions::registerConverterName(converter, "WheelHelper*");
    Shiboken::Conversions::registerConverterName(converter, "WheelHelper&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::WheelHelper).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        WheelHelper_PythonToCpp_WheelHelper_COPY,
        is_WheelHelper_PythonToCpp_WheelHelper_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Direction'.
    SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_WheelHelper_TypeF(),
        "Direction",
        "1:PyFalkon.WheelHelper.Direction",
        "WheelHelper::Direction");
    if (!SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX],
        Sbk_WheelHelper_TypeF(), "None_", (long) WheelHelper::Direction::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX],
        Sbk_WheelHelper_TypeF(), "WheelUp", (long) WheelHelper::Direction::WheelUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX],
        Sbk_WheelHelper_TypeF(), "WheelDown", (long) WheelHelper::Direction::WheelDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX],
        Sbk_WheelHelper_TypeF(), "WheelLeft", (long) WheelHelper::Direction::WheelLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX],
        Sbk_WheelHelper_TypeF(), "WheelRight", (long) WheelHelper::Direction::WheelRight))
        return;
    // Register converter for enum 'WheelHelper::Direction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX],
            WheelHelper_Direction_CppToPython_WheelHelper_Direction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            WheelHelper_Direction_PythonToCpp_WheelHelper_Direction,
            is_WheelHelper_Direction_PythonToCpp_WheelHelper_Direction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPyFalkonTypes[SBK_WHEELHELPER_DIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "WheelHelper::Direction");
        Shiboken::Conversions::registerConverterName(converter, "Direction");
    }
    // End of 'Direction' enum.


    qRegisterMetaType< ::WheelHelper >("WheelHelper");
    qRegisterMetaType< ::WheelHelper::Direction >("WheelHelper::Direction");
}
