
#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#include "shiboken_python.h"



// Extra includes
#include "sbkversion.h"
#include "voidptr.h"

// Current module's type array.
PyTypeObject **SbkShibokenTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkShibokenModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkShibokenTypeConverters = nullptr;
// Global functions ------------------------------------------------------------
static PyObject *SbkShibokenModule__unpickle_enum(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    static const char *fullName = "Shiboken._unpickle_enum";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "_unpickle_enum", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: _unpickle_enum(PyObject*,PyObject*)->PyObject*
    if (numArgs == 2
        && PyObject_Check(pyArgs[0])
        && PyObject_Check(pyArgs[1])) {
        overloadId = 0; // _unpickle_enum(PyObject*,PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkShibokenModule__unpickle_enum_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // _unpickle_enum(PyObject*,PyObject*)
            // Begin code injection
            pyResult = Shiboken::Enum::unpickleEnum(pyArgs[0], pyArgs[1]);
            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkShibokenModule__unpickle_enum_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        return {};
}

static PyObject *SbkShibokenModule_createdByPython(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    static const char *fullName = "Shiboken.createdByPython";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: createdByPython(PyObject*)->bool
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // createdByPython(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkShibokenModule_createdByPython_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createdByPython(PyObject*)
            // Begin code injection
            if (Shiboken::Object::checkType(pyArg)) {
                bool wasCreatedByPython = Shiboken::Object::wasCreatedByPython(reinterpret_cast<SbkObject *>(pyArg));
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &wasCreatedByPython);
            } else {
                PyErr_SetString(PyExc_TypeError, "You need a shiboken-based type.");
            }
            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkShibokenModule_createdByPython_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        return {};
}

static PyObject *SbkShibokenModule_delete(PyObject *self, PyObject *pyArg)
{
    Shiboken::AutoDecRef errInfo{};
    static const char *fullName = "Shiboken.delete";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: delete(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // delete(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkShibokenModule_delete_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // delete(PyObject*)
            // Begin code injection
            if (Shiboken::Object::checkType(pyArg)) {
                Shiboken::Object::callCppDestructors(reinterpret_cast<SbkObject *>(pyArg));
            } else {
                PyErr_SetString(PyExc_TypeError, "You need a shiboken-based type.");
            }
            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    SbkShibokenModule_delete_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        return {};
}

static PyObject *SbkShibokenModule_dump(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    static const char *fullName = "Shiboken.dump";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: dump(PyObject*)->PyObject*
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // dump(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkShibokenModule_dump_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dump(PyObject*)
            // Begin code injection
            if (!Shiboken::Object::checkType(pyArg)) {
                pyResult = Shiboken::String::fromCString("Ordinary Python type.");
            } else {
                std::string str = Shiboken::Object::info(reinterpret_cast<SbkObject *>(pyArg));
                pyResult = Shiboken::String::fromCString(str.c_str());
            }
            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkShibokenModule_dump_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        return {};
}

static PyObject *SbkShibokenModule_getAllValidWrappers(PyObject *self)
{
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    static const char *fullName = "Shiboken.getAllValidWrappers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getAllValidWrappers()
            // Begin code injection
            std::set<PyObject*> setAll = Shiboken::BindingManager::instance().getAllPyObjects();
            PyObject* listAll = PyList_New(0);
            if (listAll == NULL)
                return NULL;

            const std::set<PyObject*>::iterator end = setAll.end();
            for (std::set<PyObject*>::iterator iter = setAll.begin(); iter != end; ++iter) {
                if (*iter != NULL) {
                    if (PyList_Append(listAll, *iter) != 0) {
                        Py_DECREF(listAll);
                        return NULL;
                    }
                }
            }
            return listAll;
            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *SbkShibokenModule_getCppPointer(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    static const char *fullName = "Shiboken.getCppPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: getCppPointer(PyObject*)->PyObject*
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // getCppPointer(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkShibokenModule_getCppPointer_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getCppPointer(PyObject*)
            // Begin code injection
            if (Shiboken::Object::checkType(pyArg)) {
                std::vector<void*> ptrs = Shiboken::Object::cppPointers(reinterpret_cast<SbkObject *>(pyArg));
                pyResult = PyTuple_New(ptrs.size());
                for (std::size_t i = 0; i < ptrs.size(); ++i)
                    PyTuple_SET_ITEM(pyResult, i, PyLong_FromVoidPtr(ptrs[i]));
            } else {
                PyErr_SetString(PyExc_TypeError, "You need a shiboken-based type.");
            }
            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkShibokenModule_getCppPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        return {};
}

static PyObject *SbkShibokenModule_invalidate(PyObject *self, PyObject *pyArg)
{
    Shiboken::AutoDecRef errInfo{};
    static const char *fullName = "Shiboken.invalidate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: invalidate(PyObject*)
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // invalidate(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkShibokenModule_invalidate_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // invalidate(PyObject*)
            // Begin code injection
            Shiboken::Object::invalidate(pyArg);
            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    SbkShibokenModule_invalidate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        return {};
}

static PyObject *SbkShibokenModule_isValid(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    static const char *fullName = "Shiboken.isValid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: isValid(PyObject*)->bool
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // isValid(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkShibokenModule_isValid_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid(PyObject*)
            // Begin code injection
            bool isValid = Shiboken::Object::isValid(pyArg, false);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &isValid);
            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkShibokenModule_isValid_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        return {};
}

static PyObject *SbkShibokenModule_ownedByPython(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    static const char *fullName = "Shiboken.ownedByPython";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ownedByPython(PyObject*)->bool
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // ownedByPython(PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkShibokenModule_ownedByPython_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ownedByPython(PyObject*)
            // Begin code injection
            if (Shiboken::Object::checkType(pyArg)) {
                bool hasOwnership = Shiboken::Object::hasOwnership(reinterpret_cast<SbkObject *>(pyArg));
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &hasOwnership);
            } else {
                PyErr_SetString(PyExc_TypeError, "You need a shiboken-based type.");
            }
            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkShibokenModule_ownedByPython_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        return {};
}

static PyObject *SbkShibokenModule_wrapInstance(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    static const char *fullName = "Shiboken.wrapInstance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "wrapInstance", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: wrapInstance(size_t,PyTypeObject)->PyObject*
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<size_t>(), (pyArgs[0])))
        && PyType_Check(pyArgs[1])) {
        overloadId = 0; // wrapInstance(size_t,PyTypeObject)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkShibokenModule_wrapInstance_TypeError;

    // Call function/method
    {
        ::size_t cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // wrapInstance(size_t,PyTypeObject)
            // Begin code injection
            auto *pyType = reinterpret_cast<PyTypeObject *>(pyArgs[1]);
            if (Shiboken::ObjectType::checkType(pyType)) {
                pyResult = Shiboken::Object::newObject(pyType,
                                                       reinterpret_cast<void *>(cppArg0),
                                                       false, true);
            } else {
                PyErr_SetString(PyExc_TypeError, "You need a shiboken-based type.");
            }
            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkShibokenModule_wrapInstance_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        return {};
}


static PyMethodDef Shiboken_methods[] = {
    {"_unpickle_enum", reinterpret_cast<PyCFunction>(SbkShibokenModule__unpickle_enum), METH_VARARGS},
    {"createdByPython", reinterpret_cast<PyCFunction>(SbkShibokenModule_createdByPython), METH_O},
    {"delete", reinterpret_cast<PyCFunction>(SbkShibokenModule_delete), METH_O},
    {"dump", reinterpret_cast<PyCFunction>(SbkShibokenModule_dump), METH_O},
    {"getAllValidWrappers", reinterpret_cast<PyCFunction>(SbkShibokenModule_getAllValidWrappers), METH_NOARGS},
    {"getCppPointer", reinterpret_cast<PyCFunction>(SbkShibokenModule_getCppPointer), METH_O},
    {"invalidate", reinterpret_cast<PyCFunction>(SbkShibokenModule_invalidate), METH_O},
    {"isValid", reinterpret_cast<PyCFunction>(SbkShibokenModule_isValid), METH_O},
    {"ownedByPython", reinterpret_cast<PyCFunction>(SbkShibokenModule_ownedByPython), METH_O},
    {"wrapInstance", reinterpret_cast<PyCFunction>(SbkShibokenModule_wrapInstance), METH_VARARGS},
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------


// Module initialization ------------------------------------------------------------
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "Shiboken",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ Shiboken_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *Shiboken_SignatureStrings[] = {
    "Shiboken._unpickle_enum(arg__1:PyObject,arg__2:PyObject)->PyObject",
    "Shiboken.createdByPython(arg__1:PyObject)->bool",
    "Shiboken.delete(arg__1:PyObject)",
    "Shiboken.dump(arg__1:PyObject)->PyObject",
    "Shiboken.getAllValidWrappers()->PyObject",
    "Shiboken.getCppPointer(arg__1:PyObject)->PyObject",
    "Shiboken.invalidate(arg__1:PyObject)",
    "Shiboken.isValid(arg__1:PyObject)->bool",
    "Shiboken.ownedByPython(arg__1:PyObject)->bool",
    "Shiboken.wrapInstance(arg__1:size_t,arg__2:PyTypeObject)->PyObject",
    nullptr}; // Sentinel

extern "C" LIBSHIBOKEN_EXPORT PyObject *PyInit_Shiboken()
{
    if (SbkShibokenModuleObject != nullptr)
        return SbkShibokenModuleObject;
    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_Shiboken_CONVERTERS_IDX_COUNT];
    SbkShibokenTypeConverters = sbkConverters;

    PyObject *module = Shiboken::Module::create("Shiboken", &moduledef);

    // Make module available from global scope
    SbkShibokenModuleObject = module;

    // Initialize classes in the type system
    // Register primitive types converters.

    Shiboken::Module::registerTypeConverters(module, SbkShibokenTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module Shiboken");
    }
    // Begin code injection
    // Add __version__ and __version_info__ attributes to the module
    PyObject* version = PyTuple_New(5);
    PyTuple_SET_ITEM(version, 0, PyLong_FromLong(SHIBOKEN_MAJOR_VERSION));
    PyTuple_SET_ITEM(version, 1, PyLong_FromLong(SHIBOKEN_MINOR_VERSION));
    PyTuple_SET_ITEM(version, 2, PyLong_FromLong(SHIBOKEN_MICRO_VERSION));
    PyTuple_SET_ITEM(version, 3, Shiboken::String::fromCString(SHIBOKEN_RELEASE_LEVEL));
    PyTuple_SET_ITEM(version, 4, PyLong_FromLong(SHIBOKEN_SERIAL));
    PyModule_AddObject(module, "__version_info__", version);
    PyModule_AddStringConstant(module, "__version__", SHIBOKEN_VERSION);

    Shiboken::initSignature(module);
    VoidPtr::addVoidPtrToModule(module);
    // End of code injection

    FinishSignatureInitialization(module, Shiboken_SignatureStrings);

    return module;
}
