/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import java.math.BigDecimal;

public abstract class NumericDigester
extends AbstractDigester {
    protected NumericDigester(String keyword) {
        super(keyword, NodeType.INTEGER, NodeType.NUMBER);
    }

    private static boolean valueIsLong(JsonNode node) {
        if (!node.canConvertToLong()) {
            return false;
        }
        if (NodeType.getNodeType(node) == NodeType.INTEGER) {
            return true;
        }
        return node.decimalValue().remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0;
    }

    protected final ObjectNode digestedNumberNode(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        JsonNode node = schema.get(this.keyword);
        boolean isLong = NumericDigester.valueIsLong(node);
        ret.put("valueIsLong", isLong);
        if (isLong) {
            ret.set(this.keyword, node.canConvertToInt() ? FACTORY.numberNode(node.intValue()) : FACTORY.numberNode(node.longValue()));
            return ret;
        }
        BigDecimal decimal = node.decimalValue();
        ret.set(this.keyword, decimal.scale() == 0 ? FACTORY.numberNode(decimal.toBigIntegerExact()) : node);
        return ret;
    }
}

