// This file is generated by kconfig_compiler_kf5 from okular.kcfg.
// All changes you do to this file will be lost.

#include "settings.h"

#include <qdom.h>
#include <QStandardPaths>
#include <qglobal.h>
#include <QFile>

#include <QDebug>

using namespace Okular;

namespace Okular {

class SettingsPrivate
{
  public:

    // Dlg Performance
    bool enableCompositing;

    // Debugging Options
    bool debugDrawBoundaries;
    bool debugDrawAnnotationRect;

    // Contents
    bool contentsSearchCaseSensitive;
    bool contentsSearchRegularExpression;

    // Layers
    bool layersSearchCaseSensitive;
    bool layersSearchRegularExpression;

    // Reviews
    bool reviewsSearchCaseSensitive;
    bool reviewsSearchRegularExpression;
    QStringList drawingTools;
    QStringList builtinAnnotationTools;
    QStringList quickAnnotationTools;
    bool annotationContinuousMode;
    uint quickAnnotationDefaultAction;

    // Zoom
    uint zoomMode;

    // General
    bool shellOpenFileInTabs;
    bool switchToTabIfOpen;
    bool showOSD;
    bool showEmbeddedContentMessages;
    bool displayDocumentTitle;
    bool rtlReadingDirection;
    int displayDocumentNameOrPath;
    bool useTTS;
    QString ttsEngine;
    bool watchFile;

    // Dlg Presentation
    QColor slidesBackgroundColor;
    int slidesTransition;
    int slidesCursor;
    bool slidesShowProgress;
    bool slidesShowSummary;
    int slidesScreen;

    // Main View
    bool showLeftPanel;
    QList<int> splitterSizes;
    bool showBottomBar;

    // Nav Panel
    bool currentPageOnly;
    bool groupByAuthor;
    bool groupByPage;
    bool filterBookmarks;
    bool syncThumbnailsViewport;
    bool tocPageColumn;
    bool sidebarShowText;
    uint sidebarIconSize;

    // PageView
    int editToolBarPlacement;
    bool smoothScrolling;
    bool showScrollBars;
    uint scrollOverlap;
    uint viewColumns;
    bool trimMargins;
    bool viewContinuous;
    int primaryAnnotationToolBar;
    int viewMode;
    int trimMode;
    int mouseMode;
    bool showSourceLocationsGraphically;
    bool useCustomBackgroundColor;
    QColor backgroundColor;

    // Search
    bool searchCaseSensitive;
    bool searchFromCurrentPage;
    bool findAsYouType;

    // Dlg Accessibility
    bool highlightImages;
    bool highlightLinks;
    QColor recolorForeground;
    QColor recolorBackground;
    uint bWThreshold;
    uint bWContrast;

    // Identity
    QString identityAuthor;

    // items
    SettingsCore::ItemBool *itemEnableCompositing;
    SettingsCore::ItemBool *itemDebugDrawBoundaries;
    SettingsCore::ItemBool *itemDebugDrawAnnotationRect;
    SettingsCore::ItemBool *itemContentsSearchCaseSensitive;
    SettingsCore::ItemBool *itemContentsSearchRegularExpression;
    SettingsCore::ItemBool *itemLayersSearchCaseSensitive;
    SettingsCore::ItemBool *itemLayersSearchRegularExpression;
    SettingsCore::ItemBool *itemReviewsSearchCaseSensitive;
    SettingsCore::ItemBool *itemReviewsSearchRegularExpression;
    SettingsCore::ItemStringList *itemDrawingTools;
    KConfigCompilerSignallingItem *itemBuiltinAnnotationTools;
    KConfigCompilerSignallingItem *itemQuickAnnotationTools;
    SettingsCore::ItemBool *itemAnnotationContinuousMode;
    SettingsCore::ItemUInt *itemQuickAnnotationDefaultAction;
    SettingsCore::ItemUInt *itemZoomMode;
    SettingsCore::ItemBool *itemShellOpenFileInTabs;
    SettingsCore::ItemBool *itemSwitchToTabIfOpen;
    SettingsCore::ItemBool *itemShowOSD;
    SettingsCore::ItemBool *itemShowEmbeddedContentMessages;
    SettingsCore::ItemBool *itemDisplayDocumentTitle;
    SettingsCore::ItemBool *itemRtlReadingDirection;
    SettingsCore::ItemEnum *itemDisplayDocumentNameOrPath;
    SettingsCore::ItemBool *itemUseTTS;
    SettingsCore::ItemString *itemTtsEngine;
    SettingsCore::ItemBool *itemWatchFile;
    SettingsCore::ItemColor *itemSlidesBackgroundColor;
    SettingsCore::ItemEnum *itemSlidesTransition;
    SettingsCore::ItemEnum *itemSlidesCursor;
    SettingsCore::ItemBool *itemSlidesShowProgress;
    SettingsCore::ItemBool *itemSlidesShowSummary;
    SettingsCore::ItemInt *itemSlidesScreen;
    SettingsCore::ItemBool *itemShowLeftPanel;
    SettingsCore::ItemIntList *itemSplitterSizes;
    SettingsCore::ItemBool *itemShowBottomBar;
    SettingsCore::ItemBool *itemCurrentPageOnly;
    SettingsCore::ItemBool *itemGroupByAuthor;
    SettingsCore::ItemBool *itemGroupByPage;
    SettingsCore::ItemBool *itemFilterBookmarks;
    SettingsCore::ItemBool *itemSyncThumbnailsViewport;
    SettingsCore::ItemBool *itemTocPageColumn;
    SettingsCore::ItemBool *itemSidebarShowText;
    SettingsCore::ItemUInt *itemSidebarIconSize;
    SettingsCore::ItemInt *itemEditToolBarPlacement;
    SettingsCore::ItemBool *itemSmoothScrolling;
    SettingsCore::ItemBool *itemShowScrollBars;
    SettingsCore::ItemUInt *itemScrollOverlap;
    SettingsCore::ItemUInt *itemViewColumns;
    SettingsCore::ItemBool *itemTrimMargins;
    KConfigCompilerSignallingItem *itemViewContinuous;
    KConfigCompilerSignallingItem *itemPrimaryAnnotationToolBar;
    SettingsCore::ItemEnum *itemViewMode;
    SettingsCore::ItemEnum *itemTrimMode;
    SettingsCore::ItemEnum *itemMouseMode;
    SettingsCore::ItemBool *itemShowSourceLocationsGraphically;
    SettingsCore::ItemBool *itemUseCustomBackgroundColor;
    SettingsCore::ItemColor *itemBackgroundColor;
    SettingsCore::ItemBool *itemSearchCaseSensitive;
    SettingsCore::ItemBool *itemSearchFromCurrentPage;
    SettingsCore::ItemBool *itemFindAsYouType;
    SettingsCore::ItemBool *itemHighlightImages;
    SettingsCore::ItemBool *itemHighlightLinks;
    KConfigCompilerSignallingItem *itemRecolorForeground;
    KConfigCompilerSignallingItem *itemRecolorBackground;
    KConfigCompilerSignallingItem *itemBWThreshold;
    KConfigCompilerSignallingItem *itemBWContrast;
    SettingsCore::ItemString *itemIdentityAuthor;
    uint settingsChanged;
};


}
namespace Okular {

class SettingsHelper
{
  public:
    SettingsHelper() : q(nullptr) {}
    ~SettingsHelper() { delete q; }
    SettingsHelper(const SettingsHelper&) = delete;
    SettingsHelper& operator=(const SettingsHelper&) = delete;
    Settings *q;
};

}
Q_GLOBAL_STATIC(SettingsHelper, s_globalSettings)
Settings *Settings::self()
{
  if (!s_globalSettings()->q)
     qFatal("you need to call Settings::instance before using");
  return s_globalSettings()->q;
}

void Settings::instance(const QString& cfgfilename)
{
  if (s_globalSettings()->q) {
     qDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(KSharedConfig::openConfig(cfgfilename));
  s_globalSettings()->q->read();
}

void Settings::instance(KSharedConfig::Ptr config)
{
  if (s_globalSettings()->q) {
     qDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(std::move(config));
  s_globalSettings()->q->read();
}

Settings::Settings( KSharedConfig::Ptr config )
  : SettingsCore( std::move( config ) )
{
  d = new SettingsPrivate;
  d->settingsChanged = 0;
  Q_ASSERT(!s_globalSettings()->q);
  s_globalSettings()->q = this;
  KConfigCompilerSignallingItem::NotifyFunction notifyFunction = static_cast<KConfigCompilerSignallingItem::NotifyFunction>(&Settings::itemChanged);

  setCurrentGroup( QStringLiteral( "Dlg Performance" ) );

  d->itemEnableCompositing = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "EnableCompositing" ), d->enableCompositing, true );
  addItem( d->itemEnableCompositing, QStringLiteral( "EnableCompositing" ) );

  setCurrentGroup( QStringLiteral( "Debugging Options" ) );

  d->itemDebugDrawBoundaries = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "DebugDrawBoundaries" ), d->debugDrawBoundaries, false );
  addItem( d->itemDebugDrawBoundaries, QStringLiteral( "DebugDrawBoundaries" ) );
  d->itemDebugDrawAnnotationRect = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "DebugDrawAnnotationRect" ), d->debugDrawAnnotationRect, false );
  addItem( d->itemDebugDrawAnnotationRect, QStringLiteral( "DebugDrawAnnotationRect" ) );

  setCurrentGroup( QStringLiteral( "Contents" ) );

  d->itemContentsSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ContentsSearchCaseSensitive" ), d->contentsSearchCaseSensitive, false );
  addItem( d->itemContentsSearchCaseSensitive, QStringLiteral( "ContentsSearchCaseSensitive" ) );
  d->itemContentsSearchRegularExpression = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ContentsSearchRegularExpression" ), d->contentsSearchRegularExpression, false );
  addItem( d->itemContentsSearchRegularExpression, QStringLiteral( "ContentsSearchRegularExpression" ) );

  setCurrentGroup( QStringLiteral( "Layers" ) );

  d->itemLayersSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "LayersSearchCaseSensitive" ), d->layersSearchCaseSensitive, false );
  addItem( d->itemLayersSearchCaseSensitive, QStringLiteral( "LayersSearchCaseSensitive" ) );
  d->itemLayersSearchRegularExpression = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "LayersSearchRegularExpression" ), d->layersSearchRegularExpression, false );
  addItem( d->itemLayersSearchRegularExpression, QStringLiteral( "LayersSearchRegularExpression" ) );

  setCurrentGroup( QStringLiteral( "Reviews" ) );

  d->itemReviewsSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ReviewsSearchCaseSensitive" ), d->reviewsSearchCaseSensitive, false );
  addItem( d->itemReviewsSearchCaseSensitive, QStringLiteral( "ReviewsSearchCaseSensitive" ) );
  d->itemReviewsSearchRegularExpression = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ReviewsSearchRegularExpression" ), d->reviewsSearchRegularExpression, false );
  addItem( d->itemReviewsSearchRegularExpression, QStringLiteral( "ReviewsSearchRegularExpression" ) );

      QStringList drawingTools;
      // load the default tool list from the 'xml tools definition' file
      QFile infoDrawingFile( QStandardPaths::locate(QStandardPaths::GenericDataLocation, "okular/drawingtools.xml") );
      if ( infoDrawingFile.exists() && infoDrawingFile.open( QIODevice::ReadOnly ) )
      {
          QDomDocument doc;
          if ( doc.setContent( &infoDrawingFile ) )
          {
              const QDomElement toolsDefinition = doc.elementsByTagName("drawingTools").item( 0 ).toElement();
               // create the annotationTools list from the XML dom tree
              QDomNode toolDescription = toolsDefinition.firstChild();
              while ( toolDescription.isElement() )
              {
                  const QDomElement toolElement = toolDescription.toElement();
                  if ( toolElement.tagName() == "tool" )
                  {
                      QDomDocument temp;
                      temp.appendChild( temp.importNode( toolElement, true) );
                      // add each <tool>...</tool> as XML string
                      drawingTools << temp.toString(-1);
                  }
                  toolDescription = toolDescription.nextSibling();
              }
          }
          else
          {
              qWarning() << "DrawingTools XML file seems to be damaged";
          }
      }
      else
      {
          qWarning() << "Unable to open DrawingTools XML definition";
      }
    
  d->itemDrawingTools = new SettingsCore::ItemStringList( currentGroup(), QStringLiteral( "DrawingTools" ), d->drawingTools, drawingTools );
  addItem( d->itemDrawingTools, QStringLiteral( "DrawingTools" ) );

      QStringList builtinAnnotationTools;
      // load the default tool list from the 'xml tools definition' file
      QFile infoFile( QStandardPaths::locate(QStandardPaths::GenericDataLocation, "okular/tools.xml") );
      if ( infoFile.exists() && infoFile.open( QIODevice::ReadOnly ) )
      {
          QDomDocument doc;
          if ( doc.setContent( &infoFile ) )
          {
              QDomElement toolsDefinition = doc.elementsByTagName("annotatingTools").item( 0 ).toElement();
               // create the builtinAnnotationTools list from the XML dom tree
              QDomNode toolDescription = toolsDefinition.firstChild();
              while ( toolDescription.isElement() )
              {
                  QDomElement toolElement = toolDescription.toElement();
                  if ( toolElement.tagName() == "tool" )
                  {
                      QDomDocument temp;
                      temp.appendChild( temp.importNode( toolElement, true) );
                      // add each <tool>...</tool> as XML string
                      builtinAnnotationTools << temp.toString(-1);
                  }
                  toolDescription = toolDescription.nextSibling();
              }
          }
          else
          {
              qWarning() << "AnnotatingTools XML file seems to be damaged";
          }
      }
      else
      {
          qWarning() << "Unable to open AnnotatingTools XML definition";
      }
    
  SettingsCore::ItemStringList  *innerItemBuiltinAnnotationTools;
  innerItemBuiltinAnnotationTools = new SettingsCore::ItemStringList( currentGroup(), QStringLiteral( "BuiltinAnnotationTools" ), d->builtinAnnotationTools, builtinAnnotationTools );
  d->itemBuiltinAnnotationTools = new KConfigCompilerSignallingItem(innerItemBuiltinAnnotationTools, this, notifyFunction, signalBuiltinAnnotationToolsChanged);
  addItem( d->itemBuiltinAnnotationTools, QStringLiteral( "BuiltinAnnotationTools" ) );

      QStringList quickAnnotationTools;
      // load the default tool list from the 'xml tools definition' file
      QFile quickAnnFile( QStandardPaths::locate(QStandardPaths::GenericDataLocation, "okular/toolsQuick.xml") );
      if ( quickAnnFile.exists() && quickAnnFile.open( QIODevice::ReadOnly ) )
      {
          QDomDocument doc;
          if ( doc.setContent( &quickAnnFile ) )
          {
              QDomElement toolsDefinition = doc.elementsByTagName("quickAnnotatingTools").item( 0 ).toElement();
               // create the quickAnnotationTools list from the XML dom tree
              QDomNode toolDescription = toolsDefinition.firstChild();
              while ( toolDescription.isElement() )
              {
                  QDomElement toolElement = toolDescription.toElement();
                  if ( toolElement.tagName() == "tool" )
                  {
                      QDomDocument temp;
                      temp.appendChild( temp.importNode( toolElement, true) );
                      // add each <tool>...</tool> as XML string
                      quickAnnotationTools << temp.toString(-1);
                  }
                  toolDescription = toolDescription.nextSibling();
              }
          }
          else
          {
              qWarning() << "QuickAnnotatingTools XML file seems to be damaged";
          }
      }
      else
      {
          qWarning() << "Unable to open QuickAnnotatingTools XML definition";
      }
    
  SettingsCore::ItemStringList  *innerItemQuickAnnotationTools;
  innerItemQuickAnnotationTools = new SettingsCore::ItemStringList( currentGroup(), QStringLiteral( "QuickAnnotationTools" ), d->quickAnnotationTools, quickAnnotationTools );
  d->itemQuickAnnotationTools = new KConfigCompilerSignallingItem(innerItemQuickAnnotationTools, this, notifyFunction, signalQuickAnnotationToolsChanged);
  addItem( d->itemQuickAnnotationTools, QStringLiteral( "QuickAnnotationTools" ) );
  d->itemAnnotationContinuousMode = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "AnnotationContinuousMode" ), d->annotationContinuousMode, true );
  addItem( d->itemAnnotationContinuousMode, QStringLiteral( "AnnotationContinuousMode" ) );
  d->itemQuickAnnotationDefaultAction = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "QuickAnnotationDefaultAction" ), d->quickAnnotationDefaultAction, 0 );
  addItem( d->itemQuickAnnotationDefaultAction, QStringLiteral( "QuickAnnotationDefaultAction" ) );

  setCurrentGroup( QStringLiteral( "Zoom" ) );

  d->itemZoomMode = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "ZoomMode" ), d->zoomMode, 1 );
  d->itemZoomMode->setMaxValue(3);
  addItem( d->itemZoomMode, QStringLiteral( "ZoomMode" ) );

  setCurrentGroup( QStringLiteral( "General" ) );

  d->itemShellOpenFileInTabs = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShellOpenFileInTabs" ), d->shellOpenFileInTabs, false );
  addItem( d->itemShellOpenFileInTabs, QStringLiteral( "ShellOpenFileInTabs" ) );
  d->itemSwitchToTabIfOpen = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SwitchToTabIfOpen" ), d->switchToTabIfOpen, true );
  addItem( d->itemSwitchToTabIfOpen, QStringLiteral( "SwitchToTabIfOpen" ) );
  d->itemShowOSD = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowOSD" ), d->showOSD, true );
  addItem( d->itemShowOSD, QStringLiteral( "ShowOSD" ) );
  d->itemShowEmbeddedContentMessages = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowEmbeddedContentMessages" ), d->showEmbeddedContentMessages, true );
  addItem( d->itemShowEmbeddedContentMessages, QStringLiteral( "ShowEmbeddedContentMessages" ) );
  d->itemDisplayDocumentTitle = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "DisplayDocumentTitle" ), d->displayDocumentTitle, true );
  addItem( d->itemDisplayDocumentTitle, QStringLiteral( "DisplayDocumentTitle" ) );
  d->itemRtlReadingDirection = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "rtlReadingDirection" ), d->rtlReadingDirection, false );
  addItem( d->itemRtlReadingDirection, QStringLiteral( "rtlReadingDirection" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesDisplayDocumentNameOrPath;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Name");
    valuesDisplayDocumentNameOrPath.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Path");
    valuesDisplayDocumentNameOrPath.append( choice );
  }
  d->itemDisplayDocumentNameOrPath = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "DisplayDocumentNameOrPath" ), d->displayDocumentNameOrPath, valuesDisplayDocumentNameOrPath, EnumDisplayDocumentNameOrPath::Name );
  addItem( d->itemDisplayDocumentNameOrPath, QStringLiteral( "DisplayDocumentNameOrPath" ) );
  d->itemUseTTS = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "UseTTS" ), d->useTTS );
  addItem( d->itemUseTTS, QStringLiteral( "UseTTS" ) );
  d->itemTtsEngine = new SettingsCore::ItemString( currentGroup(), QStringLiteral( "ttsEngine" ), d->ttsEngine, QStringLiteral( "speechd" ) );
  addItem( d->itemTtsEngine, QStringLiteral( "ttsEngine" ) );
  d->itemWatchFile = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "WatchFile" ), d->watchFile, true );
  addItem( d->itemWatchFile, QStringLiteral( "WatchFile" ) );

  setCurrentGroup( QStringLiteral( "Dlg Presentation" ) );

  d->itemSlidesBackgroundColor = new SettingsCore::ItemColor( currentGroup(), QStringLiteral( "SlidesBackgroundColor" ), d->slidesBackgroundColor, Qt::black );
  addItem( d->itemSlidesBackgroundColor, QStringLiteral( "SlidesBackgroundColor" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesSlidesTransition;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("NoTransitions");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Replace");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Random");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BlindsHorizontal");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BlindsVertical");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BoxIn");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BoxOut");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Dissolve");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Fade");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("GlitterDown");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("GlitterRight");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("GlitterRightDown");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("SplitHorizontalIn");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("SplitHorizontalOut");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("SplitVerticalIn");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("SplitVerticalOut");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("WipeDown");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("WipeRight");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("WipeLeft");
    valuesSlidesTransition.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("WipeUp");
    valuesSlidesTransition.append( choice );
  }
  d->itemSlidesTransition = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "SlidesTransition" ), d->slidesTransition, valuesSlidesTransition, EnumSlidesTransition::Replace );
  addItem( d->itemSlidesTransition, QStringLiteral( "SlidesTransition" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesSlidesCursor;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("HiddenDelay");
    valuesSlidesCursor.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Visible");
    valuesSlidesCursor.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Hidden");
    valuesSlidesCursor.append( choice );
  }
  d->itemSlidesCursor = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "SlidesCursor" ), d->slidesCursor, valuesSlidesCursor, EnumSlidesCursor::HiddenDelay );
  addItem( d->itemSlidesCursor, QStringLiteral( "SlidesCursor" ) );
  d->itemSlidesShowProgress = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SlidesShowProgress" ), d->slidesShowProgress, true );
  addItem( d->itemSlidesShowProgress, QStringLiteral( "SlidesShowProgress" ) );
  d->itemSlidesShowSummary = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SlidesShowSummary" ), d->slidesShowSummary, false );
  addItem( d->itemSlidesShowSummary, QStringLiteral( "SlidesShowSummary" ) );
  d->itemSlidesScreen = new SettingsCore::ItemInt( currentGroup(), QStringLiteral( "SlidesScreen" ), d->slidesScreen, -2 );
  d->itemSlidesScreen->setMinValue(-2);
  d->itemSlidesScreen->setMaxValue(20);
  addItem( d->itemSlidesScreen, QStringLiteral( "SlidesScreen" ) );

  setCurrentGroup( QStringLiteral( "Main View" ) );

  d->itemShowLeftPanel = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowLeftPanel" ), d->showLeftPanel, true );
  addItem( d->itemShowLeftPanel, QStringLiteral( "ShowLeftPanel" ) );
  QList<int> defaultSplitterSizes;

  d->itemSplitterSizes = new SettingsCore::ItemIntList( currentGroup(), QStringLiteral( "SplitterSizes" ), d->splitterSizes, defaultSplitterSizes );
  addItem( d->itemSplitterSizes, QStringLiteral( "SplitterSizes" ) );
  d->itemShowBottomBar = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowBottomBar" ), d->showBottomBar, false );
  addItem( d->itemShowBottomBar, QStringLiteral( "ShowBottomBar" ) );

  setCurrentGroup( QStringLiteral( "Nav Panel" ) );

  d->itemCurrentPageOnly = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "CurrentPageOnly" ), d->currentPageOnly, false );
  addItem( d->itemCurrentPageOnly, QStringLiteral( "CurrentPageOnly" ) );
  d->itemGroupByAuthor = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "GroupByAuthor" ), d->groupByAuthor, true );
  addItem( d->itemGroupByAuthor, QStringLiteral( "GroupByAuthor" ) );
  d->itemGroupByPage = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "GroupByPage" ), d->groupByPage, true );
  addItem( d->itemGroupByPage, QStringLiteral( "GroupByPage" ) );
  d->itemFilterBookmarks = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "FilterBookmarks" ), d->filterBookmarks, false );
  addItem( d->itemFilterBookmarks, QStringLiteral( "FilterBookmarks" ) );
  d->itemSyncThumbnailsViewport = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SyncThumbnailsViewport" ), d->syncThumbnailsViewport, true );
  addItem( d->itemSyncThumbnailsViewport, QStringLiteral( "SyncThumbnailsViewport" ) );
  d->itemTocPageColumn = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "TocPageColumn" ), d->tocPageColumn, true );
  addItem( d->itemTocPageColumn, QStringLiteral( "TocPageColumn" ) );
  d->itemSidebarShowText = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SidebarShowText" ), d->sidebarShowText, true );
  addItem( d->itemSidebarShowText, QStringLiteral( "SidebarShowText" ) );
  d->itemSidebarIconSize = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "SidebarIconSize" ), d->sidebarIconSize, 48 );
  addItem( d->itemSidebarIconSize, QStringLiteral( "SidebarIconSize" ) );

  setCurrentGroup( QStringLiteral( "PageView" ) );

  d->itemEditToolBarPlacement = new SettingsCore::ItemInt( currentGroup(), QStringLiteral( "EditToolBarPlacement" ), d->editToolBarPlacement, 0 );
  addItem( d->itemEditToolBarPlacement, QStringLiteral( "EditToolBarPlacement" ) );
  d->itemSmoothScrolling = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SmoothScrolling" ), d->smoothScrolling, true );
  addItem( d->itemSmoothScrolling, QStringLiteral( "SmoothScrolling" ) );
  d->itemShowScrollBars = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowScrollBars" ), d->showScrollBars, true );
  addItem( d->itemShowScrollBars, QStringLiteral( "ShowScrollBars" ) );
  d->itemScrollOverlap = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "ScrollOverlap" ), d->scrollOverlap, 0 );
  d->itemScrollOverlap->setMinValue(0);
  d->itemScrollOverlap->setMaxValue(50);
  addItem( d->itemScrollOverlap, QStringLiteral( "ScrollOverlap" ) );
  d->itemViewColumns = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "ViewColumns" ), d->viewColumns, 3 );
  d->itemViewColumns->setMinValue(1);
  d->itemViewColumns->setMaxValue(8);
  addItem( d->itemViewColumns, QStringLiteral( "ViewColumns" ) );
  d->itemTrimMargins = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "TrimMargins" ), d->trimMargins, false );
  addItem( d->itemTrimMargins, QStringLiteral( "TrimMargins" ) );
  SettingsCore::ItemBool  *innerItemViewContinuous;
  innerItemViewContinuous = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ViewContinuous" ), d->viewContinuous, true );
  d->itemViewContinuous = new KConfigCompilerSignallingItem(innerItemViewContinuous, this, notifyFunction, signalViewContinuousChanged);
  addItem( d->itemViewContinuous, QStringLiteral( "ViewContinuous" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesPrimaryAnnotationToolBar;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("FullAnnotationToolBar");
    valuesPrimaryAnnotationToolBar.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("QuickAnnotationToolBar");
    valuesPrimaryAnnotationToolBar.append( choice );
  }
  SettingsCore::ItemEnum  *innerItemPrimaryAnnotationToolBar;
  innerItemPrimaryAnnotationToolBar = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "PrimaryAnnotationToolBar" ), d->primaryAnnotationToolBar, valuesPrimaryAnnotationToolBar, EnumPrimaryAnnotationToolBar::FullAnnotationToolBar );
  d->itemPrimaryAnnotationToolBar = new KConfigCompilerSignallingItem(innerItemPrimaryAnnotationToolBar, this, notifyFunction, signalPrimaryAnnotationToolBarChanged);
  addItem( d->itemPrimaryAnnotationToolBar, QStringLiteral( "PrimaryAnnotationToolBar" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesViewMode;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Single");
    valuesViewMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Facing");
    valuesViewMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("FacingFirstCentered");
    valuesViewMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Summary");
    valuesViewMode.append( choice );
  }
  d->itemViewMode = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "ViewMode" ), d->viewMode, valuesViewMode, EnumViewMode::Single );
  addItem( d->itemViewMode, QStringLiteral( "ViewMode" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesTrimMode;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("None");
    valuesTrimMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Margins");
    valuesTrimMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Selection");
    valuesTrimMode.append( choice );
  }
  d->itemTrimMode = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "TrimMode" ), d->trimMode, valuesTrimMode, EnumTrimMode::None );
  addItem( d->itemTrimMode, QStringLiteral( "TrimMode" ) );
  QList<SettingsCore::ItemEnum::Choice> valuesMouseMode;
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Browse");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Zoom");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("RectSelect");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TextSelect");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TableSelect");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Magnifier");
    valuesMouseMode.append( choice );
  }
  {
    SettingsCore::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TrimSelect");
    valuesMouseMode.append( choice );
  }
  d->itemMouseMode = new SettingsCore::ItemEnum( currentGroup(), QStringLiteral( "MouseMode" ), d->mouseMode, valuesMouseMode, EnumMouseMode::Browse );
  addItem( d->itemMouseMode, QStringLiteral( "MouseMode" ) );
  d->itemShowSourceLocationsGraphically = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "ShowSourceLocationsGraphically" ), d->showSourceLocationsGraphically, false );
  addItem( d->itemShowSourceLocationsGraphically, QStringLiteral( "ShowSourceLocationsGraphically" ) );
  d->itemUseCustomBackgroundColor = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "UseCustomBackgroundColor" ), d->useCustomBackgroundColor, false );
  addItem( d->itemUseCustomBackgroundColor, QStringLiteral( "UseCustomBackgroundColor" ) );
  d->itemBackgroundColor = new SettingsCore::ItemColor( currentGroup(), QStringLiteral( "BackgroundColor" ), d->backgroundColor );
  addItem( d->itemBackgroundColor, QStringLiteral( "BackgroundColor" ) );

  setCurrentGroup( QStringLiteral( "Search" ) );

  d->itemSearchCaseSensitive = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SearchCaseSensitive" ), d->searchCaseSensitive, false );
  addItem( d->itemSearchCaseSensitive, QStringLiteral( "SearchCaseSensitive" ) );
  d->itemSearchFromCurrentPage = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "SearchFromCurrentPage" ), d->searchFromCurrentPage, true );
  addItem( d->itemSearchFromCurrentPage, QStringLiteral( "SearchFromCurrentPage" ) );
  d->itemFindAsYouType = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "FindAsYouType" ), d->findAsYouType, true );
  addItem( d->itemFindAsYouType, QStringLiteral( "FindAsYouType" ) );

  setCurrentGroup( QStringLiteral( "Dlg Accessibility" ) );

  d->itemHighlightImages = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "HighlightImages" ), d->highlightImages, false );
  addItem( d->itemHighlightImages, QStringLiteral( "HighlightImages" ) );
  d->itemHighlightLinks = new SettingsCore::ItemBool( currentGroup(), QStringLiteral( "HighlightLinks" ), d->highlightLinks, false );
  addItem( d->itemHighlightLinks, QStringLiteral( "HighlightLinks" ) );
  SettingsCore::ItemColor  *innerItemRecolorForeground;
  innerItemRecolorForeground = new SettingsCore::ItemColor( currentGroup(), QStringLiteral( "RecolorForeground" ), d->recolorForeground, 0x600000 );
  d->itemRecolorForeground = new KConfigCompilerSignallingItem(innerItemRecolorForeground, this, notifyFunction, signalColorModesChanged2);
  addItem( d->itemRecolorForeground, QStringLiteral( "RecolorForeground" ) );
  SettingsCore::ItemColor  *innerItemRecolorBackground;
  innerItemRecolorBackground = new SettingsCore::ItemColor( currentGroup(), QStringLiteral( "RecolorBackground" ), d->recolorBackground, 0xF0F0F0 );
  d->itemRecolorBackground = new KConfigCompilerSignallingItem(innerItemRecolorBackground, this, notifyFunction, signalColorModesChanged2);
  addItem( d->itemRecolorBackground, QStringLiteral( "RecolorBackground" ) );
  SettingsCore::ItemUInt  *innerItemBWThreshold;
  innerItemBWThreshold = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "BWThreshold" ), d->bWThreshold, 127 );
  d->itemBWThreshold = new KConfigCompilerSignallingItem(innerItemBWThreshold, this, notifyFunction, signalColorModesChanged2);
  innerItemBWThreshold->setMinValue(2);
  innerItemBWThreshold->setMaxValue(253);
  addItem( d->itemBWThreshold, QStringLiteral( "BWThreshold" ) );
  SettingsCore::ItemUInt  *innerItemBWContrast;
  innerItemBWContrast = new SettingsCore::ItemUInt( currentGroup(), QStringLiteral( "BWContrast" ), d->bWContrast, 2 );
  d->itemBWContrast = new KConfigCompilerSignallingItem(innerItemBWContrast, this, notifyFunction, signalColorModesChanged2);
  innerItemBWContrast->setMinValue(2);
  innerItemBWContrast->setMaxValue(6);
  addItem( d->itemBWContrast, QStringLiteral( "BWContrast" ) );

  setCurrentGroup( QStringLiteral( "Identity" ) );


      KUser currentUser;
      QString userString = currentUser.property( KUser::FullName ).toString();
      if ( userString.isEmpty() )
      {
        userString = currentUser.loginName();
      }
    
  d->itemIdentityAuthor = new SettingsCore::ItemString( currentGroup(), QStringLiteral( "IdentityAuthor" ), d->identityAuthor, userString );
  addItem( d->itemIdentityAuthor, QStringLiteral( "IdentityAuthor" ) );
}

void Settings::setEnableCompositing( bool v )
{
    if (!self()->Settings::isEnableCompositingImmutable())
      self()->d->enableCompositing = v;
}

bool Settings::enableCompositing()
{
  return self()->d->enableCompositing;
}

bool  Settings::isEnableCompositingImmutable()
{
    return self()->isImmutable( QStringLiteral( "EnableCompositing" ) );
}


void Settings::setDebugDrawBoundaries( bool v )
{
    if (!self()->Settings::isDebugDrawBoundariesImmutable())
      self()->d->debugDrawBoundaries = v;
}

bool Settings::debugDrawBoundaries()
{
  return self()->d->debugDrawBoundaries;
}

bool  Settings::isDebugDrawBoundariesImmutable()
{
    return self()->isImmutable( QStringLiteral( "DebugDrawBoundaries" ) );
}


void Settings::setDebugDrawAnnotationRect( bool v )
{
    if (!self()->Settings::isDebugDrawAnnotationRectImmutable())
      self()->d->debugDrawAnnotationRect = v;
}

bool Settings::debugDrawAnnotationRect()
{
  return self()->d->debugDrawAnnotationRect;
}

bool  Settings::isDebugDrawAnnotationRectImmutable()
{
    return self()->isImmutable( QStringLiteral( "DebugDrawAnnotationRect" ) );
}


void Settings::setContentsSearchCaseSensitive( bool v )
{
    if (!self()->Settings::isContentsSearchCaseSensitiveImmutable())
      self()->d->contentsSearchCaseSensitive = v;
}

bool Settings::contentsSearchCaseSensitive()
{
  return self()->d->contentsSearchCaseSensitive;
}

bool  Settings::isContentsSearchCaseSensitiveImmutable()
{
    return self()->isImmutable( QStringLiteral( "ContentsSearchCaseSensitive" ) );
}


void Settings::setContentsSearchRegularExpression( bool v )
{
    if (!self()->Settings::isContentsSearchRegularExpressionImmutable())
      self()->d->contentsSearchRegularExpression = v;
}

bool Settings::contentsSearchRegularExpression()
{
  return self()->d->contentsSearchRegularExpression;
}

bool  Settings::isContentsSearchRegularExpressionImmutable()
{
    return self()->isImmutable( QStringLiteral( "ContentsSearchRegularExpression" ) );
}


void Settings::setLayersSearchCaseSensitive( bool v )
{
    if (!self()->Settings::isLayersSearchCaseSensitiveImmutable())
      self()->d->layersSearchCaseSensitive = v;
}

bool Settings::layersSearchCaseSensitive()
{
  return self()->d->layersSearchCaseSensitive;
}

bool  Settings::isLayersSearchCaseSensitiveImmutable()
{
    return self()->isImmutable( QStringLiteral( "LayersSearchCaseSensitive" ) );
}


void Settings::setLayersSearchRegularExpression( bool v )
{
    if (!self()->Settings::isLayersSearchRegularExpressionImmutable())
      self()->d->layersSearchRegularExpression = v;
}

bool Settings::layersSearchRegularExpression()
{
  return self()->d->layersSearchRegularExpression;
}

bool  Settings::isLayersSearchRegularExpressionImmutable()
{
    return self()->isImmutable( QStringLiteral( "LayersSearchRegularExpression" ) );
}


void Settings::setReviewsSearchCaseSensitive( bool v )
{
    if (!self()->Settings::isReviewsSearchCaseSensitiveImmutable())
      self()->d->reviewsSearchCaseSensitive = v;
}

bool Settings::reviewsSearchCaseSensitive()
{
  return self()->d->reviewsSearchCaseSensitive;
}

bool  Settings::isReviewsSearchCaseSensitiveImmutable()
{
    return self()->isImmutable( QStringLiteral( "ReviewsSearchCaseSensitive" ) );
}


void Settings::setReviewsSearchRegularExpression( bool v )
{
    if (!self()->Settings::isReviewsSearchRegularExpressionImmutable())
      self()->d->reviewsSearchRegularExpression = v;
}

bool Settings::reviewsSearchRegularExpression()
{
  return self()->d->reviewsSearchRegularExpression;
}

bool  Settings::isReviewsSearchRegularExpressionImmutable()
{
    return self()->isImmutable( QStringLiteral( "ReviewsSearchRegularExpression" ) );
}


void Settings::setDrawingTools( const QStringList & v )
{
    if (!self()->Settings::isDrawingToolsImmutable())
      self()->d->drawingTools = v;
}

QStringList Settings::drawingTools()
{
  return self()->d->drawingTools;
}

bool  Settings::isDrawingToolsImmutable()
{
    return self()->isImmutable( QStringLiteral( "DrawingTools" ) );
}


void Settings::setBuiltinAnnotationTools( const QStringList & v )
{
    if (v != self()->d->builtinAnnotationTools && !self()->Settings::isBuiltinAnnotationToolsImmutable()) {
      self()->d->builtinAnnotationTools = v;
      self()->d->settingsChanged |= signalBuiltinAnnotationToolsChanged;
    }
}

QStringList Settings::builtinAnnotationTools()
{
  return self()->d->builtinAnnotationTools;
}

bool  Settings::isBuiltinAnnotationToolsImmutable()
{
    return self()->isImmutable( QStringLiteral( "BuiltinAnnotationTools" ) );
}


void Settings::setQuickAnnotationTools( const QStringList & v )
{
    if (v != self()->d->quickAnnotationTools && !self()->Settings::isQuickAnnotationToolsImmutable()) {
      self()->d->quickAnnotationTools = v;
      self()->d->settingsChanged |= signalQuickAnnotationToolsChanged;
    }
}

QStringList Settings::quickAnnotationTools()
{
  return self()->d->quickAnnotationTools;
}

bool  Settings::isQuickAnnotationToolsImmutable()
{
    return self()->isImmutable( QStringLiteral( "QuickAnnotationTools" ) );
}


void Settings::setAnnotationContinuousMode( bool v )
{
    if (!self()->Settings::isAnnotationContinuousModeImmutable())
      self()->d->annotationContinuousMode = v;
}

bool Settings::annotationContinuousMode()
{
  return self()->d->annotationContinuousMode;
}

bool  Settings::isAnnotationContinuousModeImmutable()
{
    return self()->isImmutable( QStringLiteral( "AnnotationContinuousMode" ) );
}


void Settings::setQuickAnnotationDefaultAction( uint v )
{
    if (!self()->Settings::isQuickAnnotationDefaultActionImmutable())
      self()->d->quickAnnotationDefaultAction = v;
}

uint Settings::quickAnnotationDefaultAction()
{
  return self()->d->quickAnnotationDefaultAction;
}

bool  Settings::isQuickAnnotationDefaultActionImmutable()
{
    return self()->isImmutable( QStringLiteral( "QuickAnnotationDefaultAction" ) );
}


void Settings::setZoomMode( uint v )
{

    if (v > 3)
    {
      qDebug() << "setZoomMode: value " << v << " is greater than the maximum value of 3";
      v = 3;
    }

    if (!self()->Settings::isZoomModeImmutable())
      self()->d->zoomMode = v;
}

uint Settings::zoomMode()
{
  return self()->d->zoomMode;
}

bool  Settings::isZoomModeImmutable()
{
    return self()->isImmutable( QStringLiteral( "ZoomMode" ) );
}


void Settings::setShellOpenFileInTabs( bool v )
{
    if (!self()->Settings::isShellOpenFileInTabsImmutable())
      self()->d->shellOpenFileInTabs = v;
}

bool Settings::shellOpenFileInTabs()
{
  return self()->d->shellOpenFileInTabs;
}

bool  Settings::isShellOpenFileInTabsImmutable()
{
    return self()->isImmutable( QStringLiteral( "ShellOpenFileInTabs" ) );
}


void Settings::setSwitchToTabIfOpen( bool v )
{
    if (!self()->Settings::isSwitchToTabIfOpenImmutable())
      self()->d->switchToTabIfOpen = v;
}

bool Settings::switchToTabIfOpen()
{
  return self()->d->switchToTabIfOpen;
}

bool  Settings::isSwitchToTabIfOpenImmutable()
{
    return self()->isImmutable( QStringLiteral( "SwitchToTabIfOpen" ) );
}


void Settings::setShowOSD( bool v )
{
    if (!self()->Settings::isShowOSDImmutable())
      self()->d->showOSD = v;
}

bool Settings::showOSD()
{
  return self()->d->showOSD;
}

bool  Settings::isShowOSDImmutable()
{
    return self()->isImmutable( QStringLiteral( "ShowOSD" ) );
}


void Settings::setShowEmbeddedContentMessages( bool v )
{
    if (!self()->Settings::isShowEmbeddedContentMessagesImmutable())
      self()->d->showEmbeddedContentMessages = v;
}

bool Settings::showEmbeddedContentMessages()
{
  return self()->d->showEmbeddedContentMessages;
}

bool  Settings::isShowEmbeddedContentMessagesImmutable()
{
    return self()->isImmutable( QStringLiteral( "ShowEmbeddedContentMessages" ) );
}


void Settings::setDisplayDocumentTitle( bool v )
{
    if (!self()->Settings::isDisplayDocumentTitleImmutable())
      self()->d->displayDocumentTitle = v;
}

bool Settings::displayDocumentTitle()
{
  return self()->d->displayDocumentTitle;
}

bool  Settings::isDisplayDocumentTitleImmutable()
{
    return self()->isImmutable( QStringLiteral( "DisplayDocumentTitle" ) );
}


void Settings::setRtlReadingDirection( bool v )
{
    if (!self()->Settings::isRtlReadingDirectionImmutable())
      self()->d->rtlReadingDirection = v;
}

bool Settings::rtlReadingDirection()
{
  return self()->d->rtlReadingDirection;
}

bool  Settings::isRtlReadingDirectionImmutable()
{
    return self()->isImmutable( QStringLiteral( "rtlReadingDirection" ) );
}


void Settings::setDisplayDocumentNameOrPath( int v )
{
    if (!self()->Settings::isDisplayDocumentNameOrPathImmutable())
      self()->d->displayDocumentNameOrPath = v;
}

int Settings::displayDocumentNameOrPath()
{
  return self()->d->displayDocumentNameOrPath;
}

bool  Settings::isDisplayDocumentNameOrPathImmutable()
{
    return self()->isImmutable( QStringLiteral( "DisplayDocumentNameOrPath" ) );
}


void Settings::setUseTTS( bool v )
{
    if (!self()->Settings::isUseTTSImmutable())
      self()->d->useTTS = v;
}

bool Settings::useTTS()
{
  return self()->d->useTTS;
}

bool  Settings::isUseTTSImmutable()
{
    return self()->isImmutable( QStringLiteral( "UseTTS" ) );
}


void Settings::setTtsEngine( const QString & v )
{
    if (!self()->Settings::isTtsEngineImmutable())
      self()->d->ttsEngine = v;
}

QString Settings::ttsEngine()
{
  return self()->d->ttsEngine;
}

bool  Settings::isTtsEngineImmutable()
{
    return self()->isImmutable( QStringLiteral( "ttsEngine" ) );
}


void Settings::setWatchFile( bool v )
{
    if (!self()->Settings::isWatchFileImmutable())
      self()->d->watchFile = v;
}

bool Settings::watchFile()
{
  return self()->d->watchFile;
}

bool  Settings::isWatchFileImmutable()
{
    return self()->isImmutable( QStringLiteral( "WatchFile" ) );
}


void Settings::setSlidesBackgroundColor( const QColor & v )
{
    if (!self()->Settings::isSlidesBackgroundColorImmutable())
      self()->d->slidesBackgroundColor = v;
}

QColor Settings::slidesBackgroundColor()
{
  return self()->d->slidesBackgroundColor;
}

bool  Settings::isSlidesBackgroundColorImmutable()
{
    return self()->isImmutable( QStringLiteral( "SlidesBackgroundColor" ) );
}


void Settings::setSlidesTransition( int v )
{
    if (!self()->Settings::isSlidesTransitionImmutable())
      self()->d->slidesTransition = v;
}

int Settings::slidesTransition()
{
  return self()->d->slidesTransition;
}

bool  Settings::isSlidesTransitionImmutable()
{
    return self()->isImmutable( QStringLiteral( "SlidesTransition" ) );
}


void Settings::setSlidesCursor( int v )
{
    if (!self()->Settings::isSlidesCursorImmutable())
      self()->d->slidesCursor = v;
}

int Settings::slidesCursor()
{
  return self()->d->slidesCursor;
}

bool  Settings::isSlidesCursorImmutable()
{
    return self()->isImmutable( QStringLiteral( "SlidesCursor" ) );
}


void Settings::setSlidesShowProgress( bool v )
{
    if (!self()->Settings::isSlidesShowProgressImmutable())
      self()->d->slidesShowProgress = v;
}

bool Settings::slidesShowProgress()
{
  return self()->d->slidesShowProgress;
}

bool  Settings::isSlidesShowProgressImmutable()
{
    return self()->isImmutable( QStringLiteral( "SlidesShowProgress" ) );
}


void Settings::setSlidesShowSummary( bool v )
{
    if (!self()->Settings::isSlidesShowSummaryImmutable())
      self()->d->slidesShowSummary = v;
}

bool Settings::slidesShowSummary()
{
  return self()->d->slidesShowSummary;
}

bool  Settings::isSlidesShowSummaryImmutable()
{
    return self()->isImmutable( QStringLiteral( "SlidesShowSummary" ) );
}


void Settings::setSlidesScreen( int v )
{
    if (v < -2)
    {
      qDebug() << "setSlidesScreen: value " << v << " is less than the minimum value of -2";
      v = -2;
    }

    if (v > 20)
    {
      qDebug() << "setSlidesScreen: value " << v << " is greater than the maximum value of 20";
      v = 20;
    }

    if (!self()->Settings::isSlidesScreenImmutable())
      self()->d->slidesScreen = v;
}

int Settings::slidesScreen()
{
  return self()->d->slidesScreen;
}

bool  Settings::isSlidesScreenImmutable()
{
    return self()->isImmutable( QStringLiteral( "SlidesScreen" ) );
}


void Settings::setShowLeftPanel( bool v )
{
    if (!self()->Settings::isShowLeftPanelImmutable())
      self()->d->showLeftPanel = v;
}

bool Settings::showLeftPanel()
{
  return self()->d->showLeftPanel;
}

bool  Settings::isShowLeftPanelImmutable()
{
    return self()->isImmutable( QStringLiteral( "ShowLeftPanel" ) );
}


void Settings::setSplitterSizes( const QList<int> & v )
{
    if (!self()->Settings::isSplitterSizesImmutable())
      self()->d->splitterSizes = v;
}

QList<int> Settings::splitterSizes()
{
  return self()->d->splitterSizes;
}

bool  Settings::isSplitterSizesImmutable()
{
    return self()->isImmutable( QStringLiteral( "SplitterSizes" ) );
}


void Settings::setShowBottomBar( bool v )
{
    if (!self()->Settings::isShowBottomBarImmutable())
      self()->d->showBottomBar = v;
}

bool Settings::showBottomBar()
{
  return self()->d->showBottomBar;
}

bool  Settings::isShowBottomBarImmutable()
{
    return self()->isImmutable( QStringLiteral( "ShowBottomBar" ) );
}


void Settings::setCurrentPageOnly( bool v )
{
    if (!self()->Settings::isCurrentPageOnlyImmutable())
      self()->d->currentPageOnly = v;
}

bool Settings::currentPageOnly()
{
  return self()->d->currentPageOnly;
}

bool  Settings::isCurrentPageOnlyImmutable()
{
    return self()->isImmutable( QStringLiteral( "CurrentPageOnly" ) );
}


void Settings::setGroupByAuthor( bool v )
{
    if (!self()->Settings::isGroupByAuthorImmutable())
      self()->d->groupByAuthor = v;
}

bool Settings::groupByAuthor()
{
  return self()->d->groupByAuthor;
}

bool  Settings::isGroupByAuthorImmutable()
{
    return self()->isImmutable( QStringLiteral( "GroupByAuthor" ) );
}


void Settings::setGroupByPage( bool v )
{
    if (!self()->Settings::isGroupByPageImmutable())
      self()->d->groupByPage = v;
}

bool Settings::groupByPage()
{
  return self()->d->groupByPage;
}

bool  Settings::isGroupByPageImmutable()
{
    return self()->isImmutable( QStringLiteral( "GroupByPage" ) );
}


void Settings::setFilterBookmarks( bool v )
{
    if (!self()->Settings::isFilterBookmarksImmutable())
      self()->d->filterBookmarks = v;
}

bool Settings::filterBookmarks()
{
  return self()->d->filterBookmarks;
}

bool  Settings::isFilterBookmarksImmutable()
{
    return self()->isImmutable( QStringLiteral( "FilterBookmarks" ) );
}


void Settings::setSyncThumbnailsViewport( bool v )
{
    if (!self()->Settings::isSyncThumbnailsViewportImmutable())
      self()->d->syncThumbnailsViewport = v;
}

bool Settings::syncThumbnailsViewport()
{
  return self()->d->syncThumbnailsViewport;
}

bool  Settings::isSyncThumbnailsViewportImmutable()
{
    return self()->isImmutable( QStringLiteral( "SyncThumbnailsViewport" ) );
}


void Settings::setTocPageColumn( bool v )
{
    if (!self()->Settings::isTocPageColumnImmutable())
      self()->d->tocPageColumn = v;
}

bool Settings::tocPageColumn()
{
  return self()->d->tocPageColumn;
}

bool  Settings::isTocPageColumnImmutable()
{
    return self()->isImmutable( QStringLiteral( "TocPageColumn" ) );
}


void Settings::setSidebarShowText( bool v )
{
    if (!self()->Settings::isSidebarShowTextImmutable())
      self()->d->sidebarShowText = v;
}

bool Settings::sidebarShowText()
{
  return self()->d->sidebarShowText;
}

bool  Settings::isSidebarShowTextImmutable()
{
    return self()->isImmutable( QStringLiteral( "SidebarShowText" ) );
}


void Settings::setSidebarIconSize( uint v )
{
    if (!self()->Settings::isSidebarIconSizeImmutable())
      self()->d->sidebarIconSize = v;
}

uint Settings::sidebarIconSize()
{
  return self()->d->sidebarIconSize;
}

bool  Settings::isSidebarIconSizeImmutable()
{
    return self()->isImmutable( QStringLiteral( "SidebarIconSize" ) );
}


void Settings::setEditToolBarPlacement( int v )
{
    if (!self()->Settings::isEditToolBarPlacementImmutable())
      self()->d->editToolBarPlacement = v;
}

int Settings::editToolBarPlacement()
{
  return self()->d->editToolBarPlacement;
}

bool  Settings::isEditToolBarPlacementImmutable()
{
    return self()->isImmutable( QStringLiteral( "EditToolBarPlacement" ) );
}


void Settings::setSmoothScrolling( bool v )
{
    if (!self()->Settings::isSmoothScrollingImmutable())
      self()->d->smoothScrolling = v;
}

bool Settings::smoothScrolling()
{
  return self()->d->smoothScrolling;
}

bool  Settings::isSmoothScrollingImmutable()
{
    return self()->isImmutable( QStringLiteral( "SmoothScrolling" ) );
}


void Settings::setShowScrollBars( bool v )
{
    if (!self()->Settings::isShowScrollBarsImmutable())
      self()->d->showScrollBars = v;
}

bool Settings::showScrollBars()
{
  return self()->d->showScrollBars;
}

bool  Settings::isShowScrollBarsImmutable()
{
    return self()->isImmutable( QStringLiteral( "ShowScrollBars" ) );
}


void Settings::setScrollOverlap( uint v )
{

    if (v > 50)
    {
      qDebug() << "setScrollOverlap: value " << v << " is greater than the maximum value of 50";
      v = 50;
    }

    if (!self()->Settings::isScrollOverlapImmutable())
      self()->d->scrollOverlap = v;
}

uint Settings::scrollOverlap()
{
  return self()->d->scrollOverlap;
}

bool  Settings::isScrollOverlapImmutable()
{
    return self()->isImmutable( QStringLiteral( "ScrollOverlap" ) );
}


void Settings::setViewColumns( uint v )
{
    if (v < 1)
    {
      qDebug() << "setViewColumns: value " << v << " is less than the minimum value of 1";
      v = 1;
    }

    if (v > 8)
    {
      qDebug() << "setViewColumns: value " << v << " is greater than the maximum value of 8";
      v = 8;
    }

    if (!self()->Settings::isViewColumnsImmutable())
      self()->d->viewColumns = v;
}

uint Settings::viewColumns()
{
  return self()->d->viewColumns;
}

bool  Settings::isViewColumnsImmutable()
{
    return self()->isImmutable( QStringLiteral( "ViewColumns" ) );
}


void Settings::setTrimMargins( bool v )
{
    if (!self()->Settings::isTrimMarginsImmutable())
      self()->d->trimMargins = v;
}

bool Settings::trimMargins()
{
  return self()->d->trimMargins;
}

bool  Settings::isTrimMarginsImmutable()
{
    return self()->isImmutable( QStringLiteral( "TrimMargins" ) );
}


void Settings::setViewContinuous( bool v )
{
    if (v != self()->d->viewContinuous && !self()->Settings::isViewContinuousImmutable()) {
      self()->d->viewContinuous = v;
      self()->d->settingsChanged |= signalViewContinuousChanged;
    }
}

bool Settings::viewContinuous()
{
  return self()->d->viewContinuous;
}

bool  Settings::isViewContinuousImmutable()
{
    return self()->isImmutable( QStringLiteral( "ViewContinuous" ) );
}


void Settings::setPrimaryAnnotationToolBar( int v )
{
    if (v != self()->d->primaryAnnotationToolBar && !self()->Settings::isPrimaryAnnotationToolBarImmutable()) {
      self()->d->primaryAnnotationToolBar = v;
      self()->d->settingsChanged |= signalPrimaryAnnotationToolBarChanged;
    }
}

int Settings::primaryAnnotationToolBar()
{
  return self()->d->primaryAnnotationToolBar;
}

bool  Settings::isPrimaryAnnotationToolBarImmutable()
{
    return self()->isImmutable( QStringLiteral( "PrimaryAnnotationToolBar" ) );
}


void Settings::setViewMode( int v )
{
    if (!self()->Settings::isViewModeImmutable())
      self()->d->viewMode = v;
}

int Settings::viewMode()
{
  return self()->d->viewMode;
}

bool  Settings::isViewModeImmutable()
{
    return self()->isImmutable( QStringLiteral( "ViewMode" ) );
}


void Settings::setTrimMode( int v )
{
    if (!self()->Settings::isTrimModeImmutable())
      self()->d->trimMode = v;
}

int Settings::trimMode()
{
  return self()->d->trimMode;
}

bool  Settings::isTrimModeImmutable()
{
    return self()->isImmutable( QStringLiteral( "TrimMode" ) );
}


void Settings::setMouseMode( int v )
{
    if (!self()->Settings::isMouseModeImmutable())
      self()->d->mouseMode = v;
}

int Settings::mouseMode()
{
  return self()->d->mouseMode;
}

bool  Settings::isMouseModeImmutable()
{
    return self()->isImmutable( QStringLiteral( "MouseMode" ) );
}


void Settings::setShowSourceLocationsGraphically( bool v )
{
    if (!self()->Settings::isShowSourceLocationsGraphicallyImmutable())
      self()->d->showSourceLocationsGraphically = v;
}

bool Settings::showSourceLocationsGraphically()
{
  return self()->d->showSourceLocationsGraphically;
}

bool  Settings::isShowSourceLocationsGraphicallyImmutable()
{
    return self()->isImmutable( QStringLiteral( "ShowSourceLocationsGraphically" ) );
}


void Settings::setUseCustomBackgroundColor( bool v )
{
    if (!self()->Settings::isUseCustomBackgroundColorImmutable())
      self()->d->useCustomBackgroundColor = v;
}

bool Settings::useCustomBackgroundColor()
{
  return self()->d->useCustomBackgroundColor;
}

bool  Settings::isUseCustomBackgroundColorImmutable()
{
    return self()->isImmutable( QStringLiteral( "UseCustomBackgroundColor" ) );
}


void Settings::setBackgroundColor( const QColor & v )
{
    if (!self()->Settings::isBackgroundColorImmutable())
      self()->d->backgroundColor = v;
}

QColor Settings::backgroundColor()
{
  return self()->d->backgroundColor;
}

bool  Settings::isBackgroundColorImmutable()
{
    return self()->isImmutable( QStringLiteral( "BackgroundColor" ) );
}


void Settings::setSearchCaseSensitive( bool v )
{
    if (!self()->Settings::isSearchCaseSensitiveImmutable())
      self()->d->searchCaseSensitive = v;
}

bool Settings::searchCaseSensitive()
{
  return self()->d->searchCaseSensitive;
}

bool  Settings::isSearchCaseSensitiveImmutable()
{
    return self()->isImmutable( QStringLiteral( "SearchCaseSensitive" ) );
}


void Settings::setSearchFromCurrentPage( bool v )
{
    if (!self()->Settings::isSearchFromCurrentPageImmutable())
      self()->d->searchFromCurrentPage = v;
}

bool Settings::searchFromCurrentPage()
{
  return self()->d->searchFromCurrentPage;
}

bool  Settings::isSearchFromCurrentPageImmutable()
{
    return self()->isImmutable( QStringLiteral( "SearchFromCurrentPage" ) );
}


void Settings::setFindAsYouType( bool v )
{
    if (!self()->Settings::isFindAsYouTypeImmutable())
      self()->d->findAsYouType = v;
}

bool Settings::findAsYouType()
{
  return self()->d->findAsYouType;
}

bool  Settings::isFindAsYouTypeImmutable()
{
    return self()->isImmutable( QStringLiteral( "FindAsYouType" ) );
}


void Settings::setHighlightImages( bool v )
{
    if (!self()->Settings::isHighlightImagesImmutable())
      self()->d->highlightImages = v;
}

bool Settings::highlightImages()
{
  return self()->d->highlightImages;
}

bool  Settings::isHighlightImagesImmutable()
{
    return self()->isImmutable( QStringLiteral( "HighlightImages" ) );
}


void Settings::setHighlightLinks( bool v )
{
    if (!self()->Settings::isHighlightLinksImmutable())
      self()->d->highlightLinks = v;
}

bool Settings::highlightLinks()
{
  return self()->d->highlightLinks;
}

bool  Settings::isHighlightLinksImmutable()
{
    return self()->isImmutable( QStringLiteral( "HighlightLinks" ) );
}


void Settings::setRecolorForeground( const QColor & v )
{
    if (v != self()->d->recolorForeground && !self()->Settings::isRecolorForegroundImmutable()) {
      self()->d->recolorForeground = v;
      self()->d->settingsChanged |= signalColorModesChanged2;
    }
}

QColor Settings::recolorForeground()
{
  return self()->d->recolorForeground;
}

bool  Settings::isRecolorForegroundImmutable()
{
    return self()->isImmutable( QStringLiteral( "RecolorForeground" ) );
}


void Settings::setRecolorBackground( const QColor & v )
{
    if (v != self()->d->recolorBackground && !self()->Settings::isRecolorBackgroundImmutable()) {
      self()->d->recolorBackground = v;
      self()->d->settingsChanged |= signalColorModesChanged2;
    }
}

QColor Settings::recolorBackground()
{
  return self()->d->recolorBackground;
}

bool  Settings::isRecolorBackgroundImmutable()
{
    return self()->isImmutable( QStringLiteral( "RecolorBackground" ) );
}


void Settings::setBWThreshold( uint v )
{
    if (v < 2)
    {
      qDebug() << "setBWThreshold: value " << v << " is less than the minimum value of 2";
      v = 2;
    }

    if (v > 253)
    {
      qDebug() << "setBWThreshold: value " << v << " is greater than the maximum value of 253";
      v = 253;
    }

    if (v != self()->d->bWThreshold && !self()->Settings::isBWThresholdImmutable()) {
      self()->d->bWThreshold = v;
      self()->d->settingsChanged |= signalColorModesChanged2;
    }
}

uint Settings::bWThreshold()
{
  return self()->d->bWThreshold;
}

bool  Settings::isBWThresholdImmutable()
{
    return self()->isImmutable( QStringLiteral( "BWThreshold" ) );
}


void Settings::setBWContrast( uint v )
{
    if (v < 2)
    {
      qDebug() << "setBWContrast: value " << v << " is less than the minimum value of 2";
      v = 2;
    }

    if (v > 6)
    {
      qDebug() << "setBWContrast: value " << v << " is greater than the maximum value of 6";
      v = 6;
    }

    if (v != self()->d->bWContrast && !self()->Settings::isBWContrastImmutable()) {
      self()->d->bWContrast = v;
      self()->d->settingsChanged |= signalColorModesChanged2;
    }
}

uint Settings::bWContrast()
{
  return self()->d->bWContrast;
}

bool  Settings::isBWContrastImmutable()
{
    return self()->isImmutable( QStringLiteral( "BWContrast" ) );
}


void Settings::setIdentityAuthor( const QString & v )
{
    if (!self()->Settings::isIdentityAuthorImmutable())
      self()->d->identityAuthor = v;
}

QString Settings::identityAuthor()
{
  return self()->d->identityAuthor;
}

bool  Settings::isIdentityAuthorImmutable()
{
    return self()->isImmutable( QStringLiteral( "IdentityAuthor" ) );
}


Settings::~Settings()
{
  delete d;
  s_globalSettings()->q = nullptr;
}

bool Settings::usrSave()
{
  const bool res = SettingsCore::usrSave();
  if (!res) return false;

  if ( d->settingsChanged & signalBuiltinAnnotationToolsChanged )
    Q_EMIT builtinAnnotationToolsChanged();
  if ( d->settingsChanged & signalQuickAnnotationToolsChanged )
    Q_EMIT quickAnnotationToolsChanged();
  if ( d->settingsChanged & signalViewContinuousChanged )
    Q_EMIT viewContinuousChanged();
  if ( d->settingsChanged & signalColorModesChanged2 )
    Q_EMIT colorModesChanged2();
  if ( d->settingsChanged & signalPrimaryAnnotationToolBarChanged )
    Q_EMIT primaryAnnotationToolBarChanged();
  d->settingsChanged = 0;
  return true;
}

void Settings::itemChanged(quint64 flags) {
  d->settingsChanged |= flags;

}

#include "settings.moc"

