from typing import Any

CODE_INDENT: int
reHtmlBlockOpen: Any
reHtmlBlockClose: Any
reThematicBreak: Any
reMaybeSpecial: Any
reNonSpace: Any
reBulletListMarker: Any
reOrderedListMarker: Any
reATXHeadingMarker: Any
reCodeFence: Any
reClosingCodeFence: Any
reSetextHeadingLine: Any
reLineEnding: Any

def is_blank(s): ...
def is_space_or_tab(s): ...
def peek(ln, pos): ...
def ends_with_blank_line(block): ...
def parse_list_marker(parser, container): ...
def lists_match(list_data, item_data): ...

class Block:
    accepts_lines: Any
    @staticmethod
    def continue_(parser: Any | None = ..., container: Any | None = ...) -> None: ...
    @staticmethod
    def finalize(parser: Any | None = ..., block: Any | None = ...) -> None: ...
    @staticmethod
    def can_contain(t) -> None: ...

class Document(Block):
    accepts_lines: bool
    @staticmethod
    def continue_(parser: Any | None = ..., container: Any | None = ...): ...
    @staticmethod
    def finalize(parser: Any | None = ..., block: Any | None = ...) -> None: ...
    @staticmethod
    def can_contain(t): ...

class List(Block):
    accepts_lines: bool
    @staticmethod
    def continue_(parser: Any | None = ..., container: Any | None = ...): ...
    @staticmethod
    def finalize(parser: Any | None = ..., block: Any | None = ...) -> None: ...
    @staticmethod
    def can_contain(t): ...

class BlockQuote(Block):
    accepts_lines: bool
    @staticmethod
    def continue_(parser: Any | None = ..., container: Any | None = ...): ...
    @staticmethod
    def finalize(parser: Any | None = ..., block: Any | None = ...) -> None: ...
    @staticmethod
    def can_contain(t): ...

class Item(Block):
    accepts_lines: bool
    @staticmethod
    def continue_(parser: Any | None = ..., container: Any | None = ...): ...
    @staticmethod
    def finalize(parser: Any | None = ..., block: Any | None = ...) -> None: ...
    @staticmethod
    def can_contain(t): ...

class Heading(Block):
    accepts_lines: bool
    @staticmethod
    def continue_(parser: Any | None = ..., container: Any | None = ...): ...
    @staticmethod
    def finalize(parser: Any | None = ..., block: Any | None = ...) -> None: ...
    @staticmethod
    def can_contain(t): ...

class ThematicBreak(Block):
    accepts_lines: bool
    @staticmethod
    def continue_(parser: Any | None = ..., container: Any | None = ...): ...
    @staticmethod
    def finalize(parser: Any | None = ..., block: Any | None = ...) -> None: ...
    @staticmethod
    def can_contain(t): ...

class CodeBlock(Block):
    accepts_lines: bool
    @staticmethod
    def continue_(parser: Any | None = ..., container: Any | None = ...): ...
    @staticmethod
    def finalize(parser: Any | None = ..., block: Any | None = ...) -> None: ...
    @staticmethod
    def can_contain(t): ...

class HtmlBlock(Block):
    accepts_lines: bool
    @staticmethod
    def continue_(parser: Any | None = ..., container: Any | None = ...): ...
    @staticmethod
    def finalize(parser: Any | None = ..., block: Any | None = ...) -> None: ...
    @staticmethod
    def can_contain(t): ...

class Paragraph(Block):
    accepts_lines: bool
    @staticmethod
    def continue_(parser: Any | None = ..., container: Any | None = ...): ...
    @staticmethod
    def finalize(parser: Any | None = ..., block: Any | None = ...) -> None: ...
    @staticmethod
    def can_contain(t): ...

class BlockStarts:
    METHODS: Any
    @staticmethod
    def block_quote(parser, container: Any | None = ...): ...
    @staticmethod
    def atx_heading(parser, container: Any | None = ...): ...
    @staticmethod
    def fenced_code_block(parser, container: Any | None = ...): ...
    @staticmethod
    def html_block(parser, container: Any | None = ...): ...
    @staticmethod
    def setext_heading(parser, container: Any | None = ...): ...
    @staticmethod
    def thematic_break(parser, container: Any | None = ...): ...
    @staticmethod
    def list_item(parser, container: Any | None = ...): ...
    @staticmethod
    def indented_code_block(parser, container: Any | None = ...): ...

class Parser:
    doc: Any
    block_starts: Any
    tip: Any
    oldtip: Any
    current_line: str
    line_number: int
    offset: int
    column: int
    next_nonspace: int
    next_nonspace_column: int
    indent: int
    indented: bool
    blank: bool
    partially_consumed_tab: bool
    all_closed: bool
    last_matched_container: Any
    refmap: Any
    last_line_length: int
    inline_parser: Any
    options: Any
    def __init__(self, options=...) -> None: ...
    def add_line(self) -> None: ...
    def add_child(self, tag, offset): ...
    def close_unmatched_blocks(self) -> None: ...
    def find_next_nonspace(self) -> None: ...
    def advance_next_nonspace(self) -> None: ...
    def advance_offset(self, count, columns) -> None: ...
    def incorporate_line(self, ln) -> None: ...
    def finalize(self, block, line_number) -> None: ...
    def process_inlines(self, block) -> None: ...
    def parse(self, my_input): ...

CAMEL_RE: Any
