from collections import OrderedDict

from .. import Provider as ColorProvider

localized = True


class Provider(ColorProvider):
    """Implement color provider for ``bg_BG`` locale."""

    all_colors = OrderedDict((
        ("Антично-бяло", "#FAEBD7"),
        ("Аквамарин", "#7FFFD4"),
        ("Лазурно", "#F0FFFF"),
        ("Бежово", "#F5F5DC"),
        ("Черно", "#000000"),
        ("Синьо", "#0000FF"),
        ("Синьо-виолетовo", "#8A2BE2"),
        ("Кафявo", "#A52A2A"),
        ("Шоколадовo", "#D2691E"),
        ("Корал", "#FF7F50"),
        ("Метличино синьо", "#6495ED"),
        ("Малиново", "#DC143C"),
        ("Тъмносиньо", "#00008B"),
        ("Тъмноциан", "#008B8B"),
        ("Тъмносуво", "#A9A9A9"),
        ("Тъмнозелено", "#006400"),
        ("Тъмно маслинено зелено", "#BDB76B"),
        ("Тъмнооранжево", "#FF8C00"),
        ("Тъмночервено", "#8B0000"),
        ("Тъмнотюркоазено", "#00CED1"),
        ("Тъмновиолетово", "#9400D3"),
        ("Тъмнорозово", "#FF1493"),
        ("Бледо сиво", "#696969"),
        ("Фуксия", "#FF00FF"),
        ("Златно", "#FFD700"),
        ("Сребърно", "#808080"),
        ("Зелено", "#008000"),
        ("Жълто-зелено", "#ADFF2F"),
        ("Ярко-розово", "#FF69B4"),
        ("Индиго", "#4B0082"),
        ("Слонова кост", "#FFFFF0"),
        ("Маслинено зелено", "#F0E68C"),
        ("Розовато-лавандулово", "#FFF0F5"),
        ("Светлосиньо", "#ADD8E6"),
        ("Светло-небесносино", "#E0FFFF"),
        ("Светлосиво", "#D3D3D3"),
        ("Светлозелено", "#90EE90"),
        ("Светлорозово", "#FFB6C1"),
        ("Небесносиньо", "#87CEFA"),
        ("Светложълто", "#FFFFE0"),
        ("Кестеняво", "#800000"),
        ("Оранжево", "#FFA500"),
        ("Оранжево-червено", "#FF4500"),
        ("Бледозелено", "#98FB98"),
        ("Бледотюркоазно", "#AFEEEE"),
        ("Розово", "#FFC0CB"),
        ("Сливово розово", "#DDA0DD"),
        ("Пурпурно", "#800080"),
        ("Червено", "#FF0000"),
        ("Циан", "#2E8B57"),
        ("Сребърно", "#C0C0C0"),
        ("Тюркоазено", "#40E0D0"),
        ("Виолетово", "#EE82EE"),
        ("Бяло", "#FFFFFF"),
        ("Жълто", "#FFFF00"),
        ("Жълто-зелено", "#9ACD32"),
    ))

    safe_colors = (
        'черно', 'бордо', 'зелено', 'маслинено зелено',
        'пурпурно', 'циан', 'лайм', 'синьо', 'сребърно',
        'сиво', 'жълто', 'фуксия', 'бяло',
    )
