%%
%% This is file `njuthesis.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% njuthesis.dtx  (with options: `class')
%% 
%% Copyright (C) 2021
%% by Nanjing University Linux User Group <nju.lug@yaoge123.cn>
%% 
%% This file may be distributed and/or modified under the conditions of
%% the LaTeX Project Public License, either version 1.3c of this license
%% or (at your option) any later version.  The latest version of this
%% license is in:
%% 
%%    http://www.latex-project.org/lppl.txt
%% 
%% and version 1.3 or later is part of all distributions of LaTeX version
%% 2005/12/01 or later.
%% 
%% To produce the documentation run the original source files ending with `.dtx'
%% through XeTeX.
%% 
\NeedsTeXFormat{LaTeX2e}
\RequirePackage{expl3}
\GetIdInfo  $Id: njuthesis.dtx 0.13.0 2021-12-13 16:30:00 +0800  NJU LUG <nju.lug@yaoge123.cn> $
  { Thesis template for Nanjing University }
\ProvidesExplClass{njuthesis}
{\ExplFileDate}{\ExplFileVersion}{\ExplFileDescription}
\RequirePackage { xtemplate, l3keys2e }
\msg_new:nnn { njuthesis } { l3-too-old }
  {
    Package~ "#1"~ is~ too~ old. \\
    Please~ update~ an~ up-to-date~ version~ of~
    the~ bundles "l3kernel"~ and~ "l3packages"~
    using~ your~ TeX~ package~ manager~ or~ from~ \\
    CTAN.
  }
\clist_map_inline:nn { xtemplate, l3keys2e }
  {
    \@ifpackagelater {#1} { 2020/10/01 }
      { } { \msg_error:nnn { njuthesis } { l3-too-old } {#1} }
  }

\msg_new:nnn { njuthesis } { unsupported-engine }
  {
    The~ njuthesis~ class~ requires~ either~
    XeTeX~ or~ LuaTeX. \\
    "#1"~ is~ not~ supported~ at~ present.~
    You~ must~ change your~ typesetting~ engine~
    to~ "xelatex"~ or~ "lualatex".
  }
\sys_if_engine_xetex:F
  {
    \sys_if_engine_luatex:F
      {
        \msg_fatal:nnx { njuthesis } { unsupported-engine }
          { \c_sys_engine_str }
      }
  }
\box_new:N   \l__nju_tmp_box
\clist_new:N \l__nju_tmp_clist
\dim_new:N   \l__nju_tmp_dim
\int_new:N   \l__nju_tmp_int
\seq_new:N   \l__nju_tmp_seq
\tl_new:N    \l__nju_tmp_tl
\clist_const:Nn \c__nju_name_type_clist
  { 毕业论文, 毕业设计 }
\clist_const:Nn \c__nju_name_type_en_clist
  { THESIS, DESIGN }
\clist_const:Nn \c__nju_name_degree_clist
  { 学士, 硕士, 硕士专业, 博士 }
\clist_const:Nn \c__nju_name_degree_en_clist
  { Bachelor, Master, Master, Doctor~of~Philosophy }
\int_new:N \l__nju_info_degree_int
\tl_new:N  \l__nju_info_degree_tl
\int_new:N \l__nju_info_diploma_int
\tl_new:N  \l__nju_info_diploma_tl
\int_new:N \l__nju_info_type_int
\tl_new:N  \l__nju_info_type_tl
\bool_new:N \l__nju_second_supv_bool
\tl_new:N \l__nju_info_supv_full_tl
\tl_new:N \l__nju_info_supv_full_en_tl
\bool_new:N \g__nju_load_sys_font_bool
\tl_new:N \g__nju_latin_font_tl
\tl_new:N \g__nju_cjk_font_tl
\cs_new:Nn \__nju_quad:  { \skip_horizontal:n { 1 em } }
\cs_new:Nn \__nju_qquad: { \skip_horizontal:n { 2 em } }
\cs_new:Nn \__nju_vskip: { \skip_vertical:n   { 1   ex } }
\cs_new:Nn \__nju_hskip: { \skip_horizontal:n { 0.3 em } }
\cs_new_protected:Npn \__nju_define_name:nn #1#2
  { \tl_const:cn { c__nju_name_ #1    _tl } {#2} }
\cs_new_protected:Npn \__nju_define_name:nnn #1#2#3
  {
    \tl_const:cn { c__nju_name_ #1    _tl } {#2}
    \tl_const:cn { c__nju_name_ #1 _en_tl } {#3}
  }
\cs_new:Npn \__nju_name:n #1 { \tl_use:c { c__nju_name_ #1 _tl } }
\cs_new:Npn \__nju_info:n #1 { \tl_use:c { l__nju_info_ #1 _tl } }
\cs_new_protected:Npn \__nju_ulined_center_box:nn #1#2
  {
    \mode_leave_vertical:
    \rule [ -0.5 ex ] { #1 } { 0.4 pt }
    \skip_horizontal:n { -#1 }
    \hbox_to_wd:nn {#1} { \hfil #2 \hfil }
  }
\cs_generate_variant:Nn \tl_map_inline:nn { xn }
\cs_new_protected:Npn \__nju_spread_box:nnn #1#2#3
  {
    \mode_leave_vertical:
    \hbox_to_wd:nn {#1}
      { #2 \tl_map_inline:xn {#3} { ##1 \hfil } \unskip }
  }
\cs_new_protected:Npn \__nju_multiline_box:nnnn #1#2#3#4
  {
    \int_set:Nn #1 { 1 }
    \int_do_until:nn { #1 > #3 }
      {
        \__nju_ulined_center_box:nn { #4 }
          { \clist_item:Nn #2 { #1 } } \\
        \int_incr:N #1
      }
  }
\cs_new_protected:Npn \__nju_put_inempty_seg:nnn #1#2#3
  {
    \tl_set:Nx \l__nju_tmp_tl { \tl_range:Nnn { #1 } { #2 } { #2 + #3 - 1 } }
    \tl_if_empty:NF \l__nju_tmp_tl { \clist_put_right:NV \l__nju_tmp_clist { \l__nju_tmp_tl } }
  }
\cs_new_protected:Npn \__nju_uline:n #1
  {
    \mode_leave_vertical:
    \rule [ -0.5 ex ] { #1 } { 0.4 pt }
    \skip_horizontal:n { -#1 }
  }
\cs_new_protected:Npn \__nju_uuline:n #1
  {
    \mode_leave_vertical:
    \rule [ -0.5 ex ] { #1 } { 0.4 pt }
    \skip_horizontal:n { -#1 }
    \rule [ -0.6 ex ] { #1 } { 0.4 pt }
    \skip_horizontal:n { -#1 }
  }
\cs_new:Npn \__nju_get_text_width:Nn #1#2
  {
    \hbox_set:Nn \l__nju_tmp_box {#2}
    \dim_set:Nn #1 { \box_wd:N \l__nju_tmp_box }
  }
\cs_generate_variant:Nn \__nju_get_text_width:Nn { NV }
\cs_new_protected:Npn \__nju_full_uline:Nn #1#2
  {
    \__nju_get_text_width:Nn #1 { #2 }
    \dim_set:Nn #1 { \textwidth - #1 } #2
  }
\cs_generate_variant:Nn \__nju_full_uline:Nn { NV }
\cs_new_protected:Npn \__nju_uline_entry:nnnn #1#2#3#4
  {
    \__nju_full_uline:NV #1 { \__nju_name:n { #2 } #4 }
    \__nju_ulined_center_box:nn { #1 } { \__nju_info:n { #3 } }
  }
\cs_new_protected:Npn \__nju_uline_bientry:nnnn #1#2#3#4
  {
    \__nju_full_uline:NV #1 { \__nju_name:n { #2 } #4 }
    \dim_sub:Nn #1 { \textwidth / 2 }
    \__nju_ulined_center_box:nn { #1 } { \__nju_info:n { #3 } }
  }
\keys_define:nn { nju }
  {
    degree     .choices:nn   = { ug, mg, mf, phd }
      { \int_set_eq:NN \l__nju_info_degree_int \l_keys_choice_int
        \tl_set:Nn \l__nju_info_degree_tl
          { \clist_item:Nn \c__nju_name_degree_clist { \l__nju_info_degree_int } }
        \int_compare:nTF { \l__nju_info_degree_int == 1 }
          { \tl_set:Nn \l__nju_info_diploma_tl { ug } }
          { \tl_set:Nn \l__nju_info_diploma_tl { g  } } },
    degree     .initial:n    = ug,
    type       .choices:nn   = { thesis, design }
      { \int_set_eq:NN \l__nju_info_type_int \l_keys_choice_int
        \tl_set:Nn \l__nju_info_type_tl
          { \clist_item:Nn \c__nju_name_type_clist { \l__nju_info_type_int } }
        \tl_put_left:Nn \l__nju_info_type_tl
          { \tl_use:c { c__nju_name_ \l__nju_info_diploma_tl _tl } } },
    type       .initial:n    = thesis,
    nlcover           .bool_set:N   = \g__nju_nlcover_bool,
    nlcover           .initial:n    = false,
    latin-font .choices:nn   =
    { gyre, mac, win, none }
    { \tl_set_eq:NN \g__nju_latin_font_tl \l_keys_choice_tl },
    cjk-font   .choices:nn   =
    { fandol, founder, mac, noto, win, none }
    { \tl_set_eq:NN \g__nju_cjk_font_tl   \l_keys_choice_tl },
  }
\ProcessKeysOptions { nju }
\clist_map_inline:nn
  {
    { id          } { 学号                          },
    { orig_decl   } { 学位论文原创性声明            },
    { pdf_creator } { LaTeX~ with~ njuthesis~ class },
    { supv_ii     } { 第二导师                      },
    { supv_ttl    } { 职称                          }
  }
  { \__nju_define_name:nn #1 }
\clist_map_inline:nn
  {
    { abstract  } { 摘要     } { ABSTRACT            },
    { appendix  } { 附录     } { appendix            },
    { dept      } { 院系     } { DEPARTMENT          },
    { figure    } { 图       } { figure              },
    { keywords  } { 关键词： } { Keywords:~          },
    { lang      } { 中文     } { 英文                },
    { nju       } { 南京大学 } { Nanjing~ University },
    { table     } { 表       } { table               }
  }
  { \__nju_define_name:nnn #1 }
\int_compare:nTF { \l__nju_info_degree_int == 1 }
  {
    \clist_map_inline:nn
      {
        { author_full } { 本科生姓名                  },
        { grade       } { 年级                        },
        { sm_date     } { 提交日期                    },
        { supv        } { 导师                        },
        { title       } { 题目                        },
        { type        } { 本科生毕业论文（设计、作品）},
        { ug          } { 本科                        }
      }
      { \__nju_define_name:nn #1 }
      \clist_map_inline:nn
        {
          { author    } { 学生姓名               } { UNDERGRADUATE  },
          { major     } { 专业                   } { SPECIALIZATION },
          { supv_full } { 指导教师（姓名、职称） } { MENTOR         }
        }
        { \__nju_define_name:nnn #1 }
  }
  {
    \clist_map_inline:nn
      {
        { abstract_r  } { 摘要首页用纸       },
        { author_r    } { 生姓名             },
        { chairman    } { 答辩委员会主席：   },
        { clc         } { 分类号             },
        { confer      } { 学位授予单位和日期 },
        { df_date     } { 论文答辩日期       },
        { degree      } { 申请学位级别       },
        { degree_l    } { （申请             },
        { degree_r    } { 学位）             },
        { field       } { 研究方向           },
        { g           } { 研究生             },
        { grade       } { 级                 },
        { major_s     } { 专业               },
        { major_nl    } { 专业名称           },
        { orig_sign   } { 研究生签名：       },
        { orig_date   } { 日期：             },
        { reviewer    } { 评阅人：           },
        { seclv       } { 密级               },
        { sign        } { （签字）           },
        { sm_date     } { 论文提交日期       },
        { supv        } { 导师               },
        { supv_r      } { （姓名、职称）     },
        { supv_info   } { 指导教师姓名、职务、
                  职称、学位、单位名称及地址 },
        { title       } { 论文题目           },
        { title_nl    } { （题名和副题名）   },
        { title_s     } { 题目               },
        { udc         } { U D C              }
      }
      { \__nju_define_name:nn #1 }
      \clist_map_inline:nn
        {
          { author    } { 作者姓名 } { POSTGRADUATE   },
          { major     } { 专业方向 } { SPECIALIZATION },
          { supv_full } { 指导教师 } { MENTOR         }
        }
        { \__nju_define_name:nnn #1 }
    \tl_const:Nn \c__nju_cover_en_text_tl
      {
        A~ dissertation~ submitted~ to \\
        the~ graduate~ school~ of~ Nanjing~ University \\
        in~ partial~ fulfilment~ of~ the~ requirements~ for~ the~ degree~ of
      }
  }
\tl_const:Nn \c__nju_orig_decl_text_tl
  {
    本人郑重声明，所提交的学位论文是本人在导师指导下独立进行科学研究工作
    所取得的成果。除本论文中已经注明引用的内容外，本论文不包含其他个人或
    集体已经发表或撰写过的研究成果，也不包含为获得南京大学或其他教育机构
    的学位证书而使用过的材料。对本文的研究做出重要贡献的个人和集体，均已
    在论文的致谢部分明确标明。本人郑重申明愿承担本声明的法律责任。
  }
\clist_const:Nn \c__nju_theorem_type_clist
  { axiom, corollary, definition, example, lemma, theorem }
\clist_map_inline:nn
  {
    { axiom      } { 公理 } { Axiom      },
    { corollary  } { 推论 } { Corollary  },
    { definition } { 定义 } { Definition },
    { example    } { 例   } { Example    },
    { lemma      } { 引理 } { Lemma      },
    { proof      } { 证明 } { Proof      },
    { theorem    } { 定理 } { Theorem    }
  }
  { \__nju_define_name:nnn #1 }
\keys_define:nn { nju } { info.meta:nn = { nju / info } { #1 } }
\keys_define:nn { nju / info }
  {
    title               .tl_set:N = \l__nju_info_title_tl,
    title              .initial:n = { 空 },
    title*              .tl_set:N = \l__nju_info_title_en_tl,
    keywords         .clist_set:N = \l__nju_info_keywords_clist,
    keywords*        .clist_set:N = \l__nju_info_keywords_en_clist,
    grade               .tl_set:N = \l__nju_info_grade_tl,
    student-id          .tl_set:N = \l__nju_info_id_tl,
    author              .tl_set:N = \l__nju_info_author_tl,
    author*             .tl_set:N = \l__nju_info_author_en_tl,
    department          .tl_set:N = \l__nju_info_dept_tl,
    department*         .tl_set:N = \l__nju_info_dept_en_tl,
    major               .tl_set:N = \l__nju_info_major_tl,
    major*              .tl_set:N = \l__nju_info_major_en_tl,
    field               .tl_set:N = \l__nju_info_field_tl,
    field*              .tl_set:N = \l__nju_info_field_en_tl,
    supervisor          .tl_set:N = \l__nju_info_supv_tl,
    supervisor*         .tl_set:N = \l__nju_info_supv_en_tl,
    supervisor-title    .tl_set:N = \l__nju_info_supv_ttl_tl,
    supervisor-title*   .tl_set:N = \l__nju_info_supv_ttl_en_tl,
    supervisor-ii       .tl_set:N = \l__nju_info_supv_ii_tl,
    supervisor-ii*      .tl_set:N = \l__nju_info_supv_ii_en_tl,
    supervisor-ii-title .tl_set:N = \l__nju_info_supv_ii_ttl_tl,
    supervisor-ii-title*.tl_set:N = \l__nju_info_supv_ii_ttl_en_tl,
    submit-date         .tl_set:N = \l__nju_info_sm_date_tl,
    submit-date*        .tl_set:N = \l__nju_info_sm_date_en_tl,
    defend-date         .tl_set:N = \l__nju_info_df_date_tl,
    chairman            .tl_set:N = \l__nju_info_chairman_tl,
    reviewer         .clist_set:N = \l__nju_info_reviewer_clist,
    clc                 .tl_set:N = \l__nju_info_clc_tl,
    secret-level        .tl_set:N = \l__nju_info_seclv_tl,
    udc                 .tl_set:N = \l__nju_info_udc_tl,
    supervisor-contact  .tl_set:N = \l__nju_info_supv_cont_tl,
  }
\NewDocumentCommand \njusetup { m } { \keys_set:nn { nju } { #1 } }
\bool_set:Nn \l__nju_second_supv_bool
  { ! \tl_if_empty_p:N \l__nju_info_supv_ii_tl }
\tl_set:Nn \l__nju_info_supv_full_tl
  {
    \l__nju_info_supv_tl \__nju_hskip:
    \l__nju_info_supv_ttl_tl
    \bool_if:NT \l__nju_second_supv_bool
      {
        \__nju_quad: \l__nju_info_supv_ii_tl
        \__nju_hskip: \l__nju_info_supv_ii_ttl_tl
      }
  }
\tl_set:Nn \l__nju_info_supv_full_en_tl
  {
    \l__nju_info_supv_ttl_en_tl \__nju_hskip:
    \l__nju_info_supv_en_tl
    \bool_if:NT \l__nju_second_supv_bool
      {
        \__nju_quad: \l__nju_info_supv_ii_ttl_en_tl
        \__nju_hskip: \l__nju_info_supv_ii_en_tl
      }
  }
\PassOptionsToClass
  {
    a4paper,
    twoside,
    UTF8,
    scheme=chinese,
    linespread=1.625,
    fontset=none,
    zihao=-4
  }
  { ctexbook }
\clist_map_inline:nn
  {
    { no-math           } { fontspec },
    { perpage           } { footmisc },
    { amsmath, thmmarks } { ntheorem },
    { hyphens           } { url      },
    { warnings-off={ mathtools-colon, mathtools-overbracket } }
                          { unicode-math },
    { capitalise, nameinlink, noabbrev }
                          { cleveref }
  }
  { \PassOptionsToPackage #1 }
\LoadClass { ctexbook } [ 2018/04/01 ]
\RequirePackage
  {
    geometry,
    caption,
    setspace,
    fancyhdr,
    hologo,
    url,
    emptypage,
    njuvisual,
    amsmath,
    mathtools,
    unicode-math,
    ntheorem,
    graphicx,
    wrapfig,
    booktabs,
    multirow,
    listings,
    enumitem,
    hyperref,
    cleveref
  }
\sys_if_engine_xetex:T
  {
    \RequirePackage{xeCJKfntef}
    \NewDocumentCommand \njuline { m } { \CJKunderline{#1} }
  }
\sys_if_engine_luatex:T
  {
    \RequirePackage{lua-ul}
    \NewDocumentCommand \njuline { m } { \underLine{#1} \null }
  }
\msg_new:nnn { njuthesis } { package-too-old }
  {
    Package~ "#1"~ is~ too~ old. \\
    The~ njuthesis~ class~ only~ supports~ "#1"~ with~
    a~ version higher~ than~ v#2.\\
    Please~ update~ an~ up-to-date~ version~ of~ it~
    using~ your TeX~ package~ manager~ or~ from~ CTAN.
  }
\cs_new_protected:Npn \__nju_check_package:nnn #1#2#3
  {
    \@ifpackagelater {#1} {#2}
      { } { \msg_error:nnnn { njuthesis } { package-too-old } {#1} {#3} }
  }
\sys_if_engine_luatex:T
  { \__nju_check_package:nnn { luatexja } { 2021/10/24 } { 20211024.0 } }
\tl_if_empty:NTF \g__nju_latin_font_tl
  { \bool_gset_true:N \g__nju_load_sys_font_bool }
  {
    \tl_if_empty:NT \g__nju_cjk_font_tl
      { \bool_gset_true:N \g__nju_load_sys_font_bool }
  }
\bool_if:NT \g__nju_load_sys_font_bool
  {
    \sys_if_platform_windows:TF
      { \tl_set:Nn \g__nju_latin_font_tl   { win    }
        \tl_set:Nn \g__nju_cjk_font_tl     { win    } }
      { \ctex_if_platform_macos:TF
        { \tl_set:Nn \g__nju_latin_font_tl { mac    }
          \tl_set:Nn \g__nju_cjk_font_tl   { mac    } }
        { \tl_set:Nn \g__nju_latin_font_tl { gyre   }
          \tl_set:Nn \g__nju_cjk_font_tl   { fandol } } }
  }
\cs_new_protected:Npn \__nju_load_latin_font_win:
  {
    \setmainfont{Times~New~Roman}
    \setsansfont{Arial}
    \setmonofont{Courier~New}[Scale=MatchLowercase]
  }
\cs_new_protected:Npn \__nju_load_latin_font_mac:
  {
    \setmainfont{Times~New~Roman}
    \setsansfont{Arial}
    \setmonofont{Menlo}[Scale=MatchLowercase]
  }
\cs_new_protected:Npn \__nju_load_latin_font_gyre:
  {
    \setmainfont{texgyretermes}[
      Extension=.otf,
      UprightFont=*-regular,
      BoldFont=*-bold,
      ItalicFont=*-italic,
      BoldItalicFont=*-bolditalic]
    \setsansfont{texgyreheros}[
      Extension=.otf,
      UprightFont=*-regular,
      BoldFont=*-bold,
      ItalicFont=*-italic,
      BoldItalicFont=*-bolditalic]
    \setmonofont{texgyrecursor}[
      Extension=.otf,
      UprightFont=*-regular,
      BoldFont=*-bold,
      ItalicFont=*-italic,
      BoldItalicFont=*-bolditalic,
      Scale=MatchLowercase,
      Ligatures=CommonOff]
  }
\cs_new_protected:Npn \__nju_load_cjk_font_win:
  {
    \setCJKmainfont{SimSun}[
      AutoFakeBold=2.17,
      ItalicFont=KaiTi]
    \setCJKsansfont{SimHei}
    \setCJKmonofont{FangSong}
    \setCJKfamilyfont{zhsong}{SimSun}[AutoFakeBold=2.17]
    \setCJKfamilyfont{zhhei}{SimHei}
    \setCJKfamilyfont{zhfs}{FangSong}
    \setCJKfamilyfont{zhkai}{KaiTi}[AutoFakeBold=2.17]
  }
\cs_new_protected:Npn \__nju_load_cjk_font_mac:
  {
    % 移除 does not contain script "CJK" 警告
    \msg_redirect_name:nnn {fontspec} {no-script} {info}
    \setCJKmainfont{Songti~SC~Light}[
      BoldFont=Songti~SC~Bold,
      ItalicFont=Kaiti~SC,
      BoldItalicFont=Kaiti~SC~Bold]
    \setCJKsansfont{Heiti~SC~Light}[BoldFont=Heiti~SC~Medium]
    \setCJKmonofont{STFangsong}
    \setCJKfamilyfont{zhsong}{Songti~SC~Light}[BoldFont=Songti~SC~Bold]
    \setCJKfamilyfont{zhhei}{Heiti~SC~Light}[BoldFont=Heiti~SC~Medium]
    \setCJKfamilyfont{zhfs}{STFangsong}
    \setCJKfamilyfont{zhkai}{Kaiti~SC}[BoldFont=Kaiti~SC~Bold]
    \setCJKfamilyfont{zhnewhei}{PingFang~SC}
  }
\cs_new_protected:Npn \__nju_load_cjk_font_fandol:
  {
    % 移除 does not contain script "CJK" 警告
    \msg_redirect_name:nnn {fontspec} {no-script} {info}
    \setCJKmainfont{FandolSong-Regular}[
      Extension=.otf,
      BoldFont=FandolSong-Bold,
      ItalicFont=FandolKai-Regular]
    \setCJKsansfont{FandolHei-Regular}[
      Extension=.otf,
      BoldFont=FandolHei-Bold]
    \setCJKmonofont{FandolFang-Regular}[Extension=.otf]
    \setCJKfamilyfont{zhsong}{FandolSong-Regular}[
      Extension=.otf,
      BoldFont=FandolSong-Bold]
    \setCJKfamilyfont{zhhei}{FandolHei-Regular}[
      Extension=.otf,
      BoldFont=FandolHei-Bold]
    \setCJKfamilyfont{zhfs}{FandolFang-Regular}[Extension=.otf]
    \setCJKfamilyfont{zhkai}{FandolKai-Regular}[
      Extension=.otf,
      AutoFakeBold=2.17]
  }
\cs_new_protected:Npn \__nju_load_cjk_font_founder:
  {
    \sys_if_engine_luatex:T
    {
      \defaultCJKfontfeatures{JFM={zh_CN/{quanjiao,fzpr}}}
    }
    \setCJKmainfont{FZSSK}[% 方正书宋
      Extension=.ttf,
      BoldFont=FZXBSK,% 方正小标宋
      ItalicFont=FZKTK]% 方正楷体
    \setCJKsansfont{FZXH1K}[% 方正细黑一
      Extension=.ttf,
      BoldFont=FZHTK]% FZHTK 方正黑体
    \setCJKmonofont{FZFSK}[Extension=.ttf]% 方正仿宋
    \setCJKfamilyfont{zhsong}
      {FZSSK}[
        Extension=.ttf,
        BoldFont=FZXBSK]
    \setCJKfamilyfont{zhhei}
      {FZHTK}[
        Extension=.ttf,
        AutoFakeBold=2.17]
    \setCJKfamilyfont{zhfs}
      {FZFSK}[Extension=.ttf]
    \setCJKfamilyfont{zhkai}
      {FZKTK}[Extension=.ttf]
    \defaultCJKfontfeatures{}
  }
\cs_new_protected:Npn \__nju_load_cjk_font_noto:
  {
    % 思源宋体
    \setCJKmainfont[
      UprightFont=NotoSerifSC-Regular,
      BoldFont=NotoSerifSC-Bold,
      ItalicFont=NotoSerifSC-Regular,
      BoldItalicFont=NotoSerifSC-Bold,
      ItalicFeatures=FakeSlant,
      BoldItalicFeatures=FakeSlant]{Noto~Serif~SC}

    % 思源黑体
    \setCJKsansfont[
      UprightFont=NotoSansSC-Regular,
      BoldFont=NotoSansSC-Bold,
      ItalicFont=NotoSansSC-Regular,
      BoldItalicFont=NotoSansSC-Bold,
      ItalicFeatures=FakeSlant,
      BoldItalicFeatures=FakeSlant]{Noto~Sans~SC}

    \setCJKmonofont{FZFSK}[Extension=.ttf]% 方正仿宋

    \setCJKfamilyfont{zhsong}{Noto~Serif~SC}
    \setCJKfamilyfont{zhhei}{Noto~Sans~SC}
    \setCJKfamilyfont{zhfs}{FZFSK}[Extension=.ttf]
    \setCJKfamilyfont{zhkai}{FZKTK}[Extension=.ttf]
  }
\cs_new_protected:Npn \__nju_load_font:
  {
    \use:c { __nju_load_latin_font_ \g__nju_latin_font_tl : }
    \use:c { __nju_load_cjk_font_   \g__nju_cjk_font_tl   : }
    \NewDocumentCommand \songti   { } { \CJKfamily{zhsong} }
    \NewDocumentCommand \heiti    { } { \CJKfamily{zhhei}  }
    \NewDocumentCommand \fangsong { } { \CJKfamily{zhfs}   }
    \NewDocumentCommand \kaishu   { } { \CJKfamily{zhkai}  }
    \RenewDocumentCommand \large  { } { \zihao{4}          }
  }
\__nju_load_font:
\setmathfont{XITSMath-Regular}[
  BoldFont = XITSMath-Bold,
  Extension = .otf]
\setmathfont{NewCMMath-Regular.otf}[range={cal,bb,frak}]
\setmathfont{NewCMMath-Regular.otf}[version=bold,range={bfcal}]
\geometry
  {
    vmargin    = 2.5 cm,
    hmargin    = 3.2 cm,
    headheight = 15 pt
  }
\fancypagestyle { plain }
  {
    \fancyhf { }
    \fancyfoot [ C ] { \zihao{5} \thepage }
    \RenewDocumentCommand \headrulewidth { } { 0 pt }
    \RenewDocumentCommand \footrulewidth { } { 0 pt }
  }
\fancypagestyle{headings}
  {
    \fancyhf { }
    \fancyhead [ CO ] { \leftmark          }
    \fancyhead [ CE ] { \rightmark         }
    \fancyfoot [ C  ] { \zihao{5} \thepage }
    \RenewDocumentCommand \headrulewidth { } { 0.4 pt }
    \RenewDocumentCommand \footrulewidth { } { 0   pt }
    \setlength { \headheight } { 20 pt }
  }
\RenewDocumentCommand \frontmatter { }
  {
    \cleardoublepage
    \pagestyle{empty}
    \pagenumbering{Roman}
  }
\RenewDocumentCommand \mainmatter { }
  {
    \cleardoublepage
    \int_compare:nTF { \l__nju_info_degree_int == 1 }
      { \pagestyle{plain} } { \pagestyle{headings} }
    \pagenumbering{arabic}
    \normalfont\normalsize
  }
\tl_const:Nn \c__nju_sec_format_tl { \large \normalfont \sffamily }
\ctexset
  {
    chapter/beforeskip   = 10 pt,
    chapter/afterskip    = 60 pt,
    chapter/format       = \centering \c__nju_sec_format_tl,
    section/format       = \c__nju_sec_format_tl,
    subsection/format    = \c__nju_sec_format_tl,
    subsubsection/format = \c__nju_sec_format_tl
  }
\cs_new_protected:Npn \__nju_chapter_in_toc:n #1
  { \addcontentsline { toc } { chapter } { \c__nju_sec_format_tl #1 } }
\NewDocumentCommand \njuchapter { m }
  {
    \chapter*{#1}
    \addcontentsline { toc } { chapter } { \c__nju_sec_format_tl #1}
    \@mkboth{#1}{#1}
  }
\ctexset
  {
    contentsname   = {目\hspace{2em}录},
    listfigurename = {插图清单},
    listtablename  = {表格清单},
    chapter / tocline = \c__nju_sec_format_tl \CTEXnumberline {#1} #2
  }
\tl_const:Nn \c__nju_toc_title_tl { \centering \zihao{3} \bf }
\cs_new_protected:Npn \__nju_modify_toc_title:nn #1#2
{
  \group_begin:
    \ctexset { chapter/format = \c__nju_toc_title_tl }
    \njuchapter { #1 }
  \group_end:
  \@starttoc{#2}
}
\RenewDocumentCommand \tableofcontents { }
  { \__nju_modify_toc_title:nn { \contentsname   } { toc } }
\RenewDocumentCommand \listoffigures   { }
  { \__nju_modify_toc_title:nn { \listfigurename } { lof } }
\RenewDocumentCommand \listoftables    { }
  { \__nju_modify_toc_title:nn { \listtablename  } { lot } }
\RequirePackage[
    style=gb7714-2015,
    %style=numeric-comp,
    %citestyle=authortitle-icomp,
    % citestyle=numeric-comp,
    %bibstyle=authoryear,
    % bibstyle=numeric,
    sorting=none,
    %sorting=nyt,
    %sortcites=true,
    %autocite=footnote,
    backend=biber, % Compile the bibliography with biber
    hyperref=true,
    backref=false,
    citecounter=true,
    pagetracker=true,
    citetracker=true,
    ibidtracker=context,
    autopunct=true,
    autocite=plain,
    % gbpub=false,         % Uncomment if you do NOT want '[S.l. : s.n.]'
                           % in reference entries, GitHub Issue (#47)
    % gbnamefmt=lowercase, % Uncomment if you do NOT want uppercase author
                           % names in reference entries, GitHub Issue (#23)
]{biblatex}
\ctexset{ bibname = {参考文献} }
\defbibheading { njubib } [ \bibname ] { \njuchapter { #1 } }
\DeclarePrintbibliographyDefaults { heading = njubib }
\AtEveryBibitem
  {
    \clist_map_inline:nn
      { abstract, issn, isbn, archivePrefix, arxivId, pmid, eprint }
      { \clearfield { #1 } }
    \ifentrytype{online}{}{\ifentrytype{misc}{}{\clearfield{url}}}
  }
\ctex_at_end_preamble:n
  {
    \tl_set_eq:NN \l__nju_tmp_tl \l__nju_info_title_tl
    \tl_remove_all:Nn \l__nju_tmp_tl { ! }
    \hypersetup
      {
        bookmarksnumbered = true,
        psdextra          = true,
        unicode           = true,
        hidelinks,
        pdftitle    = \l__nju_tmp_tl,
        pdfauthor   = \l__nju_info_author_tl,
        pdfkeywords = \l__nju_info_keywords_clist,
        pdfcreator  = \c__nju_name_pdf_creator_tl
      }
  }
\cs_new_protected:Npn \__nju_cref_name:n #1
  {
    \clist_map_inline:nn { #1 }
      { \crefname { ##1 } { \__nju_name:n { ##1 } } { \__nju_name:n { ##1 _en } } }
  }
\cs_new_protected:Npn \__nju_cref_name:N #1
  {
    \clist_map_inline:Nn #1
      { \crefname { ##1 } { \__nju_name:n { ##1 } } { \__nju_name:n { ##1 _en } } }
  }
\crefdefaultlabelformat{#2#1#3\,}
\crefformat { equation      } { 公式~#2#1#3~   }
\crefformat { chapter       } { 第#2#1#3章     }
\crefformat { section       } { 第~#2#1#3~节   }
\crefformat { subsection    } { 第~#2#1#3~小节 }
\crefformat { subsubsection } { 第~#2#1#3~小节 }
\__nju_cref_name:n { figure, table, appendix, proof }
\__nju_cref_name:N \c__nju_theorem_type_clist
\DeclareGraphicsExtensions{.pdf,.eps,.jpg,.png}
\DeclareCaptionStyle{njucap}
  {
    font          = small,
    labelfont     = bf,
    labelsep      = quad,
    justification = centering
  }
\captionsetup [ figure ] { style = njucap }
\captionsetup [ table  ] { style = njucap }
\lstdefinestyle { njulisting }
  {
    basewidth    = 0.5 em,
    lineskip     = 3 pt,
    basicstyle   = \tiny\tt,
    keywordstyle = \bf,
    commentstyle = \it\color{gray},
    numbers      = left,
    captionpos   = t,
    breaklines   = true,
    xleftmargin  = 2 em,
    xrightmargin = 2 em
  }
\lstset
  {
    style        = njulisting,
    flexiblecolumns
  }
\ExplSyntaxOff
\lstMakeShortInline[
  style=njulisting,
  basicstyle=\normalsize\tt,
  columns=fixed]|
\ExplSyntaxOn
\setlist { noitemsep }
\NewDocumentCommand\mathbi{m}{\textbf{\em #1}}
\cs_new_protected:Npn \__nju_new_theorem:N #1
  {
    \theoremsymbol { }
    \clist_map_inline:Nn #1
      { \newtheorem { ##1 } { \__nju_name:n { ##1 } } }
  }
\theoremsymbol { \ensuremath { \mdwhtsquare } }
\newtheorem* { proof } { \c__nju_name_proof_tl }
\__nju_new_theorem:N \c__nju_theorem_type_clist
\cs_new_protected:Npn \__nju_split_title:n #1
  {
    \tl_if_in:VnTF { #1 } { ! }
      {
        \seq_set_split:NnV \l__nju_tmp_seq { ! } { #1 }
        \clist_set_from_seq:NN \l__nju_tmp_clist \l__nju_tmp_seq
      }
      {
        \__nju_put_inempty_seg:nnn { #1 } { 1  } { 15 }
        \__nju_put_inempty_seg:nnn { #1 } { 16 } { 15 }
        \__nju_put_inempty_seg:nnn { #1 } { 31 } { 15 }
      }
  }
\cs_new_protected:Npn \__nju_multiline_title:nnn #1#2#3
  {
    \__nju_split_title:n { \l__nju_info_title_tl }
    \__nju_spread_box:nnn { #2 } { \kaishu } { \c__nju_name_title_tl }
    \__nju_hskip:
    \clist_map_inline:Nn \l__nju_tmp_clist
      { \__nju_ulined_center_box:nn { #3 } { #1 ##1 } \__nju_vskip: }
  }
\cs_new_protected:Npn \__nju_cover_entry:nnn #1#2#3
  {
    \__nju_spread_box:nnn { #2 } { \kaishu } { \__nju_name:n { #1 } }
    \__nju_hskip:
    \__nju_ulined_center_box:nn  { #3 }      { \__nju_info:n { #1 } }
    \__nju_vskip:
  }
\cs_new_protected:Npn \__nju_cover_bientry:nnnn #1#2#3#4
  {
    \__nju_spread_box:nnn { #3 } { \kaishu } { \__nju_name:n { #1 } }
    \__nju_hskip:
    \__nju_ulined_center_box:nn  { #4 }      { \__nju_info:n { #1 } }
    \skip_horizontal:n { 0.5 em }
    \__nju_spread_box:nnn { #3 } { \kaishu } { \__nju_name:n { #2 } }
    \__nju_hskip:
    \__nju_ulined_center_box:nn  { #4 }      { \__nju_info:n { #2 } }
    \__nju_vskip:
  }
\cs_new_protected:Npn \__nju_cover_title_ug:
  { \__nju_spread_box:nnn { 9em } { \bf } { \l__nju_info_type_tl } }
\cs_new_protected:Npn \__nju_cover_info_ug:nnn #1#2#3
  {
    \begin{minipage} [ c ] { #1 + #2 + 0.3 em }
      \raggedleft
      \__nju_cover_entry:nnn { dept            } { #1 } { #2 }
      \__nju_cover_entry:nnn { major           } { #1 } { #2 }
      \__nju_multiline_title:nnn   { \bf } { #1 } { #2 }
      \__nju_cover_bientry:nnnn { grade } { id } { #1 } { #3 }
      \__nju_cover_entry:nnn { author          } { #1 } { #2 }
      \__nju_cover_bientry:nnnn { supv } { supv_ttl } { #1 } { #3 }
      \tl_if_blank:VF { \l__nju_info_supv_ii_tl }
        { \__nju_cover_bientry:nnnn { supv_ii } { supv_ttl } { #1 } { #3 } }
      \__nju_cover_entry:nnn { sm_date     } { #1 } { #2 }
    \end{minipage}
  }
\cs_new_protected:Npn \__nju_cover_title_g:
  {
    \__nju_spread_box:nnn { 9em } { } { \l__nju_info_type_tl } \__nju_vskip:
    \c__nju_name_degree_l_tl \l__nju_info_degree_tl \c__nju_name_degree_r_tl
  }
\cs_new_protected:Npn \__nju_cover_info_g:nn #1#2
  {
    \begin{minipage} [ c ] { #1 + #2 + 0.3 em }
      \raggedleft
      \__nju_multiline_title:nnn { } { #1 } { #2 }
      \clist_map_inline:nn { author, major, field, supv_full }
        { \__nju_cover_entry:nnn { ##1 } { #1 } { #2 } }
    \end{minipage}
  }
\cs_new_protected:Npn \__nju_cover_back_g:
  {
    \__nju_spread_box:nnn { 6.2 em } { \kaishu } { \c__nju_name_id_tl }
    { : \__nju_quad: } \l__nju_info_id_tl
    \__nju_vskip:
    \__nju_spread_box:nnn { 6.2 em } { \kaishu } { \c__nju_name_df_date_tl }
    { : \__nju_quad: } \l__nju_info_df_date_tl
    \__nju_vskip:
    \__nju_spread_box:nnn { 6.2 em } { \kaishu } { \c__nju_name_supv_full_tl }
    { : \__nju_quad: } \skip_horizontal:n { 8 em } \c__nju_name_sign_tl
  }
\cs_new_protected:Npn \__nju_cover_en_g:
  {
      \parbox { \textwidth }
        { \centering \bf \sffamily \zihao { 2 } \l__nju_info_title_en_tl }
      \skip_vertical:n { 1 cm }
      \group_begin: \zihao { 4 } { by } \group_end: \__nju_vskip:
      \group_begin:
        \bf \sffamily \zihao { 4 } \l__nju_info_author_en_tl
      \group_end: \skip_vertical:n { 1 cm }
      \group_begin: \zihao { 4 } { Supervised~ by } \group_end: \__nju_vskip:
      \group_begin:
        \sffamily \zihao { 4 } \l__nju_info_supv_full_en_tl
      \group_end: \vfill
      \c__nju_cover_en_text_tl \__nju_vskip:
      \textsc { \clist_item:Nn \c__nju_name_degree_en_clist
                  { \l__nju_info_degree_int } }
      \__nju_vskip: { in } \__nju_vskip:
      \l__nju_info_major_en_tl \skip_vertical:n { 1 cm }
      \njuemblem [ black ] { ! } { 2.5 cm } \__nju_vskip:
      \l__nju_info_dept_en_tl \\ \c__nju_name_nju_en_tl
      \skip_vertical:n { 1 cm }
      \l__nju_info_sm_date_en_tl
  }
\cs_new_protected:Npn \__nju_cover_top_nl:
  {
    \__nju_spread_box:nnn { 3.2 em } { } { \c__nju_name_clc_tl   } \__nju_hskip:
    \__nju_ulined_center_box:nn { 9 em } { \l__nju_info_clc_tl   } \hfill
    \__nju_spread_box:nnn { 3.2 em } { } { \c__nju_name_seclv_tl } \__nju_hskip:
    \__nju_ulined_center_box:nn { 9 em } { \l__nju_info_seclv_tl } \\
    \__nju_spread_box:nnn { 3.2 em } { } { \c__nju_name_udc_tl   } \__nju_hskip:
    \__nju_ulined_center_box:nn { 9 em } { \l__nju_info_udc_tl   } \hfill \null
  }
\cs_new_protected:Npn \__nju_cover_title_nl:
  {
    \noindent \kaishu \zihao { -0 } \skip_vertical:n { -1 cm }
    \__nju_spread_box:nnn { 6 em } { } { \c__nju_name_title_tl }
    \__nju_vskip: \zihao { 1 }
    \__nju_split_title:n { \l__nju_info_title_tl }
    \__nju_multiline_box:nnnn { \l__nju_tmp_int } \l__nju_tmp_clist { 3 } { 15 em }
    \__nju_vskip: \zihao{4} \c__nju_name_title_nl_tl
    \__nju_vskip: \zihao{1}
    \__nju_ulined_center_box:nn { 4.5 em } { \l__nju_info_author_tl }
    \__nju_vskip: \zihao{4} { ( } \c__nju_name_author_tl { ) }
  }
\cs_new_protected:Npn \__nju_cover_info_nl:
  {
    \__nju_uline_entry:nnnn   \l__nju_tmp_dim { supv_info } { supv   } { } \\
    \__nju_ulined_center_box:nn { \textwidth } { \__nju_info:n { supv_ttl }
    \__nju_quad: \__nju_info:n  { supv_cont } }                             \\
    \__nju_uline_bientry:nnnn \l__nju_tmp_dim { degree   } { degree  } { }
    \__nju_uline_bientry:nnnn \l__nju_tmp_dim { major_nl } { major   } { } \\
    \__nju_uline_bientry:nnnn \l__nju_tmp_dim { sm_date  } { sm_date } { }
    \__nju_uline_bientry:nnnn \l__nju_tmp_dim { df_date  } { df_date } { } \\
    \__nju_full_uline:Nn \l__nju_tmp_dim { \c__nju_name_confer_tl }
    \__nju_uline:n { \l__nju_tmp_dim }
  }
\cs_new_protected:Npn \__nju_cover_bottom_nl:
  {
    \__nju_name:n { chairman } \__nju_hskip:
    \__nju_ulined_center_box:nn { 9 em } { \__nju_info:n { chairman } } \\
    \__nju_name:n { reviewer } \__nju_hskip:
    \__nju_multiline_box:nnnn { \l__nju_tmp_int }
      { \l__nju_info_reviewer_clist } { 4 } { 9 em }
  }
\cs_new_protected:Npn \__nju_make_cover_ug:
  {
    \newpage
    \null \skip_horizontal:n { -1 cm }
    \njuemblem [ black] { ! } { 3.35 cm }
    \begin{center}
      \njuname[black]{!}{3cm} \__nju_vskip:
      \group_begin: \zihao { -1 } \__nju_cover_title_ug: \group_end:
      \skip_vertical:n { 1.5 cm } \vfil
      \zihao{3} \__nju_cover_info_ug:nnn { 4.2 em } { 16 em } { 5.5 em } \vfil
    \end{center}
  }
\cs_new_protected:Npn \__nju_make_cover_g:
  {
    \newpage
    \begin{center}
      \null \skip_vertical:n { 1 cm }
      \njuemblem [ black ] { ! } { 1.9 cm } \skip_vertical:n { 0.5 cm }
      \njuname   [ black ] { 4.4 cm } { ! } \__nju_vskip:
      \group_begin:
        \zihao { -1 } \bf \kaishu \__nju_cover_title_g:
      \group_end:
      \skip_vertical:n { 3 cm } \vfil
      \group_begin:
        \zihao { 3 } \kaishu
        \__nju_cover_info_g:nn { 6.2 em } { 18 em } \vfil
        \skip_vertical:n { 2 cm } \l__nju_info_sm_date_tl
      \group_end:
    \end{center}
    \newpage
    \noindent \null \skip_vertical:n { 18 cm }
    \group_begin:
      \zihao { 3 } \kaishu \__nju_cover_back_g:
    \group_end:
    \newpage
    \noindent \null \skip_vertical:n { 2 cm }
    \begin{center}
      \__nju_cover_en_g:
    \end{center}
  }
\cs_new_protected:Npn \__nju_make_cover_nl:
  {
    \pdfbookmark [ 0 ] { 国家图书馆封面 } { nlcover }
    \noindent \null
    \begin{center}
      \zihao{ -4 } \skip_vertical:n { -2 cm }
      \__nju_cover_top_nl:
    \end{center}
    \begin{center}
      \skip_vertical:n { -2 cm }
      \__nju_cover_title_nl:
    \end{center}
    \group_begin:
      \kaishu \zihao { 4 } \noindent \__nju_cover_info_nl:
    \group_end:
    \begin{flushright}
      \__nju_cover_bottom_nl:
    \end{flushright}
    \begin{center}
      \kaishu \zihao{3} \__nju_qquad: 年 \__nju_quad: 月 \__nju_quad: 日
    \end{center}
    \skip_vertical:n { -1 cm }
  }
\cs_new_protected:Npn \__nju_make_orig_decl:
  {
    \normalfont \normalsize
    \chapter* { \c__nju_name_nju_tl \c__nju_name_orig_decl_tl }
    \thispagestyle { empty }
    \c__nju_orig_decl_text_tl
    \vfil
    \begin{flushright}
      \__nju_name:n { orig_sign } \__nju_uline:n { 7 em } \__nju_vskip:
      \__nju_name:n { orig_date } \__nju_uline:n { 7 em }
    \end{flushright}
    \vfil
  }
\RenewDocumentCommand \maketitle { }
  {
    \pagestyle{empty}
    \bool_if:NTF \g__nju_nlcover_bool
      { \__nju_make_cover_nl: \__nju_make_orig_decl: }
      { \use:c { __nju_make_cover_ \l__nju_info_diploma_tl : } }
    \tl_remove_all:Nn \l__nju_info_title_tl { ! }
    \cleardoublepage
    \pagestyle{plain}
    \pagenumbering{Roman}
    \normalfont \normalsize
  }
\cs_new_protected:Npn \__nju_abs_title_uuline:n #1
  { \bf \kaishu \zihao { -2 } \__nju_uuline:n { #1 } }
\cs_new_protected:Npn \__nju_abs_info_style:n #1
  { \noindent \zihao{ #1 } \kaishu }
\cs_new_protected:Npn \__nju_abs_info_style_en: #1 { \zihao{ #1 } }
\cs_new_protected:Npn \__nju_abs_bookmark:n #1
  {
    \pdfbookmark [ 0 ]
      { \__nju_name:n { abstract #1 } } { abstract #1 }
  }
\cs_generate_variant:Nn \clist_map_inline:nn { Vn }
\cs_new_protected:Npn \__nju_abs_title_ug:n #1
  {
    \__nju_name:n { nju     } \__nju_name:n { type     }
    \__nju_name:n { lang #1 } \__nju_name:n { abstract }
  }
\cs_new_protected:Npn \__nju_abs_info_ug:nn #1#2
  {
    \tl_if_blank:eTF { #1 }
      { \c__nju_name_title_tl }
      { \clist_item:Nn \c__nju_name_type_en_clist { \l__nju_info_type_int } }
    #2 \tl_use:c { l__nju_info_title #1 _tl } \\
    \tl_set_eq:NN \c__nju_name_author_tl \c__nju_name_author_full_tl
    \clist_map_inline:nn { dept, major, author, supv_full }
      { \__nju_name:n { ##1 #1 } #2 \__nju_info:n { ##1 #1 } \\ }
    \__nju_name:n { abstract #1 } #2
  }
\cs_new_protected:Npn \__nju_abs_title_g:n #1
  {
    \__nju_name:n { nju     } \__nju_info:n { type       }
    \__nju_name:n { lang #1 } \__nju_name:n { abstract_r }
  }
\cs_new_protected:Npn \__nju_abs_info_g:nn #1#2
  {
    \tl_if_blank:eTF { #1 }
      {
        \__nju_full_uline:NV \l__nju_tmp_dim
          {
            \clist_item:Nn \c__nju_name_type_clist { \l__nju_info_type_int }
            \c__nju_name_title_s_tl #2
          }
        \__nju_ulined_center_box:nn { \l__nju_tmp_dim }
          { \tl_range:Nnn \l__nju_info_title_tl { 1 } { 20 } } \\
        \__nju_uline:n { \textwidth } \__nju_qquad:
        \tl_range:Nnn \l__nju_info_title_tl { 21 } { -1 } \\
        \__nju_full_uline:NV \l__nju_tmp_dim
          {
            \__nju_ulined_center_box:nn { 11 em } { \l__nju_info_major_tl }
            \c__nju_name_major_s_tl
            \__nju_ulined_center_box:nn { 4 em } { \l__nju_info_grade_tl }
            \c__nju_name_grade_tl
            \tl_item:nn { \l__nju_info_degree_tl } { 1 }
            \c__nju_name_author_r_tl #2
          }
        \__nju_ulined_center_box:nn { \l__nju_tmp_dim }
          { \l__nju_info_author_tl } \\
        \__nju_full_uline:NV \l__nju_tmp_dim
          { \c__nju_name_supv_full_tl \c__nju_name_supv_r_tl #2 }
        \__nju_ulined_center_box:nn { \l__nju_tmp_dim }
          { \l__nju_info_supv_full_tl }
      }
      {
        \__nju_full_uline:NV \l__nju_tmp_dim
          { \clist_item:cn { c__nju_name_type #1 _clist }
              { \l__nju_info_type_int } # 2 }
        \__nju_ulined_center_box:nn { \l__nju_tmp_dim }
          { \tl_range:Nnn \l__nju_info_title_en_tl { 1 } { 40 } } \\
        \__nju_uline:n { \textwidth } \__nju_qquad:
        \tl_range:Nnn \l__nju_info_title_en_tl { 41 } { -1 }
        \clist_map_inline:nn { major, author, supv_full }
          { \\
            \__nju_uline_entry:nnnn \l__nju_tmp_dim { ##1 _en } { ##1 _en } { #2 }
          }
      }
  }
\cs_new_protected:Npn \__nju_print_keywords:nn #1#2
  {
    \skip_vertical:n { 2 ex }
    \group_begin:
      \noindent \bf \heiti
      \use:c { c__nju_name_keywords #1 _tl }
    \group_end:
    \clist_use:cn { l__nju_info_keywords #1 _clist } { #2 }
  }
\cs_new_protected:Npn \__nju_make_abs_ug:nn #1#2
  {
    \begin{center}
      \__nju_abs_title_uuline:n { 22 em }
      \__nju_abs_title_ug:n { #1 }
    \end{center}
    \group_begin:
      \__nju_abs_info_style:n { -4 }
      \__nju_abs_info_ug:nn { #1 } { #2 }
    \group_end: \__nju_vskip:
  }
\cs_new_protected:Npn \__nju_make_abs_g:nn #1#2
  {
    \begin{center}
      \__nju_abs_title_uuline:n { 19 em }
      \__nju_abs_title_g:n { #1 }
    \end{center}
    \group_begin:
      \__nju_abs_info_style:n { 4 }
      \__nju_abs_info_g:nn { #1 } { #2 }
    \group_end: \__nju_vskip:
  }
\NewDocumentEnvironment{abstract} { +b }
  {
    \newpage
    \__nju_abs_bookmark:n { }
    \use:c { __nju_make_abs_ \l__nju_info_diploma_tl :nn } { } { ： }
    \group_begin: \normalfont \zihao { -4 } #1
  }
  { \__nju_print_keywords:nn { } { ； } \group_end: }
\NewDocumentEnvironment{abstract*} { +b }
  {
    \newpage
    \__nju_abs_bookmark:n { _en }
    \use:c { __nju_make_abs_ \l__nju_info_diploma_tl :nn } { _en } { :~ }
    \group_begin: \normalfont \zihao{ -4 } #1
    }
  { \__nju_print_keywords:nn { _en } { ;~ } \group_end: }
\NewDocumentEnvironment{preface}         { +b }
  { \njuchapter { 前\hspace{2em}言 } #1 } { }
\NewDocumentEnvironment{acknowledgement} { +b }
  { \njuchapter { 致\hspace{2em}谢 } #1 } { }
\NewDocumentCommand\njupaperlist { t* m }
  {
    \begin{refsection}
      \nocite{#2}
      \bool_if:NTF { #1 }
      { \printbibliography[heading=subbibliography,title=合作文章目录] }
      { \printbibliography[heading=subbibliography,title=发表文章目录] }
    \end{refsection}
  }
\endinput
%%
%% End of file `njuthesis.cls'.
