/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.jasper.Constants;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.security.SecurityUtil;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.PeriodicEventListener;
import org.apache.tomcat.util.security.Escape;

public class JspServlet
extends HttpServlet
implements PeriodicEventListener {
    private static final long serialVersionUID = 1L;
    private final transient Log log = LogFactory.getLog(JspServlet.class);
    private transient ServletContext context;
    private ServletConfig config;
    private transient Options options;
    private transient JspRuntimeContext rctxt;
    private String jspFile;

    public void init(ServletConfig servletConfig) throws ServletException {
        Serializable serializable;
        super.init(servletConfig);
        this.config = servletConfig;
        this.context = servletConfig.getServletContext();
        String string = servletConfig.getInitParameter("engineOptionsClass");
        if (Constants.IS_SECURITY_ENABLED && string != null) {
            this.log.info((Object)Localizer.getMessage("jsp.info.ignoreSetting", "engineOptionsClass", string));
            string = null;
        }
        if (string != null) {
            Object object;
            try {
                object = Thread.currentThread().getContextClassLoader();
                serializable = ((ClassLoader)object).loadClass(string);
                Class[] classArray = new Class[]{ServletConfig.class, ServletContext.class};
                Constructor<?> constructor = serializable.getConstructor(classArray);
                Object[] objectArray = new Object[]{servletConfig, this.context};
                this.options = (Options)constructor.newInstance(objectArray);
            }
            catch (Throwable throwable) {
                object = ExceptionUtils.unwrapInvocationTargetException(throwable);
                ExceptionUtils.handleThrowable((Throwable)object);
                this.log.warn((Object)Localizer.getMessage("jsp.warning.engineOptionsClass", string), (Throwable)object);
                this.options = new EmbeddedServletOptions(servletConfig, this.context);
            }
        } else {
            this.options = new EmbeddedServletOptions(servletConfig, this.context);
        }
        this.rctxt = new JspRuntimeContext(this.context, this.options);
        if (servletConfig.getInitParameter("jspFile") != null) {
            this.jspFile = servletConfig.getInitParameter("jspFile");
            try {
                if (null == this.context.getResource(this.jspFile)) {
                    return;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new ServletException(Localizer.getMessage("jsp.error.no.jsp", this.jspFile), (Throwable)malformedURLException);
            }
            try {
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    AccessController.doPrivileged(() -> {
                        this.serviceJspFile(null, null, this.jspFile, true);
                        return null;
                    });
                } else {
                    this.serviceJspFile(null, null, this.jspFile, true);
                }
            }
            catch (IOException iOException) {
                throw new ServletException(Localizer.getMessage("jsp.error.precompilation", this.jspFile), (Throwable)iOException);
            }
            catch (PrivilegedActionException privilegedActionException) {
                serializable = privilegedActionException.getCause();
                if (serializable instanceof ServletException) {
                    throw (ServletException)((Object)serializable);
                }
                throw new ServletException(Localizer.getMessage("jsp.error.precompilation", this.jspFile), (Throwable)privilegedActionException);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)Localizer.getMessage("jsp.message.scratch.dir.is", this.options.getScratchDir().toString()));
            this.log.debug((Object)Localizer.getMessage("jsp.message.dont.modify.servlets"));
        }
    }

    public int getJspCount() {
        return this.rctxt.getJspCount();
    }

    public void setJspReloadCount(int n) {
        this.rctxt.setJspReloadCount(n);
    }

    public int getJspReloadCount() {
        return this.rctxt.getJspReloadCount();
    }

    public int getJspQueueLength() {
        return this.rctxt.getJspQueueLength();
    }

    public int getJspUnloadCount() {
        return this.rctxt.getJspUnloadCount();
    }

    boolean preCompile(HttpServletRequest httpServletRequest) throws ServletException {
        String string;
        String string2 = this.rctxt.getOptions().getJspPrecompilationQueryParameter();
        String string3 = httpServletRequest.getQueryString();
        if (string3 == null) {
            return false;
        }
        int n = string3.indexOf(string2);
        if (n < 0) {
            return false;
        }
        if ((string3 = string3.substring(n + string2.length())).length() == 0) {
            return true;
        }
        if (string3.startsWith("&")) {
            return true;
        }
        if (!string3.startsWith("=")) {
            return false;
        }
        int n2 = string3.length();
        int n3 = string3.indexOf(38);
        if (n3 > 0) {
            n2 = n3;
        }
        if ((string = string3.substring(1, n2)).equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return true;
        }
        throw new ServletException(Localizer.getMessage("jsp.error.precompilation.parameter", string2, string));
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.jspFile;
        if (string == null) {
            String string2;
            string = (String)httpServletRequest.getAttribute("jakarta.servlet.include.servlet_path");
            if (string != null) {
                string2 = (String)httpServletRequest.getAttribute("jakarta.servlet.include.path_info");
                if (string2 != null) {
                    string = string + string2;
                }
            } else {
                string = httpServletRequest.getServletPath();
                string2 = httpServletRequest.getPathInfo();
                if (string2 != null) {
                    string = string + string2;
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("JspEngine --> " + string));
            this.log.debug((Object)("\t     ServletPath: " + httpServletRequest.getServletPath()));
            this.log.debug((Object)("\t        PathInfo: " + httpServletRequest.getPathInfo()));
            this.log.debug((Object)("\t        RealPath: " + this.context.getRealPath(string)));
            this.log.debug((Object)("\t      RequestURI: " + httpServletRequest.getRequestURI()));
            this.log.debug((Object)("\t     QueryString: " + httpServletRequest.getQueryString()));
        }
        try {
            boolean bl = this.preCompile(httpServletRequest);
            this.serviceJspFile(httpServletRequest, httpServletResponse, string, bl);
        }
        catch (ServletException | IOException | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            throw new ServletException(throwable);
        }
    }

    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JspServlet.destroy()");
        }
        this.rctxt.destroy();
    }

    public void periodicEvent() {
        this.rctxt.checkUnload();
        this.rctxt.checkCompile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) throws ServletException, IOException {
        JspServletWrapper jspServletWrapper = this.rctxt.getWrapper(string);
        if (jspServletWrapper == null) {
            JspServlet jspServlet = this;
            synchronized (jspServlet) {
                jspServletWrapper = this.rctxt.getWrapper(string);
                if (jspServletWrapper == null) {
                    if (null == this.context.getResource(string)) {
                        this.handleMissingResource(httpServletRequest, httpServletResponse, string);
                        return;
                    }
                    jspServletWrapper = new JspServletWrapper(this.config, this.options, string, this.rctxt);
                    this.rctxt.addWrapper(string, jspServletWrapper);
                }
            }
        }
        try {
            jspServletWrapper.service(httpServletRequest, httpServletResponse, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.handleMissingResource(httpServletRequest, httpServletResponse, string);
        }
    }

    private void handleMissingResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        String string2 = (String)httpServletRequest.getAttribute("jakarta.servlet.include.request_uri");
        String string3 = Localizer.getMessage("jsp.error.file.not.found", string);
        if (string2 != null) {
            throw new ServletException(Escape.htmlElementContent((String)string3));
        }
        try {
            httpServletResponse.sendError(404, string3);
        }
        catch (IllegalStateException illegalStateException) {
            this.log.error((Object)string3);
        }
    }
}

