/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.PushBuilder;
import org.apache.catalina.Context;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.util.SessionConfig;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.collections.CaseInsensitiveKeyMap;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationPushBuilder
implements PushBuilder {
    private static final StringManager sm = StringManager.getManager(ApplicationPushBuilder.class);
    private static final Set<String> DISALLOWED_METHODS = new HashSet<String>();
    private final HttpServletRequest baseRequest;
    private final Request catalinaRequest;
    private final org.apache.coyote.Request coyoteRequest;
    private final String sessionCookieName;
    private final String sessionPathParameterName;
    private final boolean addSessionCookie;
    private final boolean addSessionPathParameter;
    private final Map<String, List<String>> headers = new CaseInsensitiveKeyMap();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String method = "GET";
    private String path;
    private String queryString;
    private String sessionId;
    private String userName;

    public ApplicationPushBuilder(Request request, HttpServletRequest httpServletRequest) {
        ArrayList<String> arrayList;
        Enumeration enumeration;
        Object object;
        CharSequence charSequence;
        this.baseRequest = httpServletRequest;
        this.catalinaRequest = request;
        this.coyoteRequest = request.getCoyoteRequest();
        Enumeration enumeration2 = httpServletRequest.getHeaderNames();
        while (enumeration2.hasMoreElements()) {
            charSequence = (String)enumeration2.nextElement();
            object = new ArrayList();
            this.headers.put((String)charSequence, (List<String>)object);
            enumeration = httpServletRequest.getHeaders((String)charSequence);
            while (enumeration.hasMoreElements()) {
                object.add(enumeration.nextElement());
            }
        }
        this.headers.remove("if-match");
        this.headers.remove("if-none-match");
        this.headers.remove("if-modified-since");
        this.headers.remove("if-unmodified-since");
        this.headers.remove("if-range");
        this.headers.remove("range");
        this.headers.remove("expect");
        this.headers.remove("authorization");
        this.headers.remove("referer");
        this.headers.remove("cookie");
        charSequence = httpServletRequest.getRequestURL();
        if (httpServletRequest.getQueryString() != null) {
            ((StringBuffer)charSequence).append('?');
            ((StringBuffer)charSequence).append(httpServletRequest.getQueryString());
        }
        this.addHeader("referer", ((StringBuffer)charSequence).toString());
        object = request.getContext();
        this.sessionCookieName = SessionConfig.getSessionCookieName((Context)object);
        this.sessionPathParameterName = SessionConfig.getSessionUriParamName((Context)object);
        enumeration = httpServletRequest.getSession(false);
        if (enumeration != null) {
            this.sessionId = enumeration.getId();
        }
        if (this.sessionId == null) {
            this.sessionId = httpServletRequest.getRequestedSessionId();
        }
        if (!httpServletRequest.isRequestedSessionIdFromCookie() && !httpServletRequest.isRequestedSessionIdFromURL() && this.sessionId != null) {
            arrayList = httpServletRequest.getServletContext().getEffectiveSessionTrackingModes();
            this.addSessionCookie = arrayList.contains(SessionTrackingMode.COOKIE);
            this.addSessionPathParameter = arrayList.contains(SessionTrackingMode.URL);
        } else {
            this.addSessionCookie = httpServletRequest.isRequestedSessionIdFromCookie();
            this.addSessionPathParameter = httpServletRequest.isRequestedSessionIdFromURL();
        }
        if (httpServletRequest.getCookies() != null) {
            this.cookies.addAll(Arrays.asList(httpServletRequest.getCookies()));
        }
        for (Cookie cookie : request.getResponse().getCookies()) {
            if (cookie.getMaxAge() < 0) {
                this.cookies.removeIf(cookie2 -> cookie2.getName().equals(cookie.getName()));
                continue;
            }
            this.cookies.add(new Cookie(cookie.getName(), cookie.getValue()));
        }
        if (this.cookies.size() > 0) {
            arrayList = new ArrayList<String>(1);
            arrayList.add(ApplicationPushBuilder.generateCookieHeader(this.cookies, request.getContext().getCookieProcessor()));
            this.headers.put("cookie", arrayList);
        }
        if (request.getPrincipal() != null) {
            if (enumeration == null || request.getSessionInternal(false).getPrincipal() == null || !(object.getAuthenticator() instanceof AuthenticatorBase) || !((AuthenticatorBase)object.getAuthenticator()).getCache()) {
                this.userName = request.getPrincipal().getName();
            }
            this.setHeader("authorization", "x-push");
        }
    }

    public PushBuilder path(String string) {
        if (string.startsWith("/")) {
            this.path = string;
        } else {
            String string2 = this.baseRequest.getContextPath();
            int n = string2.length() + string.length() + 1;
            StringBuilder stringBuilder = new StringBuilder(n);
            stringBuilder.append(string2);
            stringBuilder.append('/');
            stringBuilder.append(string);
            this.path = stringBuilder.toString();
        }
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public PushBuilder method(String string) {
        String string2 = string.trim().toUpperCase(Locale.ENGLISH);
        if (DISALLOWED_METHODS.contains(string2) || string2.length() == 0) {
            throw new IllegalArgumentException(sm.getString("applicationPushBuilder.methodInvalid", new Object[]{string2}));
        }
        if (!HttpParser.isToken((String)string2)) {
            throw new IllegalArgumentException(sm.getString("applicationPushBuilder.methodNotToken", new Object[]{string2}));
        }
        this.method = string;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public PushBuilder queryString(String string) {
        this.queryString = string;
        return this;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public PushBuilder sessionId(String string) {
        this.sessionId = string;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public PushBuilder addHeader(String string, String string2) {
        List<String> list = this.headers.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(string, list);
        }
        list.add(string2);
        return this;
    }

    public PushBuilder setHeader(String string, String string2) {
        List<String> list = this.headers.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(string, list);
        } else {
            list.clear();
        }
        list.add(string2);
        return this;
    }

    public PushBuilder removeHeader(String string) {
        this.headers.remove(string);
        return this;
    }

    public Set<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    public String getHeader(String string) {
        List<String> list = this.headers.get(string);
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    /*
     * WARNING - void declaration
     */
    public void push() {
        void var3_9;
        if (this.path == null) {
            throw new IllegalStateException(sm.getString("pushBuilder.noPath"));
        }
        org.apache.coyote.Request request = new org.apache.coyote.Request();
        request.method().setString(this.method);
        request.serverName().setString(this.baseRequest.getServerName());
        request.setServerPort(this.baseRequest.getServerPort());
        request.scheme().setString(this.baseRequest.getScheme());
        for (Map.Entry<String, List<String>> object2 : this.headers.entrySet()) {
            for (String string : object2.getValue()) {
                request.getMimeHeaders().addValue(object2.getKey()).setString(string);
            }
        }
        int n = this.path.indexOf(63);
        Object object = null;
        if (n > -1) {
            String string = this.path.substring(0, n);
            if (n + 1 < this.path.length()) {
                object = this.path.substring(n + 1);
            }
        } else {
            String string = this.path;
        }
        if (this.sessionId != null) {
            if (this.addSessionPathParameter) {
                void var3_7;
                String string = (String)var3_7 + ";" + this.sessionPathParameterName + "=" + this.sessionId;
                request.addPathParameter(this.sessionPathParameterName, this.sessionId);
            }
            if (this.addSessionCookie) {
                String string;
                string = this.sessionCookieName + "=" + this.sessionId;
                MessageBytes messageBytes = request.getMimeHeaders().getValue("cookie");
                if (messageBytes == null) {
                    messageBytes = request.getMimeHeaders().addValue("cookie");
                    messageBytes.setString(string);
                } else {
                    messageBytes.setString(messageBytes.getString() + ";" + string);
                }
            }
        }
        request.requestURI().setString((String)var3_9);
        request.decodedURI().setString(ApplicationPushBuilder.decode((String)var3_9, this.catalinaRequest.getConnector().getURICharset()));
        if (object == null && this.queryString != null) {
            request.queryString().setString(this.queryString);
        } else if (object != null && this.queryString == null) {
            request.queryString().setString((String)object);
        } else if (object != null && this.queryString != null) {
            request.queryString().setString((String)object + "&" + this.queryString);
        }
        if (this.userName != null) {
            request.getRemoteUser().setString(this.userName);
            request.setRemoteUserNeedsAuthorization(true);
        }
        this.coyoteRequest.action(ActionCode.PUSH_REQUEST, (Object)request);
        this.path = null;
        this.headers.remove("if-none-match");
        this.headers.remove("if-modified-since");
    }

    static String decode(String string, Charset charset) {
        int n = string.indexOf(37);
        int n2 = 0;
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        while (n != -1) {
            stringBuilder.append(string.substring(n2, n));
            for (n2 = n + 3; n2 < string.length() && string.charAt(n2) == '%'; n2 += 3) {
            }
            stringBuilder.append(ApplicationPushBuilder.decodePercentSequence(string.substring(n, n2), charset));
            n = string.indexOf(37, n2);
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    private static String decodePercentSequence(String string, Charset charset) {
        byte[] byArray = new byte[string.length() / 3];
        for (int i = 0; i < byArray.length; i += 3) {
            byArray[i] = (byte)((HexUtils.getDec((int)string.charAt(1 + 3 * i)) << 4) + HexUtils.getDec((int)string.charAt(2 + 3 * i)));
        }
        return new String(byArray, charset);
    }

    private static String generateCookieHeader(List<Cookie> list, CookieProcessor cookieProcessor) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Cookie cookie : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(';');
            }
            stringBuilder.append(cookieProcessor.generateHeader(cookie, null));
        }
        return stringBuilder.toString();
    }

    static {
        DISALLOWED_METHODS.add("POST");
        DISALLOWED_METHODS.add("PUT");
        DISALLOWED_METHODS.add("DELETE");
        DISALLOWED_METHODS.add("CONNECT");
        DISALLOWED_METHODS.add("OPTIONS");
        DISALLOWED_METHODS.add("TRACE");
    }
}

