/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui.actions;

import java.awt.event.ActionEvent;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.ui.actions.RenameConfigurator;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.openide.util.NbBundle;

class RenameDataSourceAction
extends SingleDataSourceAction<DataSource> {
    private static RenameDataSourceAction instance;

    public static synchronized RenameDataSourceAction instance() {
        if (instance == null) {
            instance = new RenameDataSourceAction();
        }
        return instance;
    }

    @Override
    protected void actionPerformed(DataSource dataSource, ActionEvent actionEvent) {
        RenameConfigurator configurator = RenameConfigurator.defineName(dataSource);
        if (configurator != null) {
            DataSourceDescriptorFactory.getDescriptor(dataSource).setName(configurator.getDisplayName());
        }
    }

    @Override
    protected boolean isEnabled(DataSource dataSource) {
        return DataSourceDescriptorFactory.getDescriptor(dataSource).supportsRename();
    }

    private RenameDataSourceAction() {
        super(DataSource.class);
        this.putValue("Name", NbBundle.getMessage(RenameDataSourceAction.class, (String)"LBL_Rename1"));
        this.putValue("ShortDescription", NbBundle.getMessage(RenameDataSourceAction.class, (String)"LBL_Rename"));
    }
}

