/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle.memory;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.sampler.truffle.TruffleDataProvider;
import org.graalvm.visualvm.sampler.truffle.cpu.ThreadInfoProvider;
import org.openide.util.NbBundle;

public final class MemoryHistogramProvider
extends TruffleDataProvider {
    public MemoryHistogramProvider(Application app) {
        this.status = this.initialize(app);
    }

    private String initialize(Application application) {
        String st = MemoryHistogramProvider.initJMXConn(application);
        if (st != null) {
            return st;
        }
        try {
            if (!this.checkAndLoadJMX(application)) {
                return NbBundle.getMessage(MemoryHistogramProvider.class, (String)"MSG_unavailable_threads", (Object)VisualVM.getInstance().getLogfileHandle());
            }
            if (!this.tbean.isHeapHistogramEnabled()) {
                return NbBundle.getMessage(MemoryHistogramProvider.class, (String)"MSG_unavailable_heaphisto");
            }
        }
        catch (SecurityException e) {
            LOGGER.log(Level.INFO, "MemoryHistogramProvider.initialize() throws SecurityException for " + application, e);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads", (Object)VisualVM.getInstance().getLogfileHandle());
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "MemoryHistogramProvider.initialize() throws Throwable for " + application, t);
            return NbBundle.getMessage(ThreadInfoProvider.class, (String)"MSG_unavailable_threads", (Object)VisualVM.getInstance().getLogfileHandle());
        }
        return null;
    }

    Map<String, Object>[] heapHistogram() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.tbean.heapHistogram();
    }
}

