/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Dimension;
import java.text.DecimalFormatSymbols;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DecimalNumberField
extends JTextField {
    public DecimalNumberField() {
        this(false);
    }

    public DecimalNumberField(boolean bl) {
        super(6);
        this.setDocument(new DecimalNumberDocument(bl));
    }

    public double getValue() {
        return DecimalNumberField.parseValue(this.getText());
    }

    public void setValue(double d) {
        this.setText("" + d);
    }

    private static double parseValue(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {}
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width < 50) {
            dimension.width = 50;
        }
        return dimension;
    }

    protected static class DecimalNumberDocument
    extends PlainDocument {
        private final boolean _allowNegative;
        private final char _decimalPoint;

        DecimalNumberDocument(boolean bl) {
            this._allowNegative = bl;
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            this._decimalPoint = decimalFormatSymbols.getDecimalSeparator();
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (!(!this._allowNegative && c == '-' || c != this._decimalPoint && "01234567890-".indexOf(c) < 0)) {
                    stringBuilder.append(c);
                }
                ++n2;
            }
            super.insertString(n, stringBuilder.toString(), attributeSet);
        }
    }
}

