
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>

QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "bookmarkstools_wrapper.h"

// inner classes

// Extra includes
#include <bookmarkitem.h>
#include <bookmarks.h>
#include <browserwindow.h>
#include <enhancedmenu.h>
#include <qobject.h>
#include <qurl.h>
#include <qwidget.h>
#include <tabwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_BookmarksTools_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::BookmarksTools >()))
        return -1;

    ::BookmarksTools *cptr{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // BookmarksTools()
            cptr = new ::BookmarksTools();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::BookmarksTools >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_BookmarksToolsFunc_addActionToMenu(PyObject *self, PyObject *args)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addActionToMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addActionToMenu(QObject*,Menu*,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_MENU_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[2])))) {
        overloadId = 0; // addActionToMenu(QObject*,Menu*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_addActionToMenu_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::Menu *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // addActionToMenu(QObject*,Menu*,BookmarkItem*)
            ::BookmarksTools::addActionToMenu(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksToolsFunc_addActionToMenu_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.addActionToMenu");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_addBookmarkDialog(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 4) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.BookmarksTools.addBookmarkDialog(): too many arguments");
        return {};
    } else if (numArgs < 3) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.BookmarksTools.addBookmarkDialog(): not enough arguments");
        return {};
    }

    if (!PyArg_ParseTuple(args, "|OOOO:addBookmarkDialog", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addBookmarkDialog(QWidget*,QUrl,QString,BookmarkItem*)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // addBookmarkDialog(QWidget*,QUrl,QString,BookmarkItem*)
        } else if ((pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[3])))) {
            overloadId = 0; // addBookmarkDialog(QWidget*,QUrl,QString,BookmarkItem*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_addBookmarkDialog_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *keyName = nullptr;
            PyObject *value = nullptr;
            keyName = Py_BuildValue("s","folder");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[3]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.BookmarksTools.addBookmarkDialog(): got multiple values for keyword argument 'folder'.");
                    return {};
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[3]))))
                        goto Sbk_BookmarksToolsFunc_addBookmarkDialog_TypeError;
                }
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local;
        ::QUrl *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::BookmarkItem *cppArg3 = 0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // addBookmarkDialog(QWidget*,QUrl,QString,BookmarkItem*)
            bool cppResult = ::BookmarksTools::addBookmarkDialog(cppArg0, *cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarksToolsFunc_addBookmarkDialog_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.addBookmarkDialog");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_addFolderContentsToMenu(PyObject *self, PyObject *args)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addFolderContentsToMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addFolderContentsToMenu(QObject*,Menu*,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_MENU_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[2])))) {
        overloadId = 0; // addFolderContentsToMenu(QObject*,Menu*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_addFolderContentsToMenu_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::Menu *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // addFolderContentsToMenu(QObject*,Menu*,BookmarkItem*)
            ::BookmarksTools::addFolderContentsToMenu(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksToolsFunc_addFolderContentsToMenu_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.addFolderContentsToMenu");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_addFolderToMenu(PyObject *self, PyObject *args)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addFolderToMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addFolderToMenu(QObject*,Menu*,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_MENU_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[2])))) {
        overloadId = 0; // addFolderToMenu(QObject*,Menu*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_addFolderToMenu_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::Menu *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // addFolderToMenu(QObject*,Menu*,BookmarkItem*)
            ::BookmarksTools::addFolderToMenu(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksToolsFunc_addFolderToMenu_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.addFolderToMenu");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_addSeparatorToMenu(PyObject *self, PyObject *args)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addSeparatorToMenu", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addSeparatorToMenu(Menu*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_MENU_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // addSeparatorToMenu(Menu*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_addSeparatorToMenu_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::Menu *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addSeparatorToMenu(Menu*,BookmarkItem*)
            ::BookmarksTools::addSeparatorToMenu(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksToolsFunc_addSeparatorToMenu_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.addSeparatorToMenu");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_addUrlToMenu(PyObject *self, PyObject *args)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addUrlToMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::addUrlToMenu(QObject*,Menu*,BookmarkItem*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_MENU_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[2])))) {
        overloadId = 0; // addUrlToMenu(QObject*,Menu*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_addUrlToMenu_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::Menu *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // addUrlToMenu(QObject*,Menu*,BookmarkItem*)
            ::BookmarksTools::addUrlToMenu(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksToolsFunc_addUrlToMenu_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.addUrlToMenu");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_bookmarkAllTabsDialog(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.BookmarksTools.bookmarkAllTabsDialog(): too many arguments");
        return {};
    } else if (numArgs < 2) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.BookmarksTools.bookmarkAllTabsDialog(): not enough arguments");
        return {};
    }

    if (!PyArg_ParseTuple(args, "|OOO:bookmarkAllTabsDialog", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::bookmarkAllTabsDialog(QWidget*,TabWidget*,BookmarkItem*)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_TABWIDGET_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // bookmarkAllTabsDialog(QWidget*,TabWidget*,BookmarkItem*)
        } else if ((pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[2])))) {
            overloadId = 0; // bookmarkAllTabsDialog(QWidget*,TabWidget*,BookmarkItem*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_bookmarkAllTabsDialog_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *keyName = nullptr;
            PyObject *value = nullptr;
            keyName = Py_BuildValue("s","folder");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[2]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.BookmarksTools.bookmarkAllTabsDialog(): got multiple values for keyword argument 'folder'.");
                    return {};
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[2]))))
                        goto Sbk_BookmarksToolsFunc_bookmarkAllTabsDialog_TypeError;
                }
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::TabWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::BookmarkItem *cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // bookmarkAllTabsDialog(QWidget*,TabWidget*,BookmarkItem*)
            bool cppResult = ::BookmarksTools::bookmarkAllTabsDialog(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarksToolsFunc_bookmarkAllTabsDialog_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.bookmarkAllTabsDialog");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_editBookmarkDialog(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "editBookmarkDialog", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::editBookmarkDialog(QWidget*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // editBookmarkDialog(QWidget*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_editBookmarkDialog_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // editBookmarkDialog(QWidget*,BookmarkItem*)
            bool cppResult = ::BookmarksTools::editBookmarkDialog(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarksToolsFunc_editBookmarkDialog_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.editBookmarkDialog");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_migrateBookmarksIfNecessary(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static BookmarksTools::migrateBookmarksIfNecessary(Bookmarks*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX]), (pyArg)))) {
        overloadId = 0; // migrateBookmarksIfNecessary(Bookmarks*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_migrateBookmarksIfNecessary_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Bookmarks *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // migrateBookmarksIfNecessary(Bookmarks*)
            bool cppResult = ::BookmarksTools::migrateBookmarksIfNecessary(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_BookmarksToolsFunc_migrateBookmarksIfNecessary_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.BookmarksTools.migrateBookmarksIfNecessary");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_openBookmark(PyObject *self, PyObject *args)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "openBookmark", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::openBookmark(BrowserWindow*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BROWSERWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // openBookmark(BrowserWindow*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_openBookmark_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // openBookmark(BrowserWindow*,BookmarkItem*)
            ::BookmarksTools::openBookmark(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksToolsFunc_openBookmark_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.openBookmark");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_openBookmarkInNewPrivateWindow(PyObject *self, PyObject *pyArg)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static BookmarksTools::openBookmarkInNewPrivateWindow(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // openBookmarkInNewPrivateWindow(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_openBookmarkInNewPrivateWindow_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // openBookmarkInNewPrivateWindow(BookmarkItem*)
            ::BookmarksTools::openBookmarkInNewPrivateWindow(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksToolsFunc_openBookmarkInNewPrivateWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.BookmarksTools.openBookmarkInNewPrivateWindow");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_openBookmarkInNewTab(PyObject *self, PyObject *args)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "openBookmarkInNewTab", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::openBookmarkInNewTab(BrowserWindow*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BROWSERWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // openBookmarkInNewTab(BrowserWindow*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_openBookmarkInNewTab_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // openBookmarkInNewTab(BrowserWindow*,BookmarkItem*)
            ::BookmarksTools::openBookmarkInNewTab(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksToolsFunc_openBookmarkInNewTab_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.openBookmarkInNewTab");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_openBookmarkInNewWindow(PyObject *self, PyObject *pyArg)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static BookmarksTools::openBookmarkInNewWindow(BookmarkItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // openBookmarkInNewWindow(BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_openBookmarkInNewWindow_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BookmarkItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // openBookmarkInNewWindow(BookmarkItem*)
            ::BookmarksTools::openBookmarkInNewWindow(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksToolsFunc_openBookmarkInNewWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.BookmarksTools.openBookmarkInNewWindow");
        return {};
}

static PyObject *Sbk_BookmarksToolsFunc_openFolderInTabs(PyObject *self, PyObject *args)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "openFolderInTabs", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static BookmarksTools::openFolderInTabs(BrowserWindow*,BookmarkItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BROWSERWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // openFolderInTabs(BrowserWindow*,BookmarkItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_BookmarksToolsFunc_openFolderInTabs_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::BookmarkItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // openFolderInTabs(BrowserWindow*,BookmarkItem*)
            ::BookmarksTools::openFolderInTabs(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_BookmarksToolsFunc_openFolderInTabs_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.BookmarksTools.openFolderInTabs");
        return {};
}


static const char *Sbk_BookmarksTools_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_BookmarksTools_methods[] = {
    {"addActionToMenu", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addActionToMenu), METH_VARARGS|METH_STATIC},
    {"addBookmarkDialog", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addBookmarkDialog), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"addFolderContentsToMenu", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addFolderContentsToMenu), METH_VARARGS|METH_STATIC},
    {"addFolderToMenu", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addFolderToMenu), METH_VARARGS|METH_STATIC},
    {"addSeparatorToMenu", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addSeparatorToMenu), METH_VARARGS|METH_STATIC},
    {"addUrlToMenu", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_addUrlToMenu), METH_VARARGS|METH_STATIC},
    {"bookmarkAllTabsDialog", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_bookmarkAllTabsDialog), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"editBookmarkDialog", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_editBookmarkDialog), METH_VARARGS|METH_STATIC},
    {"migrateBookmarksIfNecessary", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_migrateBookmarksIfNecessary), METH_O|METH_STATIC},
    {"openBookmark", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_openBookmark), METH_VARARGS|METH_STATIC},
    {"openBookmarkInNewPrivateWindow", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_openBookmarkInNewPrivateWindow), METH_O|METH_STATIC},
    {"openBookmarkInNewTab", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_openBookmarkInNewTab), METH_VARARGS|METH_STATIC},
    {"openBookmarkInNewWindow", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_openBookmarkInNewWindow), METH_O|METH_STATIC},
    {"openFolderInTabs", reinterpret_cast<PyCFunction>(Sbk_BookmarksToolsFunc_openFolderInTabs), METH_VARARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_BookmarksTools_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_BookmarksTools_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_BookmarksTools_Type = nullptr;
static SbkObjectType *Sbk_BookmarksTools_TypeF(void)
{
    return _Sbk_BookmarksTools_Type;
}

static PyType_Slot Sbk_BookmarksTools_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_BookmarksTools_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_BookmarksTools_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_BookmarksTools_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_BookmarksTools_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_BookmarksTools_spec = {
    "1:PyFalkon.BookmarksTools",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_BookmarksTools_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void BookmarksTools_PythonToCpp_BookmarksTools_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_BookmarksTools_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_BookmarksTools_PythonToCpp_BookmarksTools_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_BookmarksTools_TypeF())))
        return BookmarksTools_PythonToCpp_BookmarksTools_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *BookmarksTools_PTR_CppToPython_BookmarksTools(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::BookmarksTools *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_BookmarksTools_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *BookmarksTools_SignatureStrings[] = {
    "PyFalkon.BookmarksTools(self)",
    "PyFalkon.BookmarksTools.addActionToMenu(receiver:PySide2.QtCore.QObject,menu:PyFalkon.Menu,item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.addBookmarkDialog(parent:PySide2.QtWidgets.QWidget,url:PySide2.QtCore.QUrl,title:QString,folder:PyFalkon.BookmarkItem=0)->bool",
    "PyFalkon.BookmarksTools.addFolderContentsToMenu(receiver:PySide2.QtCore.QObject,menu:PyFalkon.Menu,folder:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.addFolderToMenu(receiver:PySide2.QtCore.QObject,menu:PyFalkon.Menu,folder:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.addSeparatorToMenu(menu:PyFalkon.Menu,separator:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.addUrlToMenu(receiver:PySide2.QtCore.QObject,menu:PyFalkon.Menu,bookmark:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.bookmarkAllTabsDialog(parent:PySide2.QtWidgets.QWidget,tabWidget:PyFalkon.TabWidget,folder:PyFalkon.BookmarkItem=0)->bool",
    "PyFalkon.BookmarksTools.editBookmarkDialog(parent:PySide2.QtWidgets.QWidget,item:PyFalkon.BookmarkItem)->bool",
    "PyFalkon.BookmarksTools.migrateBookmarksIfNecessary(bookmarks:PyFalkon.Bookmarks)->bool",
    "PyFalkon.BookmarksTools.openBookmark(window:PyFalkon.BrowserWindow,item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.openBookmarkInNewPrivateWindow(item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.openBookmarkInNewTab(window:PyFalkon.BrowserWindow,item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.openBookmarkInNewWindow(item:PyFalkon.BookmarkItem)",
    "PyFalkon.BookmarksTools.openFolderInTabs(window:PyFalkon.BrowserWindow,folder:PyFalkon.BookmarkItem)",
    nullptr}; // Sentinel

void init_BookmarksTools(PyObject *module)
{
    _Sbk_BookmarksTools_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "BookmarksTools",
        "BookmarksTools*",
        &Sbk_BookmarksTools_spec,
        &Shiboken::callCppDestructor< ::BookmarksTools >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_BookmarksTools_Type);
    InitSignatureStrings(pyType, BookmarksTools_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_BookmarksTools_Type), Sbk_BookmarksTools_PropertyStrings);
    SbkPyFalkonTypes[SBK_BOOKMARKSTOOLS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_BookmarksTools_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_BookmarksTools_TypeF(),
        BookmarksTools_PythonToCpp_BookmarksTools_PTR,
        is_BookmarksTools_PythonToCpp_BookmarksTools_PTR_Convertible,
        BookmarksTools_PTR_CppToPython_BookmarksTools);

    Shiboken::Conversions::registerConverterName(converter, "BookmarksTools");
    Shiboken::Conversions::registerConverterName(converter, "BookmarksTools*");
    Shiboken::Conversions::registerConverterName(converter, "BookmarksTools&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::BookmarksTools).name());



}
