// services/viz/public/mojom/compositing/copy_output_request.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/copy_output_request.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/copy_output_request.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
CopyOutputRequest::CopyOutputRequest()
    : result_format(),
      scale_from(),
      scale_to(),
      source(),
      area(),
      result_selection(),
      result_sender() {}

CopyOutputRequest::CopyOutputRequest(
    ::viz::mojom::CopyOutputResultFormat result_format_in,
    const ::gfx::Vector2d& scale_from_in,
    const ::gfx::Vector2d& scale_to_in,
    const base::Optional<::base::UnguessableToken>& source_in,
    const base::Optional<::gfx::Rect>& area_in,
    const base::Optional<::gfx::Rect>& result_selection_in,
    ::mojo::PendingRemote<CopyOutputResultSender> result_sender_in)
    : result_format(std::move(result_format_in)),
      scale_from(std::move(scale_from_in)),
      scale_to(std::move(scale_to_in)),
      source(std::move(source_in)),
      area(std::move(area_in)),
      result_selection(std::move(result_selection_in)),
      result_sender(std::move(result_sender_in)) {}

CopyOutputRequest::~CopyOutputRequest() = default;

void CopyOutputRequest::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("result_format", base::trace_event::ValueToString(this->result_format));
  value->SetString("scale_from", base::trace_event::ValueToString(this->scale_from, "<value of type const ::gfx::Vector2d&>"));
  value->SetString("scale_to", base::trace_event::ValueToString(this->scale_to, "<value of type const ::gfx::Vector2d&>"));
  value->SetString("source", base::trace_event::ValueToString(this->source, "<value of type const base::Optional<::base::UnguessableToken>&>"));
  value->SetString("area", base::trace_event::ValueToString(this->area, "<value of type const base::Optional<::gfx::Rect>&>"));
  value->SetString("result_selection", base::trace_event::ValueToString(this->result_selection, "<value of type const base::Optional<::gfx::Rect>&>"));
  value->SetBoolean("result_sender", this->result_sender.is_valid());
}

bool CopyOutputRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char CopyOutputResultSender::Name_[] = "viz.mojom.CopyOutputResultSender";

CopyOutputResultSenderProxy::CopyOutputResultSenderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CopyOutputResultSenderProxy::SendResult(
    ::std::unique_ptr<::viz::CopyOutputResult> in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CopyOutputResultSender::SendResult", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type ::std::unique_ptr<::viz::CopyOutputResult>>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCopyOutputResultSender_SendResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CopyOutputResultSender_SendResult_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::viz::mojom::CopyOutputResultDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in CopyOutputResultSender.SendResult request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CopyOutputResultSender::Name_);
  message.set_method_name("SendResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CopyOutputResultSenderStubDispatch::Accept(
    CopyOutputResultSender* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCopyOutputResultSender_SendResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CopyOutputResultSender::SendResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CopyOutputResultSender::SendResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CopyOutputResultSender_SendResult_Params_Data* params =
          reinterpret_cast<internal::CopyOutputResultSender_SendResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::std::unique_ptr<::viz::CopyOutputResult> p_result{};
      CopyOutputResultSender_SendResult_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CopyOutputResultSender::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendResult(
std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool CopyOutputResultSenderStubDispatch::AcceptWithResponder(
    CopyOutputResultSender* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCopyOutputResultSender_SendResult_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCopyOutputResultSenderValidationInfo[] = {
    {internal::kCopyOutputResultSender_SendResult_Name,
     {&internal::CopyOutputResultSender_SendResult_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CopyOutputResultSenderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::CopyOutputResultSender::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCopyOutputResultSenderValidationInfo);
}

}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::CopyOutputRequest::DataView, ::viz::mojom::CopyOutputRequestPtr>::Read(
    ::viz::mojom::CopyOutputRequest::DataView input,
    ::viz::mojom::CopyOutputRequestPtr* output) {
  bool success = true;
  ::viz::mojom::CopyOutputRequestPtr result(::viz::mojom::CopyOutputRequest::New());
  
      if (success && !input.ReadResultFormat(&result->result_format))
        success = false;
      if (success && !input.ReadScaleFrom(&result->scale_from))
        success = false;
      if (success && !input.ReadScaleTo(&result->scale_to))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success && !input.ReadArea(&result->area))
        success = false;
      if (success && !input.ReadResultSelection(&result->result_selection))
        success = false;
      if (success) {
        result->result_sender =
            input.TakeResultSender<decltype(result->result_sender)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif