
#line 337 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

#include "repparser.h"

#include <QCryptographicHash>
#include <QDebug>
#include <QTextStream>

// for normalizeTypeInternal
#include <private/qmetaobject_p.h>
#include <private/qmetaobject_moc_p.h>

// Code copied from moc.cpp
// We cannot depend on QMetaObject::normalizedSignature,
// since repc is linked against Qt5Bootstrap (which doesn't offer QMetaObject) when cross-compiling
// Thus, just use internal API which is exported in private headers, as moc does
static QByteArray normalizeType(const QByteArray &ba)
{
    const char *s = ba.constData();
    int len = ba.size();
    char stackbuf[64];
    char *buf = (len >= 64 ? new char[len + 1] : stackbuf);
    char *d = buf;
    char last = 0;
    while (*s && is_space(*s))
        s++;
    while (*s) {
        while (*s && !is_space(*s))
            last = *d++ = *s++;
        while (*s && is_space(*s))
            s++;
        if (*s && ((is_ident_char(*s) && is_ident_char(last))
                   || ((*s == ':') && (last == '<')))) {
            last = *d++ = ' ';
        }
    }
    *d = '\0';
    QByteArray result = normalizeTypeInternal(buf, d);
    if (buf != stackbuf)
        delete [] buf;
    return result;
}

SignedType::SignedType(const QString &name) : name(name)
{
}

void SignedType::generateSignature(AST &ast)
{
    QCryptographicHash checksum(QCryptographicHash::Sha1);
    signature_impl(ast, checksum);
    ast.typeSignatures[typeName()] = checksum.result().toHex();
}

QString SignedType::typeName() const
{
    return name;
}

ASTProperty::ASTProperty()
    : modifier(ReadPush), persisted(false), isPointer(false)
{
}

ASTProperty::ASTProperty(const QString &type, const QString &name, const QString &defaultValue, Modifier modifier, bool persisted, bool isPointer)
    : type(type), name(name), defaultValue(defaultValue), modifier(modifier), persisted(persisted), isPointer(isPointer)
{
}

QString ASTDeclaration::asString(bool withName) const
{
    QString str;
    if (variableType & ASTDeclaration::Constant)
        str += QLatin1String("const ");
    str += type;
    if (variableType & ASTDeclaration::Reference)
        str += QLatin1String(" &");
    if (withName)
        str += QString::fromLatin1(" %1").arg(name);
    return str;
}

ASTFunction::ASTFunction(const QString &name, const QString &returnType)
    : returnType(returnType), name(name)
{
}

QString ASTFunction::paramsAsString(ParamsAsStringFormat format) const
{
    QString str;
    for (const ASTDeclaration &param : params) {
        QString paramStr = param.asString(format != Normalized);
        if (format == Normalized) {
            paramStr = QString::fromLatin1(::normalizeType(paramStr.toLatin1().constData()));
            str += paramStr + QLatin1Char(',');
        } else {
            str += paramStr + QLatin1String(", ");
        }
    }

    str.chop((format == Normalized ? 1 : 2)); // chop trailing ',' or ', '

    return str;
}

QStringList ASTFunction::paramNames() const
{
    QStringList names;
    names.reserve(params.size());
    for (const ASTDeclaration &param : params)
        names << param.name;
    return names;
}

ASTEnum::ASTEnum(const QString &name)
    : SignedType(name), isSigned(false), isScoped(false), max(0)
{
}

void ASTEnum::signature_impl(const AST &ast, QCryptographicHash &checksum)
{
    Q_UNUSED(ast)
    checksum.addData(name.toLatin1());
    if (isScoped)
        checksum.addData("class", qstrlen("class"));
    if (!type.isEmpty())
        checksum.addData(type.toLatin1());
    for (const ASTEnumParam &param : params) {
        checksum.addData(param.name.toLatin1());
        checksum.addData(QByteArray::number(param.value));
    }
}

QString ASTEnum::typeName() const
{
    if (scope.isEmpty())
        return name;

    return QLatin1String("%1::%2").arg(scope, name);
}

ASTFlag::ASTFlag(const QString &name, const QString &_enum)
    : SignedType(name), _enum(_enum)
{
}

void ASTFlag::signature_impl(const AST &ast, QCryptographicHash &checksum)
{
    checksum.addData(name.toLatin1());
    checksum.addData(ast.typeData(_enum, scope));
}

QString ASTFlag::typeName() const
{
    if (scope.isEmpty())
        return name;

    return QLatin1String("%1::%2").arg(scope, name);
}

bool ASTFlag::isValid() const
{
    return !name.isEmpty();
}

void ASTModel::signature_impl(const AST &ast, QCryptographicHash &checksum)
{
    Q_UNUSED(ast)
    QByteArrayList _roles;
    for (const auto &role : roles)
        _roles << role.name.toLatin1();
    std::sort(_roles.begin(), _roles.end());
    checksum.addData(_roles.join('_'));
}

QString ASTModel::typeName() const
{
    return QLatin1String("%1::%2").arg(scope, name);
}

ASTClass::ASTClass(const QString &name)
    : SignedType(name), hasPersisted(false)
{
}

void ASTClass::signature_impl(const AST &ast, QCryptographicHash &checksum)
{
    checksum.addData(name.toLatin1());

    // Checksum properties
    QSet<int> classIndices{ subClassPropertyIndices.begin(),
                            subClassPropertyIndices.end() };
    int propertyIndex = -1;
    int modelIndex = 0;
    for (const ASTProperty &p : properties) {
        propertyIndex++;
        checksum.addData(p.name.toLatin1());
        if (p.type == QLatin1String("QAbstractItemModel"))
            checksum.addData(ast.typeSignatures[modelMetadata[modelIndex++].typeName()]);
        else if (classIndices.contains(propertyIndex))
            checksum.addData(ast.typeSignatures[p.type]);
        else
            checksum.addData(ast.typeData(p.type, name));
        ASTProperty::Modifier m = p.modifier;
        // Treat ReadOnly and SourceOnlySetter the same (interface-wise they are)
        if (m == ASTProperty::SourceOnlySetter)
            m = ASTProperty::ReadOnly;
        checksum.addData(reinterpret_cast<const char *>(&m), sizeof(m));
    }

    // Checksum signals
    checksum.addData(ast.functionsData(signalsList, name));

    // Checksum slots
    checksum.addData(ast.functionsData(slotsList, name));
}

void POD::signature_impl(const AST &ast, QCryptographicHash &checksum)
{
    checksum.addData(name.toLatin1());
    for (const PODAttribute &attr : attributes) {
        checksum.addData(attr.name.toLatin1());
        checksum.addData(ast.typeData(attr.type, name));
    }
}

bool ASTClass::isValid() const
{
    return !name.isEmpty();
}

bool ASTClass::hasPointerObjects() const
{
    int count = modelMetadata.size() + subClassPropertyIndices.size();
    return count > 0;
}

QByteArray AST::typeData(const QString &type, const QString &className) const
{
    static const QRegularExpression re = QRegularExpression(QLatin1String("([^<>,\\s]+)"));
    if (type.contains(QLatin1Char('<'))) { // templated type
        QByteArray result;
        for (const QRegularExpressionMatch &match : re.globalMatch(type))
            result += typeData(match.captured(1), className);
        return result;
    }
    // Try enum/flags within the class first
    if (!className.isEmpty()) {
        auto classType = QLatin1String("%1::%2").arg(className, type);
        auto it = typeSignatures.find(classType);
        if (it != typeSignatures.end())
            return it.value();
    }
    auto it = typeSignatures.find(type);
    if (it != typeSignatures.end())
        return it.value();
    const auto pos = type.lastIndexOf(QLatin1String("::"));
    if (pos > 0)
        return typeData(type.mid(pos + 2), className);
    return type.toLatin1();
}

QByteArray AST::functionsData(const QList<ASTFunction> &functions, const QString &className) const
{
    QByteArray ret;
    for (const ASTFunction &func : functions) {
        ret += func.name.toLatin1();
        for (const ASTDeclaration &param : func.params) {
            ret += param.name.toLatin1();
            ret += typeData(param.type, className);
            ret += QByteArray(reinterpret_cast<const char *>(&param.variableType),
                              sizeof(param.variableType));
        }
        ret += typeData(func.returnType, className);
    }
    return ret;
}

RepParser::RepParser(QIODevice &outputDevice)
    : QRegexParser(), m_astEnumValue(-1)
{
    setBufferFromDevice(&outputDevice);
}

void RepParser::reset()
{
    m_ast = AST();
    m_astClass = ASTClass();
    m_astPod = POD();
    m_argString.clear();
    m_astEnum = ASTEnum();
    //setDebug();
}

bool RepParser::parseModifierFlag(const QString &flag, ASTProperty::Modifier &modifier, bool &persisted)
{
    QRegularExpression regex(QStringLiteral("\\s*,\\s*"));
    QStringList flags = flag.split(regex);
    persisted = flags.removeAll(QStringLiteral("PERSISTED")) > 0;
    if (flags.length() == 0)
        return true;
    if (flags.length() > 1) {
        // Only valid combination is "READONLY" and "CONSTANT"
        if (flags.length() == 2 && flags.contains(QStringLiteral("READONLY")) &&
            flags.contains(QStringLiteral("CONSTANT"))) {
            // If we have READONLY and CONSTANT that means CONSTANT
            modifier = ASTProperty::Constant;
            return true;
        } else {
            setErrorString(QLatin1String("Invalid property declaration: combination not allowed (%1)").arg(flag));
            return false;
        }
    }
    const QString &f = flags.at(0);
    if (f == QLatin1String("READONLY"))
        modifier = ASTProperty::ReadOnly;
    else if (f == QLatin1String("CONSTANT"))
        modifier = ASTProperty::Constant;
    else if (f == QLatin1String("READPUSH"))
        modifier = ASTProperty::ReadPush;
    else if (f == QLatin1String("READWRITE"))
        modifier = ASTProperty::ReadWrite;
    else if (f == QLatin1String("SOURCEONLYSETTER"))
        modifier = ASTProperty::SourceOnlySetter;
    else {
        setErrorString(QLatin1String("Invalid property declaration: flag %1 is unknown").arg(flag));
        return false;
    }

    return true;
}

QString stripArgs(const QString &arguments)
{
    // This repc parser searches for the longest possible matches, which can be multiline.
    // This method "cleans" the string input, removing comments and converting to a single
    // line for subsequent parsing.
    QStringList lines = arguments.split(QRegularExpression(QStringLiteral("\r?\n")));
    for (auto & line : lines)
        line.replace(QRegularExpression(QStringLiteral("//.*")),QString());
    return lines.join(QString());
}

bool RepParser::parseProperty(ASTClass &astClass, const QString &propertyDeclaration)
{
    QString input = stripArgs(propertyDeclaration).trimmed();
    const QRegularExpression whitespace(QStringLiteral("\\s"));

    QString propertyType;
    QString propertyName;
    QString propertyDefaultValue;
    ASTProperty::Modifier propertyModifier = ASTProperty::ReadPush;
    bool persisted = false;

    // parse type declaration which could be a nested template as well
    bool inTemplate = false;
    int templateDepth = 0;
    int nameIndex = -1;

    for (int i = 0; i < input.size(); ++i) {
        const QChar inputChar(input.at(i));
        if (inputChar == QLatin1Char('<')) {
            propertyType += inputChar;
            inTemplate = true;
            ++templateDepth;
        } else if (inputChar == QLatin1Char('>')) {
            propertyType += inputChar;
            --templateDepth;
            if (templateDepth == 0)
                inTemplate = false;
        } else if (inputChar.isSpace()) {
            if (!inTemplate) {
                nameIndex = i;
                break;
            } else {
                propertyType += inputChar;
            }
        } else {
            propertyType += inputChar;
        }
    }

    if (nameIndex == -1) {
        setErrorString(QLatin1String("PROP: Invalid property declaration: %1").arg(propertyDeclaration));
        return false;
    }

    // parse the name of the property
    input = input.mid(nameIndex).trimmed();

    const int equalSignIndex = input.indexOf(QLatin1Char('='));
    if (equalSignIndex != -1) { // we have a default value
        propertyName = input.left(equalSignIndex).trimmed();

        input = input.mid(equalSignIndex + 1).trimmed();
        const int lastQuoteIndex = input.lastIndexOf(QLatin1Char('"'));
        if (lastQuoteIndex != -1) {
            propertyDefaultValue = input.left(lastQuoteIndex + 1);
            input = input.mid(lastQuoteIndex + 1);
        }
        const int whitespaceIndex = input.indexOf(whitespace);
        if (whitespaceIndex == -1) { // no flag given
            if (propertyDefaultValue.isEmpty())
                propertyDefaultValue = input;
            propertyModifier = ASTProperty::ReadPush;
        } else { // flag given
            if (propertyDefaultValue.isEmpty())
                propertyDefaultValue = input.left(whitespaceIndex).trimmed();

            const QString flag = input.mid(whitespaceIndex + 1).trimmed();
            if (!parseModifierFlag(flag, propertyModifier, persisted))
                return false;
        }
    } else { // there is no default value
        const int whitespaceIndex = input.indexOf(whitespace);
        if (whitespaceIndex == -1) { // no flag given
            propertyName = input;
            propertyModifier = ASTProperty::ReadPush;
        } else { // flag given
            propertyName = input.left(whitespaceIndex).trimmed();

            const QString flag = input.mid(whitespaceIndex + 1).trimmed();
            if (!parseModifierFlag(flag, propertyModifier, persisted))
                return false;
        }
    }

    astClass.properties << ASTProperty(propertyType, propertyName, propertyDefaultValue, propertyModifier, persisted);
    if (persisted)
        astClass.hasPersisted = true;
    return true;
}

bool RepParser::parseRoles(ASTModel &astModel, const QString &modelRoles)
{
    const QString input = modelRoles.trimmed();

    if (input.isEmpty())
        return true;

    const QStringList roleStrings = input.split(QChar(QLatin1Char(',')));
    for (auto role : roleStrings)
        astModel.roles << ASTModelRole(role.trimmed());
    return true;
}

AST RepParser::ast() const
{
    return m_ast;
}

void RepParser::TypeParser::parseArguments(const QString &arguments)
{
    const QString strippedArgs = stripArgs(arguments);
    int templateDepth = 0;
    bool inTemplate = false;
    bool inVariable = false;
    QString propertyType;
    QString variableName;
    ASTDeclaration::VariableTypes variableType = ASTDeclaration::None;
    int variableNameIndex = 0;
    for (int i = 0; i < strippedArgs.size(); ++i) {
        const QChar inputChar(strippedArgs.at(i));
        if (inputChar == QLatin1Char('<')) {
            propertyType += inputChar;
            inTemplate = true;
            ++templateDepth;
        } else if (inputChar == QLatin1Char('>')) {
            propertyType += inputChar;
            --templateDepth;
            if (templateDepth == 0)
                inTemplate = false;
        } else if (inputChar.isSpace()) {
            if (inTemplate)
                propertyType += inputChar;
            else if (!propertyType.isEmpty()) {
                if (propertyType == QLatin1String("const")) {
                    propertyType.clear();
                    variableType |= ASTDeclaration::Constant;
                } else {
                    inVariable = true;
                }
            }
        } else if (inputChar == QLatin1Char('&')) {
            variableType |= ASTDeclaration::Reference;
        } else if (inputChar == QLatin1Char(',')) {
            if (!inTemplate) {
                RepParser::TypeParser::generateFunctionParameter(variableName, propertyType, variableNameIndex, variableType);
                propertyType.clear();
                variableName.clear();
                variableType = ASTDeclaration::None;
                inVariable = false;
            } else {
                propertyType += inputChar;
            }
        } else {
            if (inVariable)
                variableName += inputChar;
            else
                propertyType += inputChar;
        }
    }
    if (!propertyType.isEmpty()) {
        RepParser::TypeParser::generateFunctionParameter(variableName, propertyType, variableNameIndex, variableType);
    }
}

void RepParser::TypeParser::generateFunctionParameter(QString variableName, const QString &propertyType, int &variableNameIndex, ASTDeclaration::VariableTypes variableType)
{
    if (!variableName.isEmpty())
        variableName = variableName.trimmed();
    else
        variableName = QString::fromLatin1("__repc_variable_%1").arg(++variableNameIndex);
    arguments.append(ASTDeclaration(propertyType, variableName, variableType));
}

void RepParser::TypeParser::appendParams(ASTFunction &slot)
{
    for (const ASTDeclaration &arg : qAsConst(arguments))
        slot.params << arg;
}

void RepParser::TypeParser::appendPods(POD &pods)
{
    for (const ASTDeclaration &arg : qAsConst(arguments)) {
        PODAttribute attr;
        attr.type = arg.type;
        attr.name = arg.name;
        pods.attributes.append(qMove(attr));
    }
}

bool RepParser::consumeRule(int ruleno)
{
    if (isDebug()) {
        qDebug() << "consumeRule:" << ruleno << spell[rule_info[rule_index[ruleno]]];
    }
    switch (ruleno) {

#line 892 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 25:
    {
        m_astEnum.generateSignature(m_ast);
        m_ast.enums.append(m_astEnum);
    }
    break;

#line 907 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 31:
    {
        m_ast.preprocessorDirectives.append(captured().value(QStringLiteral("preprocessor_directive")));
    }
    break;

#line 916 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 32:
    {
        POD pod;
        pod.name = captured().value(QStringLiteral("name")).trimmed();

        const QString argString = captured().value(QLatin1String("types")).trimmed();
        if (argString.isEmpty()) {
            qWarning() << "[repc] - Ignoring POD with no data members.  POD name: " << qPrintable(pod.name);
            return true;
        }
        if (argString.contains(QLatin1String("ENUM"))) {
            setErrorString(QLatin1String("ENUMs are only available in PODs using bracket syntax ('{'), not parentheses"));
            return false;
        }

        RepParser::TypeParser parseType;
        parseType.parseArguments(argString);
        parseType.appendPods(pod);
        pod.generateSignature(m_ast);
        m_ast.pods.append(pod);
    }
    break;

#line 942 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 33:

#line 946 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 34:

#line 950 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 35:
    {
        m_astClass.generateSignature(m_ast);
        m_ast.classes.append(m_astClass);
    }
    break;

#line 962 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 45:
    {
        m_astEnum.scope = m_astClass.name;
        m_astEnum.generateSignature(m_ast);
        m_astClass.enums.append(m_astEnum);
    }
    break;

#line 973 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 46:

#line 977 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 47:

#line 981 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 48:
    {
        RepParser::TypeParser parseType;
        parseType.parseArguments(m_argString);
        parseType.appendPods(m_astPod);
        m_astPod.generateSignature(m_ast);
        m_ast.pods.append(m_astPod);
    }
    break;

#line 996 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 56:
    {
        m_astEnum.generateSignature(m_ast);
        m_astPod.enums.append(m_astEnum);
    }
    break;

#line 1015 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 66:
    {
        m_argString += m_symbol;
    }
    break;

#line 1024 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 67:
    {
        m_argString += QLatin1Char('<');
    }
    break;

#line 1033 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 68:
    {
        m_argString += QLatin1Char('>');
    }
    break;

#line 1042 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 69:
    {
        m_argString += captured().value(QLatin1String("value")).trimmed() + QLatin1Char(' ');
    }
    break;

#line 1051 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 70:
    {
        m_argString += QLatin1Char(' ') + captured().value(QLatin1String("value")).trimmed();
    }
    break;

#line 1062 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 73:

#line 1066 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 74:
    {
        m_argString += QLatin1Char(',');
    }
    break;

#line 1075 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 75:
    {
        m_argString += m_symbol;
    }
    break;

#line 1084 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 76:
    {
        m_argString += QLatin1Char(' ') + m_symbol;
    }
    break;

#line 1109 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 117:
    {
        const QString name = captured().value(QLatin1String("name"));
        const QString type = captured().value(QLatin1String("type"));
        const QString _class = captured().value(QLatin1String("class"));

        // new Class declaration
        m_astEnum = ASTEnum(name);
        if (!_class.isEmpty())
            m_astEnum.isScoped = true;
        if (!type.isEmpty())
            m_astEnum.type = type;
        m_astEnumValue = -1;
    }
    break;

#line 1130 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 120:
    {
        ASTEnumParam param;
        param.name = m_symbol;
        param.value = ++m_astEnumValue;
        if (m_astEnum.max < param.value)
            m_astEnum.max = param.value;
        m_astEnum.params << param;
    }
    break;

#line 1144 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 121:
    {
        ASTEnumParam param;
        param.name = m_symbol;
        param.value = m_astEnumValue;
        if (param.value < 0) {
            m_astEnum.isSigned = true;
            if (m_astEnum.max < -param.value)
                m_astEnum.max = -param.value;
        } else if (m_astEnum.max < param.value)
            m_astEnum.max = param.value;
        m_astEnum.params << param;
    }
    break;

#line 1162 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 122:
    {
        m_symbol = captured().value(QStringLiteral("symbol")).trimmed();
    }
    break;

#line 1171 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 123:
    {
        QString value = captured().value(QStringLiteral("value")).trimmed();
        if (value.startsWith(QLatin1String("0x"), Qt::CaseInsensitive))
            m_astEnumValue = value.toInt(0,16);
        else
            m_astEnumValue = value.toInt();
    }
    break;

#line 1184 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 124:
    {
        const QString name = captured().value(QLatin1String("name"));
        const QString _enum = captured().value(QLatin1String("enum"));
        int enumIndex = 0;
        for (auto &en : m_astClass.enums) {
            if (en.name == _enum) {
                en.flagIndex = m_astClass.flags.count();
                break;
            }
            enumIndex++;
        }
        if (enumIndex == m_astClass.enums.count()) {
            setErrorString(QLatin1String("FLAG: Unknown (class) enum: %1").arg(_enum));
            return false;
        }
        auto flag = ASTFlag(name, _enum);
        flag.scope = m_astClass.name;
        flag.generateSignature(m_ast);
        m_astClass.flags.append(flag);
    }
    break;

#line 1210 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 125:
    {
        const QString name = captured().value(QLatin1String("name"));
        const QString _enum = captured().value(QLatin1String("enum"));
        int enumIndex = 0;
        for (auto &en : m_astPod.enums) {
            if (en.name == _enum) {
                en.flagIndex = m_astPod.flags.count();
                break;
            }
            enumIndex++;
        }
        if (enumIndex == m_astPod.enums.count()) {
            setErrorString(QLatin1String("FLAG: Unknown (pod) enum: %1").arg(_enum));
            return false;
        }
        auto flag = ASTFlag(name, _enum);
        flag.scope = m_astPod.name;
        flag.generateSignature(m_ast);
        m_astPod.flags.append(flag);
    }
    break;

#line 1236 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 126:
    {
        const QString args = captured().value(QLatin1String("args"));
        if (!parseProperty(m_astClass, args))
            return false;
    }
    break;

#line 1247 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 127:
    {
        ASTFunction signal;
        signal.name = captured().value(QLatin1String("name")).trimmed();

        const QString argString = captured().value(QLatin1String("args")).trimmed();
        RepParser::TypeParser parseType;
        parseType.parseArguments(argString);
        parseType.appendParams(signal);
        m_astClass.signalsList << signal;
    }
    break;

#line 1263 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 128:
    {
        QString returnTypeAndName = captured().value(QLatin1String("type")).trimmed();
        const QString argString = captured().value(QLatin1String("args")).trimmed();

        // compat code with old SLOT declaration: "SLOT(func(...))"
        const bool hasWhitespace = returnTypeAndName.indexOf(u' ') != -1;
        if (!hasWhitespace) {
            qWarning() << "[repc] - Adding 'void' for unspecified return type on" << qPrintable(returnTypeAndName);
            returnTypeAndName.prepend(QLatin1String("void "));
        }

        const int startOfFunctionName = returnTypeAndName.lastIndexOf(u' ') + 1;

        ASTFunction slot;
        slot.returnType = returnTypeAndName.mid(0, startOfFunctionName-1);
        slot.name = returnTypeAndName.mid(startOfFunctionName);

        RepParser::TypeParser parseType;
        parseType.parseArguments(argString);
        parseType.appendParams(slot);
        m_astClass.slotsList << slot;
    }
    break;

#line 1291 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 129:
    {
        const QString name = captured().value(QLatin1String("name")).trimmed();
        const QString argString = captured().value(QLatin1String("args")).trimmed();

        ASTModel model(name, m_astClass.name, m_astClass.properties.size());
        if (!parseRoles(model, argString))
            return false;

        model.generateSignature(m_ast);
        m_astClass.modelMetadata << model;
        m_astClass.properties << ASTProperty(QStringLiteral("QAbstractItemModel"), name, QStringLiteral("nullptr"), ASTProperty::SourceOnlySetter, false, true);
    }
    break;

#line 1309 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

case 130:
{
    const QString name = captured().value(QLatin1String("name")).trimmed();
    const QString type = captured().value(QLatin1String("type")).trimmed();

    m_astClass.subClassPropertyIndices << m_astClass.properties.size();
    m_astClass.properties << ASTProperty(type, name, QStringLiteral("nullptr"), ASTProperty::SourceOnlySetter, false, true);
}
break;

#line 1322 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 131:

#line 1326 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 132:
    {
        const QString name = captured().value(QLatin1String("name"));

        // new Class declaration
        m_astClass = ASTClass(name);
    }
    break;

#line 1338 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 133:

#line 1342 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 134:
    {
        // new POD declaration
        m_astPod = POD();
        m_astPod.name = captured().value(QLatin1String("name")).trimmed();
        m_argString.clear();
    }
    break;

#line 1354 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 135:
    {
        const QString name = captured().value(QLatin1String("name"));

        m_ast.enumUses.append(name);
    }
    break;

#line 1365 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 136:
    {
        const QString name = captured().value(QLatin1String("name"));
        const QString _enum = captured().value(QLatin1String("enum"));
        int enumIndex = 0;
        for (auto &en : m_ast.enums) {
            if (en.name == _enum) {
                en.flagIndex = m_ast.flags.count();
                break;
            }
            if (en.name == _enum)
                break;
            enumIndex++;
        }
        if (enumIndex == m_ast.enums.count()) {
            setErrorString(QLatin1String("FLAG: Unknown (global) enum: %1").arg(_enum));
            return false;
        }
        auto flag = ASTFlag(name, _enum);
        flag.generateSignature(m_ast);
        m_ast.flags.append(flag);
    }
    break;

#line 1393 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 137:
    {
        setErrorString(QStringLiteral("class: Cannot be nested"));
        return false;
    }
    break;

#line 1402 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 138:
    {
        setErrorString(QStringLiteral("POD: Can only be used in global scope"));
        return false;
    }
    break;

#line 1411 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 139:
    {
        setErrorString(QStringLiteral("USE_ENUM: Can only be used in global scope"));
        return false;
    }
    break;

#line 1420 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 140:
    {
        setErrorString(QStringLiteral("SIGNAL: Can only be used in class scope"));
        return false;
    }
    break;

#line 1429 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 141:
    {
        setErrorString(QStringLiteral("SLOT: Can only be used in class scope"));
        return false;
    }
    break;

#line 1438 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 142:
    {
        setErrorString(QStringLiteral("PROP: Can only be used in class scope"));
        return false;
    }
    break;

#line 1447 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 143:
    {
        setErrorString(QStringLiteral("MODEL: Can only be used in class scope"));
        return false;
    }
    break;

#line 1457 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    case 144:
    {
        setErrorString(QStringLiteral("CLASS: Can only be used in class scope"));
        return false;
    }
    break;

#line 1466 "/build/qt6-remoteobjects/src/qtremoteobjects-everywhere-src-6.2.4/src/repparser/parser.g"

    } // switch
    return true;
}
