/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.util.List;
import javax.websocket.Extension;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.PerMessageDeflate;
import org.apache.tomcat.websocket.Transformation;

public class TransformationFactory {
    private static final StringManager sm = StringManager.getManager(TransformationFactory.class);
    private static final TransformationFactory factory = new TransformationFactory();

    private TransformationFactory() {
    }

    public static TransformationFactory getInstance() {
        return factory;
    }

    public Transformation create(String string, List<List<Extension.Parameter>> list, boolean bl) {
        if ("permessage-deflate".equals(string)) {
            return PerMessageDeflate.negotiate(list, bl);
        }
        if (Constants.ALLOW_UNSUPPORTED_EXTENSIONS) {
            return null;
        }
        throw new IllegalArgumentException(sm.getString("transformerFactory.unsupportedExtension", new Object[]{string}));
    }
}

