
#ifndef KDECLARATIVE_EXPORT_H
#define KDECLARATIVE_EXPORT_H

#ifdef KDECLARATIVE_STATIC_DEFINE
#  define KDECLARATIVE_EXPORT
#  define KDECLARATIVE_NO_EXPORT
#else
#  ifndef KDECLARATIVE_EXPORT
#    ifdef KF5Declarative_EXPORTS
        /* We are building this library */
#      define KDECLARATIVE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KDECLARATIVE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KDECLARATIVE_NO_EXPORT
#    define KDECLARATIVE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KDECLARATIVE_DECL_DEPRECATED
#  define KDECLARATIVE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KDECLARATIVE_DECL_DEPRECATED_EXPORT
#  define KDECLARATIVE_DECL_DEPRECATED_EXPORT KDECLARATIVE_EXPORT KDECLARATIVE_DECL_DEPRECATED
#endif

#ifndef KDECLARATIVE_DECL_DEPRECATED_NO_EXPORT
#  define KDECLARATIVE_DECL_DEPRECATED_NO_EXPORT KDECLARATIVE_NO_EXPORT KDECLARATIVE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KDECLARATIVE_NO_DEPRECATED
#    define KDECLARATIVE_NO_DEPRECATED
#  endif
#endif

#define KDECLARATIVE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KDECLARATIVE_NO_DEPRECATED) && !defined(KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KDECLARATIVE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KDECLARATIVE_NO_DEPRECATED_WARNINGS) && !defined(KDECLARATIVE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KDECLARATIVE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KDECLARATIVE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KDECLARATIVE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KDECLARATIVE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KDECLARATIVE_NO_DEPRECATED)
#  undef KDECLARATIVE_DEPRECATED
#  define KDECLARATIVE_DEPRECATED_EXPORT KDECLARATIVE_EXPORT
#  define KDECLARATIVE_DEPRECATED_NO_EXPORT KDECLARATIVE_NO_EXPORT
#elif defined(KDECLARATIVE_NO_DEPRECATED_WARNINGS)
#  define KDECLARATIVE_DEPRECATED
#  define KDECLARATIVE_DEPRECATED_EXPORT KDECLARATIVE_EXPORT
#  define KDECLARATIVE_DEPRECATED_NO_EXPORT KDECLARATIVE_NO_EXPORT
#else
#  define KDECLARATIVE_DEPRECATED KDECLARATIVE_DECL_DEPRECATED
#  define KDECLARATIVE_DEPRECATED_EXPORT KDECLARATIVE_DECL_DEPRECATED_EXPORT
#  define KDECLARATIVE_DEPRECATED_NO_EXPORT KDECLARATIVE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDECLARATIVE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDECLARATIVE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDECLARATIVE_NO_DEPRECATED
#  define KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55c00
#endif
#ifdef KDECLARATIVE_NO_DEPRECATED_WARNINGS
#  define KDECLARATIVE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDECLARATIVE_DEPRECATED_WARNINGS_SINCE
#  ifdef KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDECLARATIVE_DEPRECATED_WARNINGS_SINCE KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDECLARATIVE_DEPRECATED_WARNINGS_SINCE 0x55c00
#  endif
#endif

#ifndef KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KDECLARATIVE_DEPRECATED
#  define KDECLARATIVE_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDECLARATIVE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KDECLARATIVE_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KDECLARATIVE_DEPRECATED_VERSION_5_0(text) KDECLARATIVE_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECLARATIVE_DEPRECATED_VERSION_5_0(text)
#endif

#if KDECLARATIVE_DEPRECATED_WARNINGS_SINCE >= 0x52d00
#  define KDECLARATIVE_DEPRECATED_VERSION_5_45(text) KDECLARATIVE_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECLARATIVE_DEPRECATED_VERSION_5_45(text)
#endif

#if KDECLARATIVE_DEPRECATED_WARNINGS_SINCE >= 0x54b00
#  define KDECLARATIVE_DEPRECATED_VERSION_5_75(text) KDECLARATIVE_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECLARATIVE_DEPRECATED_VERSION_5_75(text)
#endif

#if KDECLARATIVE_DEPRECATED_WARNINGS_SINCE >= 0x55b00
#  define KDECLARATIVE_DEPRECATED_VERSION_5_91(text) KDECLARATIVE_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECLARATIVE_DEPRECATED_VERSION_5_91(text)
#endif
#define KDECLARATIVE_DEPRECATED_VERSION_5(minor, text)      KDECLARATIVE_DEPRECATED_VERSION_5_##minor(text)
#define KDECLARATIVE_DEPRECATED_VERSION(major, minor, text) KDECLARATIVE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KDECLARATIVE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDECLARATIVE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KDECLARATIVE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KDECLARATIVE_DEPRECATED_VERSION(major, minor, text)
#  define KDECLARATIVE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDECLARATIVE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KDECLARATIVE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KDECLARATIVE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KDECLARATIVE_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KDECLARATIVE_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KDECLARATIVE_EXPORT_H


#define KDECLARATIVE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KDECLARATIVE_NO_DEPRECATED) && !defined(KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KDECLARATIVE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KDECLARATIVE_NO_DEPRECATED_WARNINGS) && !defined(KDECLARATIVE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KDECLARATIVE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KDECLARATIVE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KDECLARATIVE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KDECLARATIVE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KDECLARATIVE_NO_DEPRECATED)
#  undef KDECLARATIVE_DEPRECATED
#  define KDECLARATIVE_DEPRECATED_EXPORT KDECLARATIVE_EXPORT
#  define KDECLARATIVE_DEPRECATED_NO_EXPORT KDECLARATIVE_NO_EXPORT
#elif defined(KDECLARATIVE_NO_DEPRECATED_WARNINGS)
#  define KDECLARATIVE_DEPRECATED
#  define KDECLARATIVE_DEPRECATED_EXPORT KDECLARATIVE_EXPORT
#  define KDECLARATIVE_DEPRECATED_NO_EXPORT KDECLARATIVE_NO_EXPORT
#else
#  define KDECLARATIVE_DEPRECATED KDECLARATIVE_DECL_DEPRECATED
#  define KDECLARATIVE_DEPRECATED_EXPORT KDECLARATIVE_DECL_DEPRECATED_EXPORT
#  define KDECLARATIVE_DEPRECATED_NO_EXPORT KDECLARATIVE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDECLARATIVE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDECLARATIVE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDECLARATIVE_NO_DEPRECATED
#  define KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55c00
#endif
#ifdef KDECLARATIVE_NO_DEPRECATED_WARNINGS
#  define KDECLARATIVE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDECLARATIVE_DEPRECATED_WARNINGS_SINCE
#  ifdef KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDECLARATIVE_DEPRECATED_WARNINGS_SINCE KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDECLARATIVE_DEPRECATED_WARNINGS_SINCE 0x55c00
#  endif
#endif

#ifndef KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KDECLARATIVE_DEPRECATED
#  define KDECLARATIVE_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KDECLARATIVE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDECLARATIVE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KDECLARATIVE_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define KDECLARATIVE_DEPRECATED_VERSION_5_0(text) KDECLARATIVE_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECLARATIVE_DEPRECATED_VERSION_5_0(text)
#endif

#if KDECLARATIVE_DEPRECATED_WARNINGS_SINCE >= 0x52d00
#  define KDECLARATIVE_DEPRECATED_VERSION_5_45(text) KDECLARATIVE_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECLARATIVE_DEPRECATED_VERSION_5_45(text)
#endif

#if KDECLARATIVE_DEPRECATED_WARNINGS_SINCE >= 0x54b00
#  define KDECLARATIVE_DEPRECATED_VERSION_5_75(text) KDECLARATIVE_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECLARATIVE_DEPRECATED_VERSION_5_75(text)
#endif

#if KDECLARATIVE_DEPRECATED_WARNINGS_SINCE >= 0x55b00
#  define KDECLARATIVE_DEPRECATED_VERSION_5_91(text) KDECLARATIVE_DECL_DEPRECATED_TEXT(text)
#else
#  define KDECLARATIVE_DEPRECATED_VERSION_5_91(text)
#endif
#define KDECLARATIVE_DEPRECATED_VERSION_5(minor, text)      KDECLARATIVE_DEPRECATED_VERSION_5_##minor(text)
#define KDECLARATIVE_DEPRECATED_VERSION(major, minor, text) KDECLARATIVE_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KDECLARATIVE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDECLARATIVE_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KDECLARATIVE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KDECLARATIVE_DEPRECATED_VERSION(major, minor, text)
#  define KDECLARATIVE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDECLARATIVE_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KDECLARATIVE_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KDECLARATIVE_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KDECLARATIVE_EXPORT_H */
