
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>

QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "history_historyentry_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_History_HistoryEntry_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::History::HistoryEntry >()))
        return -1;

    ::History::HistoryEntry *cptr{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "HistoryEntry", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: HistoryEntry::HistoryEntry()
    // 1: HistoryEntry::HistoryEntry(History::HistoryEntry)
    if (numArgs == 0) {
        overloadId = 0; // HistoryEntry()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // HistoryEntry(History::HistoryEntry)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_History_HistoryEntry_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // HistoryEntry()
        {

            if (!PyErr_Occurred()) {
                // HistoryEntry()
                cptr = new ::History::HistoryEntry();
            }
            break;
        }
        case 1: // HistoryEntry(const History::HistoryEntry & HistoryEntry)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::History::HistoryEntry cppArg0_local;
            ::History::HistoryEntry *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // HistoryEntry(History::HistoryEntry)
                cptr = new ::History::HistoryEntry(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::History::HistoryEntry >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto Sbk_History_HistoryEntry_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_History_HistoryEntry_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.History.HistoryEntry");
        return -1;
}

static PyObject *Sbk_History_HistoryEntry___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_History_HistoryEntry_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_History_HistoryEntry_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_History_HistoryEntry___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_History_HistoryEntry_get_id(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->id;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_History_HistoryEntry_set_id(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'id' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'id', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->id;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->id = cppOut_local;

    return 0;
}

static PyObject *Sbk_History_HistoryEntry_get_count(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->count;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_History_HistoryEntry_set_count(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'count' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'count', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->count;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->count = cppOut_local;

    return 0;
}

static PyObject *Sbk_History_HistoryEntry_get_date(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->date)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->date))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->date)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &(cppSelf->date), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_History_HistoryEntry_set_date(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'date' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'date', 'QDateTime' or convertible type expected");
        return -1;
    }

    ::QDateTime& cppOut_ptr = cppSelf->date;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_History_HistoryEntry_get_url(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->url)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->url))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->url)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &(cppSelf->url), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_History_HistoryEntry_set_url(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'url' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'url', 'QUrl' or convertible type expected");
        return -1;
    }

    ::QUrl& cppOut_ptr = cppSelf->url;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_History_HistoryEntry_get_urlString(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->urlString);
    return pyOut;
}
static int Sbk_History_HistoryEntry_set_urlString(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'urlString' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'urlString', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->urlString;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_History_HistoryEntry_get_title(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->title);
    return pyOut;
}
static int Sbk_History_HistoryEntry_set_title(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'title' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'title', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->title;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for HistoryEntry
static PyGetSetDef Sbk_History_HistoryEntry_getsetlist[] = {
    {const_cast<char *>("id"), Sbk_History_HistoryEntry_get_id, Sbk_History_HistoryEntry_set_id},
    {const_cast<char *>("count"), Sbk_History_HistoryEntry_get_count, Sbk_History_HistoryEntry_set_count},
    {const_cast<char *>("date"), Sbk_History_HistoryEntry_get_date, Sbk_History_HistoryEntry_set_date},
    {const_cast<char *>("url"), Sbk_History_HistoryEntry_get_url, Sbk_History_HistoryEntry_set_url},
    {const_cast<char *>("urlString"), Sbk_History_HistoryEntry_get_urlString, Sbk_History_HistoryEntry_set_urlString},
    {const_cast<char *>("title"), Sbk_History_HistoryEntry_get_title, Sbk_History_HistoryEntry_set_title},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_History_HistoryEntry_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_History_HistoryEntry_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_History_HistoryEntry_Type = nullptr;
static SbkObjectType *Sbk_History_HistoryEntry_TypeF(void)
{
    return _Sbk_History_HistoryEntry_Type;
}

static PyType_Slot Sbk_History_HistoryEntry_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_History_HistoryEntry_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_History_HistoryEntry_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_History_HistoryEntry_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_History_HistoryEntry_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_History_HistoryEntry_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_History_HistoryEntry_spec = {
    "1:PyFalkon.History.HistoryEntry",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_History_HistoryEntry_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void HistoryEntry_PythonToCpp_HistoryEntry_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_History_HistoryEntry_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_HistoryEntry_PythonToCpp_HistoryEntry_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_History_HistoryEntry_TypeF())))
        return HistoryEntry_PythonToCpp_HistoryEntry_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *HistoryEntry_PTR_CppToPython_HistoryEntry(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::History::HistoryEntry *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_History_HistoryEntry_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *HistoryEntry_COPY_CppToPython_HistoryEntry(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_History_HistoryEntry_TypeF(), new ::History::HistoryEntry(*reinterpret_cast<const ::History::HistoryEntry *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void HistoryEntry_PythonToCpp_HistoryEntry_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::History::HistoryEntry *>(cppOut) = *reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_HistoryEntry_PythonToCpp_HistoryEntry_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_History_HistoryEntry_TypeF())))
        return HistoryEntry_PythonToCpp_HistoryEntry_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *History_HistoryEntry_SignatureStrings[] = {
    "1:PyFalkon.History.HistoryEntry(self)",
    "0:PyFalkon.History.HistoryEntry(self,HistoryEntry:PyFalkon.History.HistoryEntry)",
    "PyFalkon.History.HistoryEntry.__copy__()",
    nullptr}; // Sentinel

void init_History_HistoryEntry(PyObject *enclosingClass)
{
    _Sbk_History_HistoryEntry_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "HistoryEntry",
        "History::HistoryEntry",
        &Sbk_History_HistoryEntry_spec,
        &Shiboken::callCppDestructor< ::History::HistoryEntry >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_History_HistoryEntry_Type);
    InitSignatureStrings(pyType, History_HistoryEntry_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_History_HistoryEntry_Type), Sbk_History_HistoryEntry_PropertyStrings);
    SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_History_HistoryEntry_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_History_HistoryEntry_TypeF(),
        HistoryEntry_PythonToCpp_HistoryEntry_PTR,
        is_HistoryEntry_PythonToCpp_HistoryEntry_PTR_Convertible,
        HistoryEntry_PTR_CppToPython_HistoryEntry,
        HistoryEntry_COPY_CppToPython_HistoryEntry);

    Shiboken::Conversions::registerConverterName(converter, "History::HistoryEntry");
    Shiboken::Conversions::registerConverterName(converter, "History::HistoryEntry*");
    Shiboken::Conversions::registerConverterName(converter, "History::HistoryEntry&");
    Shiboken::Conversions::registerConverterName(converter, "HistoryEntry");
    Shiboken::Conversions::registerConverterName(converter, "HistoryEntry*");
    Shiboken::Conversions::registerConverterName(converter, "HistoryEntry&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::History::HistoryEntry).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        HistoryEntry_PythonToCpp_HistoryEntry_COPY,
        is_HistoryEntry_PythonToCpp_HistoryEntry_COPY_Convertible);


    qRegisterMetaType< ::History::HistoryEntry >("HistoryEntry");
    qRegisterMetaType< ::History::HistoryEntry >("History::HistoryEntry");
}
