/*
 * libinstpatch.h - Main public header file for libInstPatch
 *
 * libInstPatch - MIDI instrument patch library
 * Copyright (C) 1999-2007 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 2.1
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA or on the web at http://www.gnu.org.
 */
#ifndef __LIB_INST_PATCH_H__
#define __LIB_INST_PATCH_H__

#include <glib.h>

G_BEGIN_DECLS

#include <libinstpatch/builtin_enums.h>
#include <libinstpatch/IpatchBase.h>
#include <libinstpatch/IpatchContainer.h>
#include <libinstpatch/IpatchConverter.h>
#include <libinstpatch/IpatchConverterSF2VoiceCache.h>
#include <libinstpatch/IpatchConvert_DLS2.h>
#include <libinstpatch/IpatchConvert_Gig.h>
#include <libinstpatch/IpatchConvert_SF2.h>
#include <libinstpatch/IpatchDLS2Conn.h>
#include <libinstpatch/IpatchDLS2.h>
#include <libinstpatch/IpatchDLS2Info.h>
#include <libinstpatch/IpatchDLS2Inst.h>
#include <libinstpatch/IpatchDLS2Region.h>
#include <libinstpatch/IpatchDLS2Sample.h>
#include <libinstpatch/IpatchDLSFile.h>
#include <libinstpatch/IpatchDLSReader.h>
#include <libinstpatch/IpatchDLSWriter.h>
#include <libinstpatch/IpatchFile.h>
#include <libinstpatch/IpatchGigEffects.h>
#include <libinstpatch/IpatchGigFile.h>
#include <libinstpatch/IpatchGig.h>
#include <libinstpatch/IpatchGigDimension.h>
#include <libinstpatch/IpatchGigInst.h>
#include <libinstpatch/IpatchGigRegion.h>
#include <libinstpatch/IpatchGigSample.h>
#include <libinstpatch/IpatchGigSubRegion.h>
#include <libinstpatch/IpatchItem.h>
#include <libinstpatch/IpatchIter.h>
#include <libinstpatch/IpatchList.h>
#include <libinstpatch/IpatchParamProp.h>
#include <libinstpatch/IpatchPaste.h>
#include <libinstpatch/IpatchRange.h>
#include <libinstpatch/IpatchRiff.h>
#include <libinstpatch/IpatchSample.h>
#include <libinstpatch/IpatchSampleStore.h>
#include <libinstpatch/IpatchSampleStoreCache.h>
#include <libinstpatch/IpatchSampleStoreFile.h>
#include <libinstpatch/IpatchSampleStoreRam.h>
#include <libinstpatch/IpatchSampleStoreRom.h>
#include <libinstpatch/IpatchSampleStoreSndFile.h>
#include <libinstpatch/IpatchSampleStoreSplit24.h>
#include <libinstpatch/IpatchSampleStoreSwap.h>
#include <libinstpatch/IpatchSampleStoreVirtual.h>
#include <libinstpatch/IpatchSampleTransform.h>
#include <libinstpatch/IpatchSF2File.h>
#include <libinstpatch/IpatchSF2Gen.h>
#include <libinstpatch/IpatchSF2GenItem.h>
#include <libinstpatch/IpatchSF2.h>
#include <libinstpatch/IpatchSF2Inst.h>
#include <libinstpatch/IpatchSF2IZone.h>
#include <libinstpatch/IpatchSF2Mod.h>
#include <libinstpatch/IpatchSF2ModItem.h>
#include <libinstpatch/IpatchSF2ModList.h>
#include <libinstpatch/IpatchSF2Preset.h>
#include <libinstpatch/IpatchSF2PZone.h>
#include <libinstpatch/IpatchSF2Reader.h>
#include <libinstpatch/IpatchSF2Sample.h>
#include <libinstpatch/IpatchSF2VoiceCache.h>
#include <libinstpatch/IpatchSF2Writer.h>
#include <libinstpatch/IpatchSF2Zone.h>
#include <libinstpatch/IpatchSLIFile.h>
#include <libinstpatch/IpatchSLI.h>
#include <libinstpatch/IpatchSLIInst.h>
#include <libinstpatch/IpatchSLIReader.h>
#include <libinstpatch/IpatchSLISample.h>
#include <libinstpatch/IpatchSLIWriter.h>
#include <libinstpatch/IpatchSLIZone.h>
#include <libinstpatch/IpatchSndFile.h>
#include <libinstpatch/IpatchTypeProp.h>
#include <libinstpatch/IpatchUnit.h>
#include <libinstpatch/IpatchUnit_generic.h>
#include <libinstpatch/IpatchUnit_DLS.h>
#include <libinstpatch/IpatchUnit_SF2.h>
#include <libinstpatch/IpatchVBank.h>
#include <libinstpatch/IpatchVBankInst.h>
#include <libinstpatch/IpatchVBankRegion.h>
#include <libinstpatch/IpatchVirtualContainer.h>
#include <libinstpatch/IpatchVirtualContainer_types.h>
#include <libinstpatch/IpatchXml.h>
#include <libinstpatch/IpatchXmlObject.h>
#include <libinstpatch/misc.h>
#include <libinstpatch/sample.h>
#include <libinstpatch/version.h>

G_END_DECLS

#endif
