// ui/display/mojom/display.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/display/mojom/display.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/display/mojom/display.mojom-params-data.h"
#include "ui/display/mojom/display.mojom-shared-message-ids.h"

#include "ui/display/mojom/display.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef UI_DISPLAY_MOJOM_DISPLAY_MOJOM_BLINK_JUMBO_H_
#define UI_DISPLAY_MOJOM_DISPLAY_MOJOM_BLINK_JUMBO_H_
#endif
namespace display {
namespace mojom {
namespace blink {
Display::Display()
    : id(),
      bounds(),
      size_in_pixels(),
      work_area(),
      device_scale_factor(),
      rotation(),
      touch_support(),
      accelerometer_support(),
      maximum_cursor_size(),
      color_spaces(),
      color_depth(),
      depth_per_component(),
      is_monochrome(),
      display_frequency() {}

Display::Display(
    int64_t id_in,
    const ::gfx::Rect& bounds_in,
    const ::gfx::Size& size_in_pixels_in,
    const ::gfx::Rect& work_area_in,
    float device_scale_factor_in,
    ::display::Display::Rotation rotation_in,
    TouchSupport touch_support_in,
    AccelerometerSupport accelerometer_support_in,
    const ::gfx::Size& maximum_cursor_size_in,
    ::gfx::mojom::blink::DisplayColorSpacesPtr color_spaces_in,
    int32_t color_depth_in,
    int32_t depth_per_component_in,
    bool is_monochrome_in,
    int32_t display_frequency_in)
    : id(std::move(id_in)),
      bounds(std::move(bounds_in)),
      size_in_pixels(std::move(size_in_pixels_in)),
      work_area(std::move(work_area_in)),
      device_scale_factor(std::move(device_scale_factor_in)),
      rotation(std::move(rotation_in)),
      touch_support(std::move(touch_support_in)),
      accelerometer_support(std::move(accelerometer_support_in)),
      maximum_cursor_size(std::move(maximum_cursor_size_in)),
      color_spaces(std::move(color_spaces_in)),
      color_depth(std::move(color_depth_in)),
      depth_per_component(std::move(depth_per_component_in)),
      is_monochrome(std::move(is_monochrome_in)),
      display_frequency(std::move(display_frequency_in)) {}

Display::~Display() = default;

void Display::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("id", base::NumberToString(this->id));
  value->SetString("bounds", base::trace_event::ValueToString(this->bounds, "<value of type const ::gfx::Rect&>"));
  value->SetString("size_in_pixels", base::trace_event::ValueToString(this->size_in_pixels, "<value of type const ::gfx::Size&>"));
  value->SetString("work_area", base::trace_event::ValueToString(this->work_area, "<value of type const ::gfx::Rect&>"));
  value->SetDouble("device_scale_factor", this->device_scale_factor);
  value->SetInteger("rotation", static_cast<int>(this->rotation));
  value->SetString("touch_support", base::trace_event::ValueToString(this->touch_support));
  value->SetString("accelerometer_support", base::trace_event::ValueToString(this->accelerometer_support));
  value->SetString("maximum_cursor_size", base::trace_event::ValueToString(this->maximum_cursor_size, "<value of type const ::gfx::Size&>"));
  if (this->color_spaces.is_null()) {
    value->SetString("color_spaces", "nullptr");
  } else {
    value->BeginDictionary("color_spaces");
    this->color_spaces->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetInteger("color_depth", this->color_depth);
  value->SetInteger("depth_per_component", this->depth_per_component);
  value->SetBoolean("is_monochrome", this->is_monochrome);
  value->SetInteger("display_frequency", this->display_frequency);
}

bool Display::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace display

namespace mojo {


// static
bool StructTraits<::display::mojom::blink::Display::DataView, ::display::mojom::blink::DisplayPtr>::Read(
    ::display::mojom::blink::Display::DataView input,
    ::display::mojom::blink::DisplayPtr* output) {
  bool success = true;
  ::display::mojom::blink::DisplayPtr result(::display::mojom::blink::Display::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
      if (success && !input.ReadSizeInPixels(&result->size_in_pixels))
        success = false;
      if (success && !input.ReadWorkArea(&result->work_area))
        success = false;
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success && !input.ReadRotation(&result->rotation))
        success = false;
      if (success && !input.ReadTouchSupport(&result->touch_support))
        success = false;
      if (success && !input.ReadAccelerometerSupport(&result->accelerometer_support))
        success = false;
      if (success && !input.ReadMaximumCursorSize(&result->maximum_cursor_size))
        success = false;
      if (success && !input.ReadColorSpaces(&result->color_spaces))
        success = false;
      if (success)
        result->color_depth = input.color_depth();
      if (success)
        result->depth_per_component = input.depth_per_component();
      if (success)
        result->is_monochrome = input.is_monochrome();
      if (success)
        result->display_frequency = input.display_frequency();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif