/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.memorylint;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openide.util.NbBundle;

public final class Histogram<T extends Entry> {
    private HashMap<String, T> map = new HashMap();

    public static final Comparator<Entry> sortByCount() {
        return new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o2.count - o1.count;
            }
        };
    }

    public static final Comparator<Entry> sortBySize() {
        return new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return Long.compare(o2.size, o1.size);
            }
        };
    }

    public SortedMap<String, T> getResults(final Comparator<Entry> comparator) {
        TreeMap<String, T> sm = new TreeMap<String, T>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Entry t2;
                Entry t1 = (Entry)Histogram.this.map.get(o1);
                int delta = comparator.compare(t1, t2 = (Entry)Histogram.this.map.get(o2));
                if (delta == 0) {
                    delta = o1.compareTo(o2);
                }
                return delta;
            }
        });
        sm.putAll(this.map);
        return sm;
    }

    public void add(String key, T entry) {
        Entry current = (Entry)this.map.get(key);
        if (current != null) {
            current.doAdd((Entry)entry);
        } else {
            this.map.put(key, entry);
        }
    }

    public String toString(int treshold) {
        StringBuilder result = new StringBuilder();
        long totalSize = 0L;
        int totalCount = 0;
        SortedMap<String, T> bySize = this.getResults(Histogram.sortBySize());
        for (Map.Entry<String, T> entry : bySize.entrySet()) {
            long size = ((Entry)entry.getValue()).getSize();
            if (size > (long)treshold) {
                result.append(entry.getKey()).append(": ").append(entry.getValue()).append("<br>");
            }
            totalSize += size;
            totalCount += ((Entry)entry.getValue()).getCount();
        }
        result.append(NbBundle.getMessage(Histogram.class, (String)"FMT_HistogramSum", (Object)totalCount, (Object)totalSize));
        return result.toString();
    }

    public static class Entry<T extends Entry> {
        private int count = 1;
        private long size;

        public Entry(long size) {
            this.size = size;
        }

        public final int getCount() {
            return this.count;
        }

        public final long getSize() {
            return this.size;
        }

        public String toString() {
            return "#:" + this.getCount() + "/" + this.getSize() + "B\n";
        }

        protected void add(T source) {
        }

        private void doAdd(T entry) {
            this.count += ((Entry)entry).count;
            this.size += ((Entry)entry).size;
            this.add(entry);
        }
    }
}

