
#ifndef KTEXTEDITOR_EXPORT_H
#define KTEXTEDITOR_EXPORT_H

#ifdef KTEXTEDITOR_STATIC_DEFINE
#  define KTEXTEDITOR_EXPORT
#  define KTEXTEDITOR_NO_EXPORT
#else
#  ifndef KTEXTEDITOR_EXPORT
#    ifdef KF5TextEditor_EXPORTS
        /* We are building this library */
#      define KTEXTEDITOR_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KTEXTEDITOR_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KTEXTEDITOR_NO_EXPORT
#    define KTEXTEDITOR_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KTEXTEDITOR_DECL_DEPRECATED
#  define KTEXTEDITOR_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KTEXTEDITOR_DECL_DEPRECATED_EXPORT
#  define KTEXTEDITOR_DECL_DEPRECATED_EXPORT KTEXTEDITOR_EXPORT KTEXTEDITOR_DECL_DEPRECATED
#endif

#ifndef KTEXTEDITOR_DECL_DEPRECATED_NO_EXPORT
#  define KTEXTEDITOR_DECL_DEPRECATED_NO_EXPORT KTEXTEDITOR_NO_EXPORT KTEXTEDITOR_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KTEXTEDITOR_NO_DEPRECATED
#    define KTEXTEDITOR_NO_DEPRECATED
#  endif
#endif

#define KTEXTEDITOR_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KTEXTEDITOR_NO_DEPRECATED) && !defined(KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KTEXTEDITOR_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KTEXTEDITOR_NO_DEPRECATED_WARNINGS) && !defined(KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KTEXTEDITOR_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KTEXTEDITOR_NO_DEPRECATED)
#  undef KTEXTEDITOR_DEPRECATED
#  define KTEXTEDITOR_DEPRECATED_EXPORT KTEXTEDITOR_EXPORT
#  define KTEXTEDITOR_DEPRECATED_NO_EXPORT KTEXTEDITOR_NO_EXPORT
#elif defined(KTEXTEDITOR_NO_DEPRECATED_WARNINGS)
#  define KTEXTEDITOR_DEPRECATED
#  define KTEXTEDITOR_DEPRECATED_EXPORT KTEXTEDITOR_EXPORT
#  define KTEXTEDITOR_DEPRECATED_NO_EXPORT KTEXTEDITOR_NO_EXPORT
#else
#  define KTEXTEDITOR_DEPRECATED KTEXTEDITOR_DECL_DEPRECATED
#  define KTEXTEDITOR_DEPRECATED_EXPORT KTEXTEDITOR_DECL_DEPRECATED_EXPORT
#  define KTEXTEDITOR_DEPRECATED_NO_EXPORT KTEXTEDITOR_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KTEXTEDITOR_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KTEXTEDITOR_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KTEXTEDITOR_NO_DEPRECATED
#  define KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55d00
#endif
#ifdef KTEXTEDITOR_NO_DEPRECATED_WARNINGS
#  define KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE
#  ifdef KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE 0x55d00
#  endif
#endif

#ifndef KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KTEXTEDITOR_DEPRECATED
#  define KTEXTEDITOR_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KTEXTEDITOR_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE >= 0x55000
#  define KTEXTEDITOR_DEPRECATED_VERSION_5_80(text) KTEXTEDITOR_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTEDITOR_DEPRECATED_VERSION_5_80(text)
#endif
#define KTEXTEDITOR_DEPRECATED_VERSION_5(minor, text)      KTEXTEDITOR_DEPRECATED_VERSION_5_##minor(text)
#define KTEXTEDITOR_DEPRECATED_VERSION(major, minor, text) KTEXTEDITOR_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KTEXTEDITOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KTEXTEDITOR_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KTEXTEDITOR_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KTEXTEDITOR_DEPRECATED_VERSION(major, minor, text)
#  define KTEXTEDITOR_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KTEXTEDITOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KTEXTEDITOR_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KTEXTEDITOR_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KTEXTEDITOR_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KTEXTEDITOR_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KTEXTEDITOR_EXPORT_H


#define KTEXTEDITOR_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KTEXTEDITOR_NO_DEPRECATED) && !defined(KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KTEXTEDITOR_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KTEXTEDITOR_NO_DEPRECATED_WARNINGS) && !defined(KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KTEXTEDITOR_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KTEXTEDITOR_NO_DEPRECATED)
#  undef KTEXTEDITOR_DEPRECATED
#  define KTEXTEDITOR_DEPRECATED_EXPORT KTEXTEDITOR_EXPORT
#  define KTEXTEDITOR_DEPRECATED_NO_EXPORT KTEXTEDITOR_NO_EXPORT
#elif defined(KTEXTEDITOR_NO_DEPRECATED_WARNINGS)
#  define KTEXTEDITOR_DEPRECATED
#  define KTEXTEDITOR_DEPRECATED_EXPORT KTEXTEDITOR_EXPORT
#  define KTEXTEDITOR_DEPRECATED_NO_EXPORT KTEXTEDITOR_NO_EXPORT
#else
#  define KTEXTEDITOR_DEPRECATED KTEXTEDITOR_DECL_DEPRECATED
#  define KTEXTEDITOR_DEPRECATED_EXPORT KTEXTEDITOR_DECL_DEPRECATED_EXPORT
#  define KTEXTEDITOR_DEPRECATED_NO_EXPORT KTEXTEDITOR_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KTEXTEDITOR_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KTEXTEDITOR_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KTEXTEDITOR_NO_DEPRECATED
#  define KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55d00
#endif
#ifdef KTEXTEDITOR_NO_DEPRECATED_WARNINGS
#  define KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE
#  ifdef KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE 0x55d00
#  endif
#endif

#ifndef KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KTEXTEDITOR_DEPRECATED
#  define KTEXTEDITOR_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KTEXTEDITOR_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KTEXTEDITOR_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KTEXTEDITOR_DEPRECATED_WARNINGS_SINCE >= 0x55000
#  define KTEXTEDITOR_DEPRECATED_VERSION_5_80(text) KTEXTEDITOR_DECL_DEPRECATED_TEXT(text)
#else
#  define KTEXTEDITOR_DEPRECATED_VERSION_5_80(text)
#endif
#define KTEXTEDITOR_DEPRECATED_VERSION_5(minor, text)      KTEXTEDITOR_DEPRECATED_VERSION_5_##minor(text)
#define KTEXTEDITOR_DEPRECATED_VERSION(major, minor, text) KTEXTEDITOR_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KTEXTEDITOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KTEXTEDITOR_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KTEXTEDITOR_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KTEXTEDITOR_DEPRECATED_VERSION(major, minor, text)
#  define KTEXTEDITOR_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KTEXTEDITOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KTEXTEDITOR_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KTEXTEDITOR_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KTEXTEDITOR_EXPORT_H */
