/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.5.1
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 26 "/build/pyqt6/src/PyQt6-6.2.3/sip/QtCore/qbytearraylist.sip"
#include <qstringlist.h>
#line 29 "/build/pyqt6/src/PyQt6-6.2.3/build/QtCore/sipQtCoreQByteArrayList.cpp"



extern "C" {static void assign_QByteArrayList(void *, Py_ssize_t, void *);}
static void assign_QByteArrayList(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QByteArrayList *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QByteArrayList *>(sipSrc);
}


extern "C" {static void *array_QByteArrayList(Py_ssize_t);}
static void *array_QByteArrayList(Py_ssize_t sipNrElem)
{
    return new  ::QByteArrayList[sipNrElem];
}


extern "C" {static void *copy_QByteArrayList(const void *, Py_ssize_t);}
static void *copy_QByteArrayList(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QByteArrayList(reinterpret_cast<const  ::QByteArrayList *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QByteArrayList(void *, int, void *);}
static void release_QByteArrayList(void *sipCppV, int, void *)
{
     ::QByteArrayList *sipCpp = reinterpret_cast< ::QByteArrayList *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QByteArrayList(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QByteArrayList(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
     ::QByteArrayList **sipCppPtr = reinterpret_cast< ::QByteArrayList **>(sipCppPtrV);

#line 56 "/build/pyqt6/src/PyQt6-6.2.3/sip/QtCore/qbytearraylist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QByteArrayList *ql = new QByteArrayList;
 
    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete ql;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        int state;
        QByteArray *t = reinterpret_cast<QByteArray *>(
                sipForceConvertToType(itm, sipType_QByteArray, sipTransferObj,
                        SIP_NOT_NONE, &state, sipIsErr));

        if (*sipIsErr)
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'str' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete ql;
            Py_DECREF(iter);

            return 0;
        }

        ql->append(*t);

        sipReleaseType(t, sipType_QByteArray, state);
        Py_DECREF(itm);
    }
 
    Py_DECREF(iter);

    *sipCppPtr = ql;
 
    return sipGetState(sipTransferObj);
#line 137 "/build/pyqt6/src/PyQt6-6.2.3/build/QtCore/sipQtCoreQByteArrayList.cpp"
}


extern "C" {static PyObject *convertFrom_QByteArrayList(void *, PyObject *);}
static PyObject *convertFrom_QByteArrayList(void *sipCppV, PyObject *sipTransferObj)
{
    ::QByteArrayList *sipCpp = reinterpret_cast< ::QByteArrayList *>(sipCppV);

#line 30 "/build/pyqt6/src/PyQt6-6.2.3/sip/QtCore/qbytearraylist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        QByteArray *t = new QByteArray(sipCpp->at(i));
        PyObject *tobj = sipConvertFromNewType(t, sipType_QByteArray,
                sipTransferObj);

        if (!tobj)
        {
            delete t;
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, tobj);
    }

    return l;
#line 170 "/build/pyqt6/src/PyQt6-6.2.3/build/QtCore/sipQtCoreQByteArrayList.cpp"
}


sipMappedTypeDef sipTypeDef_QtCore_QByteArrayList = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_QByteArrayList,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_QByteArrayList,
    array_QByteArrayList,
    copy_QByteArrayList,
    release_QByteArrayList,
    convertTo_QByteArrayList,
    convertFrom_QByteArrayList
};
