/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspContext;
import org.apache.jasper.Constants;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.el.ELContextImpl;
import org.apache.jasper.el.JasperELResolver;

public class JspApplicationContextImpl
implements JspApplicationContext {
    private static final String KEY = JspApplicationContextImpl.class.getName();
    private final ExpressionFactory expressionFactory = ExpressionFactory.newInstance();
    private final List<ELContextListener> contextListeners = new ArrayList<ELContextListener>();
    private final List<ELResolver> resolvers = new ArrayList<ELResolver>();
    private boolean instantiated = false;
    private ELResolver resolver;

    public void addELContextListener(ELContextListener eLContextListener) {
        if (eLContextListener == null) {
            throw new IllegalArgumentException(Localizer.getMessage("jsp.error.nullArgument"));
        }
        this.contextListeners.add(eLContextListener);
    }

    public static JspApplicationContextImpl getInstance(ServletContext servletContext) {
        if (servletContext == null) {
            throw new IllegalArgumentException(Localizer.getMessage("jsp.error.nullArgument"));
        }
        JspApplicationContextImpl jspApplicationContextImpl = (JspApplicationContextImpl)servletContext.getAttribute(KEY);
        if (jspApplicationContextImpl == null) {
            jspApplicationContextImpl = new JspApplicationContextImpl();
            servletContext.setAttribute(KEY, (Object)jspApplicationContextImpl);
        }
        return jspApplicationContextImpl;
    }

    public ELContextImpl createELContext(JspContext jspContext) {
        if (jspContext == null) {
            throw new IllegalArgumentException(Localizer.getMessage("jsp.error.nullArgument"));
        }
        ELResolver eLResolver = this.createELResolver();
        ELContextImpl eLContextImpl = Constants.IS_SECURITY_ENABLED ? AccessController.doPrivileged(() -> new ELContextImpl(eLResolver)) : new ELContextImpl(eLResolver);
        eLContextImpl.putContext(JspContext.class, jspContext);
        this.fireListeners(eLContextImpl);
        return eLContextImpl;
    }

    protected void fireListeners(ELContext eLContext) {
        ELContextEvent eLContextEvent = new ELContextEvent(eLContext);
        for (ELContextListener eLContextListener : this.contextListeners) {
            eLContextListener.contextCreated(eLContextEvent);
        }
    }

    private ELResolver createELResolver() {
        this.instantiated = true;
        if (this.resolver == null) {
            JasperELResolver jasperELResolver = new JasperELResolver(this.resolvers, this.expressionFactory.getStreamELResolver());
            this.resolver = jasperELResolver;
        }
        return this.resolver;
    }

    public void addELResolver(ELResolver eLResolver) throws IllegalStateException {
        if (eLResolver == null) {
            throw new IllegalArgumentException(Localizer.getMessage("jsp.error.nullArgument"));
        }
        if (this.instantiated) {
            throw new IllegalStateException(Localizer.getMessage("jsp.error.cannotAddResolver"));
        }
        this.resolvers.add(eLResolver);
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }
}

