/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.tomcat.dbcp.dbcp2.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp2.DelegatingCallableStatement;
import org.apache.tomcat.dbcp.dbcp2.DelegatingDatabaseMetaData;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.DelegatingStatement;
import org.apache.tomcat.dbcp.dbcp2.Jdbc41Bridge;
import org.apache.tomcat.dbcp.dbcp2.SQLExceptionList;

public class DelegatingConnection<C extends Connection>
extends AbandonedTrace
implements Connection {
    private static final Map<String, ClientInfoStatus> EMPTY_FAILED_PROPERTIES = Collections.emptyMap();
    private volatile C connection;
    private volatile boolean closed;
    private boolean cacheState = true;
    private Boolean cachedAutoCommit;
    private Boolean cachedReadOnly;
    private String cachedCatalog;
    private String cachedSchema;
    private Duration defaultQueryTimeoutDuration;

    public DelegatingConnection(C c) {
        this.connection = c;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            Jdbc41Bridge.abort(this.connection, executor);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    protected void activate() {
        this.closed = false;
        this.setLastUsed();
        if (this.connection instanceof DelegatingConnection) {
            ((DelegatingConnection)this.connection).activate();
        }
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            if (null != this.connection) {
                String string = "";
                try {
                    string = this.connection.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SQLException("Connection " + string + " is closed.");
            }
            throw new SQLException("Connection is null.");
        }
    }

    public void clearCachedState() {
        this.cachedAutoCommit = null;
        this.cachedReadOnly = null;
        this.cachedSchema = null;
        this.cachedCatalog = null;
        if (this.connection instanceof DelegatingConnection) {
            ((DelegatingConnection)this.connection).clearCachedState();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this.connection.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closeInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected final void closeInternal() throws SQLException {
        try {
            this.passivate();
        }
        finally {
            if (this.connection != null) {
                try {
                    var1_1 = this.connection.isClosed();
                }
                catch (SQLException var2_2) {
                    var1_1 = false;
                }
                try {
                    if (var1_1) ** GOTO lbl19
                    this.connection.close();
                }
                finally {
                    this.closed = true;
                }
            } else {
                this.closed = true;
            }
lbl19:
            // 3 sources

        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        try {
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createArrayOf(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createBlob();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createClob();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createNClob();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createSQLXML();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingStatement(this, this.connection.createStatement()));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingStatement(this, this.connection.createStatement(n, n2)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingStatement(this, this.connection.createStatement(n, n2, n3)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createStruct(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        if (this.cacheState && this.cachedAutoCommit != null) {
            return this.cachedAutoCommit;
        }
        try {
            this.cachedAutoCommit = this.connection.getAutoCommit();
            return this.cachedAutoCommit;
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean getCacheState() {
        return this.cacheState;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        if (this.cacheState && this.cachedCatalog != null) {
            return this.cachedCatalog;
        }
        try {
            this.cachedCatalog = this.connection.getCatalog();
            return this.cachedCatalog;
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getClientInfo();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getClientInfo(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Deprecated
    public Integer getDefaultQueryTimeout() {
        return this.defaultQueryTimeoutDuration == null ? null : Integer.valueOf((int)this.defaultQueryTimeoutDuration.getSeconds());
    }

    public Duration getDefaultQueryTimeoutDuration() {
        return this.defaultQueryTimeoutDuration;
    }

    public C getDelegate() {
        return this.getDelegateInternal();
    }

    protected final C getDelegateInternal() {
        return this.connection;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getHoldability();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public Connection getInnermostDelegate() {
        return this.getInnermostDelegateInternal();
    }

    public final Connection getInnermostDelegateInternal() {
        C c = this.connection;
        while (c instanceof DelegatingConnection) {
            if (this != (c = ((DelegatingConnection)c).getDelegateInternal())) continue;
            return null;
        }
        return c;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingDatabaseMetaData(this, this.connection.getMetaData());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkOpen();
        try {
            return Jdbc41Bridge.getNetworkTimeout(this.connection);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        if (this.cacheState && this.cachedSchema != null) {
            return this.cachedSchema;
        }
        try {
            this.cachedSchema = Jdbc41Bridge.getSchema(this.connection);
            return this.cachedSchema;
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return -1;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    protected void handleException(SQLException sQLException) throws SQLException {
        throw sQLException;
    }

    protected <T extends Throwable> T handleExceptionNoThrow(T t) {
        return t;
    }

    private <T extends DelegatingStatement> T init(T t) throws SQLException {
        if (this.defaultQueryTimeoutDuration != null && this.defaultQueryTimeoutDuration.getSeconds() != (long)t.getQueryTimeout()) {
            t.setQueryTimeout((int)this.defaultQueryTimeoutDuration.getSeconds());
        }
        return t;
    }

    public boolean innermostDelegateEquals(Connection connection) {
        Connection connection2 = this.getInnermostDelegateInternal();
        if (connection2 == null) {
            return connection == null;
        }
        return connection2.equals(connection);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed || this.connection == null || this.connection.isClosed();
    }

    protected boolean isClosedInternal() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        if (this.cacheState && this.cachedReadOnly != null) {
            return this.cachedReadOnly;
        }
        try {
            this.cachedReadOnly = this.connection.isReadOnly();
            return this.cachedReadOnly;
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public boolean isValid(Duration duration) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.connection.isValid((int)duration.getSeconds());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    @Deprecated
    public boolean isValid(int n) throws SQLException {
        return this.isValid(Duration.ofSeconds(n));
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (clazz.isAssignableFrom(this.connection.getClass())) {
            return true;
        }
        return this.connection.isWrapperFor(clazz);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.checkOpen();
        try {
            return this.connection.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    protected void passivate() throws SQLException {
        List<AbandonedTrace> list = this.getTrace();
        if (list != null && !list.isEmpty()) {
            ArrayList<Exception> arrayList = new ArrayList<Exception>();
            for (AbandonedTrace abandonedTrace : list) {
                if (abandonedTrace instanceof Statement) {
                    try {
                        ((Statement)((Object)abandonedTrace)).close();
                    }
                    catch (Exception exception) {
                        arrayList.add(exception);
                    }
                    continue;
                }
                if (!(abandonedTrace instanceof ResultSet)) continue;
                try {
                    ((ResultSet)((Object)abandonedTrace)).close();
                }
                catch (Exception exception) {
                    arrayList.add(exception);
                }
            }
            this.clearTrace();
            if (!arrayList.isEmpty()) {
                throw new SQLExceptionList(arrayList);
            }
        }
        this.setLastUsed(Instant.EPOCH);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingCallableStatement(this, this.connection.prepareCall(string)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingCallableStatement(this, this.connection.prepareCall(string, n, n2)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingCallableStatement(this, this.connection.prepareCall(string, n, n2, n3)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingPreparedStatement(this, this.connection.prepareStatement(string)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingPreparedStatement(this, this.connection.prepareStatement(string, n)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingPreparedStatement(this, this.connection.prepareStatement(string, n, n2)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingPreparedStatement(this, this.connection.prepareStatement(string, n, n2, n3)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingPreparedStatement(this, this.connection.prepareStatement(string, nArray)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        try {
            return this.init(new DelegatingPreparedStatement(this, this.connection.prepareStatement(string, stringArray)));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        try {
            this.connection.rollback();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        try {
            this.connection.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setAutoCommit(bl);
            if (this.cacheState) {
                this.cachedAutoCommit = this.connection.getAutoCommit();
            }
        }
        catch (SQLException sQLException) {
            this.cachedAutoCommit = null;
            this.handleException(sQLException);
        }
    }

    public void setCacheState(boolean bl) {
        this.cacheState = bl;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setCatalog(string);
            if (this.cacheState) {
                this.cachedCatalog = this.connection.getCatalog();
            }
        }
        catch (SQLException sQLException) {
            this.cachedCatalog = null;
            this.handleException(sQLException);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkOpen();
            this.connection.setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException("Connection is closed.", EMPTY_FAILED_PROPERTIES, (Throwable)sQLException);
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.checkOpen();
            this.connection.setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException("Connection is closed.", EMPTY_FAILED_PROPERTIES, (Throwable)sQLException);
        }
    }

    protected void setClosedInternal(boolean bl) {
        this.closed = bl;
    }

    public void setDefaultQueryTimeout(Duration duration) {
        this.defaultQueryTimeoutDuration = duration;
    }

    @Deprecated
    public void setDefaultQueryTimeout(Integer n) {
        this.defaultQueryTimeoutDuration = n == null ? null : Duration.ofSeconds(n.intValue());
    }

    public void setDelegate(C c) {
        this.connection = c;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setHoldability(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.checkOpen();
        try {
            Jdbc41Bridge.setNetworkTimeout(this.connection, executor, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setReadOnly(bl);
            if (this.cacheState) {
                this.cachedReadOnly = this.connection.isReadOnly();
            }
        }
        catch (SQLException sQLException) {
            this.cachedReadOnly = null;
            this.handleException(sQLException);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.setSavepoint();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkOpen();
        try {
            return this.connection.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.checkOpen();
        try {
            Jdbc41Bridge.setSchema(this.connection, string);
            if (this.cacheState) {
                this.cachedSchema = this.connection.getSchema();
            }
        }
        catch (SQLException sQLException) {
            this.cachedSchema = null;
            this.handleException(sQLException);
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public synchronized String toString() {
        String string = null;
        Connection connection = this.getInnermostDelegateInternal();
        if (connection != null) {
            try {
                if (connection.isClosed()) {
                    string = "connection is closed";
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.hashCode());
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    if (databaseMetaData != null) {
                        stringBuilder.append(", URL=");
                        stringBuilder.append(databaseMetaData.getURL());
                        stringBuilder.append(", ");
                        stringBuilder.append(databaseMetaData.getDriverName());
                        string = stringBuilder.toString();
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return string != null ? string : super.toString();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(this.connection.getClass())) {
            return clazz.cast(this.connection);
        }
        return this.connection.unwrap(clazz);
    }
}

