/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import org.apache.coyote.ActionCode;
import org.apache.coyote.CloseNowException;
import org.apache.coyote.Constants;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HttpOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http2.AbstractNonZeroStream;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.HpackDecoder;
import org.apache.coyote.http2.HpackException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Http2OutputBuffer;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.coyote.http2.RecycledStream;
import org.apache.coyote.http2.StreamException;
import org.apache.coyote.http2.StreamProcessor;
import org.apache.coyote.http2.WindowAllocationManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.Host;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.WriteBuffer;
import org.apache.tomcat.util.res.StringManager;

class Stream
extends AbstractNonZeroStream
implements HpackDecoder.HeaderEmitter {
    private static final Log log = LogFactory.getLog(Stream.class);
    private static final StringManager sm = StringManager.getManager(Stream.class);
    private static final int HEADER_STATE_START = 0;
    private static final int HEADER_STATE_PSEUDO = 1;
    private static final int HEADER_STATE_REGULAR = 2;
    private static final int HEADER_STATE_TRAILER = 3;
    private static final MimeHeaders ACK_HEADERS;
    private static final Integer HTTP_UPGRADE_STREAM;
    private volatile long contentLengthReceived = 0L;
    private final Http2UpgradeHandler handler;
    private final WindowAllocationManager allocationManager = new WindowAllocationManager(this);
    private final Request coyoteRequest;
    private final Response coyoteResponse = new Response();
    private final StreamInputBuffer inputBuffer;
    private final StreamOutputBuffer streamOutputBuffer = new StreamOutputBuffer();
    private final Http2OutputBuffer http2OutputBuffer = new Http2OutputBuffer(this.coyoteResponse, this.streamOutputBuffer);
    private int headerState = 0;
    private StreamException headerException = null;
    private volatile StringBuilder cookieHeader = null;
    private Object pendingWindowUpdateForStreamLock = new Object();
    private int pendingWindowUpdateForStream = 0;

    Stream(Integer n, Http2UpgradeHandler http2UpgradeHandler) {
        this(n, http2UpgradeHandler, null);
    }

    Stream(Integer n, Http2UpgradeHandler http2UpgradeHandler, Request request) {
        super(http2UpgradeHandler.getConnectionId(), n);
        this.handler = http2UpgradeHandler;
        http2UpgradeHandler.addChild(this);
        this.setWindowSize(http2UpgradeHandler.getRemoteSettings().getInitialWindowSize());
        if (request == null) {
            this.coyoteRequest = new Request();
            this.inputBuffer = new StreamInputBuffer();
            this.coyoteRequest.setInputBuffer(this.inputBuffer);
        } else {
            this.coyoteRequest = request;
            this.inputBuffer = null;
            this.state.receivedStartOfHeaders();
            if (HTTP_UPGRADE_STREAM.equals(n)) {
                try {
                    this.prepareRequest();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.coyoteResponse.setStatus(400);
                    this.coyoteResponse.setError();
                }
            }
            this.state.receivedEndOfStream();
        }
        this.coyoteRequest.setSendfile(false);
        this.coyoteResponse.setOutputBuffer(this.http2OutputBuffer);
        this.coyoteRequest.setResponse(this.coyoteResponse);
        this.coyoteRequest.protocol().setString("HTTP/2.0");
        if (this.coyoteRequest.getStartTime() < 0L) {
            this.coyoteRequest.setStartTime(System.currentTimeMillis());
        }
    }

    private void prepareRequest() {
        int n;
        MessageBytes messageBytes = this.coyoteRequest.getMimeHeaders().getUniqueValue("host");
        if (messageBytes == null) {
            throw new IllegalArgumentException();
        }
        messageBytes.toBytes();
        ByteChunk byteChunk = messageBytes.getByteChunk();
        byte[] byArray = byteChunk.getBytes();
        int n2 = byteChunk.getLength();
        int n3 = byteChunk.getStart();
        int n4 = Host.parse(messageBytes);
        if (n4 != -1) {
            int n5 = 0;
            for (n = n4 + 1; n < n2; ++n) {
                char c = (char)byArray[n + n3];
                if (c < '0' || c > '9') {
                    throw new IllegalArgumentException();
                }
                n5 = n5 * 10 + c - 48;
            }
            this.coyoteRequest.setServerPort(n5);
            n2 = n4;
        }
        char[] cArray = new char[n2];
        for (n = 0; n < n2; ++n) {
            cArray[n] = (char)byArray[n + n3];
        }
        this.coyoteRequest.serverName().setChars(cArray, 0, n2);
    }

    final void receiveReset(long l) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reset.receive", new Object[]{this.getConnectionId(), this.getIdAsString(), Long.toString(l)}));
        }
        this.state.receivedReset();
        if (this.inputBuffer != null) {
            this.inputBuffer.receiveReset();
        }
        this.cancelAllocationRequests();
    }

    final void cancelAllocationRequests() {
        this.allocationManager.notifyAny();
    }

    @Override
    final synchronized void incrementWindowSize(int n) throws Http2Exception {
        boolean bl = this.getWindowSize() < 1L;
        super.incrementWindowSize(n);
        if (bl && this.getWindowSize() > 0L) {
            this.allocationManager.notifyStream();
        }
    }

    private synchronized int reserveWindowSize(int n, boolean bl) throws IOException {
        long l = this.getWindowSize();
        while (l < 1L) {
            if (!this.canWrite()) {
                throw new CloseNowException(sm.getString("stream.notWritable", new Object[]{this.getConnectionId(), this.getIdAsString()}));
            }
            if (bl) {
                try {
                    long l2 = this.handler.getProtocol().getStreamWriteTimeout();
                    this.allocationManager.waitForStream(l2);
                    l = this.getWindowSize();
                    if (l != 0L) continue;
                    this.doStreamCancel(sm.getString("stream.writeTimeout"), Http2Error.ENHANCE_YOUR_CALM);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
            this.allocationManager.waitForStreamNonBlocking();
            return 0;
        }
        int n2 = l < (long)n ? (int)l : n;
        this.decrementWindowSize(n2);
        return n2;
    }

    void doStreamCancel(String string, Http2Error http2Error) throws CloseNowException {
        StreamException streamException = new StreamException(string, http2Error, this.getIdAsInt());
        this.streamOutputBuffer.closed = true;
        this.coyoteResponse.setError();
        this.coyoteResponse.setErrorReported();
        this.streamOutputBuffer.reset = streamException;
        throw new CloseNowException(string, streamException);
    }

    void waitForConnectionAllocation(long l) throws InterruptedException {
        this.allocationManager.waitForConnection(l);
    }

    void waitForConnectionAllocationNonBlocking() {
        this.allocationManager.waitForConnectionNonBlocking();
    }

    void notifyConnection() {
        this.allocationManager.notifyConnection();
    }

    @Override
    public final void emitHeader(String string, String string2) throws HpackException {
        boolean bl;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.header.debug", new Object[]{this.getConnectionId(), this.getIdAsString(), string, string2}));
        }
        if (!string.toLowerCase(Locale.US).equals(string)) {
            throw new HpackException(sm.getString("stream.header.case", new Object[]{this.getConnectionId(), this.getIdAsString(), string}));
        }
        if ("connection".equals(string)) {
            throw new HpackException(sm.getString("stream.header.connection", new Object[]{this.getConnectionId(), this.getIdAsString()}));
        }
        if ("te".equals(string) && !"trailers".equals(string2)) {
            throw new HpackException(sm.getString("stream.header.te", new Object[]{this.getConnectionId(), this.getIdAsString(), string2}));
        }
        if (this.headerException != null) {
            return;
        }
        if (string.length() == 0) {
            throw new HpackException(sm.getString("stream.header.empty", new Object[]{this.getConnectionId(), this.getIdAsString()}));
        }
        boolean bl2 = bl = string.charAt(0) == ':';
        if (bl && this.headerState != 1) {
            this.headerException = new StreamException(sm.getString("stream.header.unexpectedPseudoHeader", new Object[]{this.getConnectionId(), this.getIdAsString(), string}), Http2Error.PROTOCOL_ERROR, this.getIdAsInt());
            return;
        }
        if (this.headerState == 1 && !bl) {
            this.headerState = 2;
        }
        switch (string) {
            case ":method": {
                if (this.coyoteRequest.method().isNull()) {
                    this.coyoteRequest.method().setString(string2);
                    break;
                }
                throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString(), ":method"}));
            }
            case ":scheme": {
                if (this.coyoteRequest.scheme().isNull()) {
                    this.coyoteRequest.scheme().setString(string2);
                    break;
                }
                throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString(), ":scheme"}));
            }
            case ":path": {
                Object object;
                String string3;
                if (!this.coyoteRequest.requestURI().isNull()) {
                    throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString(), ":path"}));
                }
                if (string2.length() == 0) {
                    throw new HpackException(sm.getString("stream.header.noPath", new Object[]{this.getConnectionId(), this.getIdAsString()}));
                }
                int n = string2.indexOf(63);
                if (n == -1) {
                    string3 = string2;
                } else {
                    string3 = string2.substring(0, n);
                    object = string2.substring(n + 1);
                    this.coyoteRequest.queryString().setString((String)object);
                }
                object = string3.getBytes(StandardCharsets.ISO_8859_1);
                this.coyoteRequest.requestURI().setBytes(object, 0, ((byte[])object).length);
                break;
            }
            case ":authority": {
                if (this.coyoteRequest.serverName().isNull()) {
                    int n;
                    try {
                        n = Host.parse(string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HpackException(sm.getString("stream.header.invalid", new Object[]{this.getConnectionId(), this.getIdAsString(), ":authority", string2}));
                    }
                    if (n > -1) {
                        this.coyoteRequest.serverName().setString(string2.substring(0, n));
                        this.coyoteRequest.setServerPort(Integer.parseInt(string2.substring(n + 1)));
                        break;
                    }
                    this.coyoteRequest.serverName().setString(string2);
                    break;
                }
                throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString(), ":authority"}));
            }
            case "cookie": {
                if (this.cookieHeader == null) {
                    this.cookieHeader = new StringBuilder();
                } else {
                    this.cookieHeader.append("; ");
                }
                this.cookieHeader.append(string2);
                break;
            }
            default: {
                if (this.headerState == 3 && !this.handler.isTrailerHeaderAllowed(string)) break;
                if ("expect".equals(string) && "100-continue".equals(string2)) {
                    this.coyoteRequest.setExpectation(true);
                }
                if (bl) {
                    this.headerException = new StreamException(sm.getString("stream.header.unknownPseudoHeader", new Object[]{this.getConnectionId(), this.getIdAsString(), string}), Http2Error.PROTOCOL_ERROR, this.getIdAsInt());
                }
                this.coyoteRequest.getMimeHeaders().addValue(string).setString(string2);
            }
        }
    }

    @Override
    public void setHeaderException(StreamException streamException) {
        if (this.headerException == null) {
            this.headerException = streamException;
        }
    }

    @Override
    public void validateHeaders() throws StreamException {
        if (this.headerException == null) {
            return;
        }
        throw this.headerException;
    }

    final boolean receivedEndOfHeaders() throws ConnectionException {
        if (this.coyoteRequest.method().isNull() || this.coyoteRequest.scheme().isNull() || this.coyoteRequest.requestURI().isNull()) {
            throw new ConnectionException(sm.getString("stream.header.required", new Object[]{this.getConnectionId(), this.getIdAsString()}), Http2Error.PROTOCOL_ERROR);
        }
        if (this.cookieHeader != null) {
            this.coyoteRequest.getMimeHeaders().addValue("cookie").setString(this.cookieHeader.toString());
        }
        return this.headerState == 2 || this.headerState == 1;
    }

    final void writeHeaders() throws IOException {
        boolean bl = this.streamOutputBuffer.hasNoBody();
        this.handler.writeHeaders(this, 0, this.coyoteResponse.getMimeHeaders(), bl, 1024);
    }

    final void addOutputFilter(OutputFilter outputFilter) {
        this.http2OutputBuffer.addFilter(outputFilter);
    }

    void writeAck() throws IOException {
        this.handler.writeHeaders(this, 0, ACK_HEADERS, false, 64);
    }

    @Override
    final String getConnectionId() {
        return this.handler.getConnectionId();
    }

    final Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    final Response getCoyoteResponse() {
        return this.coyoteResponse;
    }

    @Override
    final ByteBuffer getInputByteBuffer() {
        if (this.inputBuffer == null) {
            return ZERO_LENGTH_BYTEBUFFER;
        }
        return this.inputBuffer.getInBuffer();
    }

    final void receivedStartOfHeaders(boolean bl) throws Http2Exception {
        if (this.headerState == 0) {
            this.headerState = 1;
            this.handler.getHpackDecoder().setMaxHeaderCount(this.handler.getMaxHeaderCount());
            this.handler.getHpackDecoder().setMaxHeaderSize(this.handler.getMaxHeaderSize());
        } else if (this.headerState == 1 || this.headerState == 2) {
            if (bl) {
                this.headerState = 3;
                this.handler.getHpackDecoder().setMaxHeaderCount(this.handler.getMaxTrailerCount());
                this.handler.getHpackDecoder().setMaxHeaderSize(this.handler.getMaxTrailerSize());
            } else {
                throw new ConnectionException(sm.getString("stream.trailerHeader.noEndOfStream", new Object[]{this.getConnectionId(), this.getIdAsString()}), Http2Error.PROTOCOL_ERROR);
            }
        }
        this.state.receivedStartOfHeaders();
    }

    @Override
    final void receivedData(int n) throws Http2Exception {
        this.contentLengthReceived += (long)n;
        long l = this.coyoteRequest.getContentLengthLong();
        if (l > -1L && this.contentLengthReceived > l) {
            throw new ConnectionException(sm.getString("stream.header.contentLength", new Object[]{this.getConnectionId(), this.getIdAsString(), l, this.contentLengthReceived}), Http2Error.PROTOCOL_ERROR);
        }
    }

    final void receivedEndOfStream() throws ConnectionException {
        if (this.isContentLengthInconsistent()) {
            throw new ConnectionException(sm.getString("stream.header.contentLength", new Object[]{this.getConnectionId(), this.getIdAsString(), this.coyoteRequest.getContentLengthLong(), this.contentLengthReceived}), Http2Error.PROTOCOL_ERROR);
        }
        this.state.receivedEndOfStream();
        if (this.inputBuffer != null) {
            this.inputBuffer.notifyEof();
        }
    }

    final boolean isContentLengthInconsistent() {
        long l = this.coyoteRequest.getContentLengthLong();
        return l > -1L && this.contentLengthReceived != l;
    }

    final void sentHeaders() {
        this.state.sentHeaders();
    }

    final void sentEndOfStream() {
        this.streamOutputBuffer.endOfStreamSent = true;
        this.state.sentEndOfStream();
    }

    final boolean isReadyForWrite() {
        return this.streamOutputBuffer.isReady();
    }

    final boolean flush(boolean bl) throws IOException {
        return this.streamOutputBuffer.flush(bl);
    }

    final StreamInputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    final HttpOutputBuffer getOutputBuffer() {
        return this.http2OutputBuffer;
    }

    final void sentPushPromise() {
        this.state.sentPushPromise();
    }

    final boolean isActive() {
        return this.state.isActive();
    }

    final boolean canWrite() {
        return this.state.canWrite();
    }

    final void closeIfIdle() {
        this.state.closeIfIdle();
    }

    final boolean isInputFinished() {
        return !this.state.isFrameTypePermitted(FrameType.DATA);
    }

    final void close(Http2Exception http2Exception) {
        if (http2Exception instanceof StreamException) {
            try {
                StreamException streamException = (StreamException)http2Exception;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("stream.reset.send", new Object[]{this.getConnectionId(), this.getIdAsString(), streamException.getError()}));
                }
                this.handler.sendStreamReset(this.state, streamException);
                this.cancelAllocationRequests();
                if (this.inputBuffer != null) {
                    this.inputBuffer.swallowUnread();
                }
            }
            catch (IOException iOException) {
                ConnectionException connectionException = new ConnectionException(sm.getString("stream.reset.fail", new Object[]{this.getConnectionId(), this.getIdAsString()}), Http2Error.PROTOCOL_ERROR, iOException);
                this.handler.closeConnection(connectionException);
            }
        } else {
            this.handler.closeConnection(http2Exception);
        }
        if (this.inputBuffer != null) {
            this.inputBuffer.receiveReset();
        }
        this.recycle();
    }

    final void recycle() {
        ByteBuffer byteBuffer;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.recycle", new Object[]{this.getConnectionId(), this.getIdAsString()}));
        }
        int n = (byteBuffer = this.getInputByteBuffer()) == null ? 0 : byteBuffer.remaining();
        this.handler.replaceStream(this, new RecycledStream(this.getConnectionId(), this.getIdentifier(), this.state, n));
    }

    final boolean isPushSupported() {
        return this.handler.getRemoteSettings().getEnablePush();
    }

    final void push(Request request) throws IOException {
        if (!this.isPushSupported() || this.getIdAsInt() % 2 == 0) {
            return;
        }
        request.getMimeHeaders().addValue(":method").duplicate(request.method());
        request.getMimeHeaders().addValue(":scheme").duplicate(request.scheme());
        StringBuilder stringBuilder = new StringBuilder(request.requestURI().toString());
        if (!request.queryString().isNull()) {
            stringBuilder.append('?');
            stringBuilder.append(request.queryString().toString());
        }
        request.getMimeHeaders().addValue(":path").setString(stringBuilder.toString());
        if (!(request.scheme().equals("http") && request.getServerPort() == 80 || request.scheme().equals("https") && request.getServerPort() == 443)) {
            request.getMimeHeaders().addValue(":authority").setString(request.serverName().getString() + ":" + request.getServerPort());
        } else {
            request.getMimeHeaders().addValue(":authority").duplicate(request.serverName());
        }
        Stream.push(this.handler, request, this);
    }

    StreamException getResetException() {
        return this.streamOutputBuffer.reset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getWindowUpdateSizeToWrite(int n) {
        int n2;
        int n3 = this.handler.getProtocol().getOverheadWindowUpdateThreshold();
        Object object = this.pendingWindowUpdateForStreamLock;
        synchronized (object) {
            if (n > n3) {
                n2 = n + this.pendingWindowUpdateForStream;
                this.pendingWindowUpdateForStream = 0;
            } else {
                this.pendingWindowUpdateForStream += n;
                if (this.pendingWindowUpdateForStream > n3) {
                    n2 = this.pendingWindowUpdateForStream;
                    this.pendingWindowUpdateForStream = 0;
                } else {
                    n2 = 0;
                }
            }
        }
        return n2;
    }

    private static void push(Http2UpgradeHandler http2UpgradeHandler, Request request, Stream stream) throws IOException {
        if (Constants.IS_SECURITY_ENABLED) {
            try {
                AccessController.doPrivileged(new PrivilegedPush(http2UpgradeHandler, request, stream));
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(privilegedActionException);
            }
        } else {
            http2UpgradeHandler.push(request, stream);
        }
    }

    static {
        HTTP_UPGRADE_STREAM = 1;
        Response response = new Response();
        response.setStatus(100);
        StreamProcessor.prepareHeaders(null, response, null, null);
        ACK_HEADERS = response.getMimeHeaders();
    }

    class StreamInputBuffer
    implements InputBuffer {
        private byte[] outBuffer;
        private volatile ByteBuffer inBuffer;
        private volatile boolean readInterest;
        private volatile boolean closed;
        private boolean resetReceived;

        StreamInputBuffer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public int doRead(ByteChunk byteChunk) throws IOException {
            this.ensureBuffersExist();
            int n = -1;
            ByteBuffer byteBuffer = this.inBuffer;
            synchronized (byteBuffer) {
                boolean bl = false;
                while (this.inBuffer.position() == 0 && (bl = Stream.this.isActive() && !Stream.this.isInputFinished())) {
                    try {
                        long l;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("stream.inputBuffer.empty"));
                        }
                        if ((l = Stream.this.handler.getProtocol().getStreamReadTimeout()) < 0L) {
                            this.inBuffer.wait();
                        } else {
                            this.inBuffer.wait(l);
                        }
                        if (this.resetReceived) {
                            throw new IOException(sm.getString("stream.inputBuffer.reset"));
                        }
                        if (this.inBuffer.position() != 0) continue;
                        String string = sm.getString("stream.inputBuffer.readTimeout");
                        StreamException streamException = new StreamException(string, Http2Error.ENHANCE_YOUR_CALM, Stream.this.getIdAsInt());
                        Stream.this.coyoteResponse.setError();
                        Stream.this.streamOutputBuffer.reset = streamException;
                        throw new CloseNowException(string, streamException);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException);
                    }
                }
                if (this.inBuffer.position() > 0) {
                    this.inBuffer.flip();
                    n = this.inBuffer.remaining();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("stream.inputBuffer.copy", new Object[]{Integer.toString(n)}));
                    }
                } else {
                    if (!bl) {
                        return -1;
                    }
                    throw new IllegalStateException();
                }
                this.inBuffer.get(this.outBuffer, 0, n);
                this.inBuffer.clear();
            }
            byteChunk.setBytes(this.outBuffer, 0, n);
            Stream.this.handler.writeWindowUpdate(Stream.this, n, true);
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
            this.ensureBuffersExist();
            int n = -1;
            ByteBuffer byteBuffer = this.inBuffer;
            if (byteBuffer == null) {
                return -1;
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                if (this.inBuffer == null) {
                    return -1;
                }
                boolean bl = false;
                while (this.inBuffer.position() == 0 && (bl = Stream.this.isActive() && !Stream.this.isInputFinished())) {
                    try {
                        long l;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("stream.inputBuffer.empty"));
                        }
                        if ((l = Stream.this.handler.getProtocol().getStreamReadTimeout()) < 0L) {
                            this.inBuffer.wait();
                        } else {
                            this.inBuffer.wait(l);
                        }
                        if (this.resetReceived) {
                            throw new IOException(sm.getString("stream.inputBuffer.reset"));
                        }
                        if (this.inBuffer.position() != 0 || !Stream.this.isActive() || Stream.this.isInputFinished()) continue;
                        String string = sm.getString("stream.inputBuffer.readTimeout");
                        StreamException streamException = new StreamException(string, Http2Error.ENHANCE_YOUR_CALM, Stream.this.getIdAsInt());
                        Stream.this.coyoteResponse.setError();
                        Stream.this.streamOutputBuffer.reset = streamException;
                        throw new CloseNowException(string, streamException);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException);
                    }
                }
                if (this.inBuffer.position() > 0) {
                    this.inBuffer.flip();
                    n = this.inBuffer.remaining();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("stream.inputBuffer.copy", new Object[]{Integer.toString(n)}));
                    }
                } else {
                    if (!bl) {
                        return -1;
                    }
                    throw new IllegalStateException();
                }
                this.inBuffer.get(this.outBuffer, 0, n);
                this.inBuffer.clear();
            }
            applicationBufferHandler.setByteBuffer(ByteBuffer.wrap(this.outBuffer, 0, n));
            Stream.this.handler.writeWindowUpdate(Stream.this, n, true);
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean isReadyForRead() {
            this.ensureBuffersExist();
            StreamInputBuffer streamInputBuffer = this;
            synchronized (streamInputBuffer) {
                if (this.available() > 0) {
                    return true;
                }
                if (!this.isRequestBodyFullyRead()) {
                    this.readInterest = true;
                }
                return false;
            }
        }

        final synchronized boolean isRequestBodyFullyRead() {
            return (this.inBuffer == null || this.inBuffer.position() == 0) && Stream.this.isInputFinished();
        }

        @Override
        public final synchronized int available() {
            if (this.inBuffer == null) {
                return 0;
            }
            return this.inBuffer.position();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final synchronized void onDataAvailable() throws IOException {
            if (this.closed) {
                this.swallowUnread();
            } else if (this.readInterest) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("stream.inputBuffer.dispatch"));
                }
                this.readInterest = false;
                Stream.this.coyoteRequest.action(ActionCode.DISPATCH_READ, null);
                Stream.this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("stream.inputBuffer.signal"));
                }
                ByteBuffer byteBuffer = this.inBuffer;
                synchronized (byteBuffer) {
                    this.inBuffer.notifyAll();
                }
            }
        }

        private final ByteBuffer getInBuffer() {
            this.ensureBuffersExist();
            return this.inBuffer;
        }

        final synchronized void insertReplayedBody(ByteChunk byteChunk) {
            this.inBuffer = ByteBuffer.wrap(byteChunk.getBytes(), byteChunk.getOffset(), byteChunk.getLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void ensureBuffersExist() {
            if (this.inBuffer == null && !this.closed) {
                int n = Stream.this.handler.getLocalSettings().getInitialWindowSize();
                StreamInputBuffer streamInputBuffer = this;
                synchronized (streamInputBuffer) {
                    if (this.inBuffer == null && !this.closed) {
                        this.inBuffer = ByteBuffer.allocate(n);
                        this.outBuffer = new byte[n];
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void receiveReset() {
            if (this.inBuffer != null) {
                ByteBuffer byteBuffer = this.inBuffer;
                synchronized (byteBuffer) {
                    this.resetReceived = true;
                    this.inBuffer.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void notifyEof() {
            if (this.inBuffer != null) {
                ByteBuffer byteBuffer = this.inBuffer;
                synchronized (byteBuffer) {
                    this.inBuffer.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void swallowUnread() throws IOException {
            StreamInputBuffer streamInputBuffer = this;
            synchronized (streamInputBuffer) {
                this.closed = true;
            }
            if (this.inBuffer != null) {
                int n = 0;
                ByteBuffer byteBuffer = this.inBuffer;
                synchronized (byteBuffer) {
                    n = this.inBuffer.position();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("stream.inputBuffer.swallowUnread", new Object[]{n}));
                    }
                    if (n > 0) {
                        this.inBuffer.position(0);
                        this.inBuffer.limit(this.inBuffer.limit() - n);
                    }
                }
                if (n > 0) {
                    Stream.this.handler.onSwallowedDataFramePayload(Stream.this.getIdAsInt(), n);
                }
            }
        }
    }

    class StreamOutputBuffer
    implements HttpOutputBuffer,
    WriteBuffer.Sink {
        private final ByteBuffer buffer = ByteBuffer.allocate(8192);
        private final WriteBuffer writeBuffer = new WriteBuffer(32768);
        private boolean dataLeft;
        private volatile long written = 0L;
        private volatile int streamReservation = 0;
        private volatile boolean closed = false;
        private volatile StreamException reset = null;
        private volatile boolean endOfStreamSent = false;

        StreamOutputBuffer() {
        }

        @Override
        @Deprecated
        public synchronized int doWrite(ByteChunk byteChunk) throws IOException {
            if (this.closed) {
                throw new IllegalStateException(sm.getString("stream.closed", new Object[]{Stream.this.getConnectionId(), Stream.this.getIdentifier()}));
            }
            if (!Stream.this.coyoteResponse.isCommitted()) {
                Stream.this.coyoteResponse.sendHeaders();
            }
            int n = byteChunk.getLength();
            int n2 = 0;
            while (n > 0) {
                int n3 = Math.min(this.buffer.remaining(), n);
                this.buffer.put(byteChunk.getBytes(), byteChunk.getOffset() + n2, n3);
                n2 += n3;
                if ((n -= n3) <= 0 || this.buffer.hasRemaining() || !this.flush(true, Stream.this.coyoteResponse.getWriteListener() == null)) continue;
                break;
            }
            this.written += (long)n2;
            return n2;
        }

        @Override
        public final synchronized int doWrite(ByteBuffer byteBuffer) throws IOException {
            if (this.closed) {
                throw new IllegalStateException(sm.getString("stream.closed", new Object[]{Stream.this.getConnectionId(), Stream.this.getIdAsString()}));
            }
            int n = 0;
            if (this.writeBuffer.isEmpty()) {
                int n2 = byteBuffer.limit();
                while (byteBuffer.remaining() > 0) {
                    int n3 = Math.min(this.buffer.remaining(), byteBuffer.remaining());
                    byteBuffer.limit(byteBuffer.position() + n3);
                    this.buffer.put(byteBuffer);
                    byteBuffer.limit(n2);
                    n += n3;
                    if (byteBuffer.remaining() <= 0 || this.buffer.hasRemaining() || !this.flush(true, Stream.this.coyoteResponse.getWriteListener() == null)) continue;
                    n = byteBuffer.remaining();
                    this.writeBuffer.add(byteBuffer);
                    this.dataLeft = true;
                    break;
                }
            } else {
                n = byteBuffer.remaining();
                this.writeBuffer.add(byteBuffer);
            }
            this.written += (long)n;
            return n;
        }

        final synchronized boolean flush(boolean bl) throws IOException {
            boolean bl2 = this.buffer.position() > 0;
            boolean bl3 = false;
            if (bl2) {
                bl2 = this.flush(false, bl);
                bl3 = true;
            }
            this.dataLeft = bl2 ? true : (this.writeBuffer.isEmpty() ? (bl3 ? false : this.flush(false, bl)) : this.writeBuffer.write(this, bl));
            return this.dataLeft;
        }

        private final synchronized boolean flush(boolean bl, boolean bl2) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("stream.outputBuffer.flush.debug", new Object[]{Stream.this.getConnectionId(), Stream.this.getIdAsString(), Integer.toString(this.buffer.position()), Boolean.toString(bl), Boolean.toString(this.closed)}));
            }
            if (this.buffer.position() == 0) {
                if (this.closed && !this.endOfStreamSent) {
                    Stream.this.handler.writeBody(Stream.this, this.buffer, 0, true);
                }
                return false;
            }
            this.buffer.flip();
            int n = this.buffer.remaining();
            while (n > 0) {
                if (this.streamReservation == 0) {
                    this.streamReservation = Stream.this.reserveWindowSize(n, bl2);
                    if (this.streamReservation == 0) {
                        this.buffer.compact();
                        return true;
                    }
                }
                while (this.streamReservation > 0) {
                    int n2 = Stream.this.handler.reserveWindowSize(Stream.this, this.streamReservation, bl2);
                    if (n2 == 0) {
                        this.buffer.compact();
                        return true;
                    }
                    Stream.this.handler.writeBody(Stream.this, this.buffer, n2, !bl && this.closed && n == n2);
                    this.streamReservation -= n2;
                    n -= n2;
                }
            }
            this.buffer.clear();
            return false;
        }

        final synchronized boolean isReady() {
            return !(Stream.this.getWindowSize() > 0L && Stream.this.allocationManager.isWaitingForStream() || Stream.this.handler.getWindowSize() > 0L && Stream.this.allocationManager.isWaitingForConnection()) && !this.dataLeft;
        }

        @Override
        public final long getBytesWritten() {
            return this.written;
        }

        @Override
        public final void end() throws IOException {
            if (this.reset != null) {
                throw new CloseNowException(this.reset);
            }
            if (!this.closed) {
                this.closed = true;
                this.flush(true);
            }
        }

        final boolean hasNoBody() {
            return this.written == 0L && this.closed;
        }

        @Override
        public void flush() throws IOException {
            this.flush(Stream.this.getCoyoteResponse().getWriteListener() == null);
        }

        @Override
        public synchronized boolean writeFromBuffer(ByteBuffer byteBuffer, boolean bl) throws IOException {
            int n = byteBuffer.limit();
            while (byteBuffer.remaining() > 0) {
                int n2 = Math.min(this.buffer.remaining(), byteBuffer.remaining());
                byteBuffer.limit(byteBuffer.position() + n2);
                this.buffer.put(byteBuffer);
                byteBuffer.limit(n);
                if (!this.flush(false, bl)) continue;
                return true;
            }
            return false;
        }
    }

    private static class PrivilegedPush
    implements PrivilegedExceptionAction<Void> {
        private final Http2UpgradeHandler handler;
        private final Request request;
        private final Stream stream;

        public PrivilegedPush(Http2UpgradeHandler http2UpgradeHandler, Request request, Stream stream) {
            this.handler = http2UpgradeHandler;
            this.request = request;
            this.stream = stream;
        }

        @Override
        public Void run() throws IOException {
            this.handler.push(this.request, this.stream);
            return null;
        }
    }
}

